/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.execution.testing.CidrScopeInfo;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, TEST_OBJECT>
extends RunConfigurationProducer<CONFIGURATION> {
    protected CidrTestRunConfigurationProducer(@NotNull ConfigurationType configurationType) {
        super(configurationType);
    }

    protected boolean setupConfigurationFromContext(@NotNull CONFIGURATION configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        List<TEST_OBJECT> objects = this.findTestObjects(context);
        if (objects.isEmpty()) {
            return false;
        }
        CidrScopeInfo scope = this.determineScope((TEST_OBJECT)objects);
        if (scope == null) {
            return false;
        }
        TEST_OBJECT testObj = objects.get(0);
        this.setupTestTarget(configuration, this.getTargetsForTestObject(testObj));
        this.setupConfiguration(configuration, scope);
        sourceElement.set((Object)this.getElement(testObj));
        return true;
    }

    public void setupTestTarget(@NotNull CONFIGURATION newConfigurationWithTemplateDefaults, @NotNull List<TARGET> targetsWithContext) {
        if (targetsWithContext.isEmpty()) {
            return;
        }
        CidrBuildTarget target = null;
        CidrBuildConfigurationHelper helper = ((CidrRunConfiguration)newConfigurationWithTemplateDefaults).getHelper();
        BuildTargetAndConfigurationData btc = this.extractTargetAndConfigurationFromCurrentSelection(newConfigurationWithTemplateDefaults.getProject(), helper, targetsWithContext);
        if (btc == null) {
            btc = helper.findSimilarValidInTargets(((CidrRunConfiguration)newConfigurationWithTemplateDefaults).getTargetAndConfigurationData(), targetsWithContext);
        }
        if (btc != null && btc.target != null) {
            target = (CidrBuildTarget)this.findTarget(targetsWithContext, btc.target);
        }
        if (target == null) {
            btc = null;
            target = (CidrBuildTarget)targetsWithContext.get(0);
        }
        assert (target != null);
        BuildTargetData buildTargetData = new BuildTargetData(target);
        this.setExecutableData(newConfigurationWithTemplateDefaults, new ExecutableData(buildTargetData));
        if (btc == null) {
            BC buildConfiguration = this.getDefaultConfiguration(newConfigurationWithTemplateDefaults, target);
            btc = new BuildTargetAndConfigurationData(buildTargetData, buildConfiguration == null ? null : buildConfiguration.getName());
        }
        ((CidrRunConfiguration)newConfigurationWithTemplateDefaults).setTargetAndConfigurationData(btc);
    }

    @Nullable
    protected abstract BuildTargetAndConfigurationData extractTargetAndConfigurationFromCurrentSelection(@NotNull Project var1, @NotNull CidrBuildConfigurationHelper<BC, TARGET> var2, @NotNull List<TARGET> var3);

    protected abstract void setExecutableData(@NotNull CONFIGURATION var1, @NotNull ExecutableData var2);

    @Nullable
    protected abstract BC getDefaultConfiguration(@NotNull CONFIGURATION var1, @NotNull TARGET var2);

    @Nullable
    protected abstract TARGET findTarget(@NotNull List<TARGET> var1, @NotNull BuildTargetData var2);

    @NotNull
    protected abstract PsiElement getElement(@NotNull TEST_OBJECT var1);

    @NotNull
    private List<TARGET> getTargetsForTestObject(@NotNull TEST_OBJECT object) {
        PsiFile containingFile = this.getElement(object).getContainingFile();
        if (containingFile == null) {
            return Collections.emptyList();
        }
        ArrayList<? extends OCResolveConfiguration> orderedConfigurations = new ArrayList<OCResolveConfiguration>(OCWorkspaceManager.getWorkspace(containingFile.getProject()).getConfigurations());
        orderedConfigurations.retainAll(OCInclusionContextUtil.getAllBuildConfigurationsForFile(containingFile, null));
        ArrayList<TARGET> targets = new ArrayList<TARGET>(orderedConfigurations.size());
        for (OCResolveConfiguration oCResolveConfiguration : orderedConfigurations) {
            TARGET target = this.getTargetFromResolveConfiguration(oCResolveConfiguration);
            if (target == null || !this.isTestTarget(target)) continue;
            targets.add(target);
        }
        return Collections.unmodifiableList(targets);
    }

    @Nullable
    protected abstract TARGET getTargetFromResolveConfiguration(@NotNull OCResolveConfiguration var1);

    protected abstract boolean isTestTarget(@NotNull TARGET var1);

    @Nullable
    protected abstract CidrScopeInfo determineScope(@NotNull List<TEST_OBJECT> var1);

    @Nullable
    protected CidrScopeInfo determineScope(@NotNull List<TEST_OBJECT> objects, String separator) {
        return this.foldScope(ContainerUtil.mapNotNull(objects, e -> this.determineScope(e)), separator);
    }

    @Nullable
    protected CidrScopeInfo determineScope(@NotNull ConfigurationContext context) {
        return this.determineScope((TEST_OBJECT)this.findTestObjects(context));
    }

    @Nullable
    protected abstract CidrScopeInfo determineScope(@NotNull TEST_OBJECT var1);

    @NotNull
    protected List<TEST_OBJECT> findTestObjects(@NotNull ConfigurationContext context) {
        return ContainerUtil.mapNotNull(this.getLocations(context), e -> this.findTestObject((Location)e));
    }

    @Nullable
    protected abstract TEST_OBJECT findTestObject(@NotNull Location var1);

    public boolean isConfigurationFromContext(CONFIGURATION configuration, ConfigurationContext context) {
        CidrScopeInfo scope = this.determineScope(context);
        if (scope == null) {
            return false;
        }
        CidrTestRunConfigurationData delegate = this.getDelegate(configuration);
        if (delegate == null) {
            return false;
        }
        return Comparing.equal((String)delegate.getTestSuite(), (String)scope.getSuite()) && Comparing.equal((String)delegate.getTestName(), (String)scope.getTest()) && Comparing.equal((String)delegate.getTestPattern(), (String)scope.getPattern()) && Comparing.equal((Object)((Object)delegate.getTestMode()), (Object)((Object)scope.getMode()));
    }

    @Contract(value="null -> null")
    @Nullable
    private CidrTestRunConfigurationData getDelegate(CONFIGURATION configuration) {
        return configuration instanceof CidrTestRunConfiguration ? ((CidrTestRunConfiguration)configuration).getTestData() : null;
    }

    protected void setupConfiguration(CONFIGURATION configuration, CidrScopeInfo scope) {
        CidrTestRunConfigurationData delegate = this.getDelegate(configuration);
        if (delegate == null) {
            return;
        }
        delegate.setTestSuite(scope.getSuite());
        delegate.setTestName(scope.getTest());
        delegate.setTestPattern(scope.getPattern());
        delegate.setTestMode(scope.getMode());
        configuration.setName(scope.getName() == null ? delegate.suggestedName(((CidrRunConfiguration)configuration).suggestNameForTarget()) : scope.getName());
    }

    @NotNull
    protected List<Location> getLocations(@NotNull ConfigurationContext context) {
        Object[] paths;
        SMTRunnerTestTreeView treeView = (SMTRunnerTestTreeView)((Object)SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW.getData(context.getDataContext()));
        if (treeView != null && (paths = treeView.getSelectionPaths()) != null && paths.length > 1) {
            GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(context.getProject());
            return ContainerUtil.mapNotNull((Object[])paths, path -> {
                if (treeView.isPathSelected(path.getParentPath())) {
                    return null;
                }
                SMTestProxy test = treeView.getSelectedTest((TreePath)path);
                return test == null ? null : test.getLocation(context.getProject(), scope);
            });
        }
        Location location = context.getLocation();
        if (location == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(location);
    }

    @Nullable
    protected CidrScopeInfo foldScope(@NotNull List<CidrScopeInfo> elements, String separator) {
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        Ref firstName = new Ref();
        List res = ContainerUtil.map(elements, scope -> {
            firstName.setIfNull((Object)this.getScopeName((CidrScopeInfo)scope));
            return scope.getMode() == CidrScopeInfo.Mode.PATTERN ? scope.getPattern() : this.createScopeElement((CidrScopeInfo)scope).toString();
        });
        if (res.isEmpty()) {
            return null;
        }
        String name = (String)firstName.get();
        if (res.size() > 1) {
            name = name + String.format(" and %d more", res.size() - 1);
        }
        return new CidrScopeInfo(null, null, name, StringUtil.join(new LinkedHashSet(res), (String)separator));
    }

    protected abstract CidrTestScopeElement createScopeElement(CidrScopeInfo var1);

    private String getScopeName(CidrScopeInfo scope) {
        if (scope.getName() != null) {
            return scope.getName();
        }
        if (scope.getTest() == null) {
            return scope.getSuite();
        }
        return this.formatTestName(scope);
    }

    protected abstract String formatTestName(CidrScopeInfo var1);
}

