/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLocation;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestLocationProvider
implements SMTestLocator {
    public static final String PROTOCOL = "gtest";
    public static final CidrGoogleTestLocationProvider INSTANCE = new CidrGoogleTestLocationProvider();
    private static final Pattern METHOD_PATTERN = Pattern.compile("((\\w+)/)?(\\w+)(\\.(\\w+))?(=(\\d+))?(\\?typed)?");

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        if (!PROTOCOL.equals(protocol)) {
            return Collections.emptyList();
        }
        Matcher matcher = METHOD_PATTERN.matcher(path);
        if (matcher.matches()) {
            boolean typed;
            String instantiationName = matcher.group(2);
            String suiteName = matcher.group(3);
            String testName = matcher.group(5);
            String param = matcher.group(7);
            boolean bl = typed = matcher.group(8) != null;
            OCSymbol<PsiElement> symbol = testName != null ? CidrGoogleTestUtil.findGoogleTestSymbol(project2, suiteName, testName) : (instantiationName != null ? CidrGoogleTestUtil.findGoogleTestInstantiationSymbol(project2, suiteName, instantiationName) : CidrGoogleTestLocationProvider.findSuiteSymbol(project2, suiteName));
            if (symbol == null) {
                return Collections.emptyList();
            }
            PsiElement psiElement = symbol.locateDefinition();
            while (!(psiElement instanceof OCStruct) && !(psiElement instanceof OCMacroCall) && psiElement != null) {
                PsiElement prev = psiElement.getPrevSibling();
                psiElement = prev == null ? psiElement.getParent() : prev;
            }
            if (psiElement == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new CidrGoogleTestLocation(project2, psiElement, param, instantiationName, testName == null, typed));
        }
        return Collections.emptyList();
    }

    @Nullable
    private static OCStructSymbol findSuiteSymbol(Project project2, String suiteName) {
        CommonProcessors.FindProcessor<OCSymbol> processor2 = new CommonProcessors.FindProcessor<OCSymbol>(){

            @Contract(value="null -> false")
            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)symbol);
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)processor2, suiteName);
        if (processor2.isFound()) {
            return (OCStructSymbol)processor2.getFoundValue();
        }
        Collection<OCStructSymbol> symbolsForSuite = CidrGoogleTestUtil.findGoogleTestSymbolsForSuiteSorted(project2, suiteName);
        return symbolsForSuite.isEmpty() ? null : symbolsForSuite.iterator().next();
    }
}

