/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLocation;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestRerunFailedTestsAction
extends CidrRerunFailedTestsAction {
    public CidrGoogleTestRerunFailedTestsAction(@NotNull ComponentContainer componentContainer) {
        super(componentContainer);
    }

    @Override
    @NotNull
    protected Filter getFilter(@NotNull Project project2, @NotNull GlobalSearchScope searchScope) {
        return super.getFilter(project2, searchScope).and(new Filter(){

            public boolean shouldAccept(AbstractTestProxy t) {
                return t.isLeaf();
            }
        });
    }

    @Override
    @Nullable
    protected CidrTestScopeElement getElement(@NotNull AbstractTestProxy test, Project project2) {
        String scope;
        CidrGoogleTestLocation location = CidrGoogleTestRerunFailedTestsAction.getLocation(test, project2);
        String param = location != null ? location.getParam() : null;
        int depth = CidrGoogleTestRerunFailedTestsAction.getTestDepth(test);
        switch (depth) {
            case 2: {
                scope = String.format("%s.%s", test.getParent().getName(), test.getName());
                break;
            }
            case 3: {
                AbstractTestProxy suite = test.getParent().getParent();
                scope = String.format("%s/%s.%s", suite.getName(), param, test.getName());
                break;
            }
            case 4: {
                if (location == null) {
                    return null;
                }
                PsiElement element = location.getPsiElement();
                if (!(element instanceof OCStruct)) {
                    return null;
                }
                Couple<String> testName = CidrGoogleTestUtil.extractGoogleTestName((OCStructSymbol)((OCStruct)element).getSymbol());
                if (testName == null) {
                    return null;
                }
                if (location.isTyped()) {
                    scope = String.format("%s/%s/%s.%s", location.getInstantiation(), testName.first, param, testName.second);
                    break;
                }
                scope = String.format("%s/%s.%s/%s", location.getInstantiation(), testName.first, testName.second, param);
                break;
            }
            default: {
                scope = null;
            }
        }
        CidrTestScopeElement scopeElement = new CidrTestScopeElement(){

            @Override
            @Contract(pure=true)
            public String toString() {
                return scope;
            }
        };
        return scope == null ? null : scopeElement;
    }

    @Nullable
    private static CidrGoogleTestLocation getLocation(AbstractTestProxy test, Project project2) {
        Location location = test.getLocation(project2, OCSearchScope.getProjectSourcesScope(project2));
        return location instanceof CidrGoogleTestLocation ? (CidrGoogleTestLocation)location : null;
    }

    private static int getTestDepth(AbstractTestProxy test) {
        int count = 0;
        while (test.getParent() != null) {
            test = test.getParent();
            ++count;
        }
        return count;
    }

    @Override
    @Nullable
    protected CidrCommandLineState createState(@NotNull CidrRunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull Executor executor, @NotNull CidrTestScope failedTests) {
        return ((CidrTestRunConfiguration)((Object)configuration)).createState(env, executor, failedTests);
    }

    @Override
    protected CidrTestScope createTestScope() {
        return new CidrTestScope(':');
    }
}

