/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.testing.CidrScopeInfo;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CidrGoogleTestRunConfigurationData
extends CidrTestRunConfigurationData {
    public static final String FRAMEWORK_NAME = "GoogleTest";
    public static final String GOOGLE_TEST = CidrBundle.message("gtest.google.test", new Object[0]);

    public CidrGoogleTestRunConfigurationData(@NotNull Project project2) {
        super(project2);
    }

    @Override
    @NotNull
    protected String formatTestMethod() {
        return this.myTestSuite + "." + this.myTestName;
    }

    @Override
    public void checkData() throws RuntimeConfigurationException {
        String typedTestClassName;
        if (this.myTestMode == CidrScopeInfo.Mode.PATTERN || this.myTestSuite == null || CidrTestRunConfigurationEditorWithLWValidation.isLWValidationOn(this.myProject)) {
            return;
        }
        Collection<OCStructSymbol> suiteSymbols = CidrGoogleTestUtil.findGoogleTestSymbolsForSuiteRandomly(this.myProject, this.myTestSuite, this.myTestName == null);
        if (suiteSymbols.isEmpty()) {
            throw new RuntimeConfigurationError(CidrBundle.message("gtest.suiteNotFound", this.myTestSuite));
        }
        if (this.myTestName == null) {
            return;
        }
        String testClassName = this.myTestSuite + "_" + this.myTestName + "_Test";
        boolean methodFound = ContainerUtil.exists(suiteSymbols, arg_0 -> CidrGoogleTestRunConfigurationData.lambda$checkData$0(testClassName, typedTestClassName = "::gtest_case_" + this.myTestSuite + "_::" + this.myTestName, arg_0));
        if (!methodFound) {
            throw new RuntimeConfigurationError(CidrBundle.message("test.testNotFound", this.formatTestMethod()));
        }
    }

    private static /* synthetic */ boolean lambda$checkData$0(String testClassName, String typedTestClassName, OCStructSymbol symbol) {
        return testClassName.equals(symbol.getName()) || symbol.getType().getCanonicalName().endsWith(typedTestClassName);
    }
}

