/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.google.common.collect.Maps;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.ui.OCFieldAdapterForSymbolName;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestRunConfigurationEditor<CONFIGURATION extends CidrRunConfiguration, BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrTestRunConfigurationEditorWithLWValidation<OCSymbol, CONFIGURATION, BC, TARGET, BCH> {
    private final NavigableMap<String, OCStructSymbol> myTestSymbols = Maps.synchronizedNavigableMap(new TreeMap());
    private AtomicReference<String> myCollectingSuiteName = new AtomicReference();

    public CidrGoogleTestRunConfigurationEditor(@NotNull Project project2, @NotNull BCH configHelper) {
        super(project2, configHelper);
    }

    @Override
    @NotNull
    protected Condition<OCSymbol> createSuiteCompletionCondition() {
        return symbol -> symbol instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)symbol);
    }

    private boolean collectTestSymbols(final @NotNull Project project2, final @NotNull String suiteName) {
        if (this.getAnySymbolForSuite(suiteName) != null) {
            return false;
        }
        String alreadyRunning = this.myCollectingSuiteName.getAndSet(suiteName);
        if (!suiteName.equals(alreadyRunning)) {
            final Computable action = () -> {
                Collection<OCStructSymbol> symbols = CidrGoogleTestUtil.findGoogleTestSymbolsForSuiteSorted(project2, suiteName);
                Pattern simpleTestPattern = CidrGoogleTestUtil.getSimpleTestPattern(suiteName);
                for (OCStructSymbol s : symbols) {
                    String name;
                    if (simpleTestPattern.matcher(s.getName()).matches()) {
                        name = s.getName();
                    } else {
                        Couple<String> res = CidrGoogleTestUtil.extractGoogleTestName(s);
                        CidrTestLog.LOG.assertTrue(res != null);
                        name = (String)res.first + "_" + (String)res.second + "_Test";
                    }
                    this.myTestSymbols.put(name, s);
                }
                return () -> {
                    if (suiteName.equals(this.getTestSuiteText())) {
                        this.scheduleSuiteAndTestsUpdate();
                    }
                };
            };
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode()) {
                ((Runnable)app.runReadAction(action)).run();
            } else {
                ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ReadTask(){

                    @Override
                    public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                        return new ReadTask.Continuation((Runnable)action.compute(), ModalityState.any());
                    }

                    @Override
                    public void onCanceled(@NotNull ProgressIndicator indicator) {
                        if (!project2.isDisposed() && CidrGoogleTestRunConfigurationEditor.this.getAnySymbolForSuite(suiteName) == null) {
                            ProgressIndicatorUtils.scheduleWithWriteActionPriority(this);
                        }
                    }
                });
            }
        }
        return true;
    }

    @NotNull
    protected OCFieldAdapterForSymbolName createSuiteAdapter() {
        return new OCFieldAdapterForSymbolName(){

            @Override
            protected boolean isTopLevelOnly() {
                return false;
            }

            @Override
            @NotNull
            public String getReadableName(@NotNull OCSymbol symbol) {
                Couple<String> pair;
                if (symbol instanceof OCStructSymbol && (pair = CidrGoogleTestUtil.extractGoogleTestName((OCStructSymbol)symbol)) != null) {
                    return (String)pair.first;
                }
                return super.getReadableName(symbol);
            }
        };
    }

    @Nullable
    private OCStructSymbol getAnySymbolForSuite(@NotNull String suiteName) {
        String prefix = suiteName + "_";
        Map.Entry<String, OCStructSymbol> entry = this.myTestSymbols.ceilingEntry(prefix);
        return entry != null && entry.getKey().startsWith(prefix) ? entry.getValue() : null;
    }

    @Override
    public boolean isValidSuiteName() {
        String className = this.getTestSuiteText();
        if (className == null || this.collectTestSymbols(this.myProject, className)) {
            return false;
        }
        OCStructSymbol symbol = this.getAnySymbolForSuite(className);
        return symbol != null && CidrGoogleTestUtil.googleTestNameMatches(symbol, className);
    }

    @Override
    @NotNull
    public Set<String> collectSuiteTests() {
        String className = this.getTestSuiteText();
        if (className == null || this.collectTestSymbols(this.myProject, className)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        String prefix = className + "_";
        for (Map.Entry<String, OCStructSymbol> each : this.myTestSymbols.tailMap(prefix).entrySet()) {
            if (!each.getKey().startsWith(prefix)) break;
            Couple<String> name = CidrGoogleTestUtil.extractGoogleTestName(each.getValue());
            if (name == null || !((String)name.getFirst()).equals(className)) continue;
            result2.add((String)name.second);
        }
        return result2;
    }

    @Override
    @NotNull
    protected List<TARGET> getTargets() {
        return ContainerUtil.filter(this.myConfigHelper.getTargets(), target -> target.isExecutable());
    }

    @Override
    protected String getSuitePlaceholder() {
        return CidrBundle.message("gtest.allTestSuites", new Object[0]);
    }

    @Override
    protected String getSuitesTipMessage() {
        return CidrBundle.message("gtest.testSuitesTip", new Object[0]);
    }

    @Override
    protected String getTestFieldLabelName() {
        return CidrBundle.message("test.configuration.test", new Object[0]);
    }

    @Override
    protected String getSuiteFieldLabelName() {
        return CidrBundle.message("gtest.configuration.suite", new Object[0]);
    }

    @Override
    protected String getAllTestsMessage() {
        return CidrBundle.message("gtest.allTestsInSuite", new Object[0]);
    }
}

