/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrScopeInfo;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationProducer;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLocation;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestObject;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestScopeElement;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrGoogleTestRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>>
extends CidrTestRunConfigurationProducer<BC, TARGET, CONFIGURATION, CidrGoogleTestObject> {
    protected CidrGoogleTestRunConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    protected PsiElement getElement(@NotNull CidrGoogleTestObject testObj) {
        return testObj.element;
    }

    @Override
    @Nullable
    protected CidrScopeInfo determineScope(@NotNull List<CidrGoogleTestObject> testObj) {
        return this.determineScope(testObj, ":");
    }

    @Override
    protected boolean isTestTarget(@NotNull TARGET target) {
        return target.isExecutable();
    }

    @Override
    @NotNull
    protected CidrTestScopeElement createScopeElement(@NotNull CidrScopeInfo scope) {
        return new CidrGoogleTestScopeElement(scope.getSuite(), scope.getTest(), null, null);
    }

    @Override
    @Nullable
    protected CidrScopeInfo determineScope(@NotNull CidrGoogleTestObject object) {
        if (object.kind == CidrGoogleTestObject.KIND.FILE) {
            Collection classes2 = PsiTreeUtil.findChildrenOfType((PsiElement)this.getElement(object), OCStruct.class);
            List suiteNames = ContainerUtil.mapNotNull((Collection)classes2, s -> {
                OCStructSymbol symbol = (OCStructSymbol)s.getSymbol();
                if (symbol == null || !CidrGoogleTestUtil.isGoogleTestClass(symbol)) {
                    return null;
                }
                Couple<String> pair = CidrGoogleTestUtil.extractGoogleTestName((OCStructSymbol)s.getSymbol());
                return pair == null ? s.getName() : (String)pair.first;
            });
            if (!suiteNames.isEmpty()) {
                Function f = s -> new CidrGoogleTestScopeElement((String)s, null, null, null);
                return new CidrScopeInfo(null, null, CidrBundle.message("test.defaultName.allTestsIn", ((OCFile)this.getElement(object)).getName()), StringUtil.join((Iterable)ContainerUtil.map(new LinkedHashSet(suiteNames), (Function)f), (String)":"));
            }
            return null;
        }
        Couple<String> res = CidrGoogleTestUtil.extractGoogleTestName((OCStructSymbol)((OCStruct)this.getElement(object)).getSymbol());
        if (res == null) {
            if (object.param == null) {
                return new CidrScopeInfo(((OCStruct)this.getElement(object)).getName(), null, null, null);
            }
            String suiteName = ((OCStruct)this.getElement(object)).getName();
            return new CidrScopeInfo(null, null, suiteName, new CidrGoogleTestScopeElement(suiteName, null, null, object.param).toString());
        }
        if (object.param == null && object.instantiation == null) {
            return new CidrScopeInfo((String)res.first, object.kind == CidrGoogleTestObject.KIND.TEST ? (String)res.second : null, null, null);
        }
        String testName = object.kind == CidrGoogleTestObject.KIND.TEST ? (String)res.second : null;
        String configurationName = (String)res.first;
        if (object.instantiation != null) {
            configurationName = object.instantiation + "-" + configurationName;
        }
        if (testName != null) {
            configurationName = configurationName + "." + testName;
        }
        return new CidrScopeInfo(null, null, configurationName, new CidrGoogleTestScopeElement((String)res.first, testName, object.instantiation, object.param).toString());
    }

    @Override
    @Nullable
    protected CidrGoogleTestObject findTestObject(@NotNull Location location) {
        PsiElement element = location.getPsiElement();
        if (location instanceof CidrGoogleTestLocation) {
            CidrGoogleTestObject object;
            CidrGoogleTestLocation gLocation = (CidrGoogleTestLocation)location;
            if (!(element instanceof OCStruct) && (object = CidrGoogleTestRunConfigurationProducer.findTestObject(element)) != null) {
                element = this.getElement(object);
            }
            if (element instanceof OCStruct) {
                return new CidrGoogleTestObject(gLocation.isSuiteOnly() ? CidrGoogleTestObject.KIND.SUITE : CidrGoogleTestObject.KIND.TEST, element, gLocation.getInstantiation(), gLocation.getParam());
            }
        }
        return CidrGoogleTestRunConfigurationProducer.findTestObject(element);
    }

    @Nullable
    private static CidrGoogleTestObject findTestObject(@NotNull PsiElement element) {
        OCSymbol owner;
        OCSymbolWithQualifiedName resolvedOwner;
        OCFunctionSymbol symbol;
        OCSymbol parentSymbol;
        PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCFunctionDefinition.class, OCStruct.class});
        if (parent instanceof OCStruct && (parentSymbol = ((OCStruct)parent).getSymbol()) != null && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)parentSymbol)) {
            return new CidrGoogleTestObject(CidrGoogleTestObject.KIND.TEST, parent);
        }
        if (parent instanceof OCFunctionDefinition && (symbol = ((OCFunctionDefinition)parent).getSymbol()) != null && (resolvedOwner = symbol.getResolvedOwner()) != null && (owner = resolvedOwner.getDefinitionSymbol()) instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)owner)) {
            OCStruct struct = (OCStruct)owner.locateDefinition();
            return struct == null ? null : new CidrGoogleTestObject(CidrGoogleTestObject.KIND.TEST, struct);
        }
        parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class, OCFile.class});
        if (parent instanceof OCMacroCall) {
            Collection<OCStructSymbol> res;
            Couple<String> suite;
            List<OCMacroCallArgument> arguments;
            OCMacroCall gtestMacro = CidrGoogleTestUtil.findGoogleTestMacros(parent);
            if (gtestMacro != null && (arguments = gtestMacro.getArguments()).size() >= 2) {
                OCStruct targetElement;
                OCMacroCallArgument suiteArg = arguments.get(0);
                OCMacroCallArgument testArg = arguments.get(1);
                boolean isSuite = CidrGoogleTestRunConfigurationProducer.isFirstArgument(PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCallArgument.class)) || CidrGoogleTestRunConfigurationProducer.isFirstArgument(element.getPrevSibling());
                String suiteName = CidrGoogleTestUtil.extractArgumentValue(suiteArg);
                String testName = CidrGoogleTestUtil.extractArgumentValue(testArg);
                OCStructSymbol symbol2 = CidrGoogleTestUtil.findGoogleTestSymbol(element.getProject(), suiteName, testName);
                if (symbol2 != null && (targetElement = (OCStruct)symbol2.locateDefinition()) != null) {
                    return new CidrGoogleTestObject(isSuite ? CidrGoogleTestObject.KIND.SUITE : CidrGoogleTestObject.KIND.TEST, targetElement);
                }
            }
            if ((suite = CidrGoogleTestUtil.extractFullSuiteNameFromMacro(parent)) != null && (res = CidrGoogleTestUtil.findGoogleTestSymbolsForSuiteRandomly(element.getProject(), (String)suite.first, true)).size() != 0) {
                OCStruct struct = (OCStruct)res.iterator().next().locateDefinition();
                if (struct == null) {
                    return null;
                }
                return new CidrGoogleTestObject(CidrGoogleTestObject.KIND.SUITE, struct, (String)suite.second, null);
            }
        } else if (parent instanceof OCFile) {
            return new CidrGoogleTestObject(CidrGoogleTestObject.KIND.FILE, parent);
        }
        return null;
    }

    private static boolean isFirstArgument(@Nullable PsiElement element) {
        OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCall.class);
        if (macroCall != null) {
            List<OCMacroCallArgument> arguments = macroCall.getArguments();
            return arguments.size() > 0 && arguments.get(0).equals(element);
        }
        return false;
    }

    @Override
    protected String formatTestName(CidrScopeInfo scope) {
        return scope.getSuite() + "." + scope.getTest();
    }
}

