/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestUtil {
    private static final Pattern namePattern = Pattern.compile("\\w+_\\w+_Test");
    private static final Set<String> GOOGLE_TEST_MACRO_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"GTEST_TEST_", "TEST_P", "TYPED_TEST", "TYPED_TEST_P"});

    @Nullable
    public static OCStructSymbol findGoogleTestSymbol(Project project2, @NotNull String suiteName, @NotNull String testName) {
        boolean found;
        Ref result2 = new Ref();
        boolean bl = found = !OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)((Processor)ocSymbol -> {
            if (ocSymbol instanceof OCStructSymbol && CidrGoogleTestUtil.googleTestNameMatches((OCStructSymbol)ocSymbol, suiteName, testName)) {
                result2.set((Object)((OCStructSymbol)ocSymbol));
                return false;
            }
            return true;
        }), suiteName + "_" + testName + "_Test");
        if (!found) {
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)((Processor)symbol -> {
                OCSymbol res;
                OCSymbol oCSymbol = res = symbol instanceof OCNamespaceSymbol ? ((OCNamespaceSymbol)symbol).findMember(testName) : null;
                if (res instanceof OCStructSymbol) {
                    result2.set((Object)((OCStructSymbol)res));
                }
                return true;
            }), "gtest_case_" + suiteName + "_");
        }
        return (OCStructSymbol)result2.get();
    }

    @NotNull
    public static Collection<OCStructSymbol> findGoogleTestSymbols(Project project2) {
        return CidrGoogleTestUtil.findGoogleTestSymbolsForSuite(project2, null, false, true);
    }

    @NotNull
    public static Collection<OCStructSymbol> findGoogleTestSymbolsForSuiteRandomly(Project project2, @Nullable String suiteName, boolean onlyFirst) {
        return CidrGoogleTestUtil.findGoogleTestSymbolsForSuite(project2, suiteName, onlyFirst, false);
    }

    @NotNull
    public static Collection<OCStructSymbol> findGoogleTestSymbolsForSuiteSorted(Project project2, @Nullable String suiteName) {
        return CidrGoogleTestUtil.findGoogleTestSymbolsForSuite(project2, suiteName, false, true);
    }

    @NotNull
    private static Collection<OCStructSymbol> findGoogleTestSymbolsForSuite(Project project2, final @Nullable String suiteName, boolean onlyFirst, boolean sorted) {
        Pattern suiteNamePattern = suiteName == null ? namePattern : CidrGoogleTestUtil.getSimpleTestPattern(suiteName);
        ArrayList<OCStructSymbol> result2 = new ArrayList<OCStructSymbol>();
        CommonProcessors.CollectProcessor<OCSymbol> allNamespaceCollector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCNamespaceSymbol && (suiteName == null || symbol.getName().contains(suiteName));
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)allNamespaceCollector, null);
        Processor processor2 = symbol -> {
            OCStructSymbol foundSymbol = null;
            if (symbol instanceof OCStructSymbol) {
                boolean ok;
                OCStructSymbol s = (OCStructSymbol)symbol;
                boolean bl = ok = suiteNamePattern.matcher(s.getName()).matches() && (suiteName == null || CidrGoogleTestUtil.googleTestNameMatches(s, suiteName)) && CidrGoogleTestUtil.isGoogleTestClass(s) && !CidrGoogleTestUtil.isTypeParameterizedTest(s);
                if (ok) {
                    foundSymbol = s;
                }
            } else {
                boolean ok;
                boolean bl = suiteName == null ? symbol.getName().startsWith("gtest_case_") && symbol.getName().endsWith("_") : (ok = symbol.getName().equals("gtest_case_" + suiteName + "_"));
                if (ok) {
                    CommonProcessors.FindFirstProcessor<OCSymbol> processor1 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                        protected boolean accept(OCSymbol symbol) {
                            return symbol instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)symbol);
                        }
                    };
                    ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<OCSymbol>)processor1);
                    if (processor1.isFound()) {
                        foundSymbol = (OCStructSymbol)processor1.getFoundValue();
                    }
                }
            }
            if (foundSymbol != null) {
                result2.add(foundSymbol);
                return !onlyFirst;
            }
            return true;
        };
        ContainerUtil.process((Iterable)allNamespaceCollector.getResults(), (Processor)processor2);
        if (!onlyFirst && sorted) {
            ContainerUtil.sort(result2, (s1, s2) -> {
                int res = s1.getName().compareTo(s2.getName());
                if (res != 0) {
                    return res;
                }
                res = s1.getOffset() - s2.getOffset();
                if (res != 0) {
                    return res;
                }
                return s1.getContainingFile() == null || s2.getContainingFile() == null ? 0 : FileUtil.comparePaths((String)s1.getContainingFile().getPath(), (String)s2.getContainingFile().getPath());
            });
        }
        return result2;
    }

    public static Pattern getSimpleTestPattern(String suiteName) {
        return Pattern.compile(Pattern.quote(suiteName) + "_\\w+_Test");
    }

    private static boolean isTypeParameterizedTest(OCStructSymbol symbol) {
        return !CidrGoogleTestUtil.extractTypeParameterizedArguments(symbol).isEmpty();
    }

    @Contract(value="null, _ -> false")
    public static boolean isGoogleTestFixture(@Nullable OCStructSymbol symbol, boolean recursively) {
        return symbol != null && CidrGoogleTestUtil.findGoogleTestFixture(symbol, recursively) != null;
    }

    @Nullable
    public static OCStructSymbol findGoogleTestFixture(@NotNull OCStructSymbol symbol, boolean recursively) {
        if (CidrGoogleTestUtil.isGoogleTestClass(symbol) && CidrGoogleTestUtil.extractGoogleTestName(symbol) == null) {
            return symbol;
        }
        if (!recursively) {
            return null;
        }
        Ref found = Ref.create();
        OCResolveContext context = new OCResolveContext(symbol.getContainingOCFile());
        symbol.processAllBaseClasses(context, (symbol1, visibility) -> {
            boolean ok;
            boolean bl = ok = symbol1 instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestFixture((OCStructSymbol)symbol1, false);
            if (ok) {
                found.set((Object)((OCStructSymbol)symbol1));
            }
            return !ok;
        }, false);
        return (OCStructSymbol)found.get();
    }

    public static boolean isGoogleTestClass(@NotNull OCStructSymbol symbol) {
        return symbol.getKind() == OCSymbolKind.STRUCT && CidrGoogleTestUtil.isGoogleTestClassWithAnyAncestor(symbol, "Test");
    }

    public static boolean isGoogleTestClassWithAnyAncestor(@NotNull OCStructSymbol symbol, String ... ancestorNames) {
        Set canonicalNames = ContainerUtil.map2Set((Object[])ancestorNames, s -> "::testing::" + s);
        return !symbol.processAllBaseClasses((symbol1, visibility) -> {
            if (!(symbol1 instanceof OCSymbolWithQualifiedName)) {
                return true;
            }
            OCQualifiedName qualifiedName = ((OCSymbolWithQualifiedName)symbol1).getResolvedQualifiedName(false);
            return qualifiedName == null || !canonicalNames.contains(qualifiedName.getCanonicalName(true));
        });
    }

    @Nullable
    public static Couple<String> extractGoogleTestName(@Nullable OCStructSymbol symbol) {
        List<Object> arguments = Collections.emptyList();
        if (symbol != null) {
            OCDeclarator varDeclarator;
            OCDeclaration declaration2;
            String name = symbol.getName();
            if (name.endsWith("_Test") && (declaration2 = (OCDeclaration)PsiTreeUtil.getParentOfType(symbol.locateDefinition(), OCDeclaration.class)) != null && (varDeclarator = (OCDeclarator)PsiTreeUtil.getChildOfType((PsiElement)(declaration2 = (OCDeclaration)PsiTreeUtil.getNextSiblingOfType((PsiElement)declaration2, OCDeclaration.class)), OCDeclarator.class)) != null) {
                if ("test_info_".equals(varDeclarator.getName())) {
                    arguments = CidrGoogleTestUtil.extractMethodArguments(varDeclarator);
                } else {
                    List<OCExpression> result2;
                    String varName = "gtest_" + name.substring(0, name.length() - "_Test".length()) + "_registered_";
                    if (varName.equals(varDeclarator.getName()) && (result2 = CidrGoogleTestUtil.extractMethodArguments(varDeclarator)).size() >= 3) {
                        arguments = result2.subList(1, 3);
                    }
                }
            }
            if (arguments.isEmpty()) {
                arguments = CidrGoogleTestUtil.extractMethodArguments(symbol, "AddToRegistry");
            }
            if (arguments.isEmpty()) {
                arguments = CidrGoogleTestUtil.extractTypeParameterizedArguments(symbol);
            }
        }
        if (arguments.size() >= 2) {
            String className = StringUtil.stripQuotesAroundValue((String)CidrGoogleTestUtil.extractArgumentValue((PsiElement)arguments.get(0)));
            String methodName = StringUtil.stripQuotesAroundValue((String)CidrGoogleTestUtil.extractArgumentValue((PsiElement)arguments.get(1)));
            return Couple.of((Object)className, (Object)methodName);
        }
        return null;
    }

    private static List<OCExpression> extractTypeParameterizedArguments(OCStructSymbol symbol) {
        List<OCExpression> arguments = Collections.emptyList();
        if (symbol.getParent() instanceof OCNamespaceSymbol && (arguments = CidrGoogleTestUtil.extractMethodArguments((OCNamespaceSymbol)symbol.getParent(), "gtest_" + symbol.getName() + "_defined_")).size() >= 4) {
            arguments = arguments.subList(2, 4);
        }
        return arguments;
    }

    public static boolean googleTestNameMatches(@NotNull OCStructSymbol symbol, @NotNull String suiteName) {
        return CidrGoogleTestUtil.googleTestNameMatches(symbol, suiteName, null);
    }

    public static boolean googleTestNameMatches(@NotNull OCStructSymbol symbol, @NotNull String suiteName, @Nullable String testName) {
        Couple<String> name = CidrGoogleTestUtil.extractGoogleTestName(symbol);
        return name != null && suiteName.equals(name.first) && (testName == null || testName.equals(name.second));
    }

    @Nullable
    public static OCMacroCall findGoogleTestMacros(@Nullable PsiElement element) {
        return CidrGoogleTestUtil.findMacros(element, GOOGLE_TEST_MACRO_NAMES);
    }

    @Nullable
    private static OCMacroCall findMacros(@Nullable PsiElement element, @NotNull Set<String> macroNames) {
        element = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class});
        while (element instanceof OCMacroCall) {
            String referenceName;
            OCReferenceElement referenceElement = ((OCMacroCall)element).getMacroReferenceElement();
            String string = referenceName = referenceElement == null ? null : referenceElement.getName();
            if (macroNames.contains(referenceName)) {
                return (OCMacroCall)element;
            }
            element = element.getNextSibling();
        }
        return null;
    }

    @Nullable
    public static Couple<String> extractFullSuiteNameFromMacro(@NotNull PsiElement element) {
        List<String> result2 = CidrGoogleTestUtil.extractMacroArgumentValues(element, ContainerUtil.newHashSet((Object[])new String[]{"INSTANTIATE_TEST_CASE_P", "INSTANTIATE_TYPED_TEST_CASE_P"}), 0, 1);
        if (result2.isEmpty()) {
            result2 = CidrGoogleTestUtil.extractMacroArgumentValues(element, ContainerUtil.newHashSet((Object[])new String[]{"TYPED_TEST_CASE", "TYPED_TEST_CASE_P", "REGISTER_TYPED_TEST_CASE_P"}), 0, 0);
            return result2.isEmpty() ? null : Couple.of((Object)result2.get(0), null);
        }
        return Couple.of((Object)result2.get(1), (Object)result2.get(0));
    }

    @NotNull
    private static List<String> extractMacroArgumentValues(@NotNull PsiElement element, Set<String> macroNames, int beginIndex, int endIndex) {
        List<OCMacroCallArgument> arguments;
        ArrayList<String> result2 = new ArrayList<String>();
        OCMacroCall macroCall = CidrGoogleTestUtil.findMacros(element, macroNames);
        if (macroCall != null && (arguments = macroCall.getArguments()).size() > endIndex) {
            while (beginIndex <= endIndex) {
                result2.add(CidrGoogleTestUtil.extractArgumentValue(arguments.get(beginIndex++)));
            }
        }
        return result2;
    }

    @NotNull
    public static String extractArgumentValue(@Nullable PsiElement element) {
        LeafPsiElement leafPsiElement = (LeafPsiElement)PsiTreeUtil.findChildOfType((PsiElement)element, LeafPsiElement.class);
        return leafPsiElement == null ? "" : StringUtil.notNullize((String)leafPsiElement.getText());
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@NotNull OCNamespaceSymbol parent, @NotNull String methodName) {
        OCSymbol member = parent.findMember(methodName);
        return member != null ? CidrGoogleTestUtil.extractMethodArguments(member) : Collections.emptyList();
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@Nullable PsiElement psiElement) {
        PsiElement parent;
        OCCallExpression expression2;
        if (psiElement != null && (expression2 = (OCCallExpression)PsiTreeUtil.findChildOfType((PsiElement)(parent = psiElement.getParent()), OCCallExpression.class)) != null) {
            return expression2.getArguments();
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@NotNull OCSymbol symbol) {
        return CidrGoogleTestUtil.extractMethodArguments(symbol.locateDefinition());
    }

    @Nullable
    public static OCSymbol findGoogleTestInstantiationSymbol(@NotNull Project project2, @NotNull String suiteName, @NotNull String instantiationName) {
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)processor2, "gtest_" + instantiationName + suiteName + "_dummy_");
        if (processor2.isFound()) {
            return (OCSymbol)processor2.getFoundValue();
        }
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)processor2, "gtest_" + instantiationName + "_" + suiteName);
        return (OCSymbol)processor2.getFoundValue();
    }

    public static boolean fileIncludesGoogleTest(final PsiFile file2) {
        CommonProcessors.CollectProcessor<OCSymbol> processor2 = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCStructSymbol && "::testing::TestCase".equals(symbol.getType().getCanonicalName((PsiElement)file2));
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(file2.getProject(), (Processor<OCSymbol>)processor2, "TestCase");
        for (OCSymbol testSymbol : processor2.getResults()) {
            Collection<VirtualFile> roots;
            if (testSymbol.getContainingFile() == null || !(roots = OCImportGraph.getAllHeaderRoots(file2.getProject(), testSymbol.getContainingFile())).contains(file2.getVirtualFile())) continue;
            return true;
        }
        return false;
    }
}

