/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.CidrConsoleBuilder;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrScopeInfo;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestScopeElement;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestCommandLineState
extends CidrTestCommandLineState {
    public static final CidrTestScope ALL_VISIBLE_TESTS = CidrCatchTestCommandLineState.getFromString(null);
    public static final CidrTestScope NO_TESTS = CidrCatchTestCommandLineState.getFromString("*");

    @NotNull
    @Contract(value="_ -> !null")
    public static CidrTestScope getFromString(final @Nullable String arg) {
        return new CidrTestScope(){

            @Override
            public String toString() {
                return StringUtil.notNullize((String)arg);
            }
        };
    }

    public CidrCatchTestCommandLineState(@NotNull RunConfiguration configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        super(configuration, launcher, env, executor, failedTests);
    }

    @Override
    @NotNull
    public CidrTestScope testScope() {
        if (this.myFailedTests != null) {
            return CidrCatchTestCommandLineState.getFromString(StringUtil.join(this.myFailedTests.getElements(), testScope -> this.prepareTestNameForScope(testScope.toString()), (String)","));
        }
        CidrTestRunConfigurationData delegate = ((CidrTestRunConfiguration)this.myConfiguration).getTestData();
        if (delegate.getTestMode() == CidrScopeInfo.Mode.PATTERN) {
            return CidrCatchTestCommandLineState.getFromString(delegate.getTestPattern());
        }
        if (delegate.getTestMode() == CidrScopeInfo.Mode.SUITE_TEST) {
            if (delegate.getTestName() == null && delegate.getTestSuite() == null) {
                return ALL_VISIBLE_TESTS;
            }
            if (delegate.getTestName() == null && delegate.getTestSuite() != null) {
                return CidrCatchTestCommandLineState.getFromString(delegate.getTestSuite());
            }
            return CidrCatchTestCommandLineState.getFromString(this.prepareTestNameForScope(delegate.getTestName()));
        }
        OCLog.LOG.error("Unknown CidrTestRunConfigurationData.Mode: " + (Object)((Object)delegate.getTestMode()));
        return NO_TESTS;
    }

    @NotNull
    protected String prepareTestNameForScope(String testName) {
        return StringUtil.escapeChars((String)testName, (char[])new char[]{',', '[', ']'});
    }

    @Override
    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(SMTRunnerConsoleView consoleView) {
        return new CidrCatchTestRerunFailedTestsAction((ComponentContainer)consoleView);
    }

    @Override
    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@Nullable String testTags, @Nullable String testMethod) {
        return new CidrCatchTestScopeElement(testTags, testMethod);
    }

    @Contract(pure=true)
    @NotNull
    public static TextConsoleBuilder createConsoleBuilder(@NotNull Project project2, final @NotNull CommandLineState state, @NotNull CidrToolEnvironment environment, @Nullable File projectBaseDir) {
        return new CidrConsoleBuilder(project2, environment, projectBaseDir){

            @Override
            @NotNull
            protected ConsoleView createConsole() {
                CidrCatchTestCommandLineState catchState = (CidrCatchTestCommandLineState)state;
                return this.createConsole(catchState.getConfiguration().getType(), new CidrCatchTestConsoleProperties(catchState.getConfiguration(), catchState.getExecutor(), catchState.getExecutionTarget()));
            }
        };
    }

    @Contract(pure=true)
    public static GeneralCommandLine prepareCommandLine(@NotNull CommandLineState state, @NotNull GeneralCommandLine cl) {
        cl.addParameters(new String[]{"-r", "xml", "-d", "yes"});
        String scope = ((CidrTestCommandLineState)state).testScope().toString();
        String testOrderSwitch = "--order";
        if (!cl.getParametersList().hasParameter("--order")) {
            cl.addParameters(new String[]{"--order", "lex"});
        }
        if (scope != null) {
            CidrCatchTestCommandLineState.fixtureForAllTestsInFile(cl, scope);
            cl.addParameter(scope);
        }
        return cl;
    }

    private static void fixtureForAllTestsInFile(@NotNull GeneralCommandLine cl, @NotNull String maybeRunAllInFileScope) {
        if (maybeRunAllInFileScope.startsWith("[#") && maybeRunAllInFileScope.endsWith("]")) {
            cl.addParameter("-#");
        }
    }
}

