/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestCache;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestLocation;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestObject;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestRunConfigurationProducer;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrCatchTestLocationProvider
implements SMTestLocator {
    public static final String PROTOCOL = "catch";
    public static final CidrCatchTestLocationProvider INSTANCE = new CidrCatchTestLocationProvider();

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        int lineNum;
        Document document;
        PsiFile file2;
        if (!PROTOCOL.equals(protocol)) {
            return Collections.emptyList();
        }
        Pair<String, Integer> locator = CidrCatchTestUtil.splitPath(path);
        CidrCatchTestCache info = CidrCatchTestUtil.findCatchTestSymbol((String)locator.first, project2, scope);
        if (info == null) {
            return Collections.emptyList();
        }
        if ((Integer)locator.second > 0 && (file2 = info.getDeclarator().getContainingFile()) != null && (document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2)) != null && (lineNum = (Integer)locator.second - 1) < document.getLineCount()) {
            CidrCatchTestObject testObject;
            int offset;
            CharSequence text = document.getCharsSequence();
            for (offset = document.getLineStartOffset(lineNum) + 1; offset < text.length() && StringUtil.isWhiteSpace((char)text.charAt(offset)); ++offset) {
            }
            PsiElement el = file2.findElementAt(offset);
            if (el != null && (testObject = CidrCatchTestRunConfigurationProducer.findTestObject(el, false)) != null && testObject.getTestInfo() != null && testObject.getTestInfo().getNotNullTestName().equals(locator.first)) {
                return Collections.singletonList(new PsiLocation(el));
            }
        }
        return Collections.singletonList(new CidrCatchTestLocation(project2, info));
    }
}

