/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.testing.CidrScopeInfo;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestCache;
import com.jetbrains.cidr.lang.psi.OCFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CidrCatchTestObject {
    private final KIND myKind;
    private final CidrCatchTestCache myTestInfo;
    private final String myPattern;
    private final OCFile myFile;

    public CidrCatchTestObject(@NotNull CidrCatchTestCache testInfo) {
        this.myKind = KIND.TEST;
        this.myTestInfo = testInfo;
        this.myPattern = null;
        this.myFile = null;
    }

    public CidrCatchTestObject(@NotNull String pattern, @NotNull OCFile file2) {
        this.myKind = KIND.FILE;
        this.myTestInfo = null;
        this.myPattern = pattern;
        this.myFile = file2;
    }

    public CidrScopeInfo getScope() {
        return this.myKind == KIND.TEST ? new CidrScopeInfo(this.myTestInfo.getTags(), this.myTestInfo.getTestName(), this.myTestInfo.getTestName(), null) : new CidrScopeInfo(null, null, CidrBundle.message("test.defaultName.allTestsIn", this.myFile.getName()), this.myPattern);
    }

    @NotNull
    public KIND getKind() {
        return this.myKind;
    }

    @Nullable
    public CidrCatchTestCache getTestInfo() {
        return this.myTestInfo;
    }

    @Nullable
    public String getPattern() {
        return this.myPattern;
    }

    @Nullable
    public OCFile getFile() {
        return this.myFile;
    }

    static enum KIND {
        FILE,
        TEST;

    }
}

