/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestLocation;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestRerunFailedTestsAction
extends CidrRerunFailedTestsAction {
    private static final String PROTOCOL_PREFIX = "catch://";

    public CidrCatchTestRerunFailedTestsAction(@NotNull ComponentContainer componentContainer) {
        super(componentContainer);
    }

    @Override
    @NotNull
    protected Filter getFilter(@NotNull Project project2, @NotNull GlobalSearchScope searchScope) {
        return super.getFilter(project2, searchScope).and(new Filter(){

            public boolean shouldAccept(AbstractTestProxy t) {
                return t.isLeaf();
            }
        });
    }

    @Override
    @Nullable
    protected CidrTestScopeElement getElement(@NotNull AbstractTestProxy test, @NotNull Project project2) {
        final String testName = CidrCatchTestRerunFailedTestsAction.getTestName(test);
        return testName == null ? null : new CidrTestScopeElement(){

            @Override
            @Contract(pure=true)
            public String toString() {
                return testName;
            }
        };
    }

    @Nullable
    private static String getTestName(@NotNull AbstractTestProxy test) {
        String url = test.getLocationUrl();
        if (url != null && url.startsWith(PROTOCOL_PREFIX)) {
            Pair<String, Integer> pair = CidrCatchTestUtil.splitPath(url.substring(PROTOCOL_PREFIX.length()));
            return (String)pair.first;
        }
        return null;
    }

    @Nullable
    private static CidrCatchTestLocation getLocation(AbstractTestProxy test, Project project2) {
        Location location = test.getLocation(project2, OCSearchScope.getProjectSourcesScope(project2));
        return location instanceof CidrCatchTestLocation ? (CidrCatchTestLocation)location : null;
    }

    @Override
    @Nullable
    protected CidrCommandLineState createState(@NotNull CidrRunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull Executor executor, @NotNull CidrTestScope failedTests) {
        return ((CidrTestRunConfiguration)((Object)configuration)).createState(env, executor, failedTests);
    }

    @Override
    protected CidrTestScope createTestScope() {
        return new CidrTestScope();
    }
}

