/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.testing.CidrScopeInfo;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CidrCatchTestRunConfigurationData
extends CidrTestRunConfigurationData {
    public static final String FRAMEWORK_NAME = CidrBundle.message("catch.test", new Object[0]);

    public CidrCatchTestRunConfigurationData(@NotNull Project project2) {
        super(project2);
    }

    @Override
    @NotNull
    protected String formatTestMethod() {
        assert (this.myTestName != null);
        return this.myTestName;
    }

    @Override
    public void checkData() throws RuntimeConfigurationException {
        if (this.myTestMode == CidrScopeInfo.Mode.PATTERN || CidrTestRunConfigurationEditorWithLWValidation.isLWValidationOn(this.myProject)) {
            return;
        }
        if (this.myTestName == null && this.myTestSuite == null) {
            return;
        }
        Set<String> configTags = CidrCatchTestUtil.splitTags(this.myTestSuite);
        int tagGrammarCount = configTags.size();
        if (!CidrCatchTestUtil.isValidStringOfTags(this.myTestSuite)) {
            throw new RuntimeConfigurationError(CidrBundle.message("catch.notValidTags", tagGrammarCount + 1, this.myTestSuite));
        }
        boolean[] validConfig = new boolean[]{false};
        CidrCatchTestUtil.consumeCatchTestSymbols(this.myProject, OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject), null, testInfo -> {
            Set<String> testTags = CidrCatchTestUtil.splitTags(testInfo.getTags());
            if (testTags.containsAll(configTags) && (this.myTestName == null || this.myTestName.equals(testInfo.getNotNullTestName()))) {
                validConfig[0] = true;
                CidrCatchTestUtil.stopIteration();
            }
        });
        if (!validConfig[0]) {
            throw new RuntimeConfigurationError(this.myTestName == null ? CidrBundle.message("catch.noTestsWithTags", tagGrammarCount, this.myTestSuite) : (this.myTestSuite == null ? CidrBundle.message("test.testNotFound", this.myTestName) : CidrBundle.message("catch.testNotFound", this.myTestName, tagGrammarCount, this.myTestSuite)));
        }
    }
}

