/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestCache;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestRunConfigurationEditor<CONFIGURATION extends CidrRunConfiguration, BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrTestRunConfigurationEditorWithLWValidation<String, CONFIGURATION, BC, TARGET, BCH> {
    private final ArrayList<CidrCatchTestCache> myTestInfo = new ArrayList();
    private static int INIT = 0;
    private static int WORKING = 1;
    private static int READY = 2;
    private final AtomicInteger myTestInfoState = new AtomicInteger(INIT);

    public CidrCatchTestRunConfigurationEditor(@NotNull Project project2, @NotNull BCH configHelper) {
        super(project2, configHelper);
    }

    @Override
    @NotNull
    protected Condition<String> createSuiteCompletionCondition() {
        return tag -> true;
    }

    @Override
    @NotNull
    protected OCFieldAdapter<String> createSuiteAdapter() {
        return new OCFieldAdapter<String>(){

            @Override
            @NotNull
            @Contract(pure=true)
            public String getName(String item) {
                return item == null ? "non-tagged" : item;
            }

            @Override
            @Contract(value="_ -> null", pure=true)
            public Icon getIcon(String item) {
                return null;
            }

            @Override
            @Contract(value="_ -> null", pure=true)
            public String getTypeText(String item) {
                return null;
            }

            @Override
            @NotNull
            @Contract(pure=true)
            public String getReadableName(String item) {
                return this.getName(item);
            }

            @Override
            @NotNull
            public Collection<String> collectValuesFromProject(@NotNull Project project2, @Nullable Condition<String> condition2) {
                return CidrCatchTestRunConfigurationEditor.this.collectStringsFromProject(CidrCatchTestRunConfigurationEditor.this.myProject, pair -> {
                    if (condition2 == null || condition2.value((Object)((CidrCatchTestCache)pair.first).getTags())) {
                        ((Set)pair.second).addAll(CidrCatchTestUtil.splitTags(((CidrCatchTestCache)pair.first).getTags()));
                    }
                });
            }

            @Override
            @Contract(pure=true)
            @NotNull
            public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
                return new TagPrefixMatcher(prefix);
            }

            @Override
            @NotNull
            public String getPrefix(@NotNull String text, int offset) {
                int i2 = Math.max(text.lastIndexOf(93, offset - 1), text.lastIndexOf(32, offset - 1)) + 1;
                int j = text.lastIndexOf(10, offset - 1) + 1;
                return text.substring(Math.max(i2, j), offset);
            }
        };
    }

    @Override
    public boolean isValidSuiteName() {
        String tagsInLine = this.getTestSuiteText();
        if (tagsInLine == null) {
            return false;
        }
        return "non-tagged".equals(tagsInLine) || CidrCatchTestUtil.isValidStringOfTags(tagsInLine);
    }

    @Override
    protected boolean isChecking() {
        return this.myTestInfoState.get() != READY;
    }

    @NotNull
    private Set<String> collectStringsFromProject(@NotNull Project project2, @Nullable Consumer<Pair<CidrCatchTestCache, Set<String>>> consumer2) {
        return OCFieldAdapter.collectAllValues(project2, Collections.emptySet(), () -> {
            if (project2.isDisposed() || this.isDisposed()) {
                return Collections.emptySet();
            }
            TreeSet result2 = new TreeSet();
            Consumer<CidrCatchTestCache> cachingConsumer = testInfo -> {
                ProgressManager.checkCanceled();
                if (this.myTestInfoState.get() == WORKING) {
                    this.myTestInfo.add((CidrCatchTestCache)testInfo);
                }
                if (consumer2 != null) {
                    consumer2.accept(Pair.create((Object)testInfo, (Object)result2));
                }
            };
            if (this.myTestInfoState.get() == READY) {
                this.myTestInfo.forEach(cachingConsumer);
            } else if ((!ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode()) && this.myTestInfoState.compareAndSet(INIT, WORKING)) {
                try {
                    CidrCatchTestUtil.consumeCatchTestSymbols(project2, OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project2), null, cachingConsumer);
                    this.myTestInfoState.set(READY);
                    this.scheduleSuiteAndTestsUpdate();
                }
                catch (Throwable throwable) {
                    this.myTestInfo.clear();
                    this.myTestInfoState.set(INIT);
                    throw throwable;
                }
            }
            return result2;
        });
    }

    @Override
    @NotNull
    public Set<String> collectSuiteTests() {
        String tags = this.getTestSuiteText();
        if (tags == null) {
            return Collections.emptySet();
        }
        Set<String> suiteTags = CidrCatchTestUtil.splitTags(tags);
        return this.collectStringsFromProject(this.myProject, pair -> {
            if (CidrCatchTestUtil.splitTags(((CidrCatchTestCache)pair.first).getTags()).containsAll(suiteTags)) {
                ((Set)pair.second).add(((CidrCatchTestCache)pair.first).getNotNullTestName());
            }
        });
    }

    @Override
    @NotNull
    protected List<TARGET> getTargets() {
        return ContainerUtil.filter(this.myConfigHelper.getTargets(), target -> target.isExecutable());
    }

    @Override
    protected String getSuitePlaceholder() {
        return CidrBundle.message("catch.allTestTags", new Object[0]);
    }

    @Override
    protected String getSuitesTipMessage() {
        return CidrBundle.message("catch.testSuitesTip", new Object[0]);
    }

    @Override
    protected String getTestFieldLabelName() {
        return CidrBundle.message("test.configuration.test", new Object[0]);
    }

    @Override
    protected String getSuiteFieldLabelName() {
        return CidrBundle.message("catch.configuration.tags", new Object[0]);
    }

    @Override
    protected String getAllTestsMessage() {
        return "non-tagged".equals(this.getTestSuiteText()) ? CidrBundle.message("catch.selectTestForNonTagged", new Object[0]) : CidrBundle.message("catch.allTestForTags", new Object[0]);
    }

    private static class TagPrefixMatcher
    extends PrefixMatcher {
        public TagPrefixMatcher(String prefix) {
            super(prefix);
        }

        public boolean prefixMatches(@NotNull String name) {
            return StringUtil.startsWith((CharSequence)name, (CharSequence)this.getPrefix());
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            return new TagPrefixMatcher(prefix);
        }
    }
}

