/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrScopeInfo;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationProducer;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestCache;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestLocation;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestObject;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestScopeElement;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrCatchTestRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>>
extends CidrTestRunConfigurationProducer<BC, TARGET, CONFIGURATION, CidrCatchTestObject> {
    protected CidrCatchTestRunConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    protected PsiElement getElement(@NotNull CidrCatchTestObject testObj) {
        return testObj.getKind() == CidrCatchTestObject.KIND.TEST ? testObj.getTestInfo().getDeclarator() : testObj.getFile();
    }

    @Override
    @Nullable
    protected abstract TARGET getTargetFromResolveConfiguration(@NotNull OCResolveConfiguration var1);

    @Override
    @Nullable
    protected CidrScopeInfo determineScope(@NotNull List<CidrCatchTestObject> testObj) {
        return this.determineScope(testObj, ",");
    }

    @Override
    protected boolean isTestTarget(@NotNull TARGET target) {
        return target.isExecutable();
    }

    @Override
    @NotNull
    protected CidrTestScopeElement createScopeElement(@NotNull CidrScopeInfo scope) {
        return new CidrCatchTestScopeElement(scope.getSuite(), scope.getTest());
    }

    @Override
    @Nullable
    protected CidrScopeInfo determineScope(@NotNull CidrCatchTestObject object) {
        if (object.getKind() == CidrCatchTestObject.KIND.FILE && !CidrCatchTestUtil.fileHasTest(object.getFile())) {
            return null;
        }
        return object.getScope();
    }

    @Override
    @Nullable
    protected CidrCatchTestObject findTestObject(@NotNull Location location) {
        if (location instanceof CidrCatchTestLocation) {
            return new CidrCatchTestObject(((CidrCatchTestLocation)location).getTestInfo());
        }
        return CidrCatchTestRunConfigurationProducer.findTestObject(location.getPsiElement(), true);
    }

    @Nullable
    static CidrCatchTestObject findTestObject(@NotNull PsiElement element, boolean fileIsTestObject) {
        while (element != null && !CidrCatchTestRunConfigurationProducer.isTestCandidate(element, fileIsTestObject)) {
            element = element.getParent();
        }
        if (element != null) {
            if (element instanceof OCFile) {
                VirtualFile vFile = ((OCFile)element).getVirtualFile();
                return vFile == null ? null : new CidrCatchTestObject("[#" + vFile.getNameWithoutExtension() + "]", (OCFile)element);
            }
            if (element instanceof OCMacroCall) {
                PsiElement start = ((OCMacroCall)element).getFirstExpansionLeaf();
                PsiElement end = ((OCMacroCall)element).getLastExpansionLeaf();
                PsiElement leaf = start;
                while (leaf != end && leaf != null) {
                    CidrCatchTestObject testObject = CidrCatchTestRunConfigurationProducer.findTestObject(leaf, false);
                    if (testObject != null) {
                        return testObject;
                    }
                    leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
                }
            }
            Ref result2 = new Ref();
            String maybeTestOwnerName = CidrCatchTestRunConfigurationProducer.getTestBodyOwnerNameIfCan(element);
            Consumer<CidrCatchTestCache> testConsumer = testInfo -> result2.set((Object)new CidrCatchTestObject((CidrCatchTestCache)testInfo));
            if (maybeTestOwnerName == null) {
                element.accept((PsiElementVisitor)CidrCatchTestUtil.getTestSymbolExtractorVisitor(testConsumer));
            } else {
                element.getContainingFile().accept((PsiElementVisitor)CidrCatchTestUtil.getTestSymbolExtractorLocalVisitor(maybeTestOwnerName, testConsumer));
            }
            return (CidrCatchTestObject)result2.get();
        }
        return null;
    }

    private static boolean isTestCandidate(@NotNull PsiElement element, boolean fileIsTestObject) {
        return fileIsTestObject && element instanceof OCFile || (element instanceof OCDeclaration || CidrCatchTestUtil.isTestMacroCandidate(element)) && (element.getParent() instanceof OCFile || element.getParent() instanceof OCCppNamespace) || CidrCatchTestRunConfigurationProducer.getTestBodyOwnerNameIfCan(element) != null;
    }

    @Nullable
    private static String getTestBodyOwnerNameIfCan(@NotNull PsiElement element) {
        OCDeclarator declarator;
        if (element instanceof OCFunctionDefinition && (declarator = ((OCFunctionDefinition)element).getDeclarator()) != null) {
            String functionName = declarator.getName();
            if (declarator.getNamespaceQualifier() != null && !declarator.getNamespaceQualifier().isEmpty()) {
                functionName = declarator.getNamespaceQualifier().getName() + "::" + functionName;
            }
            if (functionName.startsWith("____C_A_T_C_H____T_E_S_T____")) {
                return functionName;
            }
        }
        return null;
    }

    @Override
    protected String formatTestName(CidrScopeInfo scope) {
        return scope.getTest();
    }
}

