/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestCache;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestUtil {
    public static final String CATCH_HEADER_NAME = "catch.hpp";
    public static final String CATCH_ENABLE_DETECTION_KEY = "cidr.test.catch.enableDetection";
    public static final Set<String> CATCH_TEST_MACRO_NAMES = Collections.unmodifiableSet(ContainerUtil.newHashSet((Object[])new String[]{"SCENARIO", "SCENARIO_METHOD", "TEST_CASE", "TEST_CASE_METHOD", "METHOD_AS_TEST_CASE", "REGISTER_TEST_CASE", "ANON_TEST_CASE", "CATCH_SCENARIO", "CATCH_SCENARIO_METHOD", "CATCH_TEST_CASE", "CATCH_TEST_CASE_METHOD", "CATCH_METHOD_AS_TEST_CASE", "CATCH_REGISTER_TEST_CASE", "CATCH_ANON_TEST_CASE"}));
    public static final String NULL_TAG_PRESENTATION_NAME = "non-tagged";
    public static final String NULL_TEST_PRESENTATION_NAME = "Anonymous test case *";
    private static final Pattern TAG = Pattern.compile("(\\[[^\\[\\]]*\\])");
    private static final Pattern TAGS_VALIDATION = Pattern.compile("(?:\\[[^\\[\\]]*\\]\\s*)*");

    @Nullable
    public static CidrCatchTestCache findCatchTestSymbol(@NotNull String topTestName, @NotNull Project project2, @Nullable GlobalSearchScope scope) {
        Ref result2 = new Ref();
        CidrCatchTestUtil.consumeCatchTestSymbols(project2, OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project2), (SearchScope)scope, testInfo -> {
            if (topTestName.equals(testInfo.getNotNullTestName())) {
                result2.set(testInfo);
                CidrCatchTestUtil.stopIteration();
            }
        });
        return (CidrCatchTestCache)result2.get();
    }

    @NotNull
    @Contract(pure=true)
    public static Pair<String, Integer> splitPath(@NotNull String path) {
        int delim = path.lastIndexOf(58);
        return delim < 0 ? Pair.create((Object)path, (Object)-1) : Pair.create((Object)path.substring(0, delim), (Object)Integer.valueOf(path.substring(delim + 1)));
    }

    @Contract(value=" -> fail")
    static void stopIteration() throws StopException {
        throw new StopException();
    }

    static boolean wasStoppedWhileIteration(Runnable r) {
        try {
            r.run();
        }
        catch (StopException ignore) {
            return true;
        }
        return false;
    }

    static void consumeCatchTestSymbols(@NotNull Project project2, @NotNull Collection<VirtualFile> potentialTestHolders, @Nullable SearchScope scope, @NotNull Consumer<CidrCatchTestCache> consumer2) {
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        try {
            for (VirtualFile file2 : potentialTestHolders) {
                PsiFile psiFile;
                ProgressManager.checkCanceled();
                if (scope != null && !scope.contains(file2) || !OCFileTypeHelpers.isSourceFile(file2.getName()) || (psiFile = psiManager.findFile(file2)) == null) continue;
                psiFile.accept((PsiElementVisitor)CidrCatchTestUtil.getTestSymbolExtractorVisitor(consumer2));
            }
        }
        catch (StopException stopException) {
            // empty catch block
        }
    }

    @Contract(pure=true)
    @NotNull
    protected static OCVisitor getTestSymbolExtractorVisitor(@NotNull Consumer<CidrCatchTestCache> declaratorConsumer) {
        return new GlobalVisitor(declaratorConsumer);
    }

    @Contract(pure=true)
    @NotNull
    protected static LocalVisitor getTestSymbolExtractorLocalVisitor(@NotNull String testOwnerName, @NotNull Consumer<CidrCatchTestCache> declaratorConsumer) {
        return new LocalVisitor(testOwnerName, declaratorConsumer);
    }

    @Contract(value="null -> false")
    public static boolean isTestMacroCandidate(@Nullable PsiElement element) {
        OCReferenceElement referenceElement;
        if (element instanceof OCMacroCall && (referenceElement = ((OCMacroCall)element).getMacroReferenceElement()) != null) {
            return CATCH_TEST_MACRO_NAMES.contains(referenceElement.getName());
        }
        return false;
    }

    @Contract(value="null -> true")
    public static boolean isValidStringOfTags(@Nullable String tagsInLine) {
        if (tagsInLine == null || tagsInLine.equals(NULL_TAG_PRESENTATION_NAME)) {
            return true;
        }
        return TAGS_VALIDATION.matcher(tagsInLine.trim()).matches();
    }

    @NotNull
    public static Set<String> splitTags(@Nullable String tags) {
        if (tags == null || tags.equals(NULL_TAG_PRESENTATION_NAME)) {
            return Collections.singleton(NULL_TAG_PRESENTATION_NAME);
        }
        HashSet<String> result2 = new HashSet<String>();
        Matcher matcher = TAG.matcher(tags);
        while (matcher.find()) {
            result2.add(matcher.group());
        }
        return result2;
    }

    public static boolean fileHasTest(@NotNull OCFile testFile) {
        return CidrCatchTestUtil.wasStoppedWhileIteration(() -> testFile.accept(CidrCatchTestUtil.getTestSymbolExtractorVisitor(testInfo -> CidrCatchTestUtil.stopIteration())));
    }

    public static boolean isTargetDetectionEnabled() {
        return Boolean.valueOf(System.getProperty(CATCH_ENABLE_DETECTION_KEY));
    }

    public static boolean setTargetDetection(boolean value2) {
        return Boolean.valueOf(System.setProperty(CATCH_ENABLE_DETECTION_KEY, Boolean.toString(value2)));
    }

    private static class StopException
    extends RuntimeException {
        public StopException() {
            super("catch stop iteration", null, false, false);
        }
    }

    private static class LocalVisitor
    extends GlobalVisitor {
        final String myStructName;
        final String myFunctionTestName;

        public LocalVisitor(@NotNull String testOwnerName, Consumer<CidrCatchTestCache> declaratorConsumer) {
            super(declaratorConsumer);
            List names = StringUtil.split((String)testOwnerName, (String)"::");
            if (names.size() == 2) {
                this.myStructName = (String)names.get(0);
                this.myFunctionTestName = (String)names.get(1);
            } else if (names.size() == 1) {
                this.myStructName = null;
                this.myFunctionTestName = (String)names.get(0);
            } else {
                this.myStructName = null;
                this.myFunctionTestName = null;
            }
        }

        @Override
        protected OCRecursiveVisitor createArgumentVisiter(OCDeclaration declaration2) {
            return new GlobalVisitor.BaseArgVisitor(declaration2, this.myDeclaratorConsumer){
                boolean found;
                {
                    super(declaration2, declaratorConsumer);
                    this.found = false;
                }

                @Override
                public void visitReferenceElement(OCReferenceElement referenceElement) {
                    PsiElement identifier = referenceElement.getNameIdentifier();
                    if (identifier != null && identifier.getText().equals(myFunctionTestName)) {
                        if (myStructName == null) {
                            this.found = true;
                        } else if (referenceElement.getNamespaceQualifier() != null && referenceElement.getNamespaceQualifier().getName() != null) {
                            this.found = referenceElement.getNamespaceQualifier().getName().equals(myStructName);
                        }
                    }
                }

                @Override
                public void visitCallExpression(OCCallExpression expression2) {
                    if (this.found) {
                        super.visitCallExpression(expression2);
                    }
                }
            };
        }
    }

    private static class GlobalVisitor
    extends OCVisitor {
        static final String AUTO_REG = "AutoReg";
        static final String NAME_AND_DESC = "NameAndDesc";
        protected final Consumer<CidrCatchTestCache> myDeclaratorConsumer;

        public GlobalVisitor(Consumer<CidrCatchTestCache> declaratorConsumer) {
            this.myDeclaratorConsumer = declaratorConsumer;
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            if (element instanceof OCFile || element instanceof OCCppNamespace) {
                for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    child.accept((PsiElementVisitor)this);
                }
            }
        }

        @Override
        public void visitDeclaration(OCDeclaration declaration2) {
            OCArgumentList argList;
            if (AUTO_REG.equals(declaration2.getType().getName()) && (argList = (OCArgumentList)PsiTreeUtil.findChildOfType((PsiElement)declaration2, OCArgumentList.class)) != null) {
                argList.accept(this.createArgumentVisiter(declaration2));
            }
        }

        protected OCRecursiveVisitor createArgumentVisiter(OCDeclaration declaration2) {
            return new BaseArgVisitor(declaration2, this.myDeclaratorConsumer);
        }

        static class BaseArgVisitor
        extends OCRecursiveVisitor {
            private OCDeclaration myDeclaration;
            private Consumer<CidrCatchTestCache> myDeclaratorConsumer;

            public BaseArgVisitor(OCDeclaration declaration2, Consumer<CidrCatchTestCache> declaratorConsumer) {
                this.myDeclaration = declaration2;
                this.myDeclaratorConsumer = declaratorConsumer;
            }

            @Override
            public void visitCallExpression(OCCallExpression expression2) {
                List<OCExpression> arguments;
                OCSymbol symbol = OCGetSymbolVisitor.getSymbol(expression2.getFunctionReferenceExpression());
                if (symbol != null && GlobalVisitor.NAME_AND_DESC.equals(symbol.getName()) && (arguments = expression2.getArgumentList().getArguments()).size() >= 1) {
                    OCExpression maybeName = arguments.get(0);
                    OCExpression maybeTags = arguments.size() > 1 ? arguments.get(1) : null;
                    List<OCDeclarator> declarators = this.myDeclaration.getDeclarators();
                    if (maybeName instanceof OCLiteralExpression && (maybeTags == null || maybeTags instanceof OCLiteralExpression) && declarators.size() == 1) {
                        this.myDeclaratorConsumer.accept(new CidrCatchTestCache(((OCLiteralExpression)maybeName).getUnescapedLiteralText(), maybeTags == null ? "" : ((OCLiteralExpression)maybeTags).getUnescapedLiteralText(), declarators.get(0)));
                    }
                }
            }
        }
    }
}

