/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.generate.handlers;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.generate.handlers.OCCppGenerateTestHandler;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGoogleGenerateTestHandler
extends OCCppGenerateTestHandler {
    public OCGoogleGenerateTestHandler(String actionTitle, String templateName) {
        super(actionTitle, templateName);
    }

    @Override
    public boolean isValidFor(Editor editor, PsiFile file2) {
        return super.isValidFor(editor, file2) && FileSymbolTablesCache.areSymbolsLoaded(file2.getProject()) && CidrGoogleTestUtil.fileIncludesGoogleTest(file2);
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(Project project2, @Nullable Editor editor, PsiFile file2) {
        return this.evaluateActionContext((OCStructSymbol)null, (PsiElement)file2);
    }

    @Override
    protected void onTemplateFinished(@NotNull PsiFile file2, @NotNull RangeMarker rangeMarker) {
        PsiElement at = OCGoogleGenerateTestHandler.getFirstInsertedElement(file2, rangeMarker);
        if (!(at instanceof OCMacroCall)) {
            at = PsiTreeUtil.getNextSiblingOfType((PsiElement)at, OCMacroCall.class);
        }
        if (at instanceof OCMacroCall) {
            OCReferenceElement referenceElement = ((OCMacroCall)at).getMacroReferenceElement();
            List<OCMacroCallArgument> arguments = ((OCMacroCall)at).getArguments();
            if (referenceElement != null && referenceElement.getName().equals("TEST") && arguments.size() == 2) {
                String suiteName = CidrGoogleTestUtil.extractArgumentValue(arguments.get(0));
                String testName = CidrGoogleTestUtil.extractArgumentValue(arguments.get(1));
                if (OCGoogleGenerateTestHandler.migrateToParameterized(referenceElement, suiteName)) {
                    return;
                }
                if (OCGoogleGenerateTestHandler.migrateToTyped(referenceElement, suiteName)) {
                    return;
                }
                if (OCGoogleGenerateTestHandler.migrateToTypeParameterized(referenceElement, suiteName, testName)) {
                    return;
                }
                OCGoogleGenerateTestHandler.migrateToFixture(referenceElement, suiteName);
            }
        }
    }

    private static boolean migrateToFixture(OCReferenceElement referenceElement, String suiteName) {
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded(suiteName, referenceElement, "TEST_F", (Condition<OCSymbol>)((Condition)symbol -> symbol instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)symbol)), null);
    }

    private static boolean migrateToTypeParameterized(OCReferenceElement referenceElement, String suiteName, String testName) {
        Consumer consumer2 = symbol -> {
            OCReferenceElement macroReferenceElement;
            OCDeclaration declaration2 = (OCDeclaration)PsiTreeUtil.getParentOfType(symbol.locateDefinition(), OCDeclaration.class);
            OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getPrevSiblingOfType((PsiElement)declaration2, OCMacroCall.class);
            if (macroCall != null && (macroReferenceElement = macroCall.getMacroReferenceElement()) != null && macroReferenceElement.getName().equals("REGISTER_TYPED_TEST_CASE_P")) {
                List<OCMacroCallArgument> arguments = macroCall.getArguments();
                OCMacroCallArgument lastArgument = arguments.get(arguments.size() - 1);
                PsiElement newElement = OCElementFactory.create(OCTokenTypes.COMMA, macroCall);
                PsiElement added = OCChangeUtil.addAfter(macroCall, newElement, lastArgument);
                OCChangeUtil.addAfter(macroCall, OCElementFactory.expressionFromText(testName, macroCall), added);
            }
        };
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded("gtest_registered_test_names_" + suiteName + "_", referenceElement, "TYPED_TEST_P", null, (Consumer<OCSymbol>)consumer2);
    }

    private static boolean migrateToTyped(OCReferenceElement referenceElement, String suiteName) {
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded("gtest_type_params_" + suiteName + "_", referenceElement, "TYPED_TEST", null, null);
    }

    private static boolean migrateToParameterized(OCReferenceElement referenceElement, String suiteName) {
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded(suiteName, referenceElement, "TEST_P", (Condition<OCSymbol>)((Condition)symbol -> symbol instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClassWithAnyAncestor((OCStructSymbol)symbol, "TestWithParam", "WithParamInterface")), null);
    }

    private static boolean correctMacroNameIfNeeded(@NotNull String suiteName, @NotNull OCReferenceElement referenceElement, @NotNull String correctMacroName, final @Nullable Condition<OCSymbol> condition2, final @Nullable Consumer<OCSymbol> onCorrection) {
        final OCFile file2 = referenceElement.getContainingOCFile();
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return file2.equals(symbol.getContainingOCFile()) && (condition2 == null || condition2.value((Object)symbol));
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(referenceElement.getProject(), (Processor<OCSymbol>)processor2, suiteName);
        if (processor2.isFound()) {
            new WriteAction((CommonProcessors.FindFirstProcessor)processor2, referenceElement, correctMacroName, file2){
                final /* synthetic */ CommonProcessors.FindFirstProcessor val$processor;
                final /* synthetic */ OCReferenceElement val$referenceElement;
                final /* synthetic */ String val$correctMacroName;
                final /* synthetic */ OCFile val$file;
                {
                    this.val$processor = findFirstProcessor;
                    this.val$referenceElement = oCReferenceElement;
                    this.val$correctMacroName = string;
                    this.val$file = oCFile;
                }

                protected void run(@NotNull Result result2) throws Throwable {
                    if (onCorrection != null) {
                        onCorrection.consume(this.val$processor.getFoundValue());
                    }
                    this.val$referenceElement.setNameOfIdentifier(this.val$correctMacroName);
                    FileSymbolTablesCache.getInstance(this.val$file.getProject()).scheduleReparseFile(this.val$file);
                }
            }.execute();
        }
        return processor2.isFound();
    }

    @Nullable
    private static PsiElement getFirstInsertedElement(@NotNull PsiFile file2, @NotNull RangeMarker rangeMarker) {
        PsiElement at = file2.findElementAt(rangeMarker.getStartOffset());
        while (at instanceof PsiWhiteSpace) {
            at = at.getNextSibling();
        }
        at = PsiTreeUtil.getContextOfType((PsiElement)at, (boolean)false, (Class[])new Class[]{OCMacroCall.class, OCDeclaration.class});
        return at;
    }

    @Override
    protected int getInsertPos(@NotNull PsiElement element, int caretOffset, @Nullable PsiElement at, @NotNull List<OCFunctionSymbol> members, @NotNull OCCppActionContext<OCStructSymbol, OCFunctionSymbol> actionContext) {
        boolean insertAfter = false;
        Condition condition2 = element1 -> element1.getParent() instanceof OCFile || element1.getParent() instanceof OCCppNamespace;
        if (condition2.value((Object)at)) {
            assert (at != null);
            return at.getTextRange().getEndOffset();
        }
        OCStruct struct = (OCStruct)PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{OCStruct.class});
        if (struct != null) {
            insertAfter = CidrGoogleTestUtil.isGoogleTestFixture((OCStructSymbol)struct.getSymbol(), false);
        }
        at = PsiTreeUtil.findFirstParent((PsiElement)at, (boolean)true, (Condition)condition2);
        at = insertAfter ? PsiTreeUtil.getNextSiblingOfType((PsiElement)at, PsiWhiteSpace.class) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)at, PsiWhiteSpace.class);
        if (at != null) {
            return at.getTextRange().getEndOffset();
        }
        return -1;
    }
}

