/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileIconProvider
extends IconProvider
implements DumbAware {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (!(element instanceof OCFile)) {
            return null;
        }
        OCFile fsElement = (OCFile)element;
        String name = fsElement.getName();
        if (OCFileTypeHelpers.isHeaderFile(name)) {
            return CidrLangIcons.FileType_h;
        }
        OCLanguageKind kind2 = OCLanguageKindCalculator.tryFileTypeAndExtension(element.getProject(), fsElement.getVirtualFile());
        if (kind2 instanceof CLanguageKind) {
            switch ((CLanguageKind)kind2) {
                case C: {
                    return CidrLangIcons.FileType_c;
                }
                case CPP: {
                    return CidrLangIcons.FileType_cpp;
                }
                case OBJ_C: 
                case OBJ_CPP: {
                    return CidrLangIcons.FileType_m;
                }
            }
        }
        return null;
    }
}

