/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.cidr.lang.OCFileTypeHelper;
import gnu.trove.TObjectHashingStrategy;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileTypeHelpers {
    public static final Set<String> HEADER_FILE_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE, (Object[])new String[]{"", "h", "hpp", "hh", "hxx", "tcc", "pch", "inl"});
    public static final Set<String> SOURCE_FILE_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE, (Object[])new String[]{"c", "cp", "cpp", "cc", "cxx"});

    @NotNull
    public static OCFileTypeHelper[] getHelpers() {
        return (OCFileTypeHelper[])Extensions.getExtensions(OCFileTypeHelper.EP_NAME);
    }

    public static boolean isHeaderFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        if (HEADER_FILE_EXTENSIONS.contains(FileUtilRt.getExtension((String)filename))) {
            return true;
        }
        if (SOURCE_FILE_EXTENSIONS.contains(FileUtilRt.getExtension((String)filename))) {
            return false;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            if (!each.isHeaderFile(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSourceFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        if (SOURCE_FILE_EXTENSIONS.contains(FileUtilRt.getExtension((String)filename))) {
            return true;
        }
        if (HEADER_FILE_EXTENSIONS.contains(FileUtilRt.getExtension((String)filename))) {
            return false;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            if (each.isHeaderFile(filename)) {
                return false;
            }
            if (!each.isSourceFile(filename)) continue;
            return true;
        }
        return false;
    }

    static {
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode() || PlatformUtils.isAppCode()) {
            SOURCE_FILE_EXTENSIONS.add("m");
            SOURCE_FILE_EXTENSIONS.add("mm");
        }
    }
}

