/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SpecificNameItemProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.OCIncludeHelper;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderRoots;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeHelpers {
    public static OCIncludeHelper[] getIncludeHelpers() {
        return (OCIncludeHelper[])Extensions.getExtensions(OCIncludeHelper.EP_NAME);
    }

    public static ShowInCompletion showInCompletion(@Nullable PsiFileSystemItem item) {
        if (item == null) {
            return ShowInCompletion.DEFAULT;
        }
        ShowInCompletion result2 = ShowInCompletion.DEFAULT;
        for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
            ShowInCompletion eachResult = each.showInCompletion(item);
            if (eachResult == ShowInCompletion.DEFAULT) continue;
            if (eachResult == ShowInCompletion.SHOW) {
                return ShowInCompletion.SHOW;
            }
            result2 = eachResult;
        }
        return result2;
    }

    @Nullable
    public static VirtualFile resolveIncludedFile(@Nullable OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile context, @NotNull OCIncludeSymbol.IncludePath include, @NotNull Project project2) {
        Ref result2 = new Ref();
        OCIncludeHelpers.resolveNextIncludedFile(rootAndConfiguration, context, null, include, project2, (Ref<VirtualFile>)result2);
        return (VirtualFile)result2.get();
    }

    public static void resolveNextIncludedFile(@Nullable OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile context, @Nullable VirtualFile after2, @NotNull OCIncludeSymbol.IncludePath include, @NotNull Project project2, @NotNull Ref<VirtualFile> result2) {
        List<PsiFileSystemItem> firstSegmentElements;
        PsiFileSystemItem item;
        if (project2.isDisposed()) {
            return;
        }
        if (context == null || !context.isValid()) {
            return;
        }
        String[] pathElements = include.getPath().split("/");
        if (pathElements.length == 0) {
            return;
        }
        CustomHeaderProvider.Helper customHeaderProviders = CustomHeaderProvider.getProviders(include.getPath(), rootAndConfiguration);
        VirtualFile customHeader = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_START);
        if (customHeader != null) {
            result2.set((Object)customHeader);
            return;
        }
        String first = pathElements[0];
        if (first.isEmpty()) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(include.getPath());
            result2.set(file2 == null || file2.isDirectory() ? null : file2);
            return;
        }
        customHeader = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_CURRENT);
        if (customHeader != null) {
            result2.set((Object)customHeader);
            return;
        }
        boolean searchInCurrent = after2 == null && !include.isAngleBrackets() && !FileUtil.namesEqual((String)context.getName(), (String)include.getPath());
        Ref afterDirRef = new Ref((Object)(after2 == null ? null : after2.getParent()));
        if (searchInCurrent && (item = FileReferenceHelper.getPsiFileSystemItem(PsiManager.getInstance((Project)project2), context)) != null && item.getParent() != null && OCIncludeHelpers.findHeader(firstSegmentElements = OCIncludeHelpers.findChild(item.getParent(), first), pathElements, (Ref<VirtualFile>)afterDirRef, result2)) {
            return;
        }
        customHeader = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_LIBRARIES);
        if (customHeader != null) {
            result2.set((Object)customHeader);
            return;
        }
        if (rootAndConfiguration != null) {
            Collection<PsiFileSystemItem> projectHeaders;
            if (!include.isAngleBrackets() && OCIncludeHelpers.findHeader(projectHeaders = HeaderRootsSegmentCache.getFirstSegmentsInProjectHeader(rootAndConfiguration, first), pathElements, (Ref<VirtualFile>)afterDirRef, result2)) {
                return;
            }
            Collection<PsiFileSystemItem> libHeaders = HeaderRootsSegmentCache.getFirstSegmentsInLibraryRoots(rootAndConfiguration, first);
            if (OCIncludeHelpers.findHeader(libHeaders, pathElements, (Ref<VirtualFile>)afterDirRef, result2)) {
                return;
            }
        }
        if ((customHeader = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_FRAMEWORKS)) != null) {
            result2.set((Object)customHeader);
            return;
        }
        if (!OCIncludeHelpers.processContainingFramework(project2, context, (Processor<PsiFileSystemItem>)((Processor)framework -> {
            if (framework.getName().equals(first) && OCIncludeHelpers.findHeader(Collections.singletonList(framework), pathElements, (Ref<VirtualFile>)afterDirRef, result2)) {
                return false;
            }
            return !OCIncludeHelpers.findHeader(OCIncludeHelpers.findChild(framework, first), pathElements, (Ref<VirtualFile>)afterDirRef, result2);
        }))) {
            return;
        }
        customHeader = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.AFTER_END);
        if (customHeader != null) {
            result2.set((Object)customHeader);
        }
    }

    @Nullable
    public static AppleFramework getFramework(@NotNull OCResolveRootAndConfiguration headerResolveCtx, @NotNull String name) {
        Collection<PsiFileSystemItem> libHeaders = HeaderRootsSegmentCache.getFirstSegmentsInLibraryRoots(headerResolveCtx, name);
        return (AppleFramework)((Object)ContainerUtil.find(libHeaders, (Condition)new FilteringIterator.InstanceOf(AppleFramework.class)));
    }

    private static boolean findHeader(@NotNull Collection<PsiFileSystemItem> firstSegmentElements, @NotNull String[] pathElements, @NotNull Ref<VirtualFile> afterDirRef, @NotNull Ref<VirtualFile> result2) {
        for (PsiFileSystemItem segment : firstSegmentElements) {
            VirtualFile file2;
            PsiFile candidate = null;
            if (pathElements.length != 1) {
                candidate = OCIncludeHelpers.find(segment, pathElements, 1);
            } else if (segment instanceof PsiFile) {
                candidate = (PsiFile)segment;
            }
            if (candidate == null || (file2 = candidate.getVirtualFile()) == null) continue;
            VirtualFile after2 = (VirtualFile)afterDirRef.get();
            if (after2 == null) {
                result2.set((Object)file2);
                return true;
            }
            if (!Comparing.equal((Object)file2.getParent(), (Object)after2)) continue;
            afterDirRef.set(null);
        }
        return false;
    }

    public static boolean processContainingFramework(@NotNull Project project2, @Nullable VirtualFile forFile, @NotNull Processor<PsiFileSystemItem> processor2) {
        if (forFile == null) {
            return true;
        }
        for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
            if (each.processContainingFramework(project2, forFile, processor2)) continue;
            return false;
        }
        return true;
    }

    public static boolean processImportSpecifications(@NotNull Project project2, @NotNull OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile targetFile, @NotNull VirtualFile fileToImport, @NotNull Processor<OCAutoImportHelper.ImportSpecification> processor2) {
        OCAutoImportHelper[] extensions;
        for (OCAutoImportHelper each : extensions = (OCAutoImportHelper[])Extensions.getExtensions(OCAutoImportHelper.EP_NAME)) {
            if (!each.supports(rootAndConfiguration) || each.processPathSpecificationToInclude(project2, targetFile, fileToImport, rootAndConfiguration, processor2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PsiFile find(PsiFileSystemItem root, String[] pathElements, int cur) {
        if (root == null) {
            return null;
        }
        String name = pathElements[cur];
        for (PsiFileSystemItem item : OCIncludeHelpers.findChild(root, name)) {
            if (cur == pathElements.length - 1) {
                if (!(item instanceof PsiFile)) continue;
                return (PsiFile)item;
            }
            PsiFile element = OCIncludeHelpers.find(item, pathElements, cur + 1);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @NotNull
    private static List<PsiFileSystemItem> findChild(PsiFileSystemItem parent, String childName) {
        PsiFile found;
        if (parent == null || !parent.isValid()) {
            return Collections.emptyList();
        }
        if ("..".equals(childName)) {
            VirtualFile vFile = parent.getVirtualFile();
            for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
                VirtualFile headersRoot = each.findHeadersRoot(parent);
                if (headersRoot == null) continue;
                vFile = headersRoot;
                break;
            }
            if (vFile == null) {
                return Collections.emptyList();
            }
            VirtualFile vParent = vFile.getParent();
            if (vParent == null) {
                return Collections.emptyList();
            }
            PsiDirectory directory = parent.getManager().findDirectory(vParent);
            return directory != null ? Collections.singletonList(directory) : Collections.emptyList();
        }
        if (".".equals(childName)) {
            return Collections.singletonList(parent);
        }
        if (parent instanceof PsiDirectory && (found = ((PsiDirectory)parent).findFile(childName)) != null) {
            return Collections.singletonList(found);
        }
        final SmartList result2 = new SmartList();
        parent.processChildren((PsiElementProcessor)new SpecificNameItemProcessor(childName){

            public boolean execute(@NotNull PsiFileSystemItem element) {
                result2.add((Object)element);
                return true;
            }
        });
        return result2;
    }

    private static class FirstSegmentCache {
        @NotNull
        private final List<HeadersSearchRoot> myRoots;
        private final boolean mySupportsRelative;
        private Map<String, List<PsiFileSystemItem>> myCache;

        private FirstSegmentCache(@NotNull List<HeadersSearchRoot> roots, boolean relative) {
            this.mySupportsRelative = relative;
            this.myRoots = roots;
        }

        private void prepareCache() {
            if (this.myCache != null) {
                return;
            }
            this.myCache = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
            for (PsiFileSystemItem psiFileSystemItem : this.myRoots) {
                if (!psiFileSystemItem.isValid()) continue;
                psiFileSystemItem.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>(){

                    public boolean execute(@NotNull PsiFileSystemItem element) {
                        String segment = element.getName();
                        ArrayList<PsiFileSystemItem> items = (ArrayList<PsiFileSystemItem>)myCache.get(segment);
                        if (items == null) {
                            items = new ArrayList<PsiFileSystemItem>();
                            myCache.put(segment, items);
                        }
                        items.add(element);
                        return true;
                    }
                });
            }
        }

        private synchronized Collection<PsiFileSystemItem> getFiles(@NotNull String segment) {
            this.prepareCache();
            List<Object> items = this.myCache.get(segment);
            if (items == null) {
                if (this.mySupportsRelative) {
                    items = new ArrayList<PsiFileSystemItem>();
                    for (PsiFileSystemItem psiFileSystemItem : this.myRoots) {
                        if (!psiFileSystemItem.isValid()) continue;
                        items.addAll(OCIncludeHelpers.findChild(psiFileSystemItem, segment));
                    }
                    this.myCache.put(segment, items);
                } else {
                    items = Collections.emptyList();
                }
            }
            return items;
        }
    }

    private static class HeaderRootsSegmentCache {
        private static final NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> RESOLVE_INCLUDE_IN_PROJECT_HEADERS_CACHE = HeaderRootsSegmentCache.createCacheKey("RESOLVE_INCLUDE_IN_PROJECT_HEADERS_CACHE", false);
        private static final NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> RESOLVE_INCLUDE_CACHE = HeaderRootsSegmentCache.createCacheKey("RESOLVE_INCLUDE_CACHE", true);
        @NotNull
        private final HashMap<HeaderRoots, FirstSegmentCache> myCache = new HashMap();
        private final boolean mySupportsRelative;

        private HeaderRootsSegmentCache(boolean supportsRelative) {
            this.mySupportsRelative = supportsRelative;
        }

        @NotNull
        static Collection<PsiFileSystemItem> getFirstSegmentsInLibraryRoots(OCResolveRootAndConfiguration headerResolveCtx, String first) {
            Project project2 = headerResolveCtx.getProject();
            if (project2 == null) {
                return Collections.emptyList();
            }
            HeaderRootsSegmentCache headerRootsCache = (HeaderRootsSegmentCache)((CachedValue)RESOLVE_INCLUDE_CACHE.getValue((UserDataHolder)project2)).getValue();
            HeaderRoots roots = headerResolveCtx.getLibraryHeadersRoots();
            FirstSegmentCache fsc = headerRootsCache.getFirstSegmentCache(roots);
            return fsc.getFiles(first);
        }

        @NotNull
        static Collection<PsiFileSystemItem> getFirstSegmentsInProjectHeader(@NotNull OCResolveRootAndConfiguration headerResolveCtx, @NotNull String firstSegment) {
            Project project2 = headerResolveCtx.getProject();
            if (project2 == null) {
                return Collections.emptyList();
            }
            HeaderRootsSegmentCache headerRootsCache = (HeaderRootsSegmentCache)((CachedValue)RESOLVE_INCLUDE_IN_PROJECT_HEADERS_CACHE.getValue((UserDataHolder)project2)).getValue();
            HeaderRoots roots = headerResolveCtx.getProjectHeadersRoots();
            FirstSegmentCache fsc = headerRootsCache.getFirstSegmentCache(roots);
            return fsc.getFiles(firstSegment);
        }

        private synchronized FirstSegmentCache getFirstSegmentCache(@NotNull HeaderRoots roots) {
            FirstSegmentCache cache2 = this.myCache.get(roots);
            if (cache2 == null) {
                cache2 = new FirstSegmentCache(roots.getRoots(), this.mySupportsRelative);
                this.myCache.put(roots, cache2);
            }
            return cache2;
        }

        private static NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> createCacheKey(@NotNull String name, boolean supportsRelative) {
            return NotNullLazyKey.create((String)name, project2 -> CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
                OCWorkspaceModificationTrackers tracker = OCWorkspaceModificationTrackers.getInstance(project2);
                return new CachedValueProvider.Result((Object)new HeaderRootsSegmentCache(supportsRelative), new Object[]{tracker.getProjectsListTracker(), tracker.getProjectFilesListTracker(), tracker.getSourceFilesListTracker(), tracker.getSelectedResolveConfigurationTracker()});
            }, false));
        }
    }

    public static enum ShowInCompletion {
        SHOW,
        DON_NOT_SHOW,
        DEFAULT;

    }
}

