/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.OCCustomOption;
import com.jetbrains.cidr.lang.settings.OCCustomOptionCpp;
import com.jetbrains.cidr.lang.settings.OCCustomOptionObjC;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguage
extends Language {
    public static final Key<Boolean> LANGUAGE_SUPPORT_DISABLED = Key.create((String)"CPP_SUPPORT_DISABLED");
    private static final boolean ourForceAppCode = Boolean.valueOf(System.getProperty("idea.isAppCode.internal"));
    private static final boolean ourGUIForAppCode = PlatformUtils.isAppCode() || ourForceAppCode;
    private static final OCLanguage ourInstance = new OCLanguage();
    private static final String DISPLAY_NAME = "C/C++" + (ourGUIForAppCode ? "/Objective-C" : "");

    @NotNull
    public static OCLanguage getInstance() {
        return ourInstance;
    }

    public OCLanguage() {
        super("ObjectiveC");
        SyntaxHighlighterFactory.LANGUAGE_FACTORY.addExplicitExtension((Object)this, (Object)new SyntaxHighlighterFactory(){
            private FactoryMap<HighlighterKey, OCFileHighlighter> myHighlighters = new FactoryMap<HighlighterKey, OCFileHighlighter>(){

                @Nullable
                protected OCFileHighlighter create(HighlighterKey key2) {
                    return new OCFileHighlighter(key2.myLanguageKind, key2.mySupportNullability);
                }
            };

            @NotNull
            public SyntaxHighlighter getSyntaxHighlighter(Project project2, VirtualFile virtualFile) {
                OCLanguageKind languageKind = CLanguageKind.maxLanguage(project2);
                if (virtualFile != null && virtualFile.isValid() && project2 != null) {
                    OCFile file2;
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                    OCFile oCFile = file2 = psiFile instanceof OCFile ? (OCFile)psiFile : null;
                    if (file2 != null) {
                        languageKind = OCLanguageKindCalculator.calculateLanguageKindFast(file2);
                    }
                }
                return (SyntaxHighlighter)this.myHighlighters.get((Object)new HighlighterKey(languageKind, true));
            }

            class HighlighterKey {
                private OCLanguageKind myLanguageKind;
                private boolean mySupportNullability;

                public HighlighterKey(OCLanguageKind languageKind, boolean supportNullability) {
                    this.myLanguageKind = languageKind;
                    this.mySupportNullability = supportNullability;
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    HighlighterKey key2 = (HighlighterKey)o;
                    if (this.mySupportNullability != key2.mySupportNullability) {
                        return false;
                    }
                    return this.myLanguageKind.equals(key2.myLanguageKind);
                }

                public int hashCode() {
                    int result2 = this.myLanguageKind.hashCode();
                    result2 = 31 * result2 + (this.mySupportNullability ? 1 : 0);
                    return result2;
                }
            }
        });
    }

    public static OCCustomOption getCustomOption() {
        return LazyOptionHolder.INSTANCE;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    static /* synthetic */ boolean access$000() {
        return ourGUIForAppCode;
    }

    private static class LazyOptionHolder {
        public static final OCCustomOption INSTANCE = OCLanguage.access$000() ? new OCCustomOptionObjC() : new OCCustomOptionCpp();

        private LazyOptionHolder() {
        }
    }
}

