/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.util.Comparing;
import com.jetbrains.cidr.lang.OCLanguageKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OCLanguageStandard {
    C89(OCLanguageKind.C),
    C99(OCLanguageKind.C),
    C11(OCLanguageKind.C),
    CPP98(OCLanguageKind.CPP),
    CPP11(OCLanguageKind.CPP),
    CPP14(OCLanguageKind.CPP),
    CPP17(OCLanguageKind.CPP),
    UNKNOWN(null);

    @Nullable
    private final OCLanguageKind myKind;
    public static final String __STDC_VERSION__VALUE_C89 = "199409L";
    public static final String __STDC_VERSION__VALUE_C99 = "199901L";
    public static final String __STDC_VERSION__VALUE_C11 = "201112L";
    public static final String __CPLUSPLUS_VALUE_CPP98 = "199711L";
    public static final String __CPLUSPLUS_VALUE_CPP11 = "201103L";
    public static final String __CPLUSPLUS_VALUE_CPP14 = "201402L";

    private OCLanguageStandard(OCLanguageKind kind2) {
        this.myKind = kind2;
    }

    public boolean supports(@NotNull OCLanguageStandard standard) {
        return Comparing.equal((Object)this.myKind, (Object)standard.myKind) && this.ordinal() >= standard.ordinal();
    }

    @NotNull
    public static OCLanguageStandard getStandardFromSTDC(@Nullable String stdc, @Nullable String stdc_version) {
        if (stdc_version != null) {
            if (stdc_version.compareTo(__STDC_VERSION__VALUE_C99) > 0) {
                return C11;
            }
            if (stdc_version.compareTo(__STDC_VERSION__VALUE_C89) > 0) {
                return C99;
            }
            return C89;
        }
        return Comparing.equal((String)"1", (String)stdc) ? C89 : UNKNOWN;
    }

    @NotNull
    public static OCLanguageStandard getStandardFromCPLUSPLUS(@Nullable String cplusplus) {
        if (cplusplus == null) {
            return UNKNOWN;
        }
        if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP14) > 0) {
            return CPP17;
        }
        if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP11) > 0) {
            return CPP14;
        }
        if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP98) > 0) {
            return CPP11;
        }
        return CPP98;
    }
}

