/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewHeaderFileAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewSourceFileAction
extends OCNewFileWithSelectedExtensionAction<OCNewFileWithSelectedExtensionAction.CreateFileDialog> {
    public OCNewSourceFileAction() {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.cpp.source.title", new Object[0]), OCBundle.message("create.cpp.source.title", new Object[0]), CidrLangIcons.FileType_cpp);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        OCCodeStyleSettings.FileExtensionPair extensionPair = ((OCNewFileWithSelectedExtensionAction.CreateFileDialog)((Object)this.myState.dialogPeer)).myFileExtensionPair;
        String sourceName = selectedName + "." + extensionPair.mySourceExt;
        return new OCNewFileActionBase.NewFileNames(sourceName, this.shouldAddHeader() ? selectedName + '.' + extensionPair.myHeaderExt : null);
    }

    private boolean shouldAddHeader() {
        return ((MyCreateFileDialog)((Object)this.myState.dialogPeer)).myShouldAddHeader;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, PsiFile sampleFile) {
        String headerExt = null;
        String sourceExt = null;
        String selectedExt = FileUtilRt.getExtension((String)selectedName);
        if (selectedExt.length() > 0) {
            if (OCFileTypeHelpers.isHeaderFile(selectedName)) {
                headerExt = selectedExt;
            } else if (OCFileTypeHelpers.isSourceFile(selectedName)) {
                sourceExt = selectedExt;
            }
        }
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)selectedName);
        Couple<String> extensions = this.determineExtensions((OCFile)sampleFile, sourceExt, headerExt);
        return new OCNewFileActionBase.NewFileNames(nameWithoutExtension + '.' + (String)extensions.first, nameWithoutExtension + '.' + (String)extensions.second);
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, @Nullable PsiFile sampleFile, Project project2) {
        String headerName;
        if (this.myState != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        if (headerName != null) {
            properties.setProperty("HEADER_FILENAME", headerName);
        }
    }

    @Override
    protected boolean isValidName(String selectedName) {
        String sourceName = selectedName + "." + ((OCNewFileWithSelectedExtensionAction.CreateFileDialog)((Object)this.myState.dialogPeer)).myFileExtensionPair.mySourceExt;
        return super.isValidName(sourceName) && OCFileImpl.isSourceCodeFile(sourceName);
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (OCFileImpl.isHeaderFile(fileName)) {
            return OCNewHeaderFileAction.headerTemplate();
        }
        return "C Source File.c";
    }

    @Override
    @NotNull
    protected OCNewFileWithSelectedExtensionAction.CreateFileDialog createDialog(@NotNull String defaultName) {
        return new MyCreateFileDialog(defaultName);
    }

    private class MyCreateFileDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        private boolean myShouldAddHeader;

        public MyCreateFileDialog(String defaultName) {
            super(defaultName);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            NonFocusableCheckBox headerCheckBox = new NonFocusableCheckBox(OCBundle.message("create.checkbox.source.associated.header", new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)headerCheckBox, (char)'&');
            headerCheckBox.addItemListener(new ItemListener((JCheckBox)headerCheckBox){
                final /* synthetic */ JCheckBox val$headerCheckBox;
                {
                    this.val$headerCheckBox = jCheckBox;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MyCreateFileDialog.this.myShouldAddHeader = this.val$headerCheckBox.isSelected();
                    if (MyCreateFileDialog.this.myKindCombo != null) {
                        MyCreateFileDialog.this.reloadExtensions();
                    }
                    MyCreateFileDialog.this.validateOkAction();
                }
            });
            OCNewSourceFileAction.this.addAuxAction(createdElements -> {
                UsageTrigger.trigger("cidr.newFile.source");
                if (this.myShouldAddHeader) {
                    UsageTrigger.trigger("cidr.newFile.source.withHeader");
                }
            });
            formBuilder.addComponent((JComponent)headerCheckBox);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull OCCodeStyleSettings.FileExtensionPair pair) {
            return this.myShouldAddHeader ? super.getPresentableName(pair) : "." + pair.mySourceExt;
        }
    }
}

