/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.asm;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.asm.AsmLexer;
import com.jetbrains.cidr.lang.asm.psi.AsmTypes;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AsmSyntaxHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"ASM_LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"ASM_BLOCK_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.BLOCK_COMMENT);
    public static final TextAttributesKey BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"ASM_BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    public static final TextAttributesKey COMMA = TextAttributesKey.createTextAttributesKey((String)"ASM_COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey SIGN = TextAttributesKey.createTextAttributesKey((String)"ASM_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey PARENTHESES = TextAttributesKey.createTextAttributesKey((String)"ASM_PARENTHESES", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey BRACES = TextAttributesKey.createTextAttributesKey((String)"ASM_BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    public static final TextAttributesKey STAR = TextAttributesKey.createTextAttributesKey((String)"ASM_STAR", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey PERCENT = TextAttributesKey.createTextAttributesKey((String)"ASM_PERCENT", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey AT = TextAttributesKey.createTextAttributesKey((String)"ASM_AT", (TextAttributesKey)DefaultLanguageHighlighterColors.METADATA);
    public static final TextAttributesKey LABEL = TextAttributesKey.createTextAttributesKey((String)"ASM_LABEL", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION);
    public static final TextAttributesKey DIRECTIVE_NAME = TextAttributesKey.createTextAttributesKey((String)"ASM_DIRECTIVE_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey PREFIX = TextAttributesKey.createTextAttributesKey((String)"ASM_PREFIX", (TextAttributesKey)DefaultLanguageHighlighterColors.METADATA);
    public static final TextAttributesKey MNEMONIC = TextAttributesKey.createTextAttributesKey((String)"ASM_MNEMONIC", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey NUMBER = TextAttributesKey.createTextAttributesKey((String)"ASM_NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    private static final Map<IElementType, TextAttributesKey[]> ourAttributes = new HashMap<IElementType, TextAttributesKey[]>();

    @NotNull
    public Lexer getHighlightingLexer() {
        return new AsmLexer();
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        return ourAttributes.getOrDefault(tokenType, EMPTY);
    }

    static {
        ourAttributes.put(AsmTypes.LINE_COMMENT, AsmSyntaxHighlighter.pack((TextAttributesKey)LINE_COMMENT));
        ourAttributes.put(AsmTypes.BLOCK_COMMENT, AsmSyntaxHighlighter.pack((TextAttributesKey)BLOCK_COMMENT));
        ourAttributes.put(TokenType.BAD_CHARACTER, AsmSyntaxHighlighter.pack((TextAttributesKey)BAD_CHARACTER));
        ourAttributes.put(AsmTypes.COMMA, AsmSyntaxHighlighter.pack((TextAttributesKey)COMMA));
        ourAttributes.put(AsmTypes.L_PAREN, AsmSyntaxHighlighter.pack((TextAttributesKey)PARENTHESES));
        ourAttributes.put(AsmTypes.R_PAREN, AsmSyntaxHighlighter.pack((TextAttributesKey)PARENTHESES));
        ourAttributes.put(AsmTypes.L_BRACE, AsmSyntaxHighlighter.pack((TextAttributesKey)BRACES));
        ourAttributes.put(AsmTypes.R_BRACE, AsmSyntaxHighlighter.pack((TextAttributesKey)BRACES));
        ourAttributes.put(AsmTypes.MINUS, AsmSyntaxHighlighter.pack((TextAttributesKey)SIGN));
        ourAttributes.put(AsmTypes.STAR, AsmSyntaxHighlighter.pack((TextAttributesKey)STAR));
        ourAttributes.put(AsmTypes.PERCENT, AsmSyntaxHighlighter.pack((TextAttributesKey)PERCENT));
        ourAttributes.put(AsmTypes.AT, AsmSyntaxHighlighter.pack((TextAttributesKey)AT));
        ourAttributes.put(AsmTypes.LABEL, AsmSyntaxHighlighter.pack((TextAttributesKey)LABEL));
        ourAttributes.put(AsmTypes.DIRECTIVE_NAME, AsmSyntaxHighlighter.pack((TextAttributesKey)DIRECTIVE_NAME));
        ourAttributes.put(AsmTypes.INTEGER, AsmSyntaxHighlighter.pack((TextAttributesKey)NUMBER));
        ourAttributes.put(AsmTypes.MNEMONIC, AsmSyntaxHighlighter.pack((TextAttributesKey)MNEMONIC));
        ourAttributes.put(AsmTypes.PREFIX, AsmSyntaxHighlighter.pack((TextAttributesKey)PREFIX));
    }
}

