/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializerMember;
import com.jetbrains.cidr.lang.psi.OCDesignatedInitializer;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveExtraInitializersIntentionAction;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCArgumentsChecker {
    public void checkCompoundInitializer(OCCompoundInitializer compInitializer, OCType type2, boolean goRecursive, boolean allowImplicitConversions) {
        Object argExprs;
        List<OCType> types;
        OCArgumentsList<OCCompoundInitializer> arguments;
        OCSymbol constructor;
        List<OCCompoundInitializerMember> initializers = compInitializer.getInitializers();
        OCFile file2 = compInitializer.getContainingOCFile();
        OCType originalType = type2;
        if (type2 instanceof OCCppReferenceType) {
            type2 = ((OCCppReferenceType)type2).getRefType();
        }
        if (OCCodeInsightUtil.isInitializerListType(type2, file2)) {
            this.checkInitializersInList(compInitializer, (OCStructType)type2);
            return;
        }
        if (type2 instanceof OCStructType && type2.isCppStructType() && ((constructor = ((OCStructType)type2).findConstructor(arguments = new OCArgumentsList<OCCompoundInitializer>(types = Collections.singletonList(compInitializer.getType()), (List<OCCompoundInitializer>)(argExprs = Collections.singletonList(compInitializer))), new OCResolveContext(file2), allowImplicitConversions, false, null)) instanceof OCFunctionSymbol || !((OCStructType)type2).isPOD(false))) {
            this.checkConstructor(compInitializer, constructor);
            return;
        }
        while (type2 instanceof OCStructType && ((OCStructType)type2).getKind() == OCSymbolKind.UNION) {
            OCDeclaratorSymbol field = null;
            for (OCSymbol symbol : ((OCStructType)type2).getSymbol().getMembersList()) {
                if (!(symbol instanceof OCDeclaratorSymbol)) continue;
                field = (OCDeclaratorSymbol)symbol;
                break;
            }
            if (field != null) {
                originalType = type2 = field.getType().resolve(compInitializer.getContainingFile());
                if (compInitializer.getInitializerExpressions().size() != 1) continue;
                OCExpression childExpression = compInitializer.getInitializerExpressions().get(0);
                if (childExpression instanceof OCCompoundInitializer) {
                    compInitializer = (OCCompoundInitializer)childExpression;
                    continue;
                }
                if (!originalType.isCompatible(childExpression.getResolvedType(), childExpression)) continue;
                return;
            }
            if (initializers.size() > 0) {
                this.addErrorAnnotation(compInitializer, OCInspections.InitializerIssues.class, "err_excess_initializers", "Excess elements in scalar initializer", new IntentionAction[0]);
            }
            return;
        }
        if (type2 instanceof OCStructType && ((OCStructType)type2).getKind() == OCSymbolKind.STRUCT || type2 instanceof OCArrayType) {
            int curInitializerIndex = 0;
            boolean excessInitializers = false;
            HashMap<PsiElement, Pair<OCType, OCSymbol>> childTypes = new HashMap<PsiElement, Pair<OCType, OCSymbol>>();
            childTypes.put(compInitializer, new Pair((Object)type2, null));
            compInitializer.inferChildTypes(childTypes, new HashSet<OCSymbol>());
            for (OCCompoundInitializerMember member : initializers) {
                if (member instanceof OCExpression) {
                    OCType childType;
                    Pair<OCType, OCSymbol> pair = childTypes.get(member);
                    OCType oCType = childType = pair != null ? (OCType)pair.first : null;
                    if (childType != null) {
                        childType = childType.resolve(file2);
                        OCType rType = ((OCExpression)member).getResolvedType();
                        OCExpression innerMember = OCParenthesesUtils.diveIntoParentheses((OCExpression)member);
                        if (type2.isCString() && childType instanceof OCArrayType && innerMember instanceof OCLiteralExpression && rType.isCString()) {
                            this.checkCharArrayInit(childType, (OCLiteralExpression)innerMember);
                        }
                        if (member instanceof OCCompoundInitializer && goRecursive) {
                            this.checkCompoundInitializer((OCCompoundInitializer)member, childType, true, true);
                        } else {
                            this.checkAssignment((OCExpression)member, member, childType, rType, (OCSymbol)pair.second, rType, true, false, "Incompatible types in initializer: ");
                        }
                    } else if (!excessInitializers) {
                        excessInitializers = true;
                        OCRemoveExtraInitializersIntentionAction fix = new OCRemoveExtraInitializersIntentionAction(initializers, curInitializerIndex);
                        if (file2.isCpp()) {
                            this.addErrorAnnotation(member, OCInspections.IncompatibleInitializers.class, "err_excess_initializers", "Excess elements in initializer", fix);
                        } else {
                            this.addWarningAnnotation(member, OCInspections.IncompatibleInitializers.class, "ext_excess_initializers", "Excess elements in initializer", null, fix);
                        }
                    }
                } else if (member instanceof OCDesignatedInitializer) {
                    OCExpression initializer;
                    OCDesignatedInitializer fieldInitializer = (OCDesignatedInitializer)member;
                    OCSymbol symbol = fieldInitializer.getDesignation().resolveToSymbol();
                    if (symbol != null && (initializer = fieldInitializer.getInitializer()) != null) {
                        OCType rType = initializer.getResolvedType().getGuessedType();
                        this.checkAssignment(initializer, member, symbol.getResolvedType(), rType, symbol, rType, true, false, "");
                    }
                } else {
                    this.addErrorAnnotation(member, OCInspections.InitializerIssues.class, "err_typecheck_convert_incompatible", "Invalid initializer for struct field", new IntentionAction[0]);
                }
                ++curInitializerIndex;
            }
        } else if (originalType != null && originalType.isScalar()) {
            if (initializers.size() == 0) {
                if (!file2.isCpp()) {
                    this.addErrorAnnotation(compInitializer, OCInspections.InitializerIssues.class, "err_empty_scalar_initializer", "Empty initializer for scalar type", new IntentionAction[0]);
                }
            } else if (initializers.size() > 1) {
                this.addErrorAnnotation(compInitializer, OCInspections.InitializerIssues.class, "err_excess_initializers", "Excess elements in scalar initializer", new IntentionAction[0]);
            } else {
                OCCompoundInitializerMember initializer = initializers.get(0);
                if (initializer instanceof OCExpression) {
                    this.checkAssignment((OCExpression)initializer, initializer, originalType, ((OCExpression)initializer).getResolvedType(), "Incompatible types in initializer: ");
                    if (compInitializer.getParent() instanceof OCCompoundInitializer) {
                        for (ASTNode child : compInitializer.getNode().getChildren(null)) {
                            if (child.getElementType() != OCTokenTypes.LBRACE && child.getElementType() != OCTokenTypes.RBRACE) continue;
                            this.addWarningAnnotation(child.getPsi(), null, "warn_braces_around_scalar_init", "Redundant braces", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                        }
                    }
                } else {
                    this.addErrorAnnotation(compInitializer, OCInspections.InitializerIssues.class, "ext_many_braces_around_scalar_init", "Invalid initializer for scalar type", new IntentionAction[0]);
                }
            }
        }
    }

    protected void checkInitializersInList(OCCompoundInitializer compInitializer, OCStructType type2) {
        OCStructSymbol paramTypeSymbol = type2.getSymbol();
        if (paramTypeSymbol.getTemplateParameters().size() == 1) {
            OCTypeParameterSymbol parameterSymbol = paramTypeSymbol.getTemplateParameters().get(0);
            OCTypeArgument paramSubstitution = paramTypeSymbol.getSubstitution().getSubstitutionFor(parameterSymbol);
            if (paramSubstitution instanceof OCType) {
                OCArgumentsList<OCExpression> argumentsList = OCArgumentsList.getArgumentList(compInitializer.getInitializerExpressions());
                for (int i2 = 0; i2 < argumentsList.getTypes().size(); ++i2) {
                    OCExpression argument = argumentsList.getExprs().get(i2);
                    OCType argumentType = argumentsList.getTypes().get(i2);
                    this.checkAssignment(argument, argument, (OCType)paramSubstitution, argumentType, "");
                }
            }
        }
    }

    public boolean checkFunctionArguments(OCElement element, OCFunctionType funcType, @NotNull List<OCExpression> arguments, OCSymbol functionSymbol) {
        int requiredArgumentsCnt;
        List<OCType> paramTypes = funcType.getParameterTypes();
        boolean allowImplicitConversions = true;
        OCResolveContext context = new OCResolveContext(element);
        if (functionSymbol != null && functionSymbol.getKind().isConstructorOrDestructor() && arguments.size() == 1 && arguments.get(0) instanceof OCCompoundInitializer) {
            OCCompoundInitializer initializer = (OCCompoundInitializer)arguments.get(0);
            List<OCExpression> expressions2 = initializer.getInitializerExpressions();
            if (paramTypes.size() > 0 && OCCodeInsightUtil.isInitializerListType(paramTypes.get(0), element.getContainingOCFile())) {
                this.checkInitializersInList(initializer, (OCStructType)paramTypes.get(0));
                return true;
            }
            if (paramTypes.size() != 1 || expressions2.size() == 1 && paramTypes.get(0).resolve(initializer.getContainingFile()).isCompatible(expressions2.get(0).getResolvedType(), initializer, false)) {
                arguments = expressions2;
            } else {
                allowImplicitConversions = false;
            }
        }
        LinkedList<Annotation> annotations2 = new LinkedList<Annotation>();
        OCArgumentsList<OCExpression> argumentsList = OCArgumentsList.getArgumentList(arguments);
        int maxArgumentsCnt = requiredArgumentsCnt = OCArgumentsChecker.getNonVariadicParametersCount(paramTypes);
        boolean variableArgs = funcType.isVararg();
        if (functionSymbol instanceof OCFunctionSymbol) {
            requiredArgumentsCnt = ((OCFunctionSymbol)functionSymbol).getNonInitializedParametersCount(context);
        }
        if (argumentsList.getCount() < requiredArgumentsCnt && !argumentsList.hasNonExpandedVariadics()) {
            annotations2.add(this.addErrorAnnotation(element, OCInspections.FunctionParameterCountMismatch.class, "err_typecheck_call_too_few_args", "Too few arguments, expected " + (variableArgs ? "at least " : "") + requiredArgumentsCnt, new IntentionAction[0]));
        } else if (!variableArgs && argumentsList.getCount() > maxArgumentsCnt) {
            if (OCCodeInsightUtil.isInPlainOldC(element) && funcType.getParameterTypes(true).isEmpty()) {
                annotations2.add(this.addWarningAnnotation(element, OCInspections.KRUnspecifiedParameters.class, "CIDR", "Too many arguments, expected " + requiredArgumentsCnt));
            } else {
                annotations2.add(this.addErrorAnnotation(element, OCInspections.FunctionParameterCountMismatch.class, "err_typecheck_call_too_many_args", "Too many arguments, expected " + requiredArgumentsCnt, new IntentionAction[0]));
            }
        }
        if (annotations2.size() == 0) {
            OCFunctionSymbol symbol;
            List<OCDeclaratorSymbol> parameterSymbols;
            List<OCDeclaratorSymbol> paramSymbols = null;
            if (functionSymbol instanceof OCFunctionSymbol && (parameterSymbols = (symbol = (OCFunctionSymbol)functionSymbol).getParameterSymbols(context)).size() == argumentsList.getCount()) {
                paramSymbols = parameterSymbols;
            }
            boolean finalAllowImplicitConversions = allowImplicitConversions;
            OCArgumentsChecker.processArguments(paramTypes, paramSymbols, argumentsList, context, (OCType parameterType, OCDeclaratorSymbol parameterSymbol, OCType argumentType, E argumentExpr, boolean isVariadic) -> {
                if (argumentExpr == null) {
                    return true;
                }
                if (parameterType instanceof OCEllipsisType || argumentType instanceof OCEllipsisType) {
                    if (argumentType.isVoid()) {
                        this.addErrorAnnotation((PsiElement)argumentExpr, null, "err_call_incomplete_argument", "Invalid use of void expression", new IntentionAction[0]);
                        return false;
                    }
                    return false;
                }
                if (parameterType instanceof OCFunctionType && argumentType instanceof OCPointerType && argumentType.getTerminalType() instanceof OCFunctionType) {
                    argumentType = ((OCPointerType)argumentType).getRefType();
                }
                if (OCTypeUtils.isUnresolvedLambdaAutoType(argumentType)) {
                    argumentType = OCTypeUtils.resolveLambdaAutoType(parameterType, argumentType, context);
                }
                OCType requiredType = argumentType.accept(OCArrayToPointerChanger.INSTANCE);
                requiredType.attachAliasName(argumentType.getAliasName());
                this.checkAssignment((OCExpression)argumentExpr, (PsiElement)argumentExpr, parameterType, argumentType, parameterSymbol, requiredType, finalAllowImplicitConversions, false, "Parameter type mismatch: ");
                return true;
            });
        }
        this.addFunctionCallQuickFixes(element, funcType, argumentsList.getExprs(), functionSymbol, argumentsList.getTypes(), annotations2);
        return annotations2.isEmpty();
    }

    public static int getNonVariadicParametersCount(List<? extends OCType> parameterTypes) {
        int count = 0;
        for (OCType oCType : parameterTypes) {
            if (oCType instanceof OCVariadicType || oCType instanceof OCEllipsisType) continue;
            ++count;
        }
        return count;
    }

    public static <E extends OCTypeOwner> boolean processArguments(@NotNull List<? extends OCType> parameterTypes, @Nullable List<OCDeclaratorSymbol> parameterSymbols, @NotNull OCArgumentsList<E> arguments, @NotNull OCResolveContext context, final @NotNull ArgumentsProcessor<E> processor2) {
        int paramIndex = 0;
        int argIndex = 0;
        while (paramIndex < parameterTypes.size()) {
            OCTypeOwner expression2;
            OCDeclaratorSymbol paramSymbol;
            OCType paramType = parameterTypes.get(paramIndex).resolve(context.clearSubstitution());
            OCDeclaratorSymbol oCDeclaratorSymbol = paramSymbol = parameterSymbols != null && paramIndex < parameterSymbols.size() ? parameterSymbols.get(paramIndex) : null;
            if (paramType instanceof OCVariadicType) {
                if (paramIndex == parameterTypes.size() - 1) {
                    OCType underlyingType = ((OCVariadicType)paramType).getUnderlyingType();
                    for (int j = argIndex; j < arguments.getCount(); ++j) {
                        OCTypeOwner expression3;
                        OCType argumentType = arguments.getTypes().get(j).getGuessedType();
                        OCTypeOwner oCTypeOwner = expression3 = arguments.getExprs() != null ? (OCTypeOwner)arguments.getExprs().get(j) : null;
                        if (processor2.process(underlyingType, paramSymbol, argumentType, expression3, true)) continue;
                        return false;
                    }
                    if (argIndex != arguments.getCount() || !underlyingType.accept(new OCBooleanTypeVisitor(){

                        @Override
                        public Boolean visitTypeParameterType(OCTypeParameterType type2) {
                            return !processor2.process(type2, paramSymbol, new OCExpansionPackType(), null, true);
                        }
                    }).booleanValue()) break;
                    return false;
                }
                ++paramIndex;
                continue;
            }
            if (argIndex >= arguments.getCount()) break;
            OCType argumentType = arguments.getTypes().get(argIndex).getGuessedType();
            OCTypeOwner oCTypeOwner = expression2 = arguments.getExprs() != null ? (OCTypeOwner)arguments.getExprs().get(argIndex) : null;
            if (!processor2.process(paramType, paramSymbol, argumentType, expression2, false)) {
                return false;
            }
            ++paramIndex;
            ++argIndex;
        }
        return true;
    }

    public static boolean processArguments(@NotNull List<? extends OCTypeArgument> parameterTypes, @NotNull List<? extends OCTypeArgument> argumentTypes, @NotNull TypeArgumentsProcessor processor2) {
        return OCArgumentsChecker.processArguments(parameterTypes, argumentTypes, null, true, processor2);
    }

    public static boolean processArguments(@NotNull List<? extends OCTypeArgument> parameterTypes, @NotNull List<? extends OCTypeArgument> argumentTypes, @Nullable Function<OCTypeArgument, OCTypeArgument> parameterResolver, boolean failIfCountMismatch, @NotNull TypeArgumentsProcessor processor2) {
        if (failIfCountMismatch && parameterTypes.size() != argumentTypes.size() && (parameterTypes.size() <= 0 || parameterTypes.size() > argumentTypes.size() + 1 || parameterTypes.get(parameterTypes.size() - 1) == null || !parameterTypes.get(parameterTypes.size() - 1).isVariadic())) {
            return false;
        }
        for (int i2 = 0; i2 < parameterTypes.size(); ++i2) {
            OCTypeArgument parameterType = parameterTypes.get(i2);
            if (parameterType != null && parameterType.isVariadic()) {
                if (i2 == parameterTypes.size() - 1) {
                    parameterType = parameterType instanceof OCVariadicType ? ((OCVariadicType)parameterType).getUnderlyingType() : new OCExpressionTypeArgument(((OCVariadicPackExpressionSymbol)((OCExpressionTypeArgument)parameterType).getSymbol()).getExpression());
                    if (parameterResolver != null) {
                        parameterType = (OCTypeArgument)parameterResolver.fun((Object)parameterType);
                    }
                    if (i2 >= argumentTypes.size() && !processor2.process(parameterType instanceof OCType ? ((OCType)parameterType).getTerminalType() : parameterType, new OCExpansionPackType())) {
                        return false;
                    }
                    for (int j = i2; j < argumentTypes.size(); ++j) {
                        OCTypeArgument argumentType = argumentTypes.get(j);
                        if (processor2.process(parameterType, argumentType)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (i2 >= argumentTypes.size()) break;
            OCTypeArgument argumentType = argumentTypes.get(i2);
            if (parameterResolver != null) {
                parameterType = (OCTypeArgument)parameterResolver.fun((Object)parameterType);
            }
            if (processor2.process(parameterType, argumentType)) continue;
            return false;
        }
        return true;
    }

    protected void addFunctionCallQuickFixes(OCElement element, OCFunctionType funcType, List<OCExpression> arguments, OCSymbol functionSymbol, List<OCType> argumentTypes, List<Annotation> annotations2) {
    }

    protected abstract void checkAssignment(OCExpression var1, PsiElement var2, OCType var3, OCType var4, OCSymbol var5, OCType var6, boolean var7, boolean var8, String var9);

    protected abstract void checkAssignment(OCExpression var1, PsiElement var2, OCType var3, OCType var4, String var5);

    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> aClass, @Nullable String inspectionID, @NotNull String message2) {
        return this.addWarningAnnotation(element, aClass, inspectionID, message2, null, IntentionAction.EMPTY_ARRAY);
    }

    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> aClass, @Nullable String inspectionID, @NotNull String message2, @Nullable ProblemHighlightType highlightType) {
        return this.addWarningAnnotation(element, aClass, inspectionID, message2, highlightType, IntentionAction.EMPTY_ARRAY);
    }

    @Nullable
    protected abstract Annotation addWarningAnnotation(@Nullable PsiElement var1, @Nullable Class<? extends OCInspection> var2, @Nullable String var3, @NotNull String var4, @Nullable ProblemHighlightType var5, IntentionAction ... var6);

    @Nullable
    protected abstract Annotation addErrorAnnotation(@Nullable PsiElement var1, @Nullable Class<? extends OCInspection> var2, @Nullable String var3, @NotNull String var4, IntentionAction ... var5);

    protected abstract void checkConstructor(OCCompoundInitializer var1, OCSymbol var2);

    public void checkCharArrayInit(@NotNull OCType type2, @NotNull OCLiteralExpression literal) {
        if (type2 instanceof OCArrayType) {
            OCArrayType arrayType = (OCArrayType)type2;
            int length = arrayType.getLength();
            OCType literalType = literal.getType();
            if (literalType instanceof OCArrayType) {
                OCArrayType literalArray = (OCArrayType)literalType;
                if (arrayType.hasLength() && length < literalArray.getLength()) {
                    this.addWarningAnnotation(literal, OCInspections.IncompatibleInitializers.class, "ext_initializer_string_for_char_array_too_long", length == literalArray.getLength() - 1 ? "Initializer string is too long, null-terminator doesn't fit" : "Initializer string is too long for array of chars");
                }
            }
        }
    }

    @FunctionalInterface
    public static interface TypeArgumentsProcessor {
        public boolean process(OCTypeArgument var1, OCTypeArgument var2);
    }

    @FunctionalInterface
    public static interface ArgumentsProcessor<E extends OCTypeOwner> {
        public boolean process(@NotNull OCType var1, @Nullable OCDeclaratorSymbol var2, @NotNull OCType var3, @Nullable E var4, boolean var5);
    }
}

