/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementAllMethodsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementMethodIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImplementPropertyAccessorsQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCMakePropertyDynamicQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSynthesizePropertyQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class OCCheckImplementedMethodsProcessor
implements Processor<OCMethodSymbol> {
    private OCAnnotator myConsumer;
    private OCImplementationSymbol implementationSymbol;
    private List<String> unimplementedMethods = new LinkedList<String>();
    private Set<String> declaredInClasses = new HashSet<String>();
    private boolean wasUnimplementedProperty = false;
    private boolean isImplementationCheckMode;
    @Nullable
    private OCObjectType mySuperType;

    OCCheckImplementedMethodsProcessor(OCAnnotator consumer2, OCImplementationSymbol implementationSymbol, @Nullable OCObjectType superType, boolean isImplementationCheckMode) {
        this.myConsumer = consumer2;
        this.implementationSymbol = implementationSymbol;
        this.isImplementationCheckMode = isImplementationCheckMode;
        this.mySuperType = superType;
    }

    public boolean process(final OCMethodSymbol intfMethodSymbol) {
        if (this.implementationSymbol == null) {
            return true;
        }
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol methodSymbol) {
                if (methodSymbol.isStatic() == intfMethodSymbol.isStatic()) {
                    return super.process((Object)methodSymbol);
                }
                return true;
            }
        };
        OCImplementationSymbol mainImplementation = this.implementationSymbol.getCategoryName() != null ? this.implementationSymbol.getMainImplementation() : null;
        this.implementationSymbol.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2);
        if (mainImplementation != null) {
            mainImplementation.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2);
        }
        if (intfMethodSymbol.getParent() instanceof OCProtocolSymbol && this.mySuperType != null) {
            this.mySuperType.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2, true, false);
        }
        OCMethodSymbol implMethodSymbol = (OCMethodSymbol)processor2.getFoundValue();
        OCPropertySymbol property = intfMethodSymbol.getGeneratedFromProperty();
        String interfaceName = ((OCClassSymbol)intfMethodSymbol.getParent()).getNameWithKindLowercase();
        String propertyName = null;
        if (property != null) {
            propertyName = property.getNameWithKindLowercase() + (property.getParent() instanceof OCProtocolSymbol ? " declared in " + interfaceName : "");
            CommonProcessors.FindFirstProcessor synthesizeProcessor = new CommonProcessors.FindFirstProcessor();
            this.implementationSymbol.processMembers(property.getName(), OCSynthesizeSymbol.class, synthesizeProcessor);
            if (mainImplementation != null) {
                mainImplementation.processMembers(property.getName(), OCSynthesizeSymbol.class, synthesizeProcessor);
            }
            OCSynthesizeSymbol synthesizeSymbol = (OCSynthesizeSymbol)synthesizeProcessor.getFoundValue();
            if (synthesizeProcessor.isFound() && implMethodSymbol != null && this.isImplementationCheckMode) {
                return this.checkSynthesize(intfMethodSymbol, implMethodSymbol, property, propertyName, synthesizeSymbol);
            }
            if (!(this.wasUnimplementedProperty && this.isImplementationCheckMode || synthesizeProcessor.isFound() || implMethodSymbol != null || intfMethodSymbol.isOptional() || OCCompilerHelper.supportsAutosynthesis(property.getContainingOCFile()))) {
                return this.reportNotSynthesized(intfMethodSymbol, property, propertyName);
            }
        } else if (implMethodSymbol == null && this.checkMethodImplementedInSynthesize(intfMethodSymbol, mainImplementation, interfaceName)) {
            return true;
        }
        if (implMethodSymbol == null) {
            if (!intfMethodSymbol.isOptional() && !intfMethodSymbol.isUnavailable() && property == null) {
                if (!this.isImplementationCheckMode) {
                    OCMethod intfMethod = (OCMethod)intfMethodSymbol.locateDefinition();
                    if (intfMethod == null) {
                        return true;
                    }
                    String clangID = OCClangMessageFinder.getInstance().getMethodNotImplemented();
                    Annotation annotation = this.myConsumer.addWarningAnnotation(intfMethod.getNameIdentifier(), OCInspections.NotImplementedMethods.class, clangID, intfMethodSymbol.getNameWithKindUppercase() + " is not implemented");
                    this.myConsumer.registerQuickFix(annotation, new OCImplementMethodIntentionAction(intfMethodSymbol));
                    this.myConsumer.registerQuickFix(annotation, new OCImplementAllMethodsIntentionAction((OCClassSymbol)intfMethodSymbol.getParent()));
                } else {
                    this.unimplementedMethods.add("'" + intfMethodSymbol.getName() + "'");
                    this.declaredInClasses.add(((OCClassSymbol)intfMethodSymbol.getParent()).getNameWithKindLowercase());
                }
            }
        } else if (this.isImplementationCheckMode) {
            Object implMethod = implMethodSymbol.locateDefinition();
            if (!(implMethod instanceof OCMethod)) {
                return true;
            }
            this.checkMethodsReturnType(intfMethodSymbol, implMethodSymbol, (PsiElement)implMethod, property, propertyName, interfaceName);
            this.checkMethodParameters(intfMethodSymbol, (PsiElement)implMethod, property, propertyName, interfaceName);
        }
        return true;
    }

    private boolean reportNotSynthesized(OCMethodSymbol intfMethodSymbol, OCPropertySymbol property, String propertyName) {
        this.wasUnimplementedProperty = true;
        PsiNameIdentifierOwner annotationElement = (PsiNameIdentifierOwner)(this.isImplementationCheckMode ? this.implementationSymbol : intfMethodSymbol).locateDefinition();
        if (annotationElement == null) {
            return true;
        }
        String message2 = StringUtil.capitalize((String)propertyName) + " requires " + (intfMethodSymbol.isGetter() ? "getter " : "setter ") + intfMethodSymbol.getNameWithKindLowercase() + " - provide implementation or use '@synthesize' or '@dynamic'";
        Annotation annotation = this.myConsumer.addWarningAnnotation(annotationElement.getNameIdentifier(), OCInspections.NoGetterOrSetter.class, "CIDR", message2);
        if (this.isImplementationCheckMode) {
            this.myConsumer.registerQuickFix(annotation, new OCImplementAllMethodsIntentionAction(this.implementationSymbol));
        } else {
            this.myConsumer.registerQuickFix(annotation, new OCImplementPropertyAccessorsQuickFix(property));
        }
        this.myConsumer.registerQuickFix(annotation, new OCSynthesizePropertyQuickFix(this.implementationSymbol, property));
        this.myConsumer.registerQuickFix(annotation, new OCMakePropertyDynamicQuickFix(this.implementationSymbol, property));
        return true;
    }

    private boolean checkSynthesize(final OCMethodSymbol intfMethodSymbol, OCMethodSymbol implMethodSymbol, final OCPropertySymbol property, String propertyName, OCSynthesizeSymbol synthesizeSymbol) {
        Object implMethod = implMethodSymbol.locateDefinition();
        if (!(implMethod instanceof OCMethod) || !synthesizeSymbol.isSynthesize()) {
            return true;
        }
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> pairAccessorFinder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol methodSymbol) {
                if (methodSymbol != intfMethodSymbol && methodSymbol.getGeneratedFromProperty() == property) {
                    return super.process((Object)methodSymbol);
                }
                return true;
            }
        };
        ((OCClassSymbol)intfMethodSymbol.getParent()).processMembers(OCMethodSymbol.class, pairAccessorFinder);
        if (pairAccessorFinder.isFound() && ((OCMethodSymbol)pairAccessorFinder.getFoundValue()).getAssociatedSymbol() == null) {
            return true;
        }
        String message2 = "Accessor methods of synthesized " + propertyName + " were overridden";
        Annotation annotation = this.myConsumer.addWarningAnnotation(((OCMethod)implMethod).getNameIdentifier(), OCInspections.AccessorsWereOverridden.class, "CIDR", message2);
        this.myConsumer.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)implMethod, "Remove " + implMethodSymbol.getNameWithKindLowercase(), "Remove accessor"));
        this.myConsumer.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)synthesizeSymbol.locateDefinition(), "Remove '@synthesize'/'@dynamic' statement"));
        return true;
    }

    private boolean checkMethodImplementedInSynthesize(final OCMethodSymbol intfMethodSymbol, OCImplementationSymbol mainImplementation, String interfaceName) {
        OCInterfaceSymbol privateCategory;
        OCInterfaceSymbol mainInterface;
        OCInterfaceSymbol anInterface = this.implementationSymbol.getInterface();
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            protected boolean accept(OCMethodSymbol methodSymbol) {
                return methodSymbol.isStatic() == intfMethodSymbol.isStatic() && methodSymbol.getGeneratedFromProperty() != null;
            }
        };
        if (anInterface != null) {
            anInterface.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2);
        }
        if (!processor2.isFound() && mainImplementation != null && (mainInterface = mainImplementation.getInterface()) != null) {
            mainInterface.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2);
        }
        if (!processor2.isFound() && (privateCategory = this.implementationSymbol.getInterface(false, "")) != null && !privateCategory.equals(anInterface)) {
            privateCategory.processMembers(intfMethodSymbol.getName(), OCMethodSymbol.class, processor2);
        }
        if (processor2.isFound()) {
            OCPropertySymbol propertySymbol = ((OCMethodSymbol)processor2.getFoundValue()).getGeneratedFromProperty();
            Ref hasSynthesizes = Ref.create((Object)false);
            propertySymbol.processSynthesizes((Processor<? super OCSynthesizeSymbol>)((Processor)symbol -> {
                String propName = propertySymbol.getNameWithKindLowercase();
                if (intfMethodSymbol.isGetter()) {
                    this.checkMethodsReturnType(intfMethodSymbol, null, (PsiElement)symbol.locateDefinition(), propertySymbol, propName, interfaceName);
                } else {
                    this.checkMethodParameters(intfMethodSymbol, (PsiElement)symbol.locateDefinition(), propertySymbol, propName, interfaceName);
                }
                hasSynthesizes.set((Object)true);
                return true;
            }));
            if (((Boolean)hasSynthesizes.get()).booleanValue() || OCCompilerHelper.supportsAutosynthesis(this.implementationSymbol.getContainingOCFile())) {
                return true;
            }
        }
        return false;
    }

    private void checkMethodsReturnType(OCMethodSymbol intfMethodSymbol, @Nullable OCMethodSymbol implMethodSymbol, PsiElement implElement, OCPropertySymbol property, String propName, String interfaceName) {
        OCType implMethodReturnType = implMethodSymbol != null ? implMethodSymbol.getReturnType().resolve(implElement.getContainingFile()) : property.getType();
        OCType intfMethodReturnType = intfMethodSymbol.getReturnType().resolve(implElement.getContainingFile());
        if (!intfMethodReturnType.isSuperType(implMethodReturnType, implElement)) {
            Annotation annotation;
            if (property != null) {
                boolean isGetter = OCNameSuggester.isObjCGetter(intfMethodSymbol.getName());
                String message2 = (isGetter ? "Getter" : "Setter") + " method for " + propName + " must return '" + intfMethodReturnType.getName(intfMethodSymbol.getContainingOCFile()) + "' rather than '" + implMethodReturnType.getName((PsiElement)implElement.getContainingFile()) + "'";
                PsiElement elementToHighlight = implElement instanceof OCMethod ? ((OCMethod)implElement).getNameIdentifier() : implElement;
                annotation = this.myConsumer.addWarningAnnotation(elementToHighlight, OCInspections.AssociatedTypeMismatch.class, "warn_non_covariant_overriding_ret_types", message2);
                if (isGetter && implMethodSymbol != null) {
                    this.myConsumer.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, implMethodReturnType));
                }
            } else {
                String message3 = "Return type '" + implMethodReturnType.getName(implMethodSymbol.getContainingOCFile()) + "' is different from declared in " + interfaceName + " ('" + intfMethodReturnType.getName(intfMethodSymbol.getContainingOCFile()) + "')";
                annotation = this.myConsumer.addWarningAnnotation(((OCMethod)implElement).getReturnTypeElement(), OCInspections.AssociatedTypeMismatch.class, "warn_non_covariant_overriding_ret_types", message3);
                this.myConsumer.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)intfMethodSymbol, implMethodReturnType, " in the interface", false));
            }
            if (implMethodSymbol != null) {
                this.myConsumer.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)implMethodSymbol, intfMethodReturnType, " in the implementation", false));
            } else {
                this.myConsumer.registerQuickFix(annotation, new OCChangeTypeIntentionAction(intfMethodSymbol, implMethodReturnType));
                this.myConsumer.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, intfMethodReturnType));
            }
        }
    }

    private void checkMethodParameters(OCMethodSymbol intfMethod, PsiElement implElement, OCPropertySymbol property, String propName, String interfaceName) {
        List<OCMethodSymbol.SelectorPartSymbol> intfParameters = intfMethod.getSelectors();
        List<OCMethodSelectorPart> implParameters = implElement instanceof OCMethod ? ((OCMethod)implElement).getParameters() : Collections.singletonList(null);
        for (int i2 = 0; i2 < intfParameters.size() && i2 < implParameters.size(); ++i2) {
            Annotation annotation;
            String message2;
            PsiElement elementToHighlight;
            OCDeclaratorSymbol intfParameter = intfParameters.get(i2).getParameter();
            if (intfParameter == null) continue;
            OCType intfParamType = intfParameter.getType().resolve(implElement.getContainingFile());
            OCMethodSelectorPart implParameter = implParameters.get(i2);
            OCType implParamType = (implParameter != null ? implParameter.getType() : property.getType()).resolve(implElement.getContainingFile());
            PsiElement psiElement = elementToHighlight = implParameter != null ? implParameter.getTypeElement() : implElement;
            if (implParamType.isSuperType(intfParamType, implElement) || elementToHighlight == null) continue;
            if (property != null) {
                message2 = "Setter method for " + propName + " must take the parameter of type '" + intfParamType.getName(intfMethod.getContainingOCFile()) + "' rather than '" + implParamType.getName((PsiElement)implElement.getContainingFile()) + "'";
                annotation = this.myConsumer.addWarningAnnotation(elementToHighlight, OCInspections.AssociatedTypeMismatch.class, "warn_non_contravariant_overriding_param_types", message2);
                if (implParameter != null) {
                    this.myConsumer.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, implParamType));
                }
            } else {
                message2 = "Parameter type '" + implParamType.getName((PsiElement)implElement.getContainingFile()) + "' is different from declared in " + interfaceName + " ('" + intfParamType.getName(intfMethod.getContainingOCFile()) + "')";
                annotation = this.myConsumer.addWarningAnnotation(elementToHighlight, OCInspections.AssociatedTypeMismatch.class, "warn_non_contravariant_overriding_param_types", message2);
                this.myConsumer.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)intfParameter, implParamType, " in the interface", false));
            }
            if (implParameter != null) {
                this.myConsumer.registerQuickFix(annotation, new OCChangeTypeIntentionAction(implParameter.getLocalSymbol(), intfParamType, " in the implementation", false));
                continue;
            }
            this.myConsumer.registerQuickFix(annotation, new OCChangeTypeIntentionAction(intfParameter, implParamType));
            this.myConsumer.registerQuickFix(annotation, new OCChangeTypeIntentionAction(property, intfParamType));
        }
    }

    private static String getListAsString(Collection<String> list, int maxLen) {
        StringBuilder result2 = new StringBuilder();
        for (String item : list) {
            if (result2.length() > 0) {
                result2.append(", ");
            }
            if (result2.length() < maxLen) {
                result2.append(item);
                continue;
            }
            result2.append("...");
            break;
        }
        return result2.toString();
    }

    public String getUnimplementedMethods() {
        ArrayList<String> methods = new ArrayList<String>(this.unimplementedMethods);
        Collections.sort(methods);
        return OCCheckImplementedMethodsProcessor.getListAsString(methods, 70);
    }

    public String getDeclaredInClasses() {
        ArrayList<String> classes2 = new ArrayList<String>(this.declaredInClasses);
        Collections.sort(classes2);
        return OCCheckImplementedMethodsProcessor.getListAsString(classes2, 30);
    }

    public boolean wasUnimplementedProperty() {
        return this.wasUnimplementedProperty;
    }
}

