/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBoxedExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import org.jetbrains.annotations.Nullable;

public class OCConstantExpressionVisitor
extends OCRecursiveVisitor {
    private boolean wasAmpersand;
    private boolean myConst;

    @Override
    public void visitUnaryExpression(OCUnaryExpression expression2) {
        if (expression2.isGetAddress()) {
            this.wasAmpersand = true;
        }
        this.visitExpression(expression2);
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression expression2) {
        if (this.wasAmpersand) {
            this.visitExpression(expression2);
        } else {
            this.nonConstExpression(expression2);
            this.myConst = false;
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expression2) {
        if (this.wasAmpersand) {
            this.wasAmpersand = false;
            return;
        }
        OCSymbol symbol = expression2.resolveToSymbol();
        if (symbol != null) {
            if (symbol instanceof OCTypeParameterSymbol) {
                return;
            }
            if (symbol.getKind() == OCSymbolKind.TYPEDEF) {
                OCType type2 = symbol.getResolvedType();
                if (OCConstantExpressionVisitor.isNonConstTypeConversion(type2, expression2)) {
                    this.nonConstExpression(expression2);
                    this.myConst = false;
                }
            } else if (!this.isConstDeclarator(expression2, symbol)) {
                this.nonConstExpression(expression2);
                this.myConst = false;
            }
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression2) {
        Object symbol;
        PsiElement resolved;
        OCExpression funRef = expression2.getFunctionReferenceExpression();
        PsiReference reference = funRef.getReference();
        if (reference != null && (resolved = reference.resolve()) instanceof OCSymbolDeclarator && ((symbol = ((OCSymbolDeclarator)resolved).getSymbol()) instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isConstexpr() || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isConstexpr())) {
            super.visitCallExpression(expression2);
            return;
        }
        if (!(funRef instanceof OCReferenceExpression)) {
            this.nonConstExpression(expression2);
            this.myConst = false;
        } else {
            OCSymbol symbol2 = ((OCReferenceExpression)funRef).resolveToSymbol();
            if (OCCodeInsightUtil.isInPlainOldC(expression2) && (symbol2 == null || !symbol2.getName().startsWith("__builtin"))) {
                this.nonConstExpression(expression2);
                this.myConst = false;
            } else {
                super.visitCallExpression(expression2);
            }
        }
    }

    @Override
    public void visitCastExpression(OCCastExpression expression2) {
        if (OCConstantExpressionVisitor.isNonConstTypeConversion(expression2.getResolvedType(), expression2)) {
            this.nonConstExpression(expression2);
            this.myConst = false;
        } else {
            super.visitCastExpression(expression2);
        }
    }

    private static boolean isNonConstTypeConversion(OCType type2, PsiElement context) {
        return !OCCodeInsightUtil.isInPlainOldC(context) && !type2.isScalar() && !type2.isUnknown();
    }

    @Override
    public void visitCppNewExpression(OCCppNewExpression expression2) {
        this.nonConstExpression(expression2);
        this.myConst = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isConstDeclarator(OCReferenceExpression expression2, OCSymbol symbol) {
        if (!symbol.getKind().isConst() && symbol instanceof OCDeclaratorSymbol) {
            OCDeclaratorSymbol declarator = (OCDeclaratorSymbol)symbol;
            if (declarator.getArrayLengths().length != 0) {
                return true;
            }
            OCFile file2 = expression2.getContainingOCFile();
            if ((file2 != null && file2.isCpp() || OCCompilerKind.CLANG.equals((Object)OCCompilerHelper.getCompiler(file2))) && declarator.isConst()) {
                return true;
            }
            if (symbol.getKind() != OCSymbolKind.BUILTIN_SYMBOL) return false;
            this.visitExpression(expression2);
            return true;
        } else {
            if (!symbol.getKind().isConstructorOrDestructor()) return true;
            return false;
        }
    }

    @Override
    public void visitLiteralExpression(OCLiteralExpression expression2) {
        OCType type2 = expression2.getResolvedType();
        if (type2.isPointerToObject() && !type2.isPointerToString()) {
            this.myConst = false;
            this.nonConstExpression(expression2);
        }
    }

    @Override
    public void visitBoxedExpression(OCBoxedExpression expression2) {
        this.myConst = false;
        this.nonConstExpression(expression2);
    }

    @Override
    public void visitBlockExpression(OCBlockExpression blockExpression) {
    }

    @Override
    public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
    }

    @Override
    public void visitSizeofExpression(OCSizeofExpression expression2) {
    }

    protected void nonConstExpression(OCExpression expression2) {
    }

    public boolean isConstant(@Nullable OCExpression expression2) {
        if (expression2 != null) {
            this.myConst = true;
            expression2.accept(this);
            return this.myConst;
        }
        return false;
    }
}

