/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCFunctionGroupHelperKt;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateDefinitionQuickFix;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.intentions.OCAddParametersToConstructorIntentionAction;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppBaseClauseList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCAddFieldInitializerFix;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddSuperConstructorCallsFix;
import com.jetbrains.cidr.lang.quickfixes.OCAddTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCGenerateConstructorFix;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSafeDeleteIntentionAction;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppChecker
extends OCAnnotator {
    public void checkCppFunction(OCFunctionDeclaration function, OCFunctionSymbol symbol) {
        OCExpression initializer = function.getDeclarator().getInitializer();
        if (initializer != null) {
            this.checkPureVirtual(symbol, initializer);
        } else if (symbol.isPredeclaration() && OCSearchScope.isInProjectSources(symbol) && !symbol.isDefault() && !symbol.isDelete() && OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(symbol, true) == OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.REQUIRED) {
            Annotation annotation = this.addWarningAnnotation(function, OCInspections.NotImplementedFunctions.class, "CIDR", symbol.getNameWithKindUppercase() + " is not implemented");
            this.registerQuickFix(annotation, new OCGenerateDefinitionQuickFix(symbol, true));
            this.registerQuickFix(annotation, new OCGenerateDefinitionQuickFix(symbol, false));
            this.registerQuickFix(annotation, new OCMakeFunctionVirtualFix(symbol, true));
        }
        final Ref nonVirtualRef = new Ref();
        CommonProcessors.FindFirstProcessor<OCFunctionSymbol> virtualFinder = new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            public boolean process(OCFunctionSymbol symbol) {
                if (symbol.isVirtual()) {
                    return super.process((Object)symbol);
                }
                nonVirtualRef.set((Object)symbol);
                return true;
            }
        };
        new OCFunctionAncestorsQuery(symbol, true, false).forEach((Processor)virtualFinder);
        OCFunctionSymbol virtualFunction = (OCFunctionSymbol)virtualFinder.getFoundValue();
        OCFunctionSymbol nonVirtualFunction = (OCFunctionSymbol)nonVirtualRef.get();
        if (virtualFunction != null) {
            this.checkFunctionReturnTypes(function, symbol, virtualFunction, true, "derived function", "virtual " + symbol.getNameWithKindLowercase(), "base function", "err_different_return_type_for_overriding_virtual_function");
        } else if (symbol.getParent() != null && nonVirtualFunction != null && nonVirtualFunction.getVisibility() != OCVisibility.PRIVATE) {
            String message2 = symbol.getNameWithKindUppercase() + " hides a non-virtual function from " + nonVirtualFunction.getParent().getNameWithKindLowercase();
            Annotation annotation = this.addWarningAnnotation(function, OCInspections.HidingNonVirtualFunction.class, "CIDR", message2);
            this.registerQuickFix(annotation, new OCAddTypeModifierIntentionAction(nonVirtualFunction, OCTokenTypes.VIRTUAL_CPP_KEYWORD, nonVirtualFunction.getParent().getName() + "::" + nonVirtualFunction.getName(), false));
        }
        if (symbol.isCppConstructor() && symbol.isDefinition() && function instanceof OCFunctionDefinition) {
            this.checkConstructorDefinition(function, symbol);
        }
        this.checkFunctionReturnTypes(function, symbol);
        this.checkOverrideControls(function, symbol);
    }

    private static boolean isImplemented(OCFunctionSymbol symbol) {
        return !symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> symbol1.isPredeclaration() && (!(symbol1 instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol1).isDefault() && !((OCFunctionSymbol)symbol1).isDelete())));
    }

    private void checkFunctionReturnTypes(OCFunctionDeclaration function, OCFunctionSymbol symbol) {
        OCSymbol associatedFunction;
        OCCppNamespaceQualifier qualifier = function.getDeclarator().getNamespaceQualifier();
        if (qualifier != null && symbol.isDefinition()) {
            associatedFunction = qualifier.getPredeclarationInParent(symbol, true);
        } else {
            associatedFunction = symbol.getAssociatedSymbol();
            if (associatedFunction instanceof OCFunctionSymbol && associatedFunction.isDefinition()) {
                Object element = associatedFunction.locateDefinition();
                OCCppNamespaceQualifier oCCppNamespaceQualifier = qualifier = element instanceof OCDeclarator ? ((OCDeclarator)element).getNamespaceQualifier() : null;
                if (qualifier != null) {
                    OCSymbol newSymbol = qualifier.getPredeclarationInParent((OCSymbolWithQualifiedName)associatedFunction, true);
                    OCFunctionSymbol oCFunctionSymbol = symbol = newSymbol instanceof OCFunctionSymbol ? (OCFunctionSymbol)newSymbol : null;
                }
            }
        }
        if (symbol != null && associatedFunction instanceof OCFunctionSymbol) {
            if (symbol.isDefinition() && !associatedFunction.isDefinition()) {
                this.checkFunctionReturnTypes(function, symbol, (OCFunctionSymbol)associatedFunction, false, "function definition", symbol.getNameWithKindLowercase() + " definition", "function declaration", "err_member_def_does_not_match_ret_type");
            } else if (!symbol.isDefinition() && associatedFunction.isDefinition()) {
                this.checkFunctionReturnTypes(function, symbol, (OCFunctionSymbol)associatedFunction, false, "function declaration", symbol.getNameWithKindLowercase() + " declaration", "function definition", "err_member_def_does_not_match_ret_type");
            }
        }
    }

    private void checkOverrideControls(OCFunctionDeclaration function, OCFunctionSymbol symbol) {
        OCSymbolWithQualifiedName owner = symbol.getResolvedOwner();
        if (owner == null || !(owner.getType() instanceof OCMagicType)) {
            Ref isOverridden = Ref.create((Object)false);
            new OCFunctionAncestorsQuery(symbol, true, false).forEach(baseFunction -> {
                if (!baseFunction.isVirtual()) {
                    return true;
                }
                isOverridden.set((Object)true);
                if (baseFunction.isFinal()) {
                    String message2 = symbol.getNameWithKindUppercase() + " overrides a final function from " + baseFunction.getParent().getNameWithKindLowercase();
                    Annotation annotation = this.addErrorAnnotation(function, "err_final_function_overridden", message2);
                    this.registerQuickFix(annotation, new OCRemoveTypeModifierIntentionAction((OCSymbolWithQualifiedName)baseFunction, OCTokenTypes.FINAL_CPP_KEYWORD, (OCFunctionSymbol)baseFunction){
                        final /* synthetic */ OCFunctionSymbol val$baseFunction;
                        {
                            this.val$baseFunction = oCFunctionSymbol;
                            super(symbol, modifier);
                        }

                        @Override
                        protected String getSubject(OCSymbol symbol1) {
                            return this.val$baseFunction.getNameWithParent();
                        }
                    });
                    this.registerQuickFix(annotation, new OCSafeDeleteIntentionAction((PsiElement)function, symbol.getNameWithKindLowercase()));
                    return false;
                }
                return true;
            });
            int overrideCount = 0;
            List<PsiElement> vs = function.getVirtualSpecifiers();
            for (PsiElement spec : vs) {
                IElementType type2 = OCElementUtil.getElementType(spec);
                Annotation highlighting = this.highlightKeyword(spec);
                if (type2 != OCTokenTypes.OVERRIDE_CPP_KEYWORD || overrideCount++ != 0 || ((Boolean)isOverridden.get()).booleanValue()) continue;
                Annotation error = this.addErrorAnnotation(spec, "err_function_marked_override_not_overriding", "Function doesn't override any base member functions");
                this.registerQuickFix(error, new OCRemoveTypeModifierIntentionAction(symbol, OCTokenTypes.OVERRIDE_CPP_KEYWORD));
                if (highlighting == null || error == null) continue;
                EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
                TextAttributes ha = scheme2.getAttributes(highlighting.getTextAttributes());
                TextAttributes ea = scheme2.getAttributes(error.getTextAttributes());
                error.setEnforcedTextAttributes(TextAttributes.merge((TextAttributes)ha, (TextAttributes)ea));
            }
        }
    }

    private void checkPureVirtual(OCFunctionSymbol symbol, OCExpression initializer) {
        Annotation annotation;
        if (!symbol.isVirtual()) {
            annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "err_non_virtual_pure", "Only virtual function can have pure specifier");
            this.registerQuickFix(annotation, new OCMakeFunctionVirtualFix(symbol, false));
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, "Remove pure specifier"));
        }
        if (!(initializer instanceof OCLiteralExpression) || !"0".equals(((OCLiteralExpression)initializer).getUnescapedLiteralText())) {
            annotation = this.addErrorAnnotation(initializer, OCInspections.ConstructionIsNotAllowed.class, "err_member_function_initialization", "Invalid pure specifier");
            OCExpression zero = OCElementFactory.expressionFromText("0", initializer, false);
            this.registerQuickFix(annotation, new OCChangeElementIntentionAction((PsiElement)initializer, (PsiElement)zero, "Change pure specifier to '= 0'"));
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)initializer, "Remove pure specifier"));
        }
    }

    private void checkFunctionReturnTypes(OCFunctionDeclaration element, OCFunctionSymbol derivedFunction, OCFunctionSymbol baseFunction, boolean allowCovariance, String derivedSubject, String derivedLongSubject, String baseSubject, String clangID) {
        PsiFile file2 = element.getContainingFile();
        OCType baseType = baseFunction.getType().getReturnType().resolve(baseFunction.getContainingOCFile());
        OCType derivedType = derivedFunction.getType().getReturnType().resolve(derivedFunction.getContainingOCFile());
        String baseTypeName = baseType.getName(element);
        String overriddenTypeName = derivedType.getName(element);
        OCTypeElement annotationElement = element.getTypeElement();
        annotationElement = annotationElement != null ? annotationElement : element;
        Annotation annotation = null;
        if (allowCovariance && (baseType.isPointer() || baseType instanceof OCCppReferenceType) && (derivedType.isPointer() || derivedType instanceof OCCppReferenceType)) {
            String message2 = "Return type of " + derivedLongSubject + " (" + overriddenTypeName + ") isn't derived from the return type of " + baseSubject + " (" + baseTypeName + ")";
            if (!baseType.getTerminalType().isSuperType(derivedType.getTerminalType(), annotationElement)) {
                annotation = this.addErrorAnnotation(annotationElement, OCInspections.DerivedFunctionsReturnTypeMismatch.class, "err_covariant_return_not_derived", message2);
            }
        } else if (!new OCTypeEqualityAfterResolvingVisitor(derivedType, true, true, false, false, true, new OCResolveContext((PsiElement)file2)).equal(baseType)) {
            String message3 = "Return type of " + derivedLongSubject + " (" + overriddenTypeName + ") differs from the return type of " + baseSubject + " (" + baseTypeName + ")";
            annotation = this.addErrorAnnotation(annotationElement, OCInspections.DerivedFunctionsReturnTypeMismatch.class, clangID, message3);
        }
        if (annotation != null) {
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)derivedFunction, baseType, true, derivedSubject));
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction((OCSymbol)baseFunction, derivedType, true, baseSubject));
        }
    }

    private static String getMissingDefaultCtorsMessage(Collection<OCStructSymbol> classesMissingDefaultCtors) {
        boolean mutual = classesMissingDefaultCtors.size() > 1;
        return "Base " + (mutual ? StringUtil.pluralize((String)"class") : "class") + " " + StringUtil.join(classesMissingDefaultCtors, symbol -> "'" + symbol.getName() + "'", (String)", ") + (mutual ? " don't" : " doesn't") + " have a default constructor";
    }

    private static List<OCStructSymbol> getBaseClasses(OCStructSymbol symbol, PsiFile file2) {
        ArrayList<OCStructSymbol> baseClasses = new ArrayList<OCStructSymbol>();
        symbol.processBaseClasses(new OCResolveContext((PsiElement)file2), (symbol1, visibility) -> {
            if (symbol1 instanceof OCStructSymbol) {
                baseClasses.add((OCStructSymbol)symbol1);
            }
            return true;
        });
        return baseClasses;
    }

    public void checkClass(OCStruct parent) {
        ASTNode[] kws;
        for (ASTNode kw : kws = parent.getNode().getChildren(OCTokenTypes.CPP_CLASS_VIRTUAL_SPECIFIERS)) {
            this.highlightKeyword(kw.getPsi());
        }
        OCStructSymbol symbol = (OCStructSymbol)parent.getSymbol();
        if (symbol == null || symbol.isPredeclaration()) {
            return;
        }
        OCCppBaseClauseList baseClausesList = parent.getBaseClausesList();
        if (baseClausesList != null) {
            for (OCCppBaseClause baseClause : baseClausesList.getBaseClauses()) {
                OCReferenceElement refElement = baseClause.getReferenceElement();
                OCSymbol baseClass = refElement != null ? refElement.resolveToSymbol() : null;
                if (!(baseClass instanceof OCStructSymbol) || !((OCStructSymbol)baseClass).isFinal()) continue;
                Annotation annotation = this.addErrorAnnotation(baseClause, "err_class_marked_final_used_as_base", baseClass.getNameWithKindUppercase() + " is marked as final");
                this.registerQuickFix(annotation, new OCRemoveTypeModifierIntentionAction((OCSymbolWithQualifiedName)baseClass, OCTokenTypes.FINAL_CPP_KEYWORD));
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)baseClause, "Remove '" + baseClass.getName() + "' from the base classes list"));
            }
        }
        if (!symbol.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor(), true, new OCResolveContext(parent))) {
            return;
        }
        List classesMissingDefaultCtors = ContainerUtil.filter(OCCppChecker.getBaseClasses(symbol, parent.getContainingFile()), struct -> !struct.hasDefaultConstructor());
        if (!classesMissingDefaultCtors.isEmpty()) {
            String message2 = OCCppChecker.getMissingDefaultCtorsMessage(classesMissingDefaultCtors);
            Annotation annotation = this.addErrorAnnotation(parent.getHeaderRange(), OCInspections.NoDefaultBaseConstructor.class, "err_missing_default_ctor", message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            this.registerQuickFix(annotation, new OCGenerateConstructorFix(symbol, true));
            for (OCStructSymbol baseClass : classesMissingDefaultCtors) {
                this.registerQuickFix(annotation, new OCGenerateConstructorFix(baseClass, false));
            }
        }
    }

    private void checkConstructorDefinition(final OCFunctionDeclaration function, final OCFunctionSymbol symbol) {
        final OCSymbolWithQualifiedName parent = symbol.getResolvedOwner();
        if (parent instanceof OCStructSymbol) {
            List classesMissingCtors;
            LinkedHashSet<OCStructSymbol> baseClasses = new LinkedHashSet<OCStructSymbol>(OCCppChecker.getBaseClasses((OCStructSymbol)parent, function.getContainingFile()));
            CommonProcessors.CollectProcessor<OCDeclaratorSymbol> collector = new CommonProcessors.CollectProcessor<OCDeclaratorSymbol>(){

                protected boolean accept(OCDeclaratorSymbol field) {
                    if (field.getKind() == OCSymbolKind.STRUCT_FIELD && !field.isFriendOrStatic() && !(field.getResolvedType() instanceof OCArrayType)) {
                        OCType type2 = field.getResolvedType();
                        return type2 instanceof OCStructType || type2 instanceof OCCppReferenceType || field.isConst();
                    }
                    return false;
                }
            };
            ((OCStructSymbol)parent).processFields((Processor<OCDeclaratorSymbol>)collector);
            HashSet fields = new HashSet(collector.getResults());
            OCConstructorInitializationList list = ((OCFunctionDefinition)function).getConstructorInitializationList();
            if (list != null) {
                for (OCConstructorFieldInitializer initializer : list.getInitializers()) {
                    OCReferenceElement referenceElement = initializer.getReferenceElement();
                    if (referenceElement == null) continue;
                    OCQualifiedName qname = OCSymbolReferenceResolver.getQualifiedName(referenceElement);
                    OCSymbolReference.LocalReference reference = OCSymbolReference.getLocalReference(qname, (PsiElement)referenceElement);
                    for (OCSymbol initializerSymbol : reference.resolveToSymbols(true, false, referenceElement.getContainingFile())) {
                        if (initializerSymbol instanceof OCStructSymbol) {
                            baseClasses.remove(initializerSymbol);
                            continue;
                        }
                        if (initializerSymbol instanceof OCFunctionSymbol) {
                            OCSymbolWithQualifiedName owner = ((OCFunctionSymbol)initializerSymbol).getResolvedOwner();
                            if (parent.equals(owner)) {
                                return;
                            }
                            if (owner == null) continue;
                            baseClasses.remove(owner);
                            continue;
                        }
                        if (!(initializerSymbol instanceof OCDeclaratorSymbol) || !fields.contains(initializerSymbol)) continue;
                        fields.remove(initializerSymbol);
                    }
                }
            }
            if (!(classesMissingCtors = ContainerUtil.filter(baseClasses, struct -> !struct.hasDefaultConstructor())).isEmpty()) {
                String message2 = OCCppChecker.getMissingDefaultCtorsMessage(classesMissingCtors);
                Annotation annotation = this.addErrorAnnotation(function, OCInspections.NoDefaultBaseConstructor.class, "err_missing_default_ctor", message2);
                this.registerQuickFix(annotation, new OCAddSuperConstructorCallsFix(symbol, classesMissingCtors));
                for (OCStructSymbol baseClass : classesMissingCtors) {
                    this.registerQuickFix(annotation, new OCGenerateConstructorFix(baseClass, false));
                }
            } else {
                for (OCStructSymbol baseClass : baseClasses) {
                    this.myOperatorsChecker.checkFieldVisibility(baseClass.getDefaultConstructor(), function, null);
                }
            }
            for (final OCDeclaratorSymbol field : fields) {
                OCType type2 = field.getResolvedType();
                OCDeclarator declarator = (OCDeclarator)field.locateDefinition();
                if (declarator != null && declarator.getInitializer() != null) continue;
                if (type2 instanceof OCStructType) {
                    OCStructSymbol structSymbol = ((OCStructType)type2).getSymbol();
                    OCFunctionSymbol constructor = structSymbol.getDefaultConstructor();
                    if (constructor != null) {
                        this.myOperatorsChecker.checkFieldVisibility(constructor, function, null);
                        continue;
                    }
                    if (structSymbol.hasDefaultConstructor()) continue;
                }
                Annotation annotation = this.addErrorAnnotation(function, OCInspections.FieldMustBeInitialized.class, "err_uninitialized_member_in_ctor", field.getNameWithKindUppercase() + " must be initialized");
                this.registerQuickFix(annotation, new OCAddParametersToConstructorIntentionAction(){

                    @Override
                    @Nullable
                    protected OCDeclaratorSymbol getField(Editor editor, PsiFile file2) {
                        return field;
                    }

                    @Override
                    @NotNull
                    public String getText() {
                        return "Add " + field.getNameWithKindLowercase() + " as a parameter to constructor";
                    }

                    @Override
                    protected boolean enableChooseDialog(Collection<OCFunctionSymbol> candidates) {
                        return false;
                    }

                    @Override
                    @Nullable
                    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(Project project2, @Nullable Editor editor, PsiFile file2) {
                        return new OCCppActionContext<OCStructSymbol, OCFunctionSymbol>((OCStructSymbol)parent, (PsiElement)function){

                            @Override
                            @NotNull
                            public Collection<OCFunctionSymbol> getMemberCandidates() {
                                return Collections.singletonList(symbol);
                            }
                        };
                    }
                });
                if (type2 instanceof OCCppReferenceType) {
                    this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(field, ((OCCppReferenceType)type2).getRefType()));
                } else {
                    if (!(type2 instanceof OCStructType)) {
                        this.registerQuickFix(annotation, new OCAddFieldInitializerFix((OCFunctionDefinition)function, field));
                    }
                    if (OCCompilerHelper.supportsInClassInitialization(function.getContainingFile())) {
                        this.registerQuickFix(annotation, new OCAddInitializerIntentionAction(declarator, field));
                    }
                }
                if (field.isConst()) {
                    this.registerQuickFix(annotation, new OCRemoveTypeModifierIntentionAction(field, OCTokenTypes.CONST_KEYWORD));
                }
                if (!(type2 instanceof OCStructType)) continue;
                this.registerQuickFix(annotation, new OCGenerateConstructorFix(((OCStructType)type2).getSymbol(), false));
            }
        }
    }

    public void checkTypeInitialization(@NotNull OCElement element, @Nullable PsiElement callElement, @NotNull OCArgumentsList<OCExpression> arguments, @Nullable OCSymbol symbol, OCType type2, boolean isCast, PsiElement expression2) {
        List<OCExpression> argumentExprs = arguments.getExprs();
        if (argumentExprs == null) {
            return;
        }
        if (type2 instanceof OCStructType) {
            OCSymbol constructor = ((OCStructType)type2).findConstructor(arguments, new OCResolveContext(element), true, false, null);
            this.checkConstructorCall(element, argumentExprs, constructor);
        } else if (!(argumentExprs.size() <= 1 || type2 instanceof OCMagicType || type2 instanceof OCCppReferenceType && ((OCCppReferenceType)type2).getRefType() instanceof OCMagicType)) {
            this.addErrorAnnotation(argumentExprs.get(1), "err_excess_initializers", "Only one initializer is permitted");
        } else if (argumentExprs.size() == 1) {
            OCExpression argument = argumentExprs.get(0);
            OCType initializerType = argument.getResolvedType();
            if (isCast) {
                this.myOperatorsChecker.checkTypeCast(type2, initializerType, callElement, argument, expression2);
            } else {
                this.checkAssignment(argument, (PsiElement)element, type2, initializerType, symbol, initializerType);
            }
        }
    }

    public boolean checkConstructorCall(@NotNull OCElement element, @NotNull List<OCExpression> arguments, @Nullable OCSymbol symbol) {
        boolean result2 = true;
        if (symbol instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol) {
            OCResolveOverloadsUtil.OCFunctionGroupSymbol groupSymbol = (OCResolveOverloadsUtil.OCFunctionGroupSymbol)symbol;
            if (!(element instanceof OCDeclarator) || ((OCDeclarator)element).isExplicitConstructorCall() || groupSymbol.getCause() != OCResolveOverloadsUtil.OCFunctionGroupSymbol.Cause.NoViable) {
                return OCFunctionGroupHelperKt.annotateAmbig(this, element, groupSymbol, "No matching constructor");
            }
        } else if (symbol instanceof OCFunctionSymbol) {
            Boolean res;
            boolean isConstructor;
            boolean isCopyConstructor = false;
            boolean bl = isConstructor = !(element instanceof OCDeclarator) || !(((OCDeclarator)element).getResolvedType() instanceof OCCppReferenceType);
            if (isConstructor && ((OCFunctionSymbol)symbol).isCppConstructor() && arguments.size() == 1) {
                OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)symbol).getParent();
                OCExpression argument = arguments.get(0);
                OCType argumentType = argument.getResolvedType();
                if (parent instanceof OCStructSymbol && !(argument instanceof OCCompoundInitializer) && parent.getType().isCompatible(argumentType, element, false)) {
                    isCopyConstructor = true;
                    List<OCDeclaratorSymbol> parameterSymbols = ((OCFunctionSymbol)symbol).getParameterSymbols();
                    if (parameterSymbols.size() != 1 || !parameterSymbols.get(0).getResolvedType().isCompatible(argumentType, element, false)) {
                        return true;
                    }
                }
            }
            if (!isCopyConstructor && (res = this.checkDeclaratorReference(element, arguments)) != null) {
                return res;
            }
            if (!isConstructor) {
                return result2;
            }
            OCFunctionType funcType = (OCFunctionType)symbol.getType().resolve(element.getContainingOCFile());
            result2 = this.myOperatorsChecker.checkFunctionArguments(element, funcType, arguments, symbol);
        } else if (symbol instanceof OCStructSymbol && symbol.getKind() == OCSymbolKind.STRUCT) {
            if (arguments.size() == 1 && arguments.get(0) instanceof OCCompoundInitializer) {
                if (OCCodeInsightUtil.isInitializerListType(symbol.getType(), element.getContainingOCFile())) {
                    Boolean res = this.checkDeclaratorReference(element, arguments);
                    return res == null || res != false;
                }
                if (element instanceof OCDeclarator && ((OCStructSymbol)symbol).isPOD(false)) {
                    return true;
                }
                arguments = ((OCCompoundInitializer)arguments.get(0)).getInitializerExpressions();
            }
            if (arguments.size() == 1 && OCTypeCompatibilityVisitor.checkConvertible(symbol.getType(), arguments.get(0).getResolvedType(), null, element, true, element instanceof OCCallExpression, true, new OCResolveContext(element)).getState() == OCType.TypeCheckState.OK) {
                return true;
            }
            if (arguments.isEmpty() && ((OCStructSymbol)symbol).hasDefaultConstructor()) {
                return true;
            }
            List argumentTypes = ContainerUtil.map(arguments, expression2 -> OCExpectedTypeUtil.getExpressionType(expression2, true));
            OCFunctionType type2 = new OCFunctionType(OCVoidType.instance(), argumentTypes);
            Annotation annotation = this.addErrorAnnotation(element, OCInspections.CannotResolve.class, "CIDR", OCCppChecker.getCantResolveCtorMessage(symbol, type2, element));
            this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, element, symbol, symbol.getName(), type2));
            return false;
        }
        return result2 &= this.myOperatorsChecker.checkFieldVisibility(symbol, element, null);
    }

    @Nullable
    private Boolean checkDeclaratorReference(OCElement element, List<OCExpression> arguments) {
        OCCppReferenceType referenceType;
        OCType type2;
        if (element instanceof OCDeclarator && (type2 = ((OCDeclarator)element).getResolvedType()) instanceof OCCppReferenceType && !(referenceType = (OCCppReferenceType)type2).isReferenceToConst() && !referenceType.isRvalueRef()) {
            OCExpression arg;
            if (!(arguments.size() != 1 || (arg = arguments.get(0)) instanceof OCCompoundInitializer && ((OCCompoundInitializer)arg).getInitializers().size() != 1)) {
                OCType argType;
                if (arg instanceof OCCompoundInitializer) {
                    arg = ((OCCompoundInitializer)arg).getInitializerExpressions().get(0);
                }
                if ((argType = arg.getResolvedType()) instanceof OCCppReferenceType && !((OCCppReferenceType)argType).isReferenceToConst() && !((OCCppReferenceType)argType).isRvalueRef()) {
                    return null;
                }
                if (referenceType.getRefType().equals((Object)argType, element)) {
                    return null;
                }
            }
            Annotation annotation = this.addErrorAnnotation(element, OCInspections.InitializerIssues.class, "err_lvalue_reference_bind_to_unrelated", "Can't use constructors for initialization of references");
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(((OCDeclarator)element).getSymbol(), referenceType.getRefType()));
            return false;
        }
        return null;
    }

    public static String getCantResolveCtorMessage(OCSymbol symbol, OCFunctionType type2, PsiElement context) {
        return symbol.getKindUppercase() + " '" + symbol.getType().getBestNameInContext(context) + "' doesn't have a constructor '" + OCTypeNameVisitor.getFunctionSignature(context, type2, symbol.getName()) + "'";
    }

    @Nullable
    public Annotation highlightKeyword(@NotNull PsiElement psi) {
        return this.highlight(psi, OCHighlightingKeys.OC_KEYWORD);
    }
}

