/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCConstantExpressionVisitor;
import com.jetbrains.cidr.lang.daemon.OCCppChecker;
import com.jetbrains.cidr.lang.daemon.OCDeclaratorChecker;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.daemon.OCImplementationChecker;
import com.jetbrains.cidr.lang.daemon.OCOperatorsChecker;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.inspections.OCGlobalUnusedInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCAttributesList;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBoxedExpression;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionAssociation;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNSArrayLiteral;
import com.jetbrains.cidr.lang.psi.OCNSDictionaryLiteral;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedDesignator;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCResolvesToSymbol;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCSynchronizedStatement;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentsOwner;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.impl.OCDefineDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddRawStringSuffix;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCImportsOptimizer;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCErrorAnnotator
extends OCAnnotator {
    public OCErrorAnnotator() {
        this.myOperatorsChecker = new OCOperatorsChecker();
        this.myDeclaratorChecker = new OCDeclaratorChecker();
        this.myCppChecker = new OCCppChecker();
        this.myImplementationChecker = new OCImplementationChecker();
        this.myOperatorsChecker.copyCheckers(this);
        this.myDeclaratorChecker.copyCheckers(this);
        this.myCppChecker.copyCheckers(this);
        this.myImplementationChecker.copyCheckers(this);
    }

    @Override
    protected void setHolder(@Nullable AnnotationHolder holder, @Nullable PsiElement annotatingElement) {
        super.setHolder(holder, annotatingElement);
        this.myOperatorsChecker.setHolder(holder, annotatingElement);
        this.myDeclaratorChecker.setHolder(holder, annotatingElement);
        this.myCppChecker.setHolder(holder, annotatingElement);
        this.myImplementationChecker.setHolder(holder, annotatingElement);
    }

    public void visitElement(PsiElement element) {
        OCClassSymbol symbol;
        super.visitElement(element);
        PsiElement parent = element.getParent();
        if (parent instanceof OCStruct && element == ((OCStruct)parent).getNameIdentifier() && ((OCFile)element.getContainingFile()).isCpp()) {
            this.myCppChecker.checkClass((OCStruct)parent);
        }
        if (!(parent instanceof OCClassDeclaration) || element != ((OCClassDeclaration)parent).getNameIdentifier()) {
            return;
        }
        if (parent instanceof OCInterface) {
            if (this.myDeclaratorChecker.checkDuplicates((OCInterface)parent)) {
                this.myImplementationChecker.checkInterfaceDeclaration((OCInterface)parent);
            }
        } else if (parent instanceof OCImplementation) {
            if (this.myDeclaratorChecker.checkDuplicates((OCImplementation)parent)) {
                this.myImplementationChecker.checkInterfaceImplementation((OCImplementation)parent);
            }
        } else if (parent instanceof OCProtocol) {
            if (this.myDeclaratorChecker.checkDuplicates((OCProtocol)parent)) {
                this.myImplementationChecker.checkProtocolDeclaration((OCProtocol)parent);
            }
        } else if (parent instanceof OCClassPredeclaration && (symbol = ((OCClassPredeclaration)parent).getSymbol()) != null) {
            OCClassSymbol definitionSymbol = symbol.getDefinitionSymbol();
            if (definitionSymbol != null) {
                OCGlobalUnusedInspection.markSymbolAsUsed(definitionSymbol, null);
            } else if (OCCodeInsightUtil.isValid((PsiElement)element.getContainingFile())) {
                Annotation annotation = this.addWarningAnnotation(((OCClassPredeclaration)parent).getNameIdentifier(), OCInspections.NoClassDefinition.class, "warn_undef_protocolref", "Can't find " + symbol.getNameWithKindLowercase() + " in the project and external files");
                this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(OCSymbolKind.INTERFACE, element, null, symbol.getName(), null));
                this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(OCSymbolKind.PROTOCOL, element, null, symbol.getName(), null));
                this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol));
            }
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expr) {
        PsiElement parent;
        super.visitReferenceExpression(expr);
        PsiElement nonParethesizedParent = parent = expr.getParent();
        while (nonParethesizedParent instanceof OCParenthesizedExpression) {
            nonParethesizedParent = nonParethesizedParent.getParent();
        }
        boolean nonExprPossible = parent instanceof OCSendMessageExpression && ((OCSendMessageExpression)parent).getReceiverExpression() == expr || parent instanceof OCQualifiedExpression && ((OCQualifiedExpression)parent).getQualifier() == expr || nonParethesizedParent instanceof OCSizeofExpression || parent instanceof OCCallExpression && expr.getContainingOCFile().isCpp() || parent instanceof OCTemplateArgumentList;
        OCElementTypes.SelfSuperToken token = expr.getSelfSuperToken();
        if (token != null) {
            OCMethod method2;
            if (new OCReadWriteAccessDetector().getExpressionAccess(expr) == ReadWriteAccessDetector.Access.Write && (method2 = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, OCMethod.class)) != null && !method2.getSelector().startsWith("init")) {
                this.addErrorAnnotation(expr, OCInspections.NotAssignable.class, "err_typecheck_arc_assign_self", "Assignment to self is allowed only in init methods");
                return;
            }
            if (token == OCElementTypes.SelfSuperToken.SELF) {
                return;
            }
            OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCClassDeclaration.class});
            if (clazz == null) {
                return;
            }
            OCObjectType type2 = clazz.getType();
            if (type2 != null && type2.getSuperType() == null) {
                this.addErrorAnnotation(expr, "CIDR", "Class '" + type2.getName(expr) + "' doesn't have a superclass");
            }
            return;
        }
        OCSymbol symbol = expr.resolveToSymbol();
        if (symbol != null) {
            List<OCSymbol> symbols;
            if (symbol.getKind() == OCSymbolKind.SYMBOL_USING_SYMBOL && (symbols = ((OCUsingSymbol)symbol).getSymbolReference().resolveToSymbols(expr.getContainingOCFile())).size() != 0) {
                symbol = symbols.get(0);
            }
            if (!nonExprPossible && !symbol.getKind().isExpression() && symbol.getKind() != OCSymbolKind.MACRO) {
                this.addErrorAnnotation(expr, "CIDR", "Expression expected");
            }
        }
    }

    @Override
    public void visitReferenceElement(OCReferenceElement referenceElement) {
        super.visitReferenceElement(referenceElement);
        this.myDeclaratorChecker.checkReferenceElement(referenceElement);
    }

    @Override
    public void visitLabeledStatement(OCLabeledStatement stmt) {
        super.visitLabeledStatement(stmt);
        this.myDeclaratorChecker.checkDuplicates(stmt);
    }

    private void checkCaseType(OCExpression caseExpr, OCType switchType) {
        if (caseExpr == null) {
            return;
        }
        OCType caseType = caseExpr.getResolvedType();
        if (switchType instanceof OCCppReferenceType) {
            switchType = ((OCCppReferenceType)switchType).getRefType();
        }
        if (caseType.isUnknown()) {
            return;
        }
        if (!(caseType.isIntegerCompatible(caseExpr) || caseType instanceof OCStructType && ((OCStructType)caseType).isEnumClass())) {
            String message2 = "Integer expression is required in 'case' statement instead of '" + caseType.getName(caseExpr) + "'";
            Annotation annotation = this.addErrorAnnotation(caseExpr, OCInspections.IntegerTypeRequired.class, "err_expr_not_ice", message2);
            this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(caseExpr, OCIntType.CHAR));
            return;
        }
        if (!new OCConstantExpressionVisitor().isConstant(caseExpr)) {
            this.addErrorAnnotation(caseExpr, OCInspections.IntegerTypeRequired.class, "err_expr_not_ice", "Constant expression is required");
            return;
        }
        String message3 = "Case expression type '" + caseType.getName(caseExpr) + "' is incompatible with switch expression type '" + switchType.getName(caseExpr) + "': ";
        this.checkAssignment(caseExpr, caseExpr, switchType, caseType, message3);
    }

    @Override
    public void visitCaseStatement(OCCaseStatement stmt) {
        super.visitCaseStatement(stmt);
        OCSwitchStatement switchStmt = (OCSwitchStatement)PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCSwitchStatement.class});
        if (switchStmt == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "err_case_not_in_switch", "Case label is outside of a switch");
            return;
        }
        OCDeclarationOrExpression switchExpr = switchStmt.getExpression();
        if (switchExpr == null) {
            return;
        }
        OCType switchType = switchExpr.getResolvedType();
        if (stmt.isRange()) {
            this.checkCaseType(stmt.getRangeFirst(), switchType);
            this.checkCaseType(stmt.getRangeSecond(), switchType);
        } else {
            this.checkCaseType(stmt.getExpression(), switchType);
        }
    }

    private void checkConditionalStatement(@Nullable OCElement condition2, @Nullable OCType conditionType, String elementName, OCStatement ... statementBlocks) {
        OCDeclarationOrExpression declOrExpr;
        OCDeclaration declaration2;
        for (OCStatement statement2 : statementBlocks) {
            if (!(statement2 instanceof OCDeclarationStatement) || !OCCodeInsightUtil.isInPlainOldC(statement2)) continue;
            Annotation annotation = this.addErrorAnnotation(statement2, "CIDR", "Declaration is not allowed here");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)statement2, "Remove statement"));
        }
        if (condition2 instanceof OCDeclarationOrExpression && (declaration2 = (declOrExpr = (OCDeclarationOrExpression)condition2).getDeclaration()) != null && declOrExpr.getExpression() == null) {
            if (!condition2.getContainingOCFile().isCpp()) {
                this.addErrorAnnotation(condition2, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Declaration is not allowed here");
            } else if (declaration2.getDeclarators().isEmpty()) {
                this.addErrorAnnotation(condition2, "err_expected_unqualified_id", "Declaration or expression is expected");
            } else if (declaration2.getDeclarators().size() > 1) {
                this.addErrorAnnotation(condition2, "CIDR", "Only one declarator is allowed here");
            } else {
                OCDeclarator declarator = declaration2.getDeclarators().get(0);
                if (declarator.getInitializer() == null) {
                    Annotation annotation = this.addErrorAnnotation(condition2, OCInspections.InitializerIssues.class, "err_expected_init_in_condition", "Initializer is expected");
                    this.registerQuickFix(annotation, new OCAddInitializerIntentionAction(declarator, declarator.getSymbol()));
                }
            }
        }
        if (conditionType == null || conditionType.isUnknown()) {
            return;
        }
        if (!conditionType.isScalarOrConvertibleToScalar(condition2)) {
            String message2 = "Type '" + conditionType.getName(condition2) + "' used in '" + elementName + "' condition is not scalar";
            this.addErrorAnnotation(condition2, OCInspections.ScalarTypeRequired.class, "err_typecheck_statement_requires_scalar", message2);
        }
    }

    @Override
    public void visitIfStatement(OCIfStatement stmt) {
        super.visitIfStatement(stmt);
        OCDeclarationOrExpression condition2 = stmt.getCondition();
        if (condition2 != null) {
            this.checkConditionalStatement(condition2, condition2.getResolvedType(), "if", stmt.getThenBranch(), stmt.getElseBranch());
        }
    }

    @Override
    public void visitWhileStatement(OCWhileStatement stmt) {
        super.visitWhileStatement(stmt);
        OCDeclarationOrExpression condition2 = stmt.getCondition();
        if (condition2 != null) {
            this.checkConditionalStatement(condition2, condition2.getResolvedType(), "while", stmt.getBody());
        }
    }

    @Override
    public void visitDoWhileStatement(OCDoWhileStatement stmt) {
        super.visitDoWhileStatement(stmt);
        OCExpression condition2 = stmt.getCondition();
        if (condition2 != null) {
            OCType conditionType = condition2.getResolvedType();
            this.checkConditionalStatement(condition2, conditionType, "do-while", stmt.getBody());
        }
    }

    @Override
    public void visitForStatement(OCForStatement stmt) {
        super.visitForStatement(stmt);
        OCDeclarationOrExpression condition2 = stmt.getCondition();
        this.checkConditionalStatement(condition2, condition2 != null ? condition2.getResolvedType() : null, "for", stmt.getBody());
    }

    @Override
    public void visitForeachStatement(OCForeachStatement statement2) {
        super.visitForeachStatement(statement2);
        this.myOperatorsChecker.checkForeach(statement2);
        this.checkConditionalStatement(null, null, "foreach", statement2.getBody());
    }

    @Override
    public void visitReturnStatement(OCReturnStatement stmt) {
        super.visitReturnStatement(stmt);
        this.myOperatorsChecker.checkReturnStatement(stmt);
    }

    @Override
    public void visitBreakStatement(OCBreakStatement stmt) {
        super.visitBreakStatement(stmt);
        if (PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCLoopStatement.class, OCSwitchStatement.class}) == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "err_break_not_in_loop_or_switch", "'break' statement is outside of a loop or switch");
        }
    }

    @Override
    public void visitContinueStatement(OCContinueStatement stmt) {
        super.visitContinueStatement(stmt);
        if (PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCLoopStatement.class}) == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "err_continue_not_in_loop", "'continue' statement is outside of a loop");
        }
    }

    @Override
    public void visitSwitchStatement(OCSwitchStatement stmt) {
        super.visitSwitchStatement(stmt);
        this.myOperatorsChecker.checkSwitchStatement(stmt);
    }

    private void checkExceptionExpression(OCExpression expression2) {
        if (expression2 == null) {
            return;
        }
        OCType type2 = expression2.getResolvedType();
        if (!(type2.isUnknown() || type2.isPointerToObject() || type2.isClassType())) {
            this.addErrorAnnotation(expression2, OCInspections.PointerTypeRequired.class, OCClangMessageFinder.getInstance().getObjcThrowExpectsObject(), "Expression type '" + type2.getName(expression2) + "' is not a pointer to object");
        }
    }

    @Override
    public void visitSynchronizedStatement(OCSynchronizedStatement stmt) {
        super.visitSynchronizedStatement(stmt);
        this.checkExceptionExpression(stmt.getLockExpression());
    }

    @Override
    public void visitThrowExpression(OCThrowExpression expression2) {
        super.visitThrowExpression(expression2);
        if (expression2.isCppStatement()) {
            return;
        }
        this.checkExceptionExpression(expression2.getExceptionExpression());
        if (expression2.getExceptionExpression() == null && PsiTreeUtil.getParentOfType((PsiElement)expression2, OCCatchSection.class, (boolean)true, (Class[])new Class[]{OCCallable.class}) == null) {
            this.addErrorAnnotation(expression2, OCClangMessageFinder.getInstance().getRethrowUsedOutsideCatch(), "@throw (rethrow) is used outside of a @catch block");
        }
    }

    @Override
    public void visitTryStatement(OCTryStatement stmt) {
        if (stmt.getCatchSections().isEmpty() && stmt.getFinallySection() == null) {
            this.addErrorAnnotation(stmt, "err_missing_catch_finally", stmt.getContainingOCFile().isCpp() ? "Missing catch or finally" : "Missing @catch or @finally");
        }
    }

    @Override
    public void visitCatchSection(OCCatchSection catchSection) {
        super.visitCatchSection(catchSection);
        OCParameterList paramList = catchSection.getParameters();
        if (paramList == null) {
            return;
        }
        if (paramList.getParameterDeclarations().size() != 1) {
            Annotation annotation = this.addErrorAnnotation(paramList, "CIDR", "Only one variable declaration is allowed");
            for (int i2 = paramList.getParameterDeclarations().size() - 1; i2 >= 1; --i2) {
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)paramList.getParameterDeclarations().get(i2), "Remove extra declarators"));
            }
            return;
        }
        OCDeclarator declarator = paramList.getParameterDeclarations().get(0).getDeclarator();
        if (declarator == null || catchSection.isCppStatement()) {
            return;
        }
        OCType type2 = declarator.getResolvedType();
        if (!(type2.isUnknown() || type2.isPointerToObject() || type2.isClassType())) {
            this.addErrorAnnotation(declarator.getNameIdentifier(), OCInspections.PointerTypeRequired.class, "err_catch_param_not_objc_type", "Variable type ('" + type2.getName(catchSection) + "') is not a pointer to object");
        }
    }

    @Override
    public void visitProperty(OCProperty property) {
        super.visitProperty(property);
        if (PsiTreeUtil.getContextOfType((PsiElement)property, (Class[])new Class[]{OCInterface.class, OCProtocol.class}) == null) {
            Annotation annotation = this.addErrorAnnotation(property, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Property is declared outside of an interface/protocol");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)property, "Remove property"));
        }
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        super.visitDeclarator(declarator);
        this.myDeclaratorChecker.checkDeclarator(declarator.getType(), declarator, declarator, declarator.getSymbol());
    }

    @Override
    public void visitDefineDirective(OCDefineDirectiveImpl directive) {
        this.myDeclaratorChecker.checkDuplicates(directive.getName(), directive, Collections.singletonList(directive));
    }

    @Override
    public void visitStructLike(OCStructLike struct) {
        super.visitStructLike(struct);
        if (struct.getContainingOCFile().isCpp()) {
            this.myDeclaratorChecker.checkDuplicates(struct);
        } else {
            List<PsiElement> navigationElements = Collections.singletonList(struct.getNameIdentifier());
            String structName = OCSymbolKind.STRUCT.getNameLowercase() + " " + struct.getName();
            String enumName = OCSymbolKind.ENUM.getNameLowercase() + " " + struct.getName();
            String unionName = OCSymbolKind.UNION.getNameLowercase() + " " + struct.getName();
            boolean bl = this.myDeclaratorChecker.checkDuplicates(structName, struct.getSymbol(), struct, navigationElements) && this.myDeclaratorChecker.checkDuplicates(enumName, struct.getSymbol(), struct, navigationElements) && this.myDeclaratorChecker.checkDuplicates(unionName, struct.getSymbol(), struct, navigationElements);
        }
    }

    @Override
    public void visitDeclaration(OCDeclaration declaration2) {
        OCDeclarator declarator;
        OCSymbol symbol;
        super.visitDeclaration(declaration2);
        PsiElement parent = declaration2.getParent();
        if (!(!(parent instanceof OCInterface) && !(parent instanceof OCProtocol) || declaration2.getDeclarators().isEmpty() || declaration2.isTypedef() || declaration2 instanceof OCFunctionDeclaration || (symbol = (declarator = declaration2.getDeclarators().get(0)).getSymbol()) instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isExtern())) {
            Annotation annotation = this.addErrorAnnotation(declaration2, OCInspections.ConstructionIsNotAllowed.class, "err_objc_var_decl_inclass", "Can't declare variables inside @interface or @protocol");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)declaration2, "Remove declaration"));
            return;
        }
        OCTypeElement typeElement = declaration2.getTypeElement();
        if (declaration2.getDeclarators().isEmpty()) {
            OCType type2;
            OCType oCType = type2 = typeElement != null ? typeElement.getType().resolve(declaration2.getContainingFile()) : null;
            if (type2 == null || !(type2 instanceof OCStructType) && !type2.isUnknown()) {
                Annotation annotation = this.addWarningAnnotation(declaration2, OCInspections.UnusedExpressionResult.class, "ext_no_declarators", "Useless type name in empty declaration");
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)declaration2, "Remove statement"));
            }
        } else if ((typeElement == null || typeElement.isEmpty()) && (parent instanceof OCProperty || parent instanceof OCInstanceVariablesList || parent instanceof OCStruct || parent instanceof OCUnion || !OCCodeInsightUtil.isInPlainOldC(parent) && (parent instanceof OCFile || parent instanceof OCCppNamespace))) {
            OCFunctionSymbol functionSymbol;
            if (declaration2 instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)declaration2).getSymbol()) instanceof OCFunctionSymbol && ((functionSymbol = (OCFunctionSymbol)symbol).isCppConstructor() || functionSymbol.isCppDestructor() || functionSymbol.isCppConversionOperator())) {
                return;
            }
            OCElement annotationRange = null;
            if (!declaration2.getDeclarators().isEmpty()) {
                OCDeclarator declarator2 = declaration2.getDeclarators().get(0);
                if (declarator2.getNamespaceQualifier() == null) {
                    annotationRange = declarator2.getNameIdentifier() != null ? declarator2.getNameIdentifier() : declarator2;
                }
            } else {
                annotationRange = declaration2;
            }
            this.addErrorAnnotation(annotationRange, "CIDR", "Explicit type is required here");
        }
        if (typeElement != null && declaration2 instanceof OCFunctionDeclaration && typeElement.getType() instanceof OCAutoType && ((OCFunctionDeclaration)declaration2).getTrailingReturnTypeElement() == null && !OCCompilerHelper.supportsCxxReturnTypeDeduction(typeElement.getContainingFile())) {
            this.addErrorAnnotation(typeElement, "err_auto_missing_trailing_return", "Return type deduction is not supported by the compiler");
        }
    }

    @Override
    public void visitMethod(OCMethod method2) {
        super.visitMethod(method2);
        this.myImplementationChecker.checkMethod(method2);
    }

    @Override
    public void visitExpressionStatement(OCExpressionStatement stmt) {
        PsiReference reference;
        super.visitExpressionStatement(stmt);
        OCExpression expr = stmt.getExpression();
        if ((expr instanceof OCUnaryExpression || expr instanceof OCBinaryExpression || expr instanceof OCArraySelectionExpression) && (!((reference = expr.getReference()) instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0 && !((OCOperatorReference)reference).hasMagicOperands())) {
            Annotation annotation = this.addWarningAnnotation(expr, OCInspections.UnusedExpressionResult.class, "warn_unused_expr", "Expression result is unused");
            if (!OCCodeInsightUtil.hasSideEffects(expr)) {
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)stmt, "Remove statement"));
            }
        }
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        super.visitMethodSelectorPart(part);
        this.myDeclaratorChecker.checkDeclarator(part.getType(), part, null, part.getLocalSymbol());
    }

    @Override
    public void visitAssignmentExpression(OCAssignmentExpression expression2) {
        super.visitAssignmentExpression(expression2);
        PsiReference reference = expression2.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkBinaryOperatorApplicable(expression2.getReceiverExpression(), expression2.getSourceExpression(), expression2.getOperationSign(), expression2);
        } else {
            this.checkOperatorVisibility(expression2, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitBinaryExpression(OCBinaryExpression expression2) {
        super.visitBinaryExpression(expression2);
        PsiReference reference = expression2.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkBinaryOperatorApplicable(expression2.getLeft(), expression2.getRight(), expression2.getOperationSign(), expression2);
        } else {
            this.checkOperatorVisibility(expression2, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitUnaryExpression(OCUnaryExpression expression2) {
        super.visitUnaryExpression(expression2);
        PsiReference reference = expression2.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkUnaryOperatorApplicable(expression2.getOperand(), expression2.getOperationSign(), expression2);
        } else {
            this.checkOperatorVisibility(expression2, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitPrefixExpression(OCPrefixExpression expression2) {
        super.visitPrefixExpression(expression2);
        PsiReference reference = expression2.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkUnaryOperatorApplicable(expression2.getOperand(), expression2.getOperationSign(), expression2);
        } else {
            this.checkOperatorVisibility(expression2, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitPostfixExpression(OCPostfixExpression expression2) {
        super.visitPostfixExpression(expression2);
        PsiReference reference = expression2.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkUnaryOperatorApplicable(expression2.getOperand(), expression2.getOperationSign(), expression2);
        } else {
            this.checkOperatorVisibility(expression2, (OCOperatorReference)reference);
        }
    }

    private void checkOperatorVisibility(OCExpression expression2, OCOperatorReference reference) {
        OCSymbol operator2 = reference.resolveToSymbols().get(0);
        this.myOperatorsChecker.checkFieldVisibility(operator2, expression2, null);
    }

    @Override
    public void visitLiteralExpression(OCLiteralExpression expression2) {
        String typeName;
        OCType type2;
        super.visitLiteralExpression(expression2);
        ASTNode child = expression2.getNode().getFirstChildNode();
        if (!OCCompilerHelper.supportsObjectLiterals(expression2.getContainingOCFile()) && (type2 = expression2.getResolvedType()) instanceof OCPointerType && ("NSNumber".equals(typeName = ((OCPointerType)type2).getRefType().getName()) || "NSArray".equals(typeName) || "NSDictionary".equals(typeName)) && this.getHolder() != null) {
            this.getHolder().createErrorAnnotation((PsiElement)expression2, typeName + " literals are not supported by the compiler");
        }
        while (child != null) {
            type2 = child.getElementType();
            if (type2 == OCTokenTypes.STRING_LITERAL) {
                String text = child.getText();
                if (text.startsWith("\"") && (text.length() == 1 || !text.endsWith("\"")) && this.getHolder() != null) {
                    this.getHolder().createErrorAnnotation(child, "Unterminated string literal").setAfterEndOfLine(true);
                }
            } else if (type2 == OCTokenTypes.WRONG_RAW_STRING_LITERAL) {
                Annotation annotation = this.getHolder().createErrorAnnotation(child, "Invalid suffix on raw string");
                annotation.setNeedsUpdateOnTyping(true);
                this.registerQuickFix(annotation, new OCAddRawStringSuffix(child.getPsi()));
            } else if (type2 == OCTokenTypes.WRONG_INTEGER_LITERAL) {
                this.addErrorAnnotation(child.getPsi(), OCClangMessageFinder.getInstance().getInvalidIntSuffix(), "Invalid suffix on integer constant");
            } else if (type2 == OCTokenTypes.WRONG_FLOAT_LITERAL) {
                this.addErrorAnnotation(child.getPsi(), OCClangMessageFinder.getInstance().getInvalidFloatSuffix(), "Invalid suffix on floating constant");
            }
            child = child.getTreeNext();
        }
    }

    @Override
    public void visitArrayLiteral(OCNSArrayLiteral literal) {
        super.visitArrayLiteral(literal);
        for (OCExpression expression2 : literal.getElements()) {
            this.checkAssignment(expression2, expression2, OCIdType.pointerToID(literal.getProject()), expression2.getResolvedType(), "");
        }
    }

    @Override
    public void visitDictionaryLiteral(OCNSDictionaryLiteral literal) {
        super.visitDictionaryLiteral(literal);
        for (OCExpression expression2 : literal.getElements()) {
            this.checkAssignment(expression2, expression2, OCIdType.pointerToID(literal.getProject()), expression2.getResolvedType(), "");
        }
    }

    @Override
    public void visitCastExpression(OCCastExpression expression2) {
        super.visitCastExpression(expression2);
        this.myOperatorsChecker.checkCastExperssion(expression2);
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression expression2) {
        super.visitArraySelectionExpression(expression2);
        OCExpression arrayExpr = expression2.getArrayExpression();
        OCExpression indexExpr = expression2.getIndexExpression();
        if (indexExpr == null) {
            return;
        }
        OCType arrayType = arrayExpr.getResolvedType();
        OCType indexType = indexExpr.getResolvedType();
        PsiReference reference = expression2.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            if (arrayType instanceof OCCppReferenceType) {
                arrayType = ((OCCppReferenceType)arrayType).getRefType();
            }
            if (arrayType.isPointerToObject() && OCCompilerHelper.supportsSubscripting(expression2.getContainingOCFile())) {
                ReadWriteAccessDetector.Access accessType = new OCReadWriteAccessDetector().getExpressionAccess(expression2);
                String accessorName = expression2.getArraySubscriptAccessorName(indexType, accessType);
                if (accessorName != null) {
                    OCSymbol symbol;
                    String message2 = "Type '" + arrayType.getName(expression2) + "' doesn't respond to '-" + accessorName + "'";
                    Annotation annotation = this.addErrorAnnotation(expression2.getArrayExpression(), OCInspections.UnresolvedMessage.class, "err_objc_subscript_method_not_found", message2);
                    OCObjectType receiverType = (OCObjectType)arrayType.getTerminalType();
                    OCClassSymbol parentClass = receiverType.getClassSymbol();
                    String signature = expression2.getArraySubscriptMethodSignature(indexType, accessType);
                    OCVoidType returnType = accessType == ReadWriteAccessDetector.Access.Read ? OCIdType.pointerToID(expression2.getProject()) : OCVoidType.instance();
                    this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(expression2, parentClass, "-" + accessorName, signature, returnType, receiverType));
                    if (arrayType.getName().equals("NSArray *") && accessorName.equals("setObject:atIndexedSubscript:")) {
                        OCSymbol symbol2 = OCGetSymbolVisitor.getSymbol(arrayExpr);
                        if (symbol2 != null && symbol2.getResolvedType().equals((Object)arrayType, arrayExpr)) {
                            OCPointerType newType = OCPointerType.to(OCReferenceType.resolvedFromText("NSMutableArray", arrayExpr.getContainingFile()));
                            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol2, newType));
                        }
                    } else if (arrayType.getName().equals("NSDictionary *") && accessorName.equals("setObject:forKeyedSubscript:") && (symbol = OCGetSymbolVisitor.getSymbol(arrayExpr)) != null && symbol.getResolvedType().equals((Object)arrayType, arrayExpr)) {
                        OCPointerType newType = OCPointerType.to(OCReferenceType.resolvedFromText("NSMutableDictionary", arrayExpr.getContainingFile()));
                        this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, newType));
                    }
                } else {
                    this.addErrorAnnotation(indexExpr, OCInspections.ArrayIssues.class, "err_objc_subscript_index_type", "Index expression must be an integer or an object pointer");
                }
            } else if (!arrayType.isSubclassOfMagic(expression2)) {
                if (!arrayType.isUnknown() && !(arrayType instanceof OCPointerType)) {
                    this.addErrorAnnotation(expression2.getArrayExpression(), OCInspections.ArrayIssues.class, "err_typecheck_subscript_value", "Subscripted value is not an array");
                    ((OCOperatorReference)reference).resolveToSymbols();
                } else if (!(indexType.isUnknown() || indexType.isIntegerCompatible(expression2) || arrayType.isMagicInside(new OCResolveContext(expression2)))) {
                    Annotation annotation = this.addErrorAnnotation(expression2.getIndexExpression(), OCInspections.ArrayIssues.class, "err_objc_subscript_index_type", "Array index is not integer");
                    this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(expression2.getIndexExpression(), OCIntType.CHAR));
                }
            }
        } else {
            OCSymbol operator2 = ((OCOperatorReference)reference).resolveToSymbols().get(0);
            this.myOperatorsChecker.checkFieldVisibility(operator2, expression2, null);
            if (operator2 instanceof OCMethodSymbol) {
                List<OCMethodSymbol.SelectorPartSymbol> selectors = ((OCMethodSymbol)operator2).getSelectors();
                OCType indexRequiredType = selectors.get(selectors.size() - 1).getParameter().getType().resolve(expression2.getContainingFile());
                this.checkAssignment(indexExpr, indexExpr, indexRequiredType, indexType, "Index type mismatch: ");
                OCExpression parentExpr = OCParenthesesUtils.topmostParenthesized(expression2);
                if (parentExpr.getParent() instanceof OCAssignmentExpression && ((OCAssignmentExpression)parentExpr.getParent()).getReceiverExpression() == parentExpr) {
                    OCExpression sourceExpr = ((OCAssignmentExpression)parentExpr.getParent()).getSourceExpression();
                    OCType sourceRequiredType = selectors.get(0).getParameter().getType().resolve(expression2.getContainingFile());
                    if (sourceExpr != null) {
                        this.checkAssignment(sourceExpr, sourceExpr, sourceRequiredType, sourceExpr.getResolvedType(), "");
                    }
                }
            }
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression2) {
        super.visitCallExpression(expression2);
        this.myOperatorsChecker.checkCallExpression(expression2);
    }

    @Override
    public void visitMacroCall(OCMacroCall macroCall) {
        super.visitMacroCall(macroCall);
        this.myOperatorsChecker.checkMacroCall(macroCall);
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression2) {
        super.visitSendMessageExpression(expression2);
        this.myOperatorsChecker.checkSendMessageExpression(expression2);
    }

    @Override
    public void visitSelectorExpression(OCSelectorExpression expression2) {
        super.visitSelectorExpression(expression2);
        for (OCMethodSymbol method2 : expression2.getReference().resolveToSymbols()) {
            OCFileSymbols.markSymbolAsUsed(expression2.getContainingOCFile(), method2, expression2);
        }
    }

    @Override
    public void visitConditionalExpression(OCConditionalExpression expression2) {
        OCType commonType;
        OCType rType;
        super.visitConditionalExpression(expression2);
        OCType type2 = expression2.getCondition().getResolvedType();
        if (!type2.isUnknown() && !type2.isScalarOrConvertibleToScalar(expression2)) {
            this.addErrorAnnotation(expression2.getCondition(), OCInspections.ScalarTypeRequired.class, OCClangMessageFinder.getInstance().getConditionShouldBeScalar(), "Type '" + type2.getName(expression2) + "' used in '?:' operator condition is not scalar");
        }
        OCExpression lExpr = expression2.getPositiveExpression(true);
        OCExpression rExpr = expression2.getNegativeExpression();
        if (lExpr == null || rExpr == null) {
            return;
        }
        OCType lType = lExpr.getResolvedType();
        if (lType instanceof OCCppReferenceType) {
            lType = ((OCCppReferenceType)lType).getRefType();
        }
        if ((rType = rExpr.getResolvedType()) instanceof OCCppReferenceType) {
            rType = ((OCCppReferenceType)rType).getRefType();
        }
        if ((commonType = expression2.getResolvedType()) instanceof OCCppReferenceType) {
            commonType = ((OCCppReferenceType)commonType).getRefType();
        }
        String lTypeName = lType.getName(expression2);
        String rTypeName = rType.getName(expression2);
        String message2 = "Types '" + lTypeName + "' and '" + rTypeName + "' are not compatible";
        if (this.checkAssignment(lExpr, lExpr, commonType, lType, message2) == null) {
            this.checkAssignment(rExpr, rExpr, commonType, rType, message2);
        }
    }

    @Override
    public void visitQualifiedExpression(OCQualifiedExpression expression2) {
        super.visitQualifiedExpression(expression2);
        this.myOperatorsChecker.checkQualifiedExpression(expression2);
    }

    @Override
    public void visitPropertyAttributesList(OCPropertyAttributesList attributes) {
        super.visitPropertyAttributesList(attributes);
        HashSet<OCPropertySymbol.PropertyAttribute> processedAttrs = new HashSet<OCPropertySymbol.PropertyAttribute>();
        for (OCPropertyAttribute attributeNode : attributes.getAttributes()) {
            String name = attributeNode.getName();
            if (name == null) continue;
            Annotation annotation = null;
            OCPropertySymbol.PropertyAttribute attribute = OCPropertySymbolImpl.parseAttribute(name);
            if (!OCCompilerHelper.supportsNullability(attributes.getContainingFile()) && attribute != null && attribute.getGroup() == 5) {
                attribute = null;
            }
            if (!OCCompilerHelper.supportsClassProperty(attributes.getContainingFile()) && attribute != null && attribute.getGroup() == 6) {
                attribute = null;
            }
            if (attributes.getParent() instanceof OCSynthesizePropertiesList && attribute != OCPropertySymbol.PropertyAttribute.CLASS) {
                attribute = null;
            }
            if (attribute != null) {
                List<OCDeclarator> declarators;
                OCProperty property;
                OCDeclaration declaration2;
                for (OCPropertySymbol.PropertyAttribute processedAttr : processedAttrs) {
                    if (processedAttr == attribute) {
                        annotation = this.addWarningAnnotation(attributeNode.getNameIdentifier(), OCInspections.DuplicateAttribute.class, "CIDR", "Attribute '" + name + "' was already declared");
                        continue;
                    }
                    if (processedAttr.getGroup() != attribute.getGroup()) continue;
                    annotation = this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_property_attr_mutually_exclusive", "Attributes '" + StringUtil.toLowerCase((String)processedAttr.name()) + "' and '" + name + "' are mutually exclusive");
                }
                if (OCPropertySymbol.PROPERTY_ATTRIBUTES_WITH_VALUE.contains((Object)attribute) && attributeNode.getValue() == null) {
                    this.addErrorAnnotation(attributeNode.getNameIdentifier(), "CIDR", "Attribute '" + name + "' requires a value");
                } else if (!OCPropertySymbol.PROPERTY_ATTRIBUTES_WITH_VALUE.contains((Object)attribute) && attributeNode.getValue() != null) {
                    this.addErrorAnnotation(attributeNode.getNameIdentifier(), "CIDR", "Attribute '" + name + "' mustn't have a value");
                } else if (OCPropertySymbol.PROPERTY_ATTRIBUTES_FOR_OBJECT.contains((Object)attribute) && attributeNode.getParent().getParent() instanceof OCProperty && (declaration2 = (property = (OCProperty)attributeNode.getParent().getParent()).getDeclaration()) != null && !(declarators = declaration2.getDeclarators()).isEmpty()) {
                    OCDeclarator declarator = declarators.get(0);
                    OCType type2 = declarator.getResolvedType();
                    OCSymbol symbol = declarator.getSymbol();
                    if (!(declarators.size() <= 0 || type2.isPointerToObjectCompatible() || symbol != null && symbol.hasAttribute("NSObject"))) {
                        String message2 = "Attribute '" + name + "' requires the property of object type instead of '" + type2.getName(attributes) + "'";
                        this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_property_requires_object", message2);
                    }
                }
                processedAttrs.add(attribute);
            } else {
                annotation = this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_expected_property_attr", "Unknown attribute '" + name + "'");
            }
            if (attributeNode.getColon() != null) {
                if ("getter".equals(name)) {
                    this.addErrorAnnotation(attributeNode.getColon(), "CIDR", "Colon is only allowed for 'setter' attribute");
                }
            } else if ("setter".equals(name)) {
                this.addErrorAnnotation(attributeNode.getValueElement(), "CIDR", "Colon is required for 'setter' attribute");
            }
            if (annotation == null) continue;
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)attributeNode, "Remove attribute"));
        }
    }

    @Override
    public void visitAttributeList(OCAttributesList list) {
        super.visitAttributeList(list);
        if (list.isMicrosoftAttributes() && !OCCompilerHelper.supportsMicrosoftAttributes(list.getContainingOCFile())) {
            this.addErrorAnnotation(list, "CIDR", "Microsoft attributes are not supported by the compiler");
        }
    }

    @Override
    public void visitTypeElement(OCTypeElement typeElement) {
        super.visitTypeElement(typeElement);
        for (ASTNode child : typeElement.getNode().getChildren(null)) {
            if (child.getElementType() != OCTokenTypes.UNDERLYING_TYPE_KEYWORD || OCCompilerHelper.supportsUnderlyingType(typeElement.getContainingFile())) continue;
            this.addErrorAnnotation(child.getPsi(), "CIDR", "__underlying_type is not supported by the compiler");
        }
    }

    @Override
    public void visitQualifiedDesignator(OCQualifiedDesignator designator) {
        if (designator.getArrayStartIndexer() != null) {
            OCType parent = designator.getParentType();
            if (parent instanceof OCArrayType) {
                OCExpression arrayStopIndexer;
                OCArrayType arrayParent = (OCArrayType)parent;
                int length = arrayParent.getLength();
                Number index = OCExpressionEvaluator.evaluate(designator.getArrayStartIndexer());
                if (index != null && (index.intValue() < 0 || arrayParent.hasLength() && index.intValue() >= length)) {
                    this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "CIDR", "Array index in initializer exceeds array bounds");
                }
                if ((arrayStopIndexer = designator.getArrayStopIndexer()) != null) {
                    Number stopIndex = OCExpressionEvaluator.evaluate(arrayStopIndexer);
                    if (stopIndex != null && (stopIndex.intValue() < 0 || arrayParent.hasLength() && stopIndex.intValue() >= length)) {
                        this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "CIDR", "Array index in initializer exceeds array bounds");
                    } else if (index != null && stopIndex != null && index.intValue() > stopIndex.intValue()) {
                        this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "err_array_designator_empty_range", "Empty index range in initializer");
                    }
                }
            } else {
                this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "err_designator_for_scalar_init", "Subscripted value is not an array");
            }
        }
    }

    @Override
    public void visitSynthesizeProperty(OCSynthesizeProperty property) {
        super.visitSynthesizeProperty(property);
        this.myImplementationChecker.checkSynthesize(property);
    }

    @Override
    public void visitProtocolExpression(OCProtocolExpression expression2) {
        OCType type2;
        super.visitProtocolExpression(expression2);
        OCTypeElement typeElement = expression2.getTypeElement();
        if (typeElement != null && !((type2 = typeElement.getType().resolve(expression2.getContainingFile())) instanceof OCObjectType) && !type2.isUnknown()) {
            this.addErrorAnnotation(typeElement, "CIDR", "'" + type2.getName(expression2) + "' isn't a protocol");
        }
    }

    @Override
    public void visitOCFile(OCFile file2) {
        super.visitOCFile(file2);
        if (file2.isHeader()) {
            return;
        }
        OCFileGlobalSymbols symbols = OCFileGlobalSymbolsCache.getInstance(file2.getProject()).forFile(file2);
        this.processUndefinedClasses(file2, symbols.getUndefinedClasses(), OCSymbolKind.INTERFACE);
        this.processUndefinedClasses(file2, symbols.getUndefinedProtocols(), OCSymbolKind.PROTOCOL);
        List<OCIncludeDirective> imports2 = OCImportsOptimizer.doGetImports(file2, false, true);
        for (OCIncludeDirective directive : imports2) {
            Annotation annotation = this.addWarningAnnotation(directive, OCInspections.UnusedImportStatement.class, "CIDR", "Unused import statement", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)directive, "Remove useless import"));
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(imports2, "Optimize imports", "Optimize imports"));
        }
    }

    private void processUndefinedClasses(OCFile file2, Map<String, Pair<OCSymbol, VirtualFile>> undefinedClasses, OCSymbolKind symbolKind) {
        for (String className : undefinedClasses.keySet()) {
            OCClassSymbol definition;
            String message2;
            Pair<OCSymbol, VirtualFile> pair = undefinedClasses.get(className);
            if (pair.second instanceof LightVirtualFileBase) continue;
            OCIncludeDirective directive = file2.findIncludeDirective((VirtualFile)pair.getSecond());
            OCSymbol symbol = (OCSymbol)pair.getFirst();
            if (directive == null || OCWorkspaceManager.getWorkspace(file2.getProject()).isInSDK(symbol.getContainingFile())) continue;
            Annotation annotation = null;
            if (symbolKind == OCSymbolKind.INTERFACE) {
                message2 = "Cannot find class '" + className + "', superclass of " + symbol.getNameWithKindLowercase();
                annotation = this.addErrorAnnotation(directive, OCInspections.CannotResolve.class, "CIDR", message2);
            } else if (symbolKind == OCSymbolKind.PROTOCOL) {
                message2 = "Cannot find protocol '" + className + "', conformed by " + symbol.getNameWithKindLowercase();
                annotation = this.addWarningAnnotation(directive, OCInspections.NotVisibleClass.class, "CIDR", message2);
            }
            if ((definition = (OCClassSymbol)OCSymbolImpl.findSymbolDefinition(className, symbolKind, file2.getProject(), file2.getVirtualFile())) == null || annotation == null) continue;
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(directive, definition));
        }
    }

    @Override
    public void visitCallable(OCCallable callable) {
        super.visitCallable(callable);
        if (!(callable instanceof OCBlockExpression) && !(callable instanceof OCLambdaExpression) || PsiTreeUtil.getContextOfType((PsiElement)callable, (Class[])new Class[]{OCCallable.class}) == null) {
            OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(callable, this, null);
            analyzer.buildControlFlowGraph();
            analyzer.analyze();
        }
    }

    @Override
    public void visitDirective(OCDirective directive) {
        PsiElement token = directive.getHeaderToken();
        IElementType header = token.getNode().getElementType();
        if (header == OCTokenTypes.ERROR_DIRECTIVE || header == OCTokenTypes.WARNING_DIRECTIVE) {
            Pair<String, TextRange> content = directive.getContent(true);
            if (header == OCTokenTypes.ERROR_DIRECTIVE) {
                this.addErrorAnnotation(directive, (TextRange)content.getSecond(), null, "CIDR", (String)content.getFirst(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            } else {
                this.addWarningAnnotation(directive, (TextRange)content.getSecond(), null, "CIDR", (String)content.getFirst(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }
    }

    @Override
    public void visitCppNewExpression(OCCppNewExpression expression2) {
        super.visitCppNewExpression(expression2);
        OCFile file2 = expression2.getContainingOCFile();
        OCType type2 = expression2.getConstructingType().resolve(file2);
        if (type2 instanceof OCArrayType) {
            type2 = ((OCArrayType)type2).getRefType();
        }
        if (type2 instanceof OCStructType) {
            for (OCStructSymbol structSymbol : ((OCStructType)type2).getStructs()) {
                OCFileSymbols.markSymbolAsUsed(file2, structSymbol, expression2);
            }
            if (((OCStructType)type2).isAbstract(new OCResolveContext(file2))) {
                String message2 = "Instantiating the abstract " + ((OCStructType)type2).getStructs().get(0).getNameWithKindLowercase();
                this.addErrorAnnotation(expression2, "err_allocation_of_abstract_type", message2);
            }
            OCReferenceElement refElement = expression2.getReferenceElement();
            this.myCppChecker.checkConstructorCall(expression2, expression2.getInitializers(), refElement != null ? refElement.resolveToSymbol() : null);
        }
    }

    @Override
    public void visitConstructorFieldInitializer(OCConstructorFieldInitializer initializer) {
        super.visitConstructorFieldInitializer(initializer);
        OCReferenceElement refElement = initializer.getReferenceElement();
        OCSymbol symbol = refElement != null ? refElement.resolveToSymbol() : null;
        List<OCExpression> initializers = initializer.getInitializers();
        if (symbol instanceof OCDeclaratorSymbol) {
            OCType type2 = symbol.getType().resolve(initializer.getContainingFile());
            this.myCppChecker.checkTypeInitialization(initializer, refElement, OCArgumentsList.getArgumentList(initializers), symbol, type2, false, initializer);
        } else {
            this.myCppChecker.checkConstructorCall(initializer, initializers, symbol);
        }
    }

    @Override
    public void visitCompoundInitializer(OCCompoundInitializer initializer) {
        super.visitCompoundInitializer(initializer);
        if (initializer.getParent() instanceof OCCompoundInitializer) {
            return;
        }
        OCType type2 = initializer.inferType();
        if (type2 != null) {
            type2 = type2.resolve(initializer.getContainingFile());
        }
        new OCAnnotator.MyArgumentsChecker(){

            @Override
            protected void checkConstructor(OCCompoundInitializer compInitializer, OCSymbol constructor) {
                PsiElement parent = OCParenthesesUtils.topmostParenthesized(compInitializer).getParent();
                if (!(parent instanceof OCDeclarator || parent instanceof OCArgumentList || parent instanceof OCCompoundInitializer || parent instanceof OCConstructorFieldInitializer || parent instanceof OCTypeElement && parent.getParent() instanceof OCCppNewExpression)) {
                    OCErrorAnnotator.this.myCppChecker.checkConstructorCall(compInitializer, Collections.singletonList(compInitializer), constructor);
                }
            }
        }.checkCompoundInitializer(initializer, type2, true, true);
    }

    @Override
    public void visitNamespaceQualifier(OCCppNamespaceQualifier qualifier) {
        super.visitNamespaceQualifier(qualifier);
        if (qualifier.getParent() instanceof OCReferenceElement) {
            for (OCSymbol symbol : qualifier.resolveToSymbols()) {
                this.myOperatorsChecker.checkFieldVisibility(symbol, qualifier, null);
                OCFileSymbols.markSymbolAsUsed(qualifier.getContainingOCFile(), symbol, qualifier);
            }
        }
    }

    @Override
    public void visitTemplateArgumentsOwner(OCTemplateArgumentsOwner argumentsOwner) {
        super.visitTemplateArgumentsOwner(argumentsOwner);
        OCTypeArgumentList argumentList = argumentsOwner.getTemplateArgumentList();
        List<OCTypeArgument> typeArguments = OCSymbolReferenceResolver.getTypeArguments(argumentsOwner);
        OCTemplateSymbol mainTemplate = null;
        if (argumentList == null || typeArguments == null) {
            return;
        }
        if (argumentsOwner instanceof OCResolvesToSymbol) {
            Object symbol = ((OCResolvesToSymbol)((Object)argumentsOwner)).resolveToSymbol();
            OCTemplateSymbol oCTemplateSymbol = mainTemplate = symbol instanceof OCTemplateSymbol ? (OCTemplateSymbol)symbol : null;
            if (mainTemplate instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol) {
                mainTemplate = ((OCResolveOverloadsUtil.OCFunctionGroupSymbol)mainTemplate).getOverloads().get(0);
            }
        }
        if (mainTemplate == null || !this.checkArguments(argumentsOwner, argumentList, typeArguments, mainTemplate, false)) {
            for (OCSymbol symbol : argumentsOwner.resolveTemplateDeclarations()) {
                OCTemplateSymbol template;
                if (!(symbol instanceof OCTemplateSymbol) || (template = (OCTemplateSymbol)symbol).getTemplateParameters().isEmpty() || template.getTemplateSpecialization() != null || mainTemplate != null && mainTemplate.getRequiredTemplateArgumentsCnt() <= typeArguments.size() && (mainTemplate.getTemplateParameters().size() >= template.getTemplateParameters().size() || template.getRequiredTemplateArgumentsCnt() > typeArguments.size())) continue;
                mainTemplate = template;
            }
        }
        if (mainTemplate == null) {
            return;
        }
        this.checkArguments(argumentsOwner, argumentList, typeArguments, mainTemplate, true);
    }

    private boolean checkArguments(@NotNull OCTemplateArgumentsOwner argumentsOwner, @NotNull OCTypeArgumentList<?> argumentList, @NotNull List<OCTypeArgument> typeArguments, @NotNull OCTemplateSymbol<?> mainTemplate, boolean addAnnotations) {
        int requiredArgumentsCnt;
        OCResolveContext context = new OCResolveContext(argumentList);
        List<OCTypeParameterSymbol> parameters2 = mainTemplate.getTemplateParameters();
        int maxArgumentsCnt = parameters2.size();
        List<?> arguments = argumentList.getArguments();
        boolean isVariableArgs = mainTemplate.isVariadicTemplate();
        if (mainTemplate instanceof OCFunctionSymbol && argumentsOwner instanceof OCFunctionDeclaration) {
            HashMap<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
            OCSymbolWithQualifiedName functionSymbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)argumentsOwner).getSymbol();
            if (functionSymbol != null) {
                OCSimpleTypeSubstitution.unify(mainTemplate.getType().resolve(context), functionSymbol.getType().resolve(context), substitutionMap, context);
                for (requiredArgumentsCnt = mainTemplate.getRequiredTemplateArgumentsCnt(); requiredArgumentsCnt > 0 && substitutionMap.containsKey(parameters2.get(requiredArgumentsCnt - 1)); --requiredArgumentsCnt) {
                }
            }
        }
        if (typeArguments.size() < requiredArgumentsCnt && !ContainerUtil.exists(typeArguments, typeArgument -> typeArgument.isVariadic())) {
            if (!(argumentsOwner instanceof OCQualifiedExpression) && !(argumentsOwner instanceof OCReferenceElement) || !(mainTemplate instanceof OCFunctionSymbol)) {
                if (addAnnotations) {
                    this.addErrorAnnotation(argumentList, OCInspections.TemplateArgumentsIssues.class, "CIDR", OCBundle.message(requiredArgumentsCnt < parameters2.size() ? "inspections.templateArguments.tooFewAtLeast" : "inspections.templateArguments.tooFew", requiredArgumentsCnt));
                }
                return false;
            }
        } else if (!isVariableArgs && arguments.size() > maxArgumentsCnt) {
            if (addAnnotations) {
                this.addErrorAnnotation(argumentList, OCInspections.TemplateArgumentsIssues.class, "CIDR", OCBundle.message(requiredArgumentsCnt < parameters2.size() ? "inspections.templateArguments.tooManyAtMost" : "inspections.templateArguments.tooMany", maxArgumentsCnt));
            }
            return false;
        }
        boolean result2 = true;
        for (int i2 = 0; i2 < typeArguments.size(); ++i2) {
            OCElement argumentPsi;
            OCTypeParameterSymbol parameter = i2 >= parameters2.size() ? parameters2.get(parameters2.size() - 1) : parameters2.get(i2);
            OCTypeArgument argument = typeArguments.get(i2);
            OCElement oCElement = argumentPsi = i2 >= arguments.size() ? (OCElement)arguments.get(arguments.size() - 1) : (OCElement)arguments.get(i2);
            if (parameter.isVariadic() && i2 < parameters2.size() - 1) break;
            if (parameter instanceof OCTypeParameterValueSymbol) {
                OCType.TypeCheckResult typeCheckResult;
                DeepEqual.Equality symbol;
                if (argument instanceof OCType) {
                    OCType resolvedType = ((OCType)argument).resolve(context);
                    if (resolvedType instanceof OCTypeParameterType && ((symbol = ((OCTypeParameterType)resolvedType).getSymbol()) instanceof OCTypeParameterValueSymbol || symbol instanceof OCTypeParameterTypeSymbol && ((OCTypeParameterTypeSymbol)symbol).isSynthetic()) || resolvedType instanceof OCReferenceType || resolvedType instanceof OCVariadicType) continue;
                    if (addAnnotations) {
                        this.addErrorAnnotation(argumentPsi, OCInspections.TemplateArgumentsIssues.class, "CIDR", OCBundle.message("inspections.templateArguments.valueInsteadOfType", new Object[0]));
                    }
                    result2 = false;
                    continue;
                }
                if (!(argument instanceof OCExpressionTypeArgument)) continue;
                OCType requiredType = ((OCTypeParameterValueSymbol)parameter).getType().resolve(context);
                symbol = ((OCExpressionTypeArgument)argument).getSymbol();
                OCType actualType = symbol.getResolvedType(context);
                if (actualType == null || (typeCheckResult = requiredType.checkCompatible(actualType, (OCTypeOwner)((Object)symbol), argumentPsi)).getState().isOK() || requiredType instanceof OCIntType && actualType instanceof OCIntType) continue;
                if (addAnnotations) {
                    this.addErrorAnnotation(argumentPsi, OCInspections.TemplateArgumentsIssues.class, "CIDR", typeCheckResult.getMessage());
                }
                result2 = false;
                continue;
            }
            if (!(parameter instanceof OCTypeParameterTypeSymbol) || !(argument instanceof OCExpressionTypeArgument)) continue;
            if (addAnnotations) {
                this.addErrorAnnotation(argumentPsi, OCInspections.TemplateArgumentsIssues.class, "CIDR", OCBundle.message("inspections.templateArguments.typeInsteadOfValue", new Object[0]));
            }
            result2 = false;
        }
        return result2;
    }

    @Override
    public void visitBoxedExpression(OCBoxedExpression expression2) {
        if (!OCCompilerHelper.supportsObjectLiterals(expression2.getContainingOCFile())) {
            this.addErrorAnnotation(expression2, "CIDR", "Expression literals are not supported by the compiler");
        } else {
            OCType type2;
            OCExpression operand2 = expression2.getOperand();
            if (!(operand2 == null || (type2 = operand2.getResolvedType()).isNumberCompatible(expression2) || type2.isPointerToChar() || type2 instanceof OCMagicType)) {
                this.addErrorAnnotation(operand2, "err_objc_illegal_boxed_expression_type", "Type '" + type2.getName(operand2) + "' is illegal for a boxed expression");
            }
        }
        super.visitBoxedExpression(expression2);
    }

    @Override
    public void visitGenericSelectionExpression(OCGenericSelectionExpression genericExpression) {
        OCExpression expr;
        boolean containsError = this.checkAssociationList(genericExpression);
        if (!containsError && (expr = genericExpression.getControllingExpression()) != null) {
            boolean noneMatch;
            OCType type2 = expr.getResolvedType();
            boolean bl = noneMatch = genericExpression.getAssociationByType(type2) == null;
            if (noneMatch) {
                this.addErrorAnnotation(expr, "err_generic_sel_no_match", "Controlling expression type '" + OCErrorAnnotator.getTypeName(type2, genericExpression) + "' not compatible with any generic association type");
            }
        }
        super.visitGenericSelectionExpression(genericExpression);
    }

    public boolean checkAssociationList(OCGenericSelectionExpression genericExpression) {
        List<OCGenericSelectionAssociation> associations = genericExpression.getAssociations();
        int size = associations.size();
        boolean containsError = false;
        for (int i2 = size - 1; i2 >= 0; --i2) {
            Optional<OCGenericSelectionAssociation> result2;
            OCGenericSelectionAssociation association = associations.get(i2);
            boolean isDefaultAssoc = association.isDefault();
            OCType type2 = isDefaultAssoc ? null : association.getAssociationResolvedType();
            OCTypeElement typeElement = (OCTypeElement)PsiTreeUtil.findChildOfType((PsiElement)association, OCTypeElement.class);
            if (type2 != null && type2.isUnresolved(association)) {
                this.addErrorAnnotation(typeElement, "err_assoc_type_incomplete", "Type '" + type2.getBestNameInContext(association) + "' in generic association incomplete");
                containsError = true;
            }
            OCType t = type2;
            while (t instanceof OCArrayType) {
                if (!((OCArrayType)t).hasLength()) {
                    this.addErrorAnnotation(typeElement, "err_assoc_type_incomplete", "Type '" + t.getBestNameInContext(association) + "' in generic association incomplete");
                    containsError = true;
                    break;
                }
                t = ((OCArrayType)t).getRefType();
            }
            if (!(result2 = associations.subList(0, i2).stream().filter(a -> {
                if (isDefaultAssoc && a.isDefault()) {
                    return true;
                }
                return type2 != null && type2.equals((Object)a.getAssociationResolvedType(), (PsiElement)a);
            }).findFirst()).isPresent()) continue;
            OCGenericSelectionAssociation duplicate = result2.get();
            if (duplicate.isDefault()) {
                this.addErrorAnnotation(association, null, "Duplicate default generic association");
                containsError = true;
                continue;
            }
            this.addErrorAnnotation(typeElement, "err_assoc_compatible_types", "Type '" + OCErrorAnnotator.getTypeName(association) + "' in generic association compatible with previously specified type '" + OCErrorAnnotator.getTypeName(duplicate) + "'");
            containsError = true;
        }
        return containsError;
    }

    @Nullable
    private static String getTypeName(@NotNull OCGenericSelectionAssociation a) {
        if (a.isDefault()) {
            return OCTokenTypes.DEFAULT_KEYWORD.getName();
        }
        OCType type2 = a.getAssociationResolvedType();
        return type2 != null ? type2.getBestNameInContext(a) : null;
    }

    private static String getTypeName(@NotNull OCType type2, @NotNull PsiElement context) {
        type2 = OCTypeUtils.decayType(type2, context.getProject());
        return type2.getBestNameInContext(context);
    }
}

