/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGetSymbolVisitor
extends OCVisitor {
    private OCSymbol mySymbol;
    private int numOfDereferences;
    private boolean wasUnresolvedSymbol;
    private boolean processCalls;
    @Nullable
    private OCResolveContext myContext;

    public OCGetSymbolVisitor() {
    }

    public OCGetSymbolVisitor(@NotNull OCResolveContext context) {
        this.myContext = context;
    }

    public OCGetSymbolVisitor(boolean processCalls) {
        this.processCalls = processCalls;
    }

    @Override
    public void visitQualifiedExpression(OCQualifiedExpression expression2) {
        CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
        expression2.processTargets(expression2.getSymbolName(), (Processor<OCSymbol>)collector, false, null, true, false, null);
        this.mySymbol = (OCSymbol)collector.getFoundValue();
        if (this.mySymbol == null) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expression2) {
        OCElementTypes.SelfSuperToken token = expression2.getSelfSuperToken();
        if (token != null) {
            this.wasUnresolvedSymbol = token == OCElementTypes.SelfSuperToken.SELF;
            return;
        }
        OCSymbol oCSymbol = this.mySymbol = this.myContext != null ? expression2.resolveToSymbol(this.myContext) : expression2.resolveToSymbol();
        if (this.mySymbol == null) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression2) {
        if (this.processCalls) {
            expression2.getFunctionReferenceExpression().accept(this);
        } else if (expression2.getResolvedType() instanceof OCCppReferenceType) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitAssignmentExpression(OCAssignmentExpression expression2) {
        if (expression2.getOperationSign() == OCTokenTypes.EQ) {
            expression2.getReceiverExpression().accept(this);
        }
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression2) {
        if (this.processCalls) {
            List<OCMethodSymbol> symbols = expression2.getProbableResponders().getFilteredByStaticnessResponders();
            if (symbols.size() == 1) {
                this.mySymbol = symbols.get(0);
            }
        } else if (expression2.getResolvedType() instanceof OCCppReferenceType) {
            this.wasUnresolvedSymbol = true;
        }
    }

    @Override
    public void visitParenthesizedExpression(OCParenthesizedExpression expression2) {
        OCExpression operand2 = expression2.getOperand();
        if (operand2 != null) {
            operand2.accept(this);
        }
    }

    @Override
    public void visitUnaryExpression(OCUnaryExpression expression2) {
        OCElementType sign = expression2.getOperationSign();
        OCExpression operand2 = expression2.getOperand();
        if (sign == OCTokenTypes.MUL) {
            ++this.numOfDereferences;
            if (operand2 != null) {
                operand2.accept(this);
            }
        } else if ((sign == OCTokenTypes.__IMAG__KEYWORD || sign == OCTokenTypes.__REAL__KEYWORD) && operand2 != null) {
            operand2.accept(this);
        }
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression expression2) {
        ++this.numOfDereferences;
        expression2.getArrayExpression().accept(this);
    }

    public OCSymbol getSymbol() {
        return this.mySymbol;
    }

    public int getNumOfDereferences() {
        return this.numOfDereferences;
    }

    public boolean wasUnresolvedSymbol() {
        return this.wasUnresolvedSymbol;
    }

    @Nullable
    public static OCSymbol getSymbol(OCExpression expr) {
        return OCGetSymbolVisitor.getSymbol(expr, new OCResolveContext(expr));
    }

    @Nullable
    public static OCSymbol getSymbol(OCExpression expr, @NotNull OCResolveContext context) {
        OCGetSymbolVisitor visitor = new OCGetSymbolVisitor(context);
        if (expr != null) {
            expr.accept(visitor);
        }
        return visitor.getSymbol();
    }
}

