/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCFunctionGroupHelperKt;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.intentions.OCCreateMissingSwitchCasesIntentionAction;
import com.jetbrains.cidr.lang.intentions.OCDeclareMethodInInterfaceIntentionAction;
import com.jetbrains.cidr.lang.intentions.OCDeclareMethodInPrivateCategoryIntentionAction;
import com.jetbrains.cidr.lang.intentions.OCDeclarePropertyInPrivateCategoryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCAddSuperProtocolIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeARCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeFunctionSignatureIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeMethodStaticnessIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangePropertyAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeVisibilityIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertLiteralIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateMissingSwitchCasesFix;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCExtractAssignmentIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCInsertCastIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCMoveDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveTypeModifierIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSafeDeleteIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCFormatSpecifiersUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCOperatorsChecker
extends OCAnnotator {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkBinaryOperatorApplicable(OCExpression lOperand, OCExpression rOperand, OCElementType operator2, OCExpression element) {
        boolean intAndPtr;
        boolean rPointerCompatible;
        OCType rType;
        if (lOperand == null || rOperand == null || operator2 == null || element == null) {
            return;
        }
        if (OCTokenTypes.ASSIGNMENT_OPERATIONS.contains((IElementType)operator2) && !this.checkAssignable(lOperand)) {
            return;
        }
        OCType lType = lOperand.getResolvedType().getGuessedType();
        if (lType instanceof OCCppReferenceType) {
            lType = ((OCCppReferenceType)lType).getRefType(element);
        }
        if ((rType = rOperand.getResolvedType().getGuessedType()) instanceof OCCppReferenceType) {
            rType = ((OCCppReferenceType)rType).getRefType(element);
        }
        if (OCTypeUtils.isUnresolvedLambdaAutoType(rType)) {
            rType = OCTypeUtils.resolveLambdaAutoType(lType, rType, new OCResolveContext(element));
        }
        OCFile containingFile = element.getContainingOCFile();
        if (lType.isUnknown() || rType.isUnknown() || lType.isSubclassOfMagic(element) || rType.isSubclassOfMagic(element)) {
            return;
        }
        if (operator2 == OCTokenTypes.EQ) {
            OCSymbol symbol2;
            OCMethod oCMethod;
            PsiElement parent = element.getParent();
            if (OCIntType.isBool(OCExpectedTypeUtil.getExpectedType(element), element) && !(parent instanceof OCParenthesizedExpression) && !(parent instanceof OCAssignmentExpression) && !(parent instanceof OCDeclarator)) {
                void var9_12;
                Class<OCInspections.EqualityInConditionalOperator> clazz = OCInspections.EqualityInConditionalOperator.class;
                String message2 = "Using '=' in conditional expression";
                if ("self".equals(lOperand.getText())) {
                    Class<OCInspections.EqualityInConditionalOperatorWithSelf> clazz2 = OCInspections.EqualityInConditionalOperatorWithSelf.class;
                    message2 = message2 + " with \"self\"";
                }
                Annotation annotation = this.addWarningAnnotation(element, (Class<? extends OCInspection>)var9_12, "warn_condition_is_assignment", message2);
                String text = element.getTextWithMacros();
                this.registerQuickFix(annotation, new OCChangeTextIntentionAction(containingFile, element.getTextOffset(), text.length(), '(' + text + ')', "Place parentheses around"));
                this.registerQuickFix(annotation, new OCExtractAssignmentIntentionAction(element, lOperand));
            }
            if (lOperand instanceof OCReferenceExpression && ((OCReferenceExpression)lOperand).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF && (oCMethod = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)element, OCMethod.class)) != null && OCElementUtil.startsWithWord(oCMethod.getSelector(), "init") && rType.isCompatible(lType, lOperand)) {
                return;
            }
            OCGetSymbolVisitor oCGetSymbolVisitor = new OCGetSymbolVisitor();
            lOperand.accept(oCGetSymbolVisitor);
            OCType symbolRequiredType = OCPointerType.to(rType.transformType(OCArrayToPointerChanger.INSTANCE), oCGetSymbolVisitor.getNumOfDereferences());
            this.checkAssignment(rOperand, (PsiElement)element, lType, rType, oCGetSymbolVisitor.getSymbol(), symbolRequiredType);
            if (lType instanceof OCStructType && rType instanceof OCStructType && lType.isVolatile() && !rType.isVolatile()) {
                this.addErrorAnnotation(element, "err_ovl_no_viable_oper", OCBundle.message("inspections.typeChecks.volatileConflict", new Object[0]));
                return;
            }
            if (!(lOperand instanceof OCReferenceExpression) || !(rOperand instanceof OCReferenceExpression)) return;
            OCReferenceElement refElement1 = ((OCReferenceExpression)lOperand).getReferenceElement();
            OCReferenceElement refElement2 = ((OCReferenceExpression)rOperand).getReferenceElement();
            OCSymbol symbol1 = refElement1 != null ? refElement1.resolveToSymbol() : null;
            OCSymbol oCSymbol = symbol2 = refElement2 != null ? refElement2.resolveToSymbol() : null;
            if (symbol1 == null || symbol2 == null || !symbol1.equals(symbol2)) return;
            String message3 = symbol1.getNameWithKindUppercase() + " is assigned to itself";
            this.addWarningAnnotation(element, OCInspections.UnusedValue.class, "warn_self_assignment", message3, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            return;
        }
        boolean lIntegerCompatible = lType.isIntegerCompatible(element);
        boolean bl = rType.isIntegerCompatible(element);
        OCResolveContext context = new OCResolveContext(lOperand);
        boolean lPointerCompatible = lType.isPointerCompatible(element) || OCExpressionEvaluator.getPointerType(lOperand, context) != null;
        boolean bl2 = rPointerCompatible = rType.isPointerCompatible(element) || OCExpressionEvaluator.getPointerType(rOperand, context) != null;
        if ((OCTokenTypes.ARITHMETIC_OPERATIONS.contains((IElementType)operator2) || OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operator2)) && !OCTokenTypes.ONLY_INTEGER_ARITHMETIC_OPERATIONS.contains((IElementType)operator2) && lType.isNumberCompatible(element) && rType.isNumberCompatible(element)) {
            return;
        }
        if (OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operator2) && lType.isScalarOrConvertibleToScalar(element) && rType.isScalarOrConvertibleToScalar(element)) {
            return;
        }
        if ((OCTokenTypes.BITLOGIC_OPERATIONS.contains((IElementType)operator2) || OCTokenTypes.ONLY_INTEGER_ARITHMETIC_OPERATIONS.contains((IElementType)operator2)) && lIntegerCompatible && bl) {
            return;
        }
        if (OCTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)operator2) && lType instanceof OCStructType && ((OCStructType)lType).isEnumClass() && rType.equals(lType, false, context)) {
            return;
        }
        String message4 = null;
        if (OCTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)operator2) && lPointerCompatible && rPointerCompatible) {
            if (lIntegerCompatible || bl) {
                message4 = "Comparison between pointer and integer";
            } else {
                if (!(lType instanceof OCPointerType) || !(rType instanceof OCPointerType)) return;
                message4 = "Comparison between distinct pointer types";
            }
        } else if (operator2 == OCTokenTypes.EQEQ || operator2 == OCTokenTypes.EXCLEQ) {
            if (lType instanceof OCStructType && !lType.isScalarOrConvertibleToScalar(element) || rType instanceof OCStructType && !rType.isScalarOrConvertibleToScalar(element)) {
                this.addErrorAnnotation(element, "err_typecheck_invalid_operands", "Can't compare structures");
                return;
            }
            message4 = "Types '" + lType.getName(lOperand) + "' and '" + rType.getName(rOperand) + "' are not compatible";
        }
        if (message4 != null) {
            this.checkTypesEquivalence(lType, rType, lOperand, rOperand, element, message4);
            return;
        }
        boolean ptrAndInt = lPointerCompatible && bl;
        boolean bl3 = intAndPtr = lIntegerCompatible && rPointerCompatible;
        if (operator2 == OCTokenTypes.PLUS && (ptrAndInt || intAndPtr) || operator2 == OCTokenTypes.MINUS && lType instanceof OCPointerType && rType instanceof OCPointerType && new OCTypeEqualityAfterResolvingVisitor(((OCPointerType)rType).getRefType(), false, false, true, true, true, element.getContainingFile()).equal(((OCPointerType)lType).getRefType()) || (operator2 == OCTokenTypes.MINUS || operator2 == OCTokenTypes.PLUSEQ || operator2 == OCTokenTypes.MINUSEQ) && ptrAndInt) {
            if (!OCCompilerHelper.isArcEnabled(containingFile) || !lType.isPointerToObjectCompatible() && !rType.isPointerToObjectCompatible()) return;
            this.addErrorAnnotation(element, OCInspections.ARCIssues.class, "err_arithmetic_nonfragile_interface", "Object pointer arithmetic is forbidden in ARC");
            return;
        }
        if (operator2 == OCTokenTypes.DOT_MUL && lType instanceof OCStructType || operator2 == OCTokenTypes.DEREF_MUL && lType instanceof OCPointerType && rType.isPointer() && (((OCPointerType)lType).getRefType() instanceof OCStructType || ((OCPointerType)lType).getRefType() instanceof OCMagicType)) {
            return;
        }
        this.addErrorAnnotation(element, "err_typecheck_invalid_operands", "Binary operator '" + operator2.getName() + "' can't be applied to the expressions of type '" + lType.getName(lOperand) + "' and '" + rType.getName(rOperand) + "'");
    }

    protected void checkTypesEquivalence(OCType lType, OCType rType, OCExpression lOperand, OCExpression rOperand, OCExpression element, String message2) {
        if (lType instanceof OCArrayType) {
            lType = OCPointerType.to(((OCArrayType)lType).getRefType(), ((OCArrayType)lType).getARCAttribute());
        }
        if (rType instanceof OCArrayType) {
            rType = OCPointerType.to(((OCArrayType)rType).getRefType(), ((OCArrayType)rType).getARCAttribute());
        }
        if (!rType.isCompatible(lType, lOperand, element)) {
            this.checkAssignment(rOperand, element, lType, rType, message2);
        }
    }

    public void checkUnaryOperatorApplicable(OCExpression operand2, OCElementType operator2, PsiElement element) {
        if (operand2 == null || operator2 == null || element == null || operator2 == OCTokenTypes.UDL_SUFFIX) {
            return;
        }
        OCFile containingFile = operand2.getContainingOCFile();
        OCType type2 = operand2.getResolvedType();
        if (type2 instanceof OCCppReferenceType) {
            type2 = ((OCCppReferenceType)type2).getRefType();
        }
        if (operator2 == OCTokenTypes.MUL) {
            if (type2.isSubclassOfMagic(operand2)) {
                return;
            }
            if (type2 instanceof OCPointerType) {
                OCType refType = ((OCPointerType)type2).getRefType();
                if (refType.isUnknown() && !(refType instanceof OCMagicType) && !(refType instanceof OCAutoType)) {
                    this.addErrorAnnotation(operand2, OCInspections.CannotResolve.class, "err_incomplete_type", "Dereferencing pointer to unknown type");
                } else if (refType instanceof OCVoidType) {
                    this.addErrorAnnotation(element, "CIDR", "Dereferencing 'void *' pointer");
                }
            } else if (!type2.isUnknown()) {
                this.addErrorAnnotation(element, OCInspections.PointerTypeRequired.class, "err_typecheck_indirection_requires_pointer", "Pointer type is required");
            }
            return;
        }
        if (type2.isUnknown()) {
            return;
        }
        if (operator2 == OCTokenTypes.PLUSPLUS || operator2 == OCTokenTypes.MINUSMINUS) {
            if (!this.checkAssignable(operand2)) {
                return;
            }
            if (OCCompilerHelper.isArcEnabled(containingFile) && type2.isPointerToObjectCompatible()) {
                this.addErrorAnnotation(operand2, OCInspections.ARCIssues.class, "err_arithmetic_nonfragile_interface", "Object pointer arithmetic is forbidden in ARC");
            } else if (!type2.isNumberCompatible(element) && !(type2 instanceof OCPointerType)) {
                this.addErrorAnnotation(operand2, OCInspections.IntegerTypeRequired.class, "err_typecheck_illegal_increment_decrement", "Expression of type '" + type2.getName(operand2) + "' is neither numeric nor a pointer");
            }
            return;
        }
        if (operator2 == OCTokenTypes.PLUS || operator2 == OCTokenTypes.MINUS) {
            if (!type2.isNumberCompatible(element)) {
                this.addErrorAnnotation(operand2, OCInspections.IntegerTypeRequired.class, "err_typecheck_unary_expr", "Expression of type '" + type2.getName(operand2) + "' is not numeric");
            }
            return;
        }
        if (operator2 == OCTokenTypes.AND) {
            if (!OCExprValueCategory.classify(operand2).isLValue()) {
                this.addErrorAnnotation(operand2, OCInspections.NotAssignable.class, "err_typecheck_invalid_lvalue_addrof", "Address expression must be lvalue");
            }
            return;
        }
        if (operator2 == OCTokenTypes.EXCL && type2.isScalarOrConvertibleToScalar(operand2)) {
            return;
        }
        if (operator2 == OCTokenTypes.TILDE && type2.isIntegerCompatible(element)) {
            return;
        }
        if ((operator2 == OCTokenTypes.__IMAG__KEYWORD || operator2 == OCTokenTypes.__REAL__KEYWORD) && type2 instanceof OCRealType) {
            return;
        }
        String message2 = "Unary operator '" + operator2.getName() + "' can't be applied to the expression of type '" + type2.getName(operand2) + "'";
        this.addErrorAnnotation(element, "err_typecheck_unary_expr", message2);
    }

    public void checkCastExperssion(OCCastExpression expression2) {
        OCType lType = expression2.getCastType().resolve(expression2.getContainingFile());
        OCExpression operand2 = expression2.getOperand();
        if (operand2 == null) {
            OCArgumentList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            if (argumentList.getArguments().size() == 1) {
                operand2 = argumentList.getArguments().get(0);
            } else {
                this.myCppChecker.checkTypeInitialization(expression2, expression2.getTypeElement(), OCArgumentsList.getArgumentList(argumentList.getArguments()), null, lType, true, expression2);
                return;
            }
        }
        PsiElement bridgeCastModifier = expression2.getBridgeCastModifier();
        OCType rType = operand2.getResolvedType().getGuessedType();
        if (bridgeCastModifier != null) {
            boolean rIsCFPtr;
            OCElementType bridgeType = (OCElementType)OCElementUtil.getElementType(bridgeCastModifier);
            String bridgeTypeName = bridgeType.getName();
            String rTypeName = rType.getName(operand2);
            boolean lIsObjectPtr = lType.isPointerToObjectCompatible();
            boolean lIsCFPtr = !lIsObjectPtr && lType instanceof OCPointerType;
            boolean rIsObjectPtr = rType.isPointerToObjectCompatible();
            boolean bl = rIsCFPtr = !rIsObjectPtr && rType instanceof OCPointerType;
            if (bridgeType == OCTokenTypes.BRIDGE_RETAINED_KEYWORD) {
                if (!lIsCFPtr) {
                    this.addErrorAnnotation(expression2.getTypeElement(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires CF pointer type");
                }
                if (!rIsObjectPtr) {
                    this.addErrorAnnotation(expression2.getOperand(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires object pointer type instead of '" + rTypeName + "'");
                }
            } else if (bridgeType == OCTokenTypes.BRIDGE_TRANSFER_KEYWORD) {
                if (!lIsObjectPtr) {
                    this.addErrorAnnotation(expression2.getTypeElement(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires object pointer type");
                }
                if (!rIsCFPtr) {
                    this.addErrorAnnotation(expression2.getOperand(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires CF pointer type instead of '" + rTypeName + "'");
                }
            } else if (bridgeType == OCTokenTypes.BRIDGE_KEYWORD) {
                if (!lIsObjectPtr && !lIsCFPtr) {
                    this.addErrorAnnotation(expression2.getTypeElement(), OCInspections.BridgeCastIssues.class, "CIDR", bridgeTypeName + " requires object or CF pointer type");
                }
                if (!(lIsCFPtr && rIsObjectPtr || lIsObjectPtr && rIsCFPtr)) {
                    String message2 = bridgeTypeName + " requires " + (lIsObjectPtr ? "CF" : "object") + " pointer type instead of '" + rTypeName + "'";
                    this.addErrorAnnotation(expression2.getOperand(), OCInspections.BridgeCastIssues.class, "CIDR", message2);
                }
            }
            return;
        }
        this.checkTypeCast(lType, rType, expression2.getTypeElement(), operand2, expression2);
    }

    public void checkTypeCast(OCType lType, OCType rType, PsiElement typeElement, OCExpression operand2, PsiElement expression2) {
        OCObjectType rObjectType;
        OCObjectType lObjectType;
        String rTypeName = rType.getName(expression2);
        String lTypeName = lType.getName(expression2);
        if (!this.checkARCPointerTypes(lType, typeElement, null)) {
            return;
        }
        OCType.TypeCheckResult typeCheckResult = lType.checkCompatible(rType, operand2, expression2);
        if (!typeCheckResult.canBeCasted(lType, rType, expression2) || typeCheckResult.getInspectionClass() == OCInspections.BridgeCastIssues.class) {
            String message2 = "Expression of type '" + rTypeName + "' can't be cast to type '" + lTypeName + "': " + typeCheckResult.getMessage();
            Annotation annotation = this.addErrorAnnotation(typeElement, typeCheckResult.getInspectionClass(), "err_typecheck_expect_scalar_operand", message2);
            this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(operand2, lType));
            IntentionAction[] quickFixes = typeCheckResult.getQuickFixes();
            if (quickFixes != null) {
                for (IntentionAction fix : quickFixes) {
                    this.registerQuickFix(annotation, fix);
                }
            }
            return;
        }
        if (lType.isPointerToObject() && rType.isPointerToObject() && !(lObjectType = (OCObjectType)lType.getTerminalType()).isAncestorOf(rObjectType = (OCObjectType)rType.getTerminalType()) && !rObjectType.isAncestorOf(lObjectType)) {
            String message3 = "Casting expression of type '" + rTypeName + "' to incompatible type '" + lTypeName + "'";
            this.addWarningAnnotation(typeElement, OCInspections.IncompatiblePointers.class, "CIDRobjc_incompatible_pointers", message3);
            return;
        }
        if (lType.getAliasName() == null && rType.getAliasName() == null && !(operand2 instanceof OCLiteralExpression)) {
            String message4;
            rType = operand2.getResolvedType();
            if (!(!rType.isPointerToID() || lType.isPointerToID() && ((OCObjectType)lType.getTerminalType()).getAllProtocols().isEmpty())) {
                return;
            }
            Annotation annotation = null;
            if (!(!lType.isPointerToObject() || lType.isPointerToID() || typeCheckResult.getState() != OCType.TypeCheckState.OK || rType instanceof OCPointerType && ((OCPointerType)rType).getRefType() instanceof OCVoidType)) {
                message4 = "Casting expression of type '" + rTypeName + "' to '" + lTypeName + "' is redundant";
                annotation = this.addWarningAnnotation(typeElement, OCInspections.RedundantCast.class, "CIDR", message4, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            } else if (lType.equals(rType, false, new OCResolveContext(operand2))) {
                message4 = "Casting expression to '" + lTypeName + "' is redundant";
                annotation = this.addWarningAnnotation(typeElement, OCInspections.RedundantCast.class, "CIDR", message4, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            }
            if (annotation != null) {
                OCExpression oldElement = OCParenthesesUtils.topmostParenthesized((OCExpression)expression2);
                OCExpression newElement = OCParenthesesUtils.diveIntoParentheses(operand2);
                this.registerQuickFix(annotation, new OCChangeElementIntentionAction((PsiElement)oldElement, (PsiElement)newElement, "Remove redundant cast"));
            }
        }
    }

    public boolean checkARCPointerTypes(@Nullable OCType lType, @Nullable PsiElement element, @Nullable OCSymbol symbol) {
        if (element == null || !OCCompilerHelper.isArcEnabled(element.getContainingFile())) {
            return true;
        }
        if (lType instanceof OCPointerType && lType.getTerminalType() instanceof OCObjectType) {
            OCPointerType pointerType = (OCPointerType)lType;
            int numOfExtraRefs = 0;
            boolean wasNotArray = false;
            while (pointerType.getRefType() instanceof OCPointerType && ((OCPointerType)pointerType.getRefType()).getRefType() instanceof OCPointerType) {
                if (!(pointerType instanceof OCArrayType)) {
                    wasNotArray = true;
                }
                pointerType = (OCPointerType)pointerType.getRefType();
                ++numOfExtraRefs;
            }
            if (!(pointerType instanceof OCArrayType && !wasNotArray || !(pointerType.getRefType() instanceof OCPointerType) || pointerType.isPointerToConst() || ((OCPointerType)pointerType.getRefType()).getARCAttribute() != null || symbol != null && symbol.getKind() == OCSymbolKind.PARAMETER)) {
                Annotation annotation = this.addErrorAnnotation(element, OCInspections.ARCIssues.class, "err_arc_indirect_no_ownership", "Pointer to non-const type '" + lType.getName(element) + "' with no explicit lifetime");
                if (symbol != null) {
                    this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, OCPointerType.to((OCType)OCPointerType.to(pointerType.getRefType().cloneWithConstModifier(element.getProject()), null), numOfExtraRefs)));
                    for (ARCAttribute attribute : ARCAttribute.values()) {
                        this.registerQuickFix(annotation, new OCChangeARCAttributeIntentionAction(symbol, attribute));
                    }
                }
                return false;
            }
        }
        return true;
    }

    private boolean checkAssignable(@Nullable OCExpression expression2) {
        OCType operandType;
        if (expression2 == null) {
            return true;
        }
        OCType resolvedType = expression2.getResolvedType();
        if ((expression2 = OCParenthesesUtils.diveIntoParenthesesAndCasts(expression2)) == null) {
            return true;
        }
        if (resolvedType instanceof OCMagicType) {
            return false;
        }
        if (expression2 instanceof OCConditionalExpression && expression2.getContainingOCFile().isCpp()) {
            if (!this.checkAssignable(((OCConditionalExpression)expression2).getPositiveExpression(true)) || !this.checkAssignable(((OCConditionalExpression)expression2).getNegativeExpression())) {
                return false;
            }
            if (!OCExprValueCategory.classify(expression2).isLValue()) {
                this.addErrorAnnotation(expression2, OCInspections.NotAssignable.class, "CIDR", "Expression is not assignable");
                return false;
            }
            return true;
        }
        OCGetSymbolVisitor visitor = new OCGetSymbolVisitor();
        expression2.accept(visitor);
        final OCSymbol symbol = visitor.getSymbol();
        if (symbol != null && symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.STRUCT_FIELD && expression2 instanceof OCQualifiedExpression && !((OCDeclaratorSymbol)symbol).isMutable()) {
            OCQualifiedExpression qualifiedExpression = (OCQualifiedExpression)expression2;
            OCExpression qualifier = qualifiedExpression.getQualifier();
            if (qualifiedExpression.getQualifyingTokenKind() == OCTokenTypes.DOT) {
                if (!this.checkAssignable(qualifier)) {
                    return false;
                }
            } else {
                OCType qualifierType = qualifier.getResolvedType();
                if (qualifierType instanceof OCPointerType && ((OCPointerType)qualifierType).isPointerToConst() && (!(qualifier instanceof OCReferenceExpression) || !((OCReferenceExpression)qualifier).isCppThis())) {
                    this.addErrorAnnotation(qualifier, OCInspections.NotAssignable.class, "CIDR", "Expression is not assignable");
                    return false;
                }
            }
        }
        boolean isAssignable = false;
        List<Object> quickfixes = null;
        String message2 = "Expression is not assignable";
        if (visitor.getNumOfDereferences() > 0) {
            isAssignable = true;
        } else if (symbol instanceof OCPropertySymbol) {
            OCClassSymbol classSymbol;
            isAssignable = !((OCPropertySymbol)symbol).isReadonly();
            quickfixes = new ArrayList<Object>(2);
            quickfixes.add(new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)symbol, OCPropertySymbol.PropertyAttribute.READONLY, null, null));
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)expression2, (Class[])new Class[]{OCImplementation.class});
            if (containingClass != null && (classSymbol = containingClass.getSymbol()) != null && ((OCClassSymbol)((OCPropertySymbol)symbol).getParent()).equals(classSymbol.getInterface())) {
                quickfixes.add(new OCDeclarePropertyInPrivateCategoryIntentionAction(){

                    @Override
                    protected OCPropertySymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
                        return (OCPropertySymbol)symbol;
                    }
                });
            }
        } else if (symbol instanceof OCMethodSymbol) {
            isAssignable = OCNameSuggester.isObjCSetter(symbol.getName());
            if (!this.checkReadonlyAccess(Collections.singletonList(expression2), (OCMethodSymbol)symbol, "Calling")) {
                return false;
            }
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            isAssignable = true;
        } else if (symbol instanceof OCFunctionSymbol) {
            isAssignable = false;
        } else if (symbol instanceof OCDeclaratorSymbol) {
            OCDeclaratorSymbol declaratorSymbol = (OCDeclaratorSymbol)symbol;
            Ref functionSymbol = new Ref();
            isAssignable = true;
            if (resolvedType instanceof OCArrayType && ((OCArrayType)resolvedType).hasLength()) {
                isAssignable = false;
                message2 = "Array is not assignable";
            }
            if (isAssignable) {
                if (declaratorSymbol.getKind() == OCSymbolKind.TYPEDEF) {
                    isAssignable = false;
                } else if (resolvedType.isConst() || declaratorSymbol.isConstexpr() || declaratorSymbol.getKind() == OCSymbolKind.ENUM_CONST) {
                    isAssignable = false;
                    message2 = "Variable is declared constant and is not assignable";
                    OCElementType keyword = declaratorSymbol.isConstexpr() ? OCTokenTypes.CONSTEXPR_CPP_KEYWORD : OCTokenTypes.CONST_KEYWORD;
                    quickfixes = Collections.singletonList(new OCRemoveTypeModifierIntentionAction(declaratorSymbol, keyword));
                } else if (resolvedType instanceof OCCppReferenceType && ((OCCppReferenceType)resolvedType).isReferenceToConst()) {
                    isAssignable = false;
                    message2 = "'" + resolvedType.getName(expression2) + "' is read-only reference";
                    OCCppReferenceType type2 = OCCppReferenceType.to(((OCCppReferenceType)resolvedType).getRefType().cloneWithoutConstModifier(expression2.getProject()));
                    quickfixes = Collections.singletonList(new OCChangeTypeIntentionAction(symbol, type2));
                } else if (OCOperatorsChecker.isOutsideBlock(expression2, declaratorSymbol)) {
                    isAssignable = false;
                    message2 = "Variable is declared outside the block and is not assignable";
                    quickfixes = Collections.singletonList(new OCAddTypeModifierIntentionAction(declaratorSymbol, OCTokenTypes.BLOCK_KEYWORD));
                } else if (OCOperatorsChecker.isInConstMemberFunction(expression2, declaratorSymbol, (Ref<OCFunctionSymbol>)functionSymbol)) {
                    isAssignable = false;
                    message2 = declaratorSymbol.getNameWithKindUppercase() + " is assigned inside a const function";
                    quickfixes = Collections.singletonList(this.changeFunctionConstQuickFix((OCFunctionSymbol)functionSymbol.get(), false));
                } else if (!OCExprValueCategory.classify(expression2).isLValue()) {
                    isAssignable = false;
                }
            }
        } else {
            isAssignable = resolvedType instanceof OCStructType ? !resolvedType.isConst() && OCOperatorReference.resolveOperator("=", OCOperatorReference.OperatorPlacement.INFIX, expression2, (OCStructType)resolvedType) != null : (visitor.wasUnresolvedSymbol() ? true : (expression2 instanceof OCLiteralExpression && ((OCLiteralExpression)expression2).isStringLiteral() ? false : OCExprValueCategory.classify(expression2).isLValue()));
        }
        OCExpression operand2 = null;
        if (expression2 instanceof OCUnaryExpression && ((OCUnaryExpression)expression2).getOperationSign() == OCTokenTypes.MUL) {
            operand2 = ((OCUnaryExpression)expression2).getOperand();
        } else if (expression2 instanceof OCArraySelectionExpression) {
            operand2 = ((OCArraySelectionExpression)expression2).getArrayExpression();
        }
        if (operand2 != null && (operandType = operand2.getResolvedType()) instanceof OCPointerType && ((OCPointerType)operandType).isPointerToConst()) {
            isAssignable = false;
            message2 = "'" + operandType.getName(operand2) + "' is read-only pointer";
            if (symbol != null && !(operandType instanceof OCArrayType)) {
                boolean isConst = operandType.isConst();
                OCType oCType = OCPointerType.to(((OCPointerType)operandType).getRefType().cloneWithoutConstModifier(expression2.getProject()), visitor.getNumOfDereferences() - 1);
                OCPointerType newType = OCPointerType.to(oCType.cloneWithoutConstModifier(expression2.getProject()), null, null, isConst, oCType.isVolatile());
                quickfixes = Collections.singletonList(new OCChangeTypeIntentionAction(symbol, newType));
            }
        }
        if (!isAssignable) {
            Annotation annotation = this.addErrorAnnotation(expression2, OCInspections.NotAssignable.class, "CIDR", message2);
            if (quickfixes != null) {
                for (IntentionAction intentionAction : quickfixes) {
                    this.registerQuickFix(annotation, intentionAction);
                }
            }
        }
        return isAssignable;
    }

    private static boolean isOutsideBlock(@NotNull OCExpression expression2, @NotNull OCDeclaratorSymbol declaratorSymbol) {
        TextRange scope;
        if (!declaratorSymbol.getKind().isLocal() || declaratorSymbol.isBlockModifiable() || declaratorSymbol.isFriendOrStatic()) {
            return false;
        }
        OCBlockExpression block = (OCBlockExpression)PsiTreeUtil.getContextOfType((PsiElement)expression2, (Class[])new Class[]{OCBlockExpression.class});
        return block != null && ((scope = declaratorSymbol.getScope()) == null || !block.getTextRange().contains(scope));
    }

    private static boolean isInConstMemberFunction(@Nullable OCExpression expression2, @NotNull OCDeclaratorSymbol declaratorSymbol, @NotNull Ref<OCFunctionSymbol> functionSymbol) {
        CVQualifiers cvQualifiers = OCCodeInsightUtil.getOuterFunctionCVQualifiers(declaratorSymbol, expression2, functionSymbol);
        return cvQualifiers != null && cvQualifiers.isConst();
    }

    @NotNull
    public OCChangeTypeIntentionAction changeFunctionConstQuickFix(final @NotNull OCFunctionSymbol functionSymbol, final boolean isConst) {
        OCFunctionType oldType = functionSymbol.getType();
        OCFunctionType newType = new OCFunctionType(oldType.getReturnType().cloneWithoutConstModifier(functionSymbol.getProject()), oldType.getParameterTypes(true), oldType.getParameterNames(true), isConst, oldType.isVolatile(), oldType.isLValueRef(), oldType.isRValueRef());
        return new OCChangeTypeIntentionAction(functionSymbol, newType){

            @Override
            protected String getTextInternal() {
                return "Make " + functionSymbol.getNameWithKindLowercase() + (isConst ? " const" : " non-const");
            }

            @Override
            @NotNull
            public String getFamilyName() {
                return "Change const qualifier";
            }
        };
    }

    @NotNull
    public OCChangeTypeIntentionAction changeFunctionVolatileQuickFix(final @NotNull OCFunctionSymbol functionSymbol, final boolean isVolatile) {
        OCFunctionType oldType = functionSymbol.getType();
        OCFunctionType newType = new OCFunctionType(oldType.getReturnType().cloneWithCVQualifiers(CVQualifiers.get(oldType.getReturnType().isConst(), false), functionSymbol.getProject()), oldType.getParameterTypes(true), oldType.getParameterNames(true), oldType.isConst(), isVolatile, oldType.isLValueRef(), oldType.isRValueRef());
        return new OCChangeTypeIntentionAction(functionSymbol, newType){

            @Override
            protected String getTextInternal() {
                return "Make " + functionSymbol.getNameWithKindLowercase() + (isVolatile ? " volatile" : " non-volatile");
            }

            @Override
            @NotNull
            public String getFamilyName() {
                return "Change volatile qualifier";
            }
        };
    }

    public boolean checkReadonlyAccess(List<? extends PsiElement> elements, OCMethodSymbol symbol, String accessKind) {
        String getter;
        OCClassSymbol parent = ((OCClassSymbol)symbol.getParent()).getInterfaceOrProtocol();
        if (parent == null) {
            return true;
        }
        CommonProcessors.FindFirstProcessor propFinder = new CommonProcessors.FindFirstProcessor();
        if (symbol.isSetter() && (getter = OCNameSuggester.getObjCGetterFromSetter(symbol.getName())) != null) {
            parent.processMembers(getter, OCPropertySymbol.class, propFinder);
        }
        if (propFinder.isFound() && ((OCPropertySymbol)propFinder.getFoundValue()).isReadonly()) {
            OCClassSymbol classSymbol;
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)elements.get(0), (Class[])new Class[]{OCImplementation.class});
            if (containingClass != null && (classSymbol = containingClass.getSymbol()) != null && parent.equals(classSymbol.getInterface())) {
                return true;
            }
            String message2 = accessKind + " the setter method for readonly " + ((OCPropertySymbol)propFinder.getFoundValue()).getNameWithKindLowercase();
            List<Annotation> annotations2 = this.addWarningAnnotations(elements, OCInspections.SetterForReadonlyProperty.class, "CIDR", message2);
            this.registerQuickFixes(annotations2, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)propFinder.getFoundValue(), OCPropertySymbol.PropertyAttribute.READONLY, null, null));
            return false;
        }
        return true;
    }

    public void checkCallExpression(OCCallExpression expr) {
        OCExpression function = OCParenthesesUtils.diveIntoParentheses(expr.getFunctionReferenceExpression());
        if (function == null) {
            return;
        }
        OCType funcType = expr.getCalleeType(new OCResolveContext(expr));
        if (funcType instanceof OCCppReferenceType) {
            funcType = ((OCCppReferenceType)funcType).getRefType();
        }
        if (expr.getContainingOCFile().isCpp()) {
            if (function instanceof OCReferenceExpression) {
                OCSymbol symbol = ((OCReferenceExpression)function).resolveToSymbol();
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() || symbol instanceof OCStructSymbol) {
                    this.myCppChecker.checkConstructorCall(expr, expr.getArguments(), symbol);
                    return;
                }
                if (symbol != null && symbol.getKind().isType()) {
                    OCType type2 = symbol.getType().resolve(expr.getContainingOCFile());
                    this.myCppChecker.checkTypeInitialization(expr, function, OCArgumentsList.getArgumentList(expr.getArguments()), symbol, type2, true, expr);
                    return;
                }
            }
            if (expr.getReference() instanceof OCOperatorReference) {
                for (OCSymbol symbol : ((OCOperatorReference)expr.getReference()).resolveToSymbols()) {
                    if (!(symbol instanceof OCFunctionSymbol)) continue;
                    this.myOperatorsChecker.checkFieldVisibility(symbol, expr, null);
                    funcType = symbol.getResolvedType();
                    break;
                }
                if (funcType != null && funcType.isSubclassOfMagic(expr)) {
                    return;
                }
            }
            if (function instanceof OCQualifiedExpression && ((OCQualifiedExpression)function).getName().startsWith("~") && expr.getArguments().isEmpty()) {
                return;
            }
        }
        if (funcType instanceof OCPointerType) {
            funcType = ((OCPointerType)funcType).getRefType();
        }
        if (funcType == null || funcType.isUnknown()) {
            return;
        }
        if (!(funcType instanceof OCFunctionType)) {
            this.addErrorAnnotation(function, "err_typecheck_call_not_function", "Called object is not a function");
            return;
        }
        OCGetSymbolVisitor visitor = new OCGetSymbolVisitor();
        function.accept(visitor);
        OCSymbol functionSymbol = visitor.getSymbol();
        if (functionSymbol instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol) {
            OCFunctionGroupHelperKt.annotateAmbig(this, function, (OCResolveOverloadsUtil.OCFunctionGroupSymbol)functionSymbol, "No matching function");
        } else {
            this.checkFunctionArguments(expr, (OCFunctionType)funcType, expr.getArguments(), functionSymbol);
        }
        if (expr.getContainingOCFile().isCpp() && functionSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)functionSymbol).getResolvedOwner() instanceof OCStructSymbol && !((OCFunctionSymbol)functionSymbol).isCppNonMemberOperator(new OCResolveContext(expr))) {
            this.checkConstFunction(function, (OCFunctionSymbol)functionSymbol);
        }
    }

    boolean checkFunctionArguments(OCElement element, OCFunctionType funcType, List<OCExpression> arguments, OCSymbol functionSymbol) {
        return new OCAnnotator.MyArgumentsChecker(){

            @Override
            protected void addFunctionCallQuickFixes(OCElement element, OCFunctionType funcType, List<OCExpression> arguments, OCSymbol functionSymbol, List<OCType> argumentTypes, List<Annotation> annotations2) {
                if (functionSymbol != null) {
                    OCOperatorsChecker.this.checkFormatSpecifiers(functionSymbol, arguments, argumentTypes);
                    argumentTypes = ContainerUtil.map(arguments, expression2 -> OCExpectedTypeUtil.getExpressionType(expression2, true));
                    OCFunctionType newFunctionType = new OCFunctionType(funcType.getReturnType(), argumentTypes);
                    OCOperatorsChecker.this.registerQuickFixes(annotations2, new OCChangeFunctionSignatureIntentionAction(functionSymbol, newFunctionType));
                    if (element.getContainingOCFile().isCpp() && functionSymbol instanceof OCFunctionSymbol) {
                        OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)functionSymbol).getResolvedOwner();
                        boolean isStatic = ((OCFunctionSymbol)functionSymbol).resolveIsStatic();
                        OCElement usage = element instanceof OCCallExpression ? ((OCCallExpression)element).getFunctionReferenceExpression() : element;
                        OCOperatorsChecker.this.registerQuickFixes(annotations2, new OCCreateNewDefinitionIntentionAction(functionSymbol.getKind().toDeclarationKind(), usage, null, parent, functionSymbol.getName(), newFunctionType, isStatic));
                    }
                }
            }
        }.checkFunctionArguments(element, funcType, arguments, functionSymbol);
    }

    protected void checkConstFunction(OCExpression function, OCFunctionSymbol symbol) {
        CVQualifiers cvQualifiers = null;
        OCQuickFix extraConstFix = null;
        OCQuickFix extraVolatileFix = null;
        if (function instanceof OCQualifiedExpression) {
            OCSymbol qualifierSymbol;
            OCQualifiedExpression qualifiedExpression = (OCQualifiedExpression)function;
            OCExpression qualifier = qualifiedExpression.getQualifier();
            OCPunctuatorElementType qualifyingTokenKind = qualifiedExpression.getQualifyingTokenKind();
            cvQualifiers = qualifiedExpression.getCVQualifiers();
            if (cvQualifiers.isConst() && qualifyingTokenKind == OCTokenTypes.DOT && (qualifierSymbol = OCGetSymbolVisitor.getSymbol(qualifier)) instanceof OCSymbolWithQualifiedName) {
                extraConstFix = new OCRemoveTypeModifierIntentionAction((OCSymbolWithQualifiedName)qualifierSymbol, OCTokenTypes.CONST_KEYWORD);
                extraVolatileFix = new OCRemoveTypeModifierIntentionAction((OCSymbolWithQualifiedName)qualifierSymbol, OCTokenTypes.VOLATILE_KEYWORD);
            }
        } else if (function instanceof OCReferenceExpression) {
            OCFunctionSymbol containingFunSymbol;
            OCFunctionDefinition containingFunction = (OCFunctionDefinition)PsiTreeUtil.getContextOfType((PsiElement)function, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class});
            OCFunctionSymbol oCFunctionSymbol = containingFunSymbol = containingFunction != null ? containingFunction.getSymbol() : null;
            if (containingFunSymbol != null) {
                cvQualifiers = containingFunSymbol.getType().getCVQualifiers();
                extraConstFix = this.changeFunctionConstQuickFix(containingFunSymbol, false);
                extraVolatileFix = this.changeFunctionVolatileQuickFix(containingFunSymbol, false);
            }
        }
        if (!symbol.isCppConstructor() && !symbol.resolveIsStatic()) {
            this.checkCVMismatch(function, symbol, cvQualifiers, true, "const", extraConstFix);
            this.checkCVMismatch(function, symbol, cvQualifiers, false, "volatile", extraVolatileFix);
        }
    }

    private void checkCVMismatch(OCExpression function, OCFunctionSymbol symbol, CVQualifiers cvQualifiers, boolean isConstModifier, String modifierName, IntentionAction extraFix) {
        if (cvQualifiers != null && (isConstModifier && cvQualifiers.isConst() && !symbol.isConst() || !isConstModifier && cvQualifiers.isVolatile() && !symbol.getType().isVolatile())) {
            String message2 = "Non-" + modifierName + " " + symbol.getNameWithKindLowercase() + " is called " + (function instanceof OCReferenceExpression ? "from the " + modifierName + " function" : "on the " + modifierName + " object");
            Annotation annotation = this.addErrorAnnotation(function, OCInspections.ConstExpressionRequired.class, "err_member_function_call_bad_cvr", message2);
            this.registerQuickFix(annotation, new OCAddTypeModifierIntentionAction(symbol.getDeclarationInParent(), OCTokenTypes.STATIC_KEYWORD, false));
            if (isConstModifier) {
                this.registerQuickFix(annotation, this.changeFunctionConstQuickFix(symbol, true));
            } else {
                this.registerQuickFix(annotation, this.changeFunctionVolatileQuickFix(symbol, true));
            }
            if (extraFix != null) {
                this.registerQuickFix(annotation, extraFix);
            }
        }
    }

    public void checkMacroCall(OCMacroCall macroCall) {
        int expectedCount;
        if (macroCall.getTextLength() == 0) {
            return;
        }
        OCMacroSymbol symbol = macroCall.resolveToSymbol();
        if (symbol == null || !symbol.hasParameterList()) {
            return;
        }
        OCMacroCall.ParameterCheckResult result2 = macroCall.checkParameters(symbol);
        int actualCount = result2.getActualCount();
        if (actualCount < (expectedCount = result2.getAllowedCount())) {
            this.addErrorAnnotation(macroCall, OCInspections.FunctionParameterCountMismatch.class, "err_too_few_args_in_macro_invoc", "Too few arguments for a macro call, expected " + (symbol.isVararg() ? "at least " : "") + expectedCount);
        } else if (actualCount > expectedCount) {
            this.addErrorAnnotation(macroCall, OCInspections.FunctionParameterCountMismatch.class, "err_too_many_args_in_macro_invoc", "Too many arguments for a macro call, expected " + expectedCount);
        }
    }

    private void checkFormatSpecifiers(OCSymbol callable, List<OCExpression> arguments, List<OCType> argumentTypes) {
        Pair<OCFormatSpecifiersUtil.FormatSpecifiersInfo, List<OCFormatSpecifiersUtil.SpecifierUsage>> formatInfo = OCFormatSpecifiersUtil.getFormatSpecifiersInfo(callable, arguments);
        if (formatInfo == null) {
            return;
        }
        List formatStringSpecifiers = (List)formatInfo.second;
        for (OCFormatSpecifiersUtil.SpecifierUsage specifier : formatStringSpecifiers) {
            TextRange specifierRange = specifier.getRange();
            if (specifierRange == null) continue;
            this.highlight(specifierRange, specifier.getType());
        }
        OCFormatSpecifiersUtil.FormatSpecifiersInfo formatSpecifiersInfo = (OCFormatSpecifiersUtil.FormatSpecifiersInfo)formatInfo.first;
        if (!formatSpecifiersInfo.formatType.needArgumentsCheck() || formatSpecifiersInfo.argumentsIndex < 0 || formatSpecifiersInfo.formatStringIndex < 0) {
            return;
        }
        OCExpression formatStringArgument = arguments.get(formatSpecifiersInfo.formatStringIndex);
        int argIndex = formatSpecifiersInfo.argumentsIndex;
        boolean skipNext = false;
        for (OCFormatSpecifiersUtil.SpecifierUsage specifier : formatStringSpecifiers) {
            TextRange specifierRange = specifier.getRange();
            if (specifier.getType() == OCHighlightingKeys.OC_VALID_STRING_ESCAPE) continue;
            if (specifier.getType() == OCHighlightingKeys.OC_INVALID_STRING_ESCAPE) {
                this.addWarningAnnotation(formatStringArgument, specifierRange, OCInspections.FormatSpecifiers.class, "warn_printf_incomplete_specifier", "Unknown, incomplete or optional format specifier", null);
                ++argIndex;
                continue;
            }
            String existingSpecifierName = specifier.getName();
            if (formatSpecifiersInfo.formatType == OCFormatSpecifiersUtil.FormatType.SCANF && existingSpecifierName.equals("*")) {
                skipNext = true;
                continue;
            }
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if ((formatSpecifiersInfo.formatType == OCFormatSpecifiersUtil.FormatType.PRINTF || formatSpecifiersInfo.formatType == OCFormatSpecifiersUtil.FormatType.NSSTRING) && existingSpecifierName.equals("%m")) {
                this.addWarningAnnotation(formatStringArgument, specifierRange, OCInspections.FormatSpecifiers.class, "CIDR", "Format specifier '" + existingSpecifierName + "' is a Glibc extension", null);
                continue;
            }
            if (argIndex >= arguments.size()) {
                PsiFile file2 = callable.getContainingPsiFile();
                OCType expectedType = formatSpecifiersInfo.formatType.resolveType(existingSpecifierName, (PsiElement)file2);
                String expectedArgType = expectedType == null ? "" : expectedType.getName((PsiElement)file2);
                this.addWarningAnnotation(formatStringArgument, specifierRange, OCInspections.FormatSpecifiers.class, "warn_printf_data_arg_not_used", "Argument missing: format specifier '" + existingSpecifierName + "' requires '" + expectedArgType + "' argument", null);
                continue;
            }
            OCExpression argument = arguments.get(argIndex);
            OCType argType = argumentTypes.get(argIndex);
            OCFormatSpecifiersUtil.FormatType formatType = formatSpecifiersInfo.formatType;
            String actualArgumentSpecifierName = formatType.getSpecifierForType(argType, argument);
            OCType expectedType = formatType.resolveType(existingSpecifierName, argument);
            if (actualArgumentSpecifierName != null && expectedType != null && !formatType.isCompatible(expectedType, argType, existingSpecifierName, actualArgumentSpecifierName, argument)) {
                String message2 = "Format specifier '" + existingSpecifierName + "' requires '" + expectedType.getName(argument) + "' argument instead of '" + argType.getName(argument) + "'";
                if (!actualArgumentSpecifierName.equals("<pointer type required>") && specifierRange != null) {
                    Annotation formatAnnotation = this.addWarningAnnotation(formatStringArgument, specifierRange, OCInspections.FormatSpecifiers.class, "warn_format_conversion_argument_type_mismatch", message2, null);
                    this.registerQuickFix(formatAnnotation, new OCChangeTextIntentionAction(argument.getContainingFile(), specifierRange.getStartOffset(), specifierRange.getLength(), actualArgumentSpecifierName, "Change format specifier to '" + actualArgumentSpecifierName + "'", "Change format specifier"));
                }
                Annotation argAnnotation = this.addWarningAnnotation(argument, OCInspections.FormatSpecifiers.class, "warn_format_conversion_argument_type_mismatch", message2);
                if (!existingSpecifierName.equals("%@")) {
                    if (formatType != OCFormatSpecifiersUtil.FormatType.SCANF) {
                        this.registerQuickFix(argAnnotation, new OCInsertCastIntentionAction(argument, expectedType));
                    }
                    if (!expectedType.isPointer()) {
                        this.registerQuickFix(argAnnotation, OCChangeTypeIntentionAction.getAction(argument, expectedType));
                    }
                }
                this.registerQuickFix(argAnnotation, new OCConvertTypeIntentionAction(argument, expectedType));
                this.registerQuickFix(argAnnotation, new OCConvertLiteralIntentionAction(argument, expectedType, argType));
            }
            ++argIndex;
        }
        if (argIndex < arguments.size()) {
            OCExpression argument = arguments.get(argIndex);
            OCExpression argumentLast = arguments.get(arguments.size() - 1);
            int requiredVarargs = argIndex - formatSpecifiersInfo.argumentsIndex;
            int hasVarargs = arguments.size() - formatSpecifiersInfo.argumentsIndex;
            Annotation annotation = this.addWarningAnnotation(argument.getParent(), new OCElementsRange(argument, argumentLast).getTextRange(), OCInspections.FormatSpecifiers.class, "warn_printf_insufficient_data_args", "Too many arguments: format string requires " + requiredVarargs + ", but has " + hasVarargs + StringUtil.pluralize((String)" argument", (int)hasVarargs), null);
            String intentionName = "Remove" + StringUtil.pluralize((String)" argument", (int)(hasVarargs - requiredVarargs));
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(arguments.subList(argIndex, arguments.size()), intentionName, intentionName));
        }
    }

    public void checkSendMessageExpression(OCSendMessageExpression expr) {
        OCSendMessageExpression.ProbableResponders responders = expr.getProbableResponders();
        OCExpression receiver2 = expr.getReceiverExpression();
        if (expr.getArguments().size() == 0) {
            this.addErrorAnnotation(expr, OCInspections.MethodParameterCountMismatch.class, "CIDRobjc_message_selector_missing", "Message selector expected");
            return;
        }
        if (responders.isStaticnessMismatch()) {
            String message2 = responders.isStaticContext() ? "Instance method is called from the class context" : "Class method is called from the instance context";
            Annotation annotation = this.addErrorAnnotation(expr, OCInspections.StaticnessMismatch.class, "CIDR", message2);
            if (responders.getAllResponders().size() == 1) {
                OCMethodSymbol responder = responders.getAllResponders().get(0);
                this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction(responder, responders.isStaticContext()));
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCMethod.class});
                if (receiver2 instanceof OCReferenceExpression && containingMethod != null && ((OCReferenceExpression)receiver2).getSelfSuperToken() != null) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction((OCMethodSymbol)containingMethod.getSymbol(), !responders.isStaticContext()));
                }
            }
            return;
        }
        OCMethodSymbol knownResponder = responders.getKnownResponder();
        if (knownResponder != null && expr.isVarargCall() && !knownResponder.isVararg()) {
            this.addErrorAnnotation(expr, OCInspections.MethodParameterCountMismatch.class, "CIDRobjc_not_vararg_method", knownResponder.getNameWithKindUppercase() + " is not a vararg method");
            return;
        }
        String messageSelector = expr.getMessageSelector();
        OCMethodSymbol target = OCOperatorsChecker.findTargetMethod(expr, responders.getFilteredByStaticnessResponders());
        if (responders.getKnownResponder() == null) {
            for (OCMethodSymbol responder : responders.getAllResponders()) {
                OCFileSymbols.markSymbolAsUsed(expr.getContainingOCFile(), responder, expr);
            }
        }
        if (target == null) {
            return;
        }
        this.checkResponderIsKnown(expr, responders, target);
        this.checkSendMessageArguments(expr, target);
        if (!OCCompilerHelper.isArcEnabled(expr.getContainingFile())) {
            Annotation annotation;
            if (messageSelector.equals("dealloc")) {
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCMethod.class});
                if (containingMethod != null && containingMethod.getSelector().equals("dealloc") && receiver2 instanceof OCReferenceExpression && ((OCReferenceExpression)receiver2).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SUPER) {
                    return;
                }
                annotation = this.addWarningAnnotation(expr, OCInspections.CallDealloc.class, "CIDR", "Sending 'dealloc' directly");
                int selectorOffset = expr.getArgumentSelectors().get(0).getTextOffset();
                String message3 = "Send \"release\" message instead of \"dealloc\"";
                this.registerQuickFix(annotation, new OCChangeTextIntentionAction(expr.getContainingFile(), selectorOffset, "dealloc".length(), "release", message3));
            } else if (OCElementUtil.isReleaseSelector(messageSelector)) {
                OCSymbol receiverSymbol = null;
                if (receiver2 instanceof OCReferenceExpression) {
                    receiverSymbol = ((OCReferenceExpression)receiver2).resolveToSymbol();
                } else if (receiver2 instanceof OCQualifiedExpression) {
                    receiverSymbol = ((OCQualifiedExpression)receiver2).resolveToSymbol();
                }
                if (receiverSymbol instanceof OCInstanceVariableSymbol) {
                    receiverSymbol = ((OCInstanceVariableSymbol)receiverSymbol).getAssociatedProperty();
                }
                if (receiverSymbol instanceof OCPropertySymbol && !((OCPropertySymbol)receiverSymbol).isReadonly() && ((OCPropertySymbol)receiverSymbol).getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, receiverSymbol.getResolvedType(), expr) == OCPropertySymbol.PropertyAttribute.ASSIGN) {
                    annotation = this.addWarningAnnotation(expr, OCInspections.ReleasingOfAssignProperties.class, "CIDR", "Releasing of the property with 'assign' attribute");
                    this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)receiverSymbol, OCPropertySymbol.PropertyAttribute.ASSIGN, OCPropertySymbol.PropertyAttribute.RETAIN, null));
                    this.registerQuickFix(annotation, new OCChangePropertyAttributeIntentionAction((OCPropertySymbol)receiverSymbol, OCPropertySymbol.PropertyAttribute.ASSIGN, OCPropertySymbol.PropertyAttribute.COPY, null));
                }
            }
        }
        this.checkReadonlyAccess(expr.getArgumentSelectors(), target, "Calling");
    }

    private void checkSendMessageArguments(OCSendMessageExpression expr, OCMethodSymbol target) {
        List<OCMessageArgument> arguments = expr.getArguments();
        ArrayList<OCType> argumentTypes = new ArrayList<OCType>();
        boolean requiresNil = OCType.isFunctionRequiringNil(target);
        int argPos = 0;
        for (OCMessageArgument arg : arguments) {
            OCExpression argument = arg.getArgumentExpression();
            if (argument == null) continue;
            OCType argumentType = argument.getResolvedType().getGuessedType();
            argumentTypes.add(argumentType);
            if (target.isVararg() && argPos >= target.getSelectors().size()) {
                if (argumentType.isVoid()) {
                    this.addErrorAnnotation(argument, "CIDR", "Invalid use of void expression");
                    continue;
                }
                if (!requiresNil || !expr.getMessageSelector().contains("Objects") || argumentType.isPointerToObjectCompatible()) continue;
                this.checkAssignment(argument, argument, OCIdType.pointerToID(argument.getProject()), argumentType, null, argumentType, true, "Parameter type mismatch: ");
                continue;
            }
            OCDeclaratorSymbol parameter = target.getSelectors().get(argPos++).getParameter();
            if (parameter == null) continue;
            OCType declType = parameter.getType().resolve(expr.getContainingFile());
            this.checkAssignment(argument, (PsiElement)argument, declType, argumentType, (OCSymbol)parameter, "Parameter type mismatch: ");
        }
        this.checkFormatSpecifiers(target, expr.getArgumentExpressions(), argumentTypes);
        if (requiresNil && arguments.size() > 0) {
            String text;
            OCMessageArgument lastArgument = arguments.get(arguments.size() - 1);
            OCExpression expression2 = lastArgument.getArgumentExpression();
            String string = text = expression2 != null ? expression2.getTextWithMacros() : null;
            if (!OCCodeInsightUtil.isLikeNull(text)) {
                Annotation annotation = this.addWarningAnnotation(lastArgument, OCInspections.LastArgumentMustBeNull.class, "CIDR", "Last argument must be \"nil\"");
                this.registerQuickFix(annotation, new OCChangeTextIntentionAction(lastArgument.getContainingOCFile(), lastArgument.getTextRange().getEndOffset(), 0, ", nil", "Append \"nil\" argument"));
            }
        }
    }

    private void checkResponderIsKnown(OCSendMessageExpression expr, OCSendMessageExpression.ProbableResponders responders, final OCMethodSymbol target) {
        OCInterfaceSymbol receiverClass;
        OCFile file2 = expr.getContainingOCFile();
        OCExpression receiver2 = expr.getReceiverExpression();
        OCFileSymbols.markSymbolAsUsed(file2, target, expr);
        OCObjectType receiverType = responders.getReceiverType();
        OCType receiverOriginalType = responders.getReceiverOriginalType();
        OCInterfaceSymbol oCInterfaceSymbol = receiverClass = receiverType != null ? receiverType.getInterface() : null;
        if (receiverClass != null && !receiverClass.isPredeclaration()) {
            OCFileSymbols.markImportNeeded(file2, receiverClass);
        }
        if (responders.getKnownResponder() != null) {
            return;
        }
        if (receiverClass != null && receiverClass.isPredeclaration()) {
            String message2 = receiverClass.getNameWithKindUppercase() + " definition is not visible";
            Annotation annotation = this.addErrorAnnotation(receiver2, OCInspections.MemberVisibility.class, "CIDRobjc_definition_not_visible", message2);
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver2, receiverClass.getDefinitionSymbol()));
        } else if (receiverType instanceof OCIdType || receiverOriginalType != null && receiverOriginalType.isClassType()) {
            if (!OCFileSymbols.isSymbolImported(file2, target.getParent())) {
                Annotation annotation = this.addErrorAnnotation(expr, OCInspections.MemberVisibility.class, "CIDRobjc_definition_not_visible", target.getNameWithKindUppercase() + " is not visible");
                this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver2, (OCSymbol)target.getParent()));
            }
        } else {
            OCClassSymbol containingClassSymbol;
            boolean isSameClassName = receiverClass != null && receiverClass.getName().equals(((OCClassSymbol)target.getParent()).getName());
            String message3 = receiverClass != null && !isSameClassName && ((OCClassSymbol)target.getParent()).isSubclass(receiverClass) ? target.getNameWithKindUppercase() + " is defined in subclass '" + ((OCClassSymbol)target.getParent()).getPresentableName() + "'" : target.getNameWithKindUppercase() + " is defined in class '" + ((OCClassSymbol)target.getParent()).getPresentableName() + "' and is not visible";
            Annotation annotation = OCCompilerHelper.isArcEnabled(file2) ? this.addErrorAnnotation(expr, OCInspections.NotInHierarchyMessage.class, "warn_inst_method_not_found", message3) : this.addWarningAnnotation(expr, OCInspections.NotInHierarchyMessage.class, "warn_inst_method_not_found", message3);
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(receiver2, (OCSymbol)target.getParent()));
            OCClassDeclaration containingClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCClassDeclaration.class});
            OCClassSymbol oCClassSymbol = containingClassSymbol = containingClass != null ? containingClass.getSymbol() : null;
            if (receiverClass != null) {
                this.registerQuickFix(annotation, new OCDeclareMethodInInterfaceIntentionAction(){

                    @Override
                    @NotNull
                    public String getText() {
                        return "Declare method in " + receiverClass.getNameWithKindLowercase();
                    }

                    @Override
                    protected OCClassSymbol getParent(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2) {
                        return receiverClass;
                    }

                    @Override
                    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
                        return OCSearchScope.isInProjectSources(target);
                    }

                    @Override
                    protected OCMethodSymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
                        return target;
                    }
                });
                if (receiver2 != null && !isSameClassName) {
                    OCPointerType targetType = OCPointerType.to(((OCClassSymbol)target.getParent()).getType().resolve(file2));
                    this.registerQuickFix(annotation, new OCInsertCastIntentionAction(receiver2, targetType));
                    this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(receiver2, targetType));
                    this.registerQuickFix(annotation, new OCConvertTypeIntentionAction(receiver2, targetType));
                    this.registerQuickFix(annotation, new OCConvertLiteralIntentionAction(receiver2, targetType, receiverType));
                }
            }
            if (receiverClass != null && containingClassSymbol != null && receiverClass.getImplementation() == containingClassSymbol) {
                this.registerQuickFix(annotation, new OCDeclareMethodInPrivateCategoryIntentionAction(){

                    @Override
                    protected OCClassSymbol getParent(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2) {
                        return receiverClass;
                    }

                    @Override
                    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
                        return OCSearchScope.isInProjectSources(target);
                    }

                    @Override
                    protected OCMethodSymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
                        return target;
                    }
                });
            }
        }
    }

    public void checkForeach(OCForeachStatement statement2) {
        OCSymbol varSymbol;
        OCElement varElement;
        OCType lType;
        OCDeclaration varDecl;
        OCElement varExprElement = statement2.getVariableExpression();
        OCExpression varExpr = varExprElement instanceof OCExpressionStatement ? ((OCExpressionStatement)varExprElement).getExpression() : (OCExpression)varExprElement;
        OCExpression collExpr = statement2.getCollectionExpression();
        OCElement varDeclElement = statement2.getVariableDeclaration();
        OCDeclaration oCDeclaration = varDecl = varDeclElement instanceof OCDeclarationStatement ? ((OCDeclarationStatement)varDeclElement).getDeclaration() : (OCDeclaration)varDeclElement;
        if (varExpr != null) {
            if (!this.checkAssignable(varExpr)) {
                return;
            }
            lType = varExpr.getResolvedType();
            varElement = varExprElement;
            varSymbol = OCGetSymbolVisitor.getSymbol(varExpr);
            if (!(statement2.isCpp11Foreach() || lType.isUnknown() || lType.isPointerToObjectCompatible())) {
                this.addErrorAnnotation(varExpr, "CIDR", "Expression has non-object type '" + lType.getName(varExpr) + "'");
            }
        } else if (varDecl != null) {
            varElement = varDecl;
            if (varDecl.getDeclarators().size() != 1) {
                Annotation annotation = this.addErrorAnnotation(varDecl, "err_toomany_element_decls", "Only one variable declarator is allowed");
                for (int i2 = varDecl.getDeclarators().size() - 1; i2 >= 1; --i2) {
                    this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)varDecl.getDeclarators().get(i2), "Remove extra declarators"));
                }
                return;
            }
            OCDeclarator declarator = varDecl.getDeclarators().get(0);
            varSymbol = declarator.getSymbol();
            lType = declarator.getResolvedType();
            if (declarator.getInitializer() != null) {
                this.addErrorAnnotation(declarator.getInitializer(), OCInspections.InitializerIssues.class, "CIDR", "Initializer is not allowed here");
            } else if (!(statement2.isCpp11Foreach() || lType.isUnknown() || lType.isPointerToObjectCompatible())) {
                this.addErrorAnnotation(declarator, "err_selector_element_type", "Variable has non-object type '" + lType.getName(varExpr) + "'");
            }
        } else {
            return;
        }
        if (collExpr == null) {
            return;
        }
        OCType rType = collExpr.getResolvedType().getGuessedType();
        if (rType.isUnknown()) {
            return;
        }
        if (statement2.isCpp11Foreach()) {
            OCType elementType = OCCodeInsightUtil.getCollectionElementType(collExpr, rType);
            if (elementType != null) {
                this.checkAssignment(null, (PsiElement)varElement, lType, elementType, varSymbol, "");
            } else {
                this.addErrorAnnotation(collExpr, OCInspections.ArrayIssues.class, "err_for_range_invalid", "'" + rType.getBestNameInContext(collExpr) + "' is not a valid range type");
            }
        } else if (rType.isPointerToObjectCompatible()) {
            OCType refType = ((OCPointerType)rType).getRefType();
            if (!(refType instanceof OCObjectType)) {
                return;
            }
            OCObjectType objectType = (OCObjectType)refType;
            OCType itemType = OCTypeUtils.getCollectionItemType(objectType, statement2);
            if (itemType != null) {
                this.checkAssignment(null, (PsiElement)varElement, lType, itemType, varSymbol, "");
            }
            String enumFunction = "countByEnumeratingWithState:objects:count:";
            if (!(objectType instanceof OCIdType && objectType.getAllProtocols().isEmpty() || objectType.findMember("countByEnumeratingWithState:objects:count:", OCMethodSymbol.class) != null)) {
                String message2 = "Collection expression of type '" + rType.getName(collExpr) + "' doesn't respond to '" + "countByEnumeratingWithState:objects:count:" + "'";
                Annotation annotation = this.addWarningAnnotation(collExpr, OCInspections.UnresolvedCollectionMessage.class, "warn_collection_expr_type", message2);
                if (objectType.getInterface() != null) {
                    this.registerQuickFix(annotation, new OCAddSuperProtocolIntentionAction(objectType.getInterface(), "NSFastEnumeration", false));
                }
            }
        } else {
            this.addErrorAnnotation(collExpr, "CIDR", "Expression has non-object type '" + rType.getName(collExpr) + "'");
        }
    }

    @Nullable
    public static OCMethodSymbol findTargetMethod(OCSendMessageExpression expr, List<OCMethodSymbol> targets) {
        List<OCMessageArgument> arguments = expr.getArguments();
        OCMethodSymbol best = null;
        int minValue = 0;
        block0: for (OCMethodSymbol target : targets) {
            int argPos = 0;
            int value2 = 0;
            for (OCMessageArgument arg : arguments) {
                OCDeclaratorSymbol parameter;
                OCExpression argument = arg.getArgumentExpression();
                if (argument == null) continue;
                OCType argumentType = argument.getResolvedType().getGuessedType();
                List<OCMethodSymbol.SelectorPartSymbol> parameters2 = target.getSelectors();
                if (target.isVararg()) {
                    if (argPos >= parameters2.size()) {
                        continue;
                    }
                } else if (parameters2.size() != arguments.size()) continue block0;
                if ((parameter = parameters2.get(argPos).getParameter()) == null) continue;
                OCType declType = parameter.getType().resolve(expr.getContainingFile());
                OCType.TypeCheckState state = declType.checkCompatible(argumentType, argument, argument).getState();
                if (state.isError(expr)) {
                    value2 += 2000;
                } else if (state != OCType.TypeCheckState.OK) {
                    ++value2;
                }
                ++argPos;
            }
            if (!OCFileSymbols.isSymbolImported(expr.getContainingOCFile(), target.getParent())) {
                value2 += 1000;
            }
            if (best != null && (value2 == -1 || value2 >= minValue)) continue;
            minValue = value2;
            best = target;
        }
        return best;
    }

    public void checkQualifiedExpression(OCQualifiedExpression expression2) {
        OCType type2 = expression2.getQualifier().getResolvedType();
        if (type2.isUnknown()) {
            return;
        }
        if (type2 instanceof OCCppReferenceType) {
            type2 = ((OCCppReferenceType)type2).getRefType();
        }
        OCFile file2 = expression2.getContainingOCFile();
        if (expression2.getQualifyingTokenKind() == OCTokenTypes.DEREF) {
            Ref isSynthetic = new Ref((Object)false);
            OCType derefType = expression2.getQualifierContainerType((Ref<Boolean>)isSynthetic);
            if (derefType == OCUnknownType.INSTANCE && ((Boolean)isSynthetic.get()).booleanValue()) {
                String message2 = "Applying '->' operator to '" + type2.getName(expression2) + "' instead of a pointer";
                Annotation annotation = this.addErrorAnnotation(expression2.getQualifier(), OCInspections.PointerTypeRequired.class, "err_typecheck_member_reference_arrow", message2);
                if (type2 instanceof OCStructType || type2 instanceof OCObjectType) {
                    this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(expression2.getQualifier(), OCPointerType.to(type2)));
                }
                return;
            }
            Ref qualifierType = new Ref();
            expression2.processTargets(expression2.getSymbolName(), (Processor<OCSymbol>)new CommonProcessors.CollectProcessor(), true, null, false, false, (Ref<OCType>)qualifierType);
            OCType oCType = type2 = qualifierType.isNull() ? derefType : (OCType)qualifierType.get();
        }
        if (!(type2.isUnknown() || type2 instanceof OCStructType || type2.isClassType() || type2 instanceof OCObjectType || expression2.getQualifyingTokenKind() == OCTokenTypes.DOT && type2.isPointerToObject())) {
            this.addErrorAnnotation(expression2.getQualifier(), "err_typecheck_member_reference_struct_union", "Structure type required instead of '" + type2.getName(expression2) + "'");
            return;
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        expression2.processTargets(expression2.getSymbolName(), (Processor<OCSymbol>)finder, false, null, true, false, null);
        OCSymbol symbol = (OCSymbol)finder.getFoundValue();
        if (symbol == null) {
            expression2.processTargets(expression2.getSymbolName(), (Processor<OCSymbol>)finder, true, null, true, false, null);
            symbol = (OCSymbol)finder.getFoundValue();
            if (symbol != null) {
                OCFileSymbols.markSymbolAsUsed(file2, symbol, expression2);
                boolean isStatic = symbol instanceof OCMemberSymbol && ((OCMemberSymbol)symbol).isStatic();
                String message3 = isStatic ? "Class " + symbol.getNameWithKindLowercase() + " is accessed from the instance context" : "Instance " + symbol.getNameWithKindLowercase() + " is accessed from the class context";
                Annotation annotation = this.addErrorAnnotation(expression2, OCInspections.StaticnessMismatch.class, "CIDR", message3);
                OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)expression2, (Class[])new Class[]{OCMethod.class});
                OCExpression qualifier = expression2.getQualifier();
                if (symbol instanceof OCMethodSymbol) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction((OCMethodSymbol)symbol, !isStatic));
                }
                if (containingMethod != null && qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).getSelfSuperToken() != null) {
                    this.registerQuickFix(annotation, new OCChangeMethodStaticnessIntentionAction((OCMethodSymbol)containingMethod.getSymbol(), isStatic));
                }
            }
        } else {
            OCFileSymbols.markSymbolAsUsed(file2, symbol, expression2);
            this.checkFieldVisibility(symbol, expression2, type2);
        }
    }

    public boolean checkFieldVisibility(OCSymbol field, PsiElement element, @Nullable OCType qualifierType) {
        String subjectName;
        if (!(field instanceof OCSymbolWithQualifiedName) && !(field instanceof OCInstanceVariableSymbol)) {
            return true;
        }
        OCSymbolWithParent symbol = (OCSymbolWithParent)field;
        OCVisibility declaredVisibility = OCVisibility.getDeclaredVisibility(symbol);
        String string = subjectName = symbol instanceof OCFunctionSymbol ? ((OCFunctionSymbol)symbol).getSignatureWithoutParamNames(true, false) : symbol.getNameWithParent();
        if (field instanceof OCFunctionSymbol && ((OCFunctionSymbol)field).isDelete()) {
            Annotation annotation = this.addErrorAnnotation(element, OCInspections.MemberVisibility.class, "err_ovl_deleted_member_call", "'" + subjectName + "' is deleted");
            Object funElement = symbol.locateDefinition();
            if (funElement instanceof OCDeclarator) {
                ASTNode deleteKeyword = (ASTNode)ContainerUtil.find((Object[])funElement.getNode().getChildren(null), node -> node.getElementType() == OCTokenTypes.DELETE_CPP_KEYWORD);
                if (deleteKeyword != null) {
                    this.registerQuickFix(annotation, new OCChangeTextIntentionAction(deleteKeyword.getPsi().getContainingFile(), deleteKeyword.getStartOffset(), deleteKeyword.getTextLength(), "default", "Make " + field.getNameWithKindLowercase() + " default"));
                }
                this.registerQuickFix(annotation, new OCSafeDeleteIntentionAction((PsiElement)funElement, field.getNameWithKindLowercase() + " declaration"));
            }
            return false;
        }
        if (declaredVisibility == null) {
            return true;
        }
        OCVisibility visibility = OCVisibility.getVisibility(symbol, element, qualifierType);
        if (visibility.ordinal() >= declaredVisibility.ordinal()) {
            return true;
        }
        Annotation annotation = this.addErrorAnnotation(element, OCInspections.MemberVisibility.class, "err_access", (Object)((Object)declaredVisibility) + " '" + subjectName + "' is inaccessible");
        if (visibility.ordinal() >= OCVisibility.PUBLIC.ordinal()) {
            this.registerQuickFix(annotation, new OCChangeVisibilityIntentionAction(symbol, OCVisibility.PUBLIC));
        }
        if (symbol instanceof OCInstanceVariableSymbol) {
            this.registerQuickFix(annotation, new OCChangeVisibilityIntentionAction(symbol, OCVisibility.PACKAGE));
        }
        if (visibility.ordinal() >= OCVisibility.PROTECTED.ordinal()) {
            this.registerQuickFix(annotation, new OCChangeVisibilityIntentionAction(symbol, OCVisibility.PROTECTED));
            if (symbol instanceof OCInstanceVariableSymbol) {
                OCInterfaceSymbol intfSymbol;
                OCImplementation clazz = (OCImplementation)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCImplementation.class});
                OCImplementationSymbol implSymbol = clazz.getSymbol();
                OCInterfaceSymbol oCInterfaceSymbol = intfSymbol = implSymbol != null ? implSymbol.getInterface() : null;
                if (implSymbol != null) {
                    this.registerQuickFix(annotation, new OCMoveDefinitionIntentionAction(symbol.getKind(), element, intfSymbol, symbol));
                }
            }
        }
        return false;
    }

    public void checkReturnStatement(OCReturnStatement stmt) {
        OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCCallable.class});
        OCExpression expr = stmt.getExpression();
        String callableKind = "function/method/block";
        if (callable == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "CIDRillegal_return", "Return statement is outside of a " + callableKind + " declaration");
            return;
        }
        OCSymbol symbol = callable.getSymbol();
        OCType unresolvedReturnType = callable.getReturnType();
        OCType returnType = unresolvedReturnType.resolve(stmt.getContainingFile());
        if (symbol != null) {
            callableKind = symbol.getKindLowercase();
            if (symbol.getKind().isConstructorOrDestructor()) {
                returnType = OCVoidType.instance();
            }
        }
        if (expr == null) {
            if (!(returnType instanceof OCVoidType)) {
                String message2 = "Returning 'void' from a " + callableKind + " returning '" + returnType.getName(stmt) + "'";
                Annotation annotation = this.addErrorAnnotation(stmt, OCInspections.IncompatibleTypes.class, "ext_return_missing_expr", message2);
                if (symbol != null) {
                    this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, (OCType)OCVoidType.instance(), true));
                }
            }
            return;
        }
        OCType rType = expr.getResolvedType().getGuessedType();
        if (returnType instanceof OCUnknownType || returnType instanceof OCAutoType) {
            if (unresolvedReturnType instanceof OCAutoType) {
                symbol = ((OCAutoType)unresolvedReturnType).getExpressionSymbol();
            }
            if (symbol instanceof OCLambdaExpressionSymbol) {
                OCType firstReturnType;
                OCResolveContext context = new OCResolveContext(stmt);
                OCExpressionSymbol returnExpr = (OCExpressionSymbol)ContainerUtil.getFirstItem(((OCLambdaExpressionSymbol)symbol).getReturnExpressions());
                OCType oCType = firstReturnType = returnExpr != null ? returnExpr.getResolvedType(context) : null;
                if (firstReturnType != null && !firstReturnType.isMagicInside(context) && !new OCTypeEqualityVisitor(rType, true, false, false, false, false, true, false, context).equal(firstReturnType)) {
                    this.addErrorAnnotation(stmt, OCInspections.IncompatibleTypes.class, "err_auto_fn_different_deductions", "'auto' return type was previously deduced as '" + firstReturnType.getName(stmt) + "' but here as '" + rType.getName(stmt) + "'");
                }
                return;
            }
        }
        String message3 = "Returning '" + rType.getName(stmt) + "' from a " + callableKind + " returning '" + returnType.getName(stmt) + "'";
        if (returnType instanceof OCVoidType && !(rType instanceof OCVoidType) && !(rType instanceof OCMagicType)) {
            Annotation annotation = this.addErrorAnnotation(stmt, OCInspections.IncompatibleTypes.class, "ext_return_has_expr", message3);
            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, rType, true));
        } else {
            this.checkAssignment(expr, (PsiElement)stmt, returnType, rType, symbol, message3 + ": ");
        }
    }

    public void checkSwitchStatement(OCSwitchStatement stmt) {
        List<Object> missingCases;
        boolean isEnumClass;
        OCType type2;
        OCDeclarationOrExpression expr = stmt.getExpression();
        OCStatement body2 = stmt.getBody();
        ArrayList<Pair<Integer, Integer>> ranges = new ArrayList<Pair<Integer, Integer>>();
        boolean wasDefaultOrUnresolved = true;
        Ref wasField = Ref.create((Object)false);
        OCType oCType = type2 = expr != null ? expr.getResolvedType() : null;
        if (type2 instanceof OCCppReferenceType) {
            type2 = ((OCCppReferenceType)type2).getRefType();
        }
        boolean bl = isEnumClass = type2 instanceof OCStructType && ((OCStructType)type2).isEnumClass();
        if (body2 != null) {
            ArrayList<OCCaseStatement> caseStmts = new ArrayList<OCCaseStatement>();
            wasDefaultOrUnresolved = OCCreateMissingSwitchCasesIntentionAction.findCaseStatements(body2, ranges, caseStmts);
            missingCases = OCCreateMissingSwitchCasesIntentionAction.getMissingCases(stmt, ranges, (Ref<Boolean>)wasField);
            final Ref wasDefault = Ref.create((Object)false);
            body2.accept(new OCRecursiveVisitor(){

                @Override
                public void visitCaseStatement(OCCaseStatement stmt) {
                    Annotation annotation;
                    super.visitCaseStatement(stmt);
                    OCStatement statement2 = stmt.getStatement();
                    if (statement2 == null) {
                        OCOperatorsChecker.this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Statement is expected");
                    } else if (statement2 instanceof OCDeclarationStatement && OCCodeInsightUtil.isInPlainOldC(stmt)) {
                        annotation = OCOperatorsChecker.this.addErrorAnnotation(statement2, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Declaration is not allowed here");
                        OCOperatorsChecker.this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)statement2, "Remove statement"));
                    }
                    if (stmt.isDefault()) {
                        if (((Boolean)wasDefault.get()).booleanValue()) {
                            OCOperatorsChecker.this.addErrorAnnotation(stmt, OCInspections.DuplicateSwitchCase.class, "err_multiple_default_labels_defined", "Duplicate default label");
                        } else {
                            if (missingCases.isEmpty() && isEnumClass) {
                                annotation = OCOperatorsChecker.this.addWarningAnnotation(stmt, OCInspections.DuplicateSwitchCase.class, "CIDR", "Default case is useless: all cases are covered");
                                OCOperatorsChecker.this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)stmt, "Remove statement"));
                            }
                            wasDefault.set((Object)true);
                        }
                    }
                }

                @Override
                public void visitSwitchStatement(OCSwitchStatement stmt) {
                }
            });
            block0: for (int i2 = 0; i2 < ranges.size(); ++i2) {
                Pair range = (Pair)ranges.get(i2);
                OCCaseStatement caseStatement = (OCCaseStatement)caseStmts.get(i2);
                for (Pair pair : ranges) {
                    if (range == pair || Math.max((Integer)range.getFirst(), (Integer)pair.getFirst()) > Math.min((Integer)range.getSecond(), (Integer)pair.getSecond())) continue;
                    String message2 = ((Integer)range.getFirst()).equals(range.getSecond()) ? "Duplicate case value" : "Overlapping case range";
                    this.addErrorAnnotation(caseStatement, OCInspections.DuplicateSwitchCase.class, "err_duplicate_case", message2);
                    continue block0;
                }
            }
        } else {
            missingCases = Collections.emptyList();
        }
        if (expr != null) {
            if (!(type2.isUnknown() || type2.isIntegerCompatible(expr) || type2 instanceof OCStructType && ((OCStructType)type2).isEnumClass())) {
                String message3 = "Integer expression is required in switch instead of '" + type2.getName(stmt) + "'";
                Annotation annotation = this.addErrorAnnotation(stmt, OCInspections.IntegerTypeRequired.class, "err_typecheck_statement_requires_integer", message3);
                OCExpression expression2 = expr.getExpression();
                if (expression2 != null) {
                    this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(expression2, OCIntType.CHAR));
                }
            }
            if (!wasDefaultOrUnresolved) {
                Annotation annotation;
                if (!(type2.getTerminalType() instanceof OCStructType || ((Boolean)wasField.get()).booleanValue() || type2.isUnknown())) {
                    annotation = this.addWarningAnnotation(stmt.getSwitchToken(), OCInspections.MissingSwitchCase.class, "CIDRmissing_default_case", "Default case is not handled");
                    this.registerQuickFix(annotation, new OCCreateMissingSwitchCasesFix(stmt, true));
                }
                if (!missingCases.isEmpty()) {
                    annotation = this.addWarningAnnotation(stmt.getSwitchToken(), OCInspections.MissingSwitchCase.class, OCClangMessageFinder.getInstance().getMissingCase(), "Not all switch cases were handled");
                    this.registerQuickFix(annotation, new OCCreateMissingSwitchCasesFix(stmt, false));
                }
            }
        }
    }
}

