/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class OCTooManyErrorsHighligher
extends TextEditorHighlightingPass
implements DumbAware {
    public static final Key<Boolean> ERRORS_KEY = Key.create((String)"PARSING_ERRORS");
    private final OCFile myFile;
    private Collection<HighlightInfo> myInfos = Collections.emptyList();

    public OCTooManyErrorsHighligher(PsiFile file2, Document document) {
        super(file2.getProject(), document);
        this.myFile = file2 instanceof OCFile ? (OCFile)file2 : null;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        this.myInfos = Collections.emptyList();
        if (this.myFile == null) {
            return;
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        Boolean errors = (Boolean)this.myFile.getUserData(ERRORS_KEY);
        if (errors != null && errors.booleanValue()) {
            infos.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(this.myFile.getTextRange()).fileLevelAnnotation().description("Too many errors while parsing.  Code insight features are disabled for this file.").create());
        }
        this.myInfos = infos;
        if (this.myFile.getVirtualFile() == null) {
            return;
        }
        OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(this.myFile.getVirtualFile(), this.myProject);
        if (rootAndConfiguration.getConfiguration() == null || rootAndConfiguration.getRootFile() == null) {
            return;
        }
        VirtualFile rootFile = rootAndConfiguration.getRootFile();
        if (OCInclusionContextUtil.isNeedToFindRoot(rootFile, this.myProject)) {
            HashSet<OCFile> visited;
            int maxInclusionDepth = OCInclusionContext.getMaxInclusionLevel(this.myProject);
            if (OCTooManyErrorsHighligher.hasIncludeWithParseError(this.myFile, 0, maxInclusionDepth, visited = new HashSet<OCFile>())) {
                infos.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(this.myFile.getTextRange()).fileLevelAnnotation().description("At least one transitively included file could not be parsed due to too many errors").create());
            }
        } else if (OCTooManyErrorsHighligher.hasIncludeWithParseErrorViaImportGraph(this.myProject, rootAndConfiguration.getConfiguration(), rootFile, progress)) {
            infos.add(HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(this.myFile.getTextRange()).fileLevelAnnotation().description("At least one transitively included file could not be parsed due to too many errors").create());
        }
        this.myInfos = infos;
    }

    private static boolean hasIncludeWithParseError(OCFile file2, int currentDepth, int maxDepth, Set<OCFile> visited) {
        if (file2 == null) {
            return false;
        }
        if (currentDepth >= maxDepth) {
            return false;
        }
        List includedFiles = file2.findIncludeDirectives().stream().map(directive -> (OCFile)directive.getIncludedFile()).filter(Objects::nonNull).filter(included -> !visited.contains(included)).collect(Collectors.toList());
        for (OCFile included2 : includedFiles) {
            visited.add(included2);
            Boolean error = (Boolean)included2.getUserData(ERRORS_KEY);
            if (error == null || !error.booleanValue()) continue;
            return true;
        }
        for (OCFile included2 : includedFiles) {
            if (!OCTooManyErrorsHighligher.hasIncludeWithParseError(included2, currentDepth + 1, maxDepth, visited)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasIncludeWithParseErrorViaImportGraph(Project project2, OCResolveConfiguration resolveConfiguration, VirtualFile rootSource, ProgressIndicator progress) {
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Set<VirtualFile> headersFromRoot = OCImportGraph.getAllRootHeaders(resolveConfiguration, rootSource, progress);
        for (VirtualFile includedFile : headersFromRoot) {
            Boolean error;
            PsiFile included;
            if (includedFile.equals(rootSource) || (included = psiManager.findFile(includedFile)) == null || (error = (Boolean)included.getUserData(ERRORS_KEY)) == null || !error.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doApplyInformationToEditor() {
        if (this.myDocument != null) {
            UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myDocument.getTextLength(), this.myInfos, this.getColorsScheme(), this.getId());
        }
    }
}

