/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class OCClangMessageDescriptor {
    public static final String EMPTY_CATEGORY = "Empty Category";
    public static final String EMPTY_GROUP = "Empty Group";
    private String myID;
    private OCClangMessageKind myKind;
    private String myCategory;
    private String myGroup;
    private Pattern myPattern;
    private int myWordsCnt;

    OCClangMessageDescriptor(String ID2, OCClangMessageKind kind2, String category, String group, Pattern pattern, int wordsCnt) {
        this.myID = ID2;
        this.myKind = kind2;
        this.myCategory = category;
        this.myGroup = group;
        this.myPattern = pattern;
        this.myWordsCnt = wordsCnt;
    }

    public String getID() {
        return this.myID;
    }

    public OCClangMessageKind getKind() {
        return this.myKind;
    }

    public String getCategory() {
        return this.myCategory;
    }

    public String getGroup() {
        return this.myGroup;
    }

    @Nullable
    public OCSuppressionGroup getSuppressionGroup() {
        return this.myGroup != null && !this.myGroup.equals(EMPTY_GROUP) ? new OCSuppressionGroup("clang", "-W" + this.myGroup) : null;
    }

    public Pattern getPattern() {
        return this.myPattern;
    }

    public int getWordsCnt() {
        return this.myWordsCnt;
    }

    public static enum OCClangMessageKind {
        Warning,
        Error,
        ExtWarn,
        Extension,
        Note,
        Remark;

    }
}

