/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageDescriptor;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionToolProvider;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCClangMessageFinder {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder");
    protected static final String MESSAGES_FILE = "all-messages.txt";
    protected static final String SUPPORTED_IDS_FILE = "supported-ids.txt";
    private static final String[] myHardcodedMessages = new String[]{"expanded from macro '.*'", "arithmetic on pointer to .*, which is not a constant size in non-fragile ABI", "collection expression type '.*' is not a valid object"};
    private final List<OCClangMessageDescriptor> myDescriptors = new ArrayList<OCClangMessageDescriptor>();
    private final Map<String, OCClangMessageDescriptor> myDescriptorsMap = new HashMap();
    private final Map<String, IntArrayList> myWordsIndex = new HashMap();
    private final Set<String> mySupportedIDs;
    private final int myClangVersion;

    @NotNull
    public static OCClangMessageFinder getInstance() {
        return (OCClangMessageFinder)ServiceManager.getService(OCClangMessageFinder.class);
    }

    @NotNull
    public String getMethodNotImplemented() {
        return this.myClangVersion >= 50 || this.myClangVersion == -1 ? "warn_undef_method_impl" : "warn_incomplete_impl";
    }

    @NotNull
    public String getUsageOfArcObjectInStruct() {
        return this.myClangVersion >= 50 || this.myClangVersion == -1 ? "err_arc_objc_object_in_tag" : "err_arc_objc_object_in_struct";
    }

    @NotNull
    public String getMissingCase() {
        return this.myClangVersion >= 70 || this.myClangVersion == -1 ? "warn_missing_case" : "warn_missing_cases";
    }

    @NotNull
    public String getConditionShouldBeScalar() {
        return this.myClangVersion >= 70 || this.myClangVersion == -1 ? "err_typecheck_cond_expect_scalar" : "err_typecheck_cond_expect_scalar_or_vector";
    }

    @NotNull
    public String getInvalidIntSuffix() {
        return this.myClangVersion >= 73 || this.myClangVersion == -1 ? "err_invalid_suffix_constant" : "err_invalid_suffix_integer_constant";
    }

    @NotNull
    public String getInvalidFloatSuffix() {
        return this.myClangVersion >= 73 || this.myClangVersion == -1 ? "err_invalid_suffix_constant" : "err_invalid_suffix_float_constant";
    }

    @NotNull
    public String getReturnStackAddr() {
        return this.myClangVersion >= 73 || this.myClangVersion == -1 ? "warn_ret_stack_addr_ref" : "warn_ret_stack_addr";
    }

    @NotNull
    public String getReturnTempAddr() {
        return this.myClangVersion >= 73 || this.myClangVersion == -1 ? "warn_ret_local_temp_addr_ref" : "warn_ret_local_temp_addr";
    }

    @NotNull
    public String getObjcThrowExpectsObject() {
        return this.myClangVersion >= 81 || this.myClangVersion == -1 ? "err_objc_throw_expects_object" : "error_objc_throw_expects_object";
    }

    @NotNull
    public String getRethrowUsedOutsideCatch() {
        return this.myClangVersion >= 81 || this.myClangVersion == -1 ? "err_rethrow_used_outside_catch" : "error_rethrow_used_outside_catch";
    }

    @NotNull
    public String getSynthesizeCategoryDecl() {
        return this.myClangVersion >= 81 || this.myClangVersion == -1 ? "err_synthesize_category_decl" : "error_synthesize_category_decl";
    }

    @NotNull
    public String getCategoryProperty() {
        return this.myClangVersion >= 81 || this.myClangVersion == -1 ? "err_category_property" : "error_category_property";
    }

    @NotNull
    public String getIvarInSuperclassUse() {
        return this.myClangVersion >= 81 || this.myClangVersion == -1 ? "err_ivar_in_superclass_use" : "error_ivar_in_superclass_use";
    }

    @NotNull
    public String getDuplicateIvarUse() {
        return this.myClangVersion >= 81 || this.myClangVersion == -1 ? "err_duplicate_ivar_use" : "error_duplicate_ivar_use";
    }

    @NotNull
    public String getPropertyImplemented() {
        return this.myClangVersion >= 81 || this.myClangVersion == -1 ? "err_property_implemented" : "error_property_implemented";
    }

    @NotNull
    public String getWeakProperty() {
        return this.myClangVersion >= 81 || this.myClangVersion == -1 ? "err_weak_property" : "error_weak_property";
    }

    @NotNull
    public String getIvarUseInClassMethod() {
        return this.myClangVersion >= 81 || this.myClangVersion == -1 ? "err_ivar_use_in_class_method" : "error_ivar_use_in_class_method";
    }

    public OCClangMessageFinder() {
        HashSet<String> categoryNames = new HashSet<String>();
        int line = 0;
        try {
            OCAnnotatorHelper helper;
            for (Class<?> inspectionClass : OCInspections.class.getDeclaredClasses()) {
                if (!OCInspectionToolProvider.getInstance().isClangCompilerInspection(inspectionClass)) continue;
                categoryNames.add(((OCInspection)((Object)inspectionClass.newInstance())).getDisplayName());
            }
            int clangVersion = -1;
            OCAnnotatorHelper[] oCAnnotatorHelperArray = OCAnnotator.getAnnotatorHelpers();
            int n = oCAnnotatorHelperArray.length;
            for (int inspectionClass = 0; inspectionClass < n && (clangVersion = (helper = oCAnnotatorHelperArray[inspectionClass]).getClangVersion()) == -1; ++inspectionClass) {
            }
            this.myClangVersion = clangVersion;
            String clangVersionPrefix = "apple81/";
            if (this.myClangVersion == 60) {
                clangVersionPrefix = "apple60/";
            } else if (this.myClangVersion == 61) {
                clangVersionPrefix = "apple61/";
            } else if (this.myClangVersion == 70) {
                clangVersionPrefix = "apple70/";
            } else if (this.myClangVersion == 73) {
                clangVersionPrefix = "apple73/";
            } else if (this.myClangVersion == 80) {
                clangVersionPrefix = "apple80/";
            } else if (this.myClangVersion == 81) {
                clangVersionPrefix = "apple81/";
            } else if (this.myClangVersion != -1) {
                LOG.warn("Unhandled clang version: " + this.myClangVersion);
            }
            String text = FileUtil.loadTextAndClose((InputStream)this.getClass().getResource(clangVersionPrefix + MESSAGES_FILE).openStream());
            String[] lines = StringUtil.splitByLines((String)text);
            while (line < lines.length) {
                OCClangMessageDescriptor.OCClangMessageKind kind2;
                ProgressManager.checkCanceled();
                String[] id = lines[line++];
                String kindString = lines[line++];
                try {
                    kind2 = OCClangMessageDescriptor.OCClangMessageKind.valueOf(kindString);
                }
                catch (IllegalArgumentException e) {
                    kind2 = OCClangMessageDescriptor.OCClangMessageKind.Warning;
                    LOG.error("Unknown message kind: " + kindString);
                }
                String category = lines[line++];
                String group = lines[line++];
                String regex = lines[line++];
                this.addDescriptor((String)id, kind2, category, group, regex.toLowerCase(), categoryNames);
            }
            LOG.assertTrue(line == lines.length, (Object)"Not all lines have been read");
            text = FileUtil.loadTextAndClose((InputStream)this.getClass().getResource(clangVersionPrefix + SUPPORTED_IDS_FILE).openStream());
            this.mySupportedIDs = new HashSet<String>();
            for (String id : StringUtil.splitByLines((String)text)) {
                if (id.startsWith("//") || id.isEmpty()) continue;
                id = id.trim();
                this.mySupportedIDs.add(id);
                if (this.myDescriptorsMap.containsKey(id)) continue;
                LOG.error("--------------------\n\nCan't find Clang message \"" + id + "\"\n", (Throwable)null);
            }
            int index = 0;
            for (String regex : myHardcodedMessages) {
                ProgressManager.checkCanceled();
                String id = "__hardcoded_" + index++;
                this.addDescriptor(id, OCClangMessageDescriptor.OCClangMessageKind.Error, "Empty Category", "Empty Group", regex.toLowerCase(), categoryNames);
                this.mySupportedIDs.add(id);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error("Error reading messages, line " + line, (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error("Can't read messages file", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void addDescriptor(String id, OCClangMessageDescriptor.OCClangMessageKind kind2, String category, String group, String regex, Set<String> categoryNames) {
        if (regex.trim().equals(".*")) {
            return;
        }
        if (!categoryNames.contains(category)) {
            LOG.error("--------------------\n\nUnknown message category: " + category + "\n", (Throwable)null);
        }
        Pattern pattern = Pattern.compile(regex);
        for (String word : StringUtil.getWordsIn((String)regex)) {
            IntArrayList list = this.myWordsIndex.get(word);
            if (list == null) {
                list = new IntArrayList();
                this.myWordsIndex.put(word, list);
            }
            list.add(this.myDescriptors.size());
        }
        OCClangMessageDescriptor descriptor = new OCClangMessageDescriptor(id, kind2, OCNamesInternary.intern(category), group, pattern, OCClangMessageFinder.getWordsInPatternCnt(regex));
        this.myDescriptors.add(descriptor);
        this.myDescriptorsMap.put(descriptor.getID(), descriptor);
    }

    private static int getWordsInPatternCnt(String regex) {
        int parLevel = 0;
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < regex.length(); ++i2) {
            char c = regex.charAt(i2);
            if (c == '(' && (i2 <= 0 || regex.charAt(i2 - 1) != '\\')) {
                ++parLevel;
                continue;
            }
            if (c == ')' && (i2 <= 0 || regex.charAt(i2 - 1) != '\\')) {
                --parLevel;
                continue;
            }
            if (parLevel != 0) continue;
            builder.append(c);
        }
        return StringUtil.getWordsIn((String)builder.toString()).size();
    }

    public boolean isMessageIDSupported(String id) {
        return this.mySupportedIDs.contains(id);
    }

    public OCClangMessageDescriptor findMessageDescriptor(String message2) {
        return new Finder(message2).find();
    }

    @Nullable
    public OCClangMessageDescriptor getSupportedMessageDescriptor(@NotNull String id) {
        OCClangMessageDescriptor descriptor = this.myDescriptorsMap.get(id);
        if (descriptor == null) {
            LOG.error("Can't find clang message " + id);
        }
        if (!this.isMessageIDSupported(id)) {
            LOG.error("Clang message " + id + " is not marked as supported");
        }
        return descriptor;
    }

    private class Finder {
        private String myString;
        private List<String> myWords;

        Finder(String string) {
            this.myString = string.toLowerCase();
            this.myWords = StringUtil.getWordsIn((String)this.myString);
        }

        private OCClangMessageDescriptor find() {
            TIntHashSet allSet = new TIntHashSet(OCClangMessageFinder.this.myDescriptors.size());
            for (int i2 = 0; i2 < OCClangMessageFinder.this.myDescriptors.size(); ++i2) {
                allSet.add(i2);
            }
            if (!this.myWords.isEmpty()) {
                Integer variant = this.process(0, allSet, 0);
                if (variant != null) {
                    return (OCClangMessageDescriptor)OCClangMessageFinder.this.myDescriptors.get(variant);
                }
            } else {
                LOG.warn("No words found in the message \"" + this.myString + "\"");
            }
            return null;
        }

        @Nullable
        private Integer process(int wordIdx, TIntHashSet possiblePatterns, int wordsIncluded) {
            if (wordIdx < this.myWords.size()) {
                Integer result2;
                TIntHashSet newVariants = new TIntHashSet(possiblePatterns.toArray());
                IntArrayList list = (IntArrayList)OCClangMessageFinder.this.myWordsIndex.get(this.myWords.get(wordIdx));
                if (list != null) {
                    newVariants.retainAll(list.toArray());
                } else {
                    newVariants.clear();
                }
                if (!newVariants.isEmpty() && (result2 = this.process(wordIdx + 1, newVariants, wordsIncluded + 1)) != null) {
                    return result2;
                }
                result2 = this.process(wordIdx + 1, possiblePatterns, wordsIncluded);
                if (result2 != null) {
                    return result2;
                }
            } else {
                TIntIterator iterator = possiblePatterns.iterator();
                while (iterator.hasNext()) {
                    if (((OCClangMessageDescriptor)OCClangMessageFinder.this.myDescriptors.get(iterator.next())).getWordsCnt() <= wordsIncluded) continue;
                    iterator.remove();
                }
                if (possiblePatterns.size() > 30) {
                    LOG.error("Too many possible patterns for \"" + this.myString + "\"");
                    return null;
                }
                for (int variant : possiblePatterns) {
                    if (!((OCClangMessageDescriptor)OCClangMessageFinder.this.myDescriptors.get(variant)).getPattern().matcher(this.myString).matches()) continue;
                    return variant;
                }
            }
            return null;
        }
    }
}

