/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public class OCClangMessagesParser {
    private File myClangDir;
    private String myFileName;
    private StringBuilder myBuilder;
    private StreamTokenizer myTokenizer;
    private Stack<String> myCategories;
    private Set<String> mySupportedIDs;
    private Map<String, String> myDiagnosticGroups;
    private boolean myVerifyIDsMode;
    protected static final String SUPPORTED_IDS_FILE = "supported-ids.txt";

    private void parse(String text) throws IOException {
        if (this.myVerifyIDsMode) {
            this.mySupportedIDs = new HashSet<String>();
            String supp = FileUtil.loadFile((File)new File(this.myClangDir, SUPPORTED_IDS_FILE));
            for (String id : StringUtil.split((String)supp, (String)"\n")) {
                if (id.startsWith("//") || id.isEmpty()) continue;
                this.mySupportedIDs.add(id.trim());
            }
        }
        if (this.myDiagnosticGroups == null) {
            this.myDiagnosticGroups = new HashMap<String, String>();
        }
        this.myTokenizer = new StreamTokenizer(new StringReader(text));
        this.myTokenizer.wordChars(95, 95);
        this.myCategories = new Stack();
        this.myCategories.push("Empty Category");
        this.myTokenizer.nextToken();
        while (this.myTokenizer.ttype != -1) {
            if (this.parseLet() || this.parseDef()) continue;
            this.error("Let or def expected");
        }
    }

    private boolean parseLet() throws IOException {
        if (!"let".equals(this.getCurWord())) {
            return false;
        }
        this.skipWord();
        String key2 = this.skipWord();
        this.expectToken('=');
        String value2 = this.skipQuotedWord();
        while (this.myTokenizer.ttype == 44) {
            this.expectToken(',');
            key2 = this.skipWord();
            this.expectToken('=');
            value2 = this.skipQuotedWord();
        }
        this.expectWord("in");
        this.expectToken('{');
        if ("CategoryName".equals(key2)) {
            this.myCategories.push(value2);
        }
        while (this.parseLet() || this.parseDef()) {
        }
        if ("CategoryName".equals(key2)) {
            this.myCategories.pop();
        }
        this.expectToken('}');
        return true;
    }

    private boolean parseDef() throws IOException {
        int prefixChar = 0;
        if (this.myVerifyIDsMode) {
            if (this.myTokenizer.ttype == 42) {
                prefixChar = 42;
                this.expectToken('*');
            } else if (this.myTokenizer.ttype == 45) {
                prefixChar = 45;
                this.expectToken('-');
            } else {
                this.error("Def is not prefixed");
            }
        }
        if (!"def".equals(this.getCurWord())) {
            return false;
        }
        this.skipWord();
        String id = null;
        if (this.myTokenizer.ttype != 58) {
            id = this.skipWord();
        }
        this.expectToken(':');
        String kind2 = this.skipWord();
        this.expectToken('<');
        if (this.myVerifyIDsMode && id != null) {
            if (prefixChar == 42 && !this.mySupportedIDs.contains(id)) {
                throw new IOException(id + " is wrongly marked as *");
            }
            if ((prefixChar == 45 || prefixChar == 0) && this.mySupportedIDs.contains(id)) {
                throw new IOException(id + " is not marked as *");
            }
        }
        StringBuilder message2 = new StringBuilder();
        while (this.myTokenizer.ttype == 34 || this.myTokenizer.ttype == -3) {
            message2.append(this.myTokenizer.sval);
            this.myTokenizer.nextToken();
        }
        if (this.myTokenizer.ttype == 44) {
            this.expectToken(',');
            this.expectToken('[');
            this.skipWord();
            while (this.myTokenizer.ttype == 44) {
                this.expectToken(',');
                this.skipWord();
            }
            this.expectToken(']');
        }
        this.expectToken('>');
        String group = "Empty Group";
        while (this.myTokenizer.ttype == 44) {
            this.expectToken(',');
            Object option = this.parseOption();
            if (!(option instanceof Pair) || !"InGroup".equals(((Pair)option).first)) continue;
            Object value2 = ((Pair)option).second;
            if (value2 instanceof String) {
                if (this.myDiagnosticGroups.containsKey((String)value2)) {
                    group = this.myDiagnosticGroups.get((String)value2);
                    continue;
                }
                this.error("No value for diagnostic group " + value2);
                continue;
            }
            if (value2 instanceof Pair && "DiagGroup".equals(((Pair)value2).first)) {
                value2 = ((Pair)value2).second;
                if (value2 instanceof String) {
                    group = (String)value2;
                    continue;
                }
                this.error("No value for option InGroup");
                continue;
            }
            this.error("No value for option InGroup");
        }
        this.expectToken(';');
        if (id != null) {
            if ("DiagGroup".equals(kind2)) {
                this.myDiagnosticGroups.put(id, message2.toString());
            } else {
                this.processMessageType(id, kind2, this.myCategories.peek(), group, message2);
            }
        }
        return true;
    }

    @Nullable
    private Object parseOption() throws IOException {
        Object optionValue = null;
        String option = this.myTokenizer.ttype == 34 ? this.skipQuotedWord() : this.skipWord();
        if (this.myTokenizer.ttype == 60) {
            this.expectToken('<');
            optionValue = this.parseOption();
            this.expectToken('>');
        }
        if (optionValue != null) {
            return Pair.create((Object)option, optionValue);
        }
        return option;
    }

    private void processMessageType(String id, String kind2, String category, String group, StringBuilder message2) {
        this.myBuilder.append(id).append("\n").append(kind2).append("\n");
        this.myBuilder.append(category).append("\n").append(group).append("\n").append(OCClangMessagesParser.convertPattern(message2.toString())).append("\n");
    }

    public static String convertPattern(String rawMessage) {
        return new Parser(rawMessage).parse();
    }

    private String getCurWord() throws IOException {
        if (this.myTokenizer.ttype == -3) {
            return this.myTokenizer.sval;
        }
        return "";
    }

    private String skipWord() throws IOException {
        if (this.myTokenizer.ttype == -3) {
            String sval = this.myTokenizer.sval;
            this.myTokenizer.nextToken();
            return sval;
        }
        throw new IOException("Expected word at " + this.myFileName + ":" + this.myTokenizer.lineno());
    }

    private String skipQuotedWord() throws IOException {
        if (this.myTokenizer.ttype == 34) {
            String sval = this.myTokenizer.sval;
            this.myTokenizer.nextToken();
            return sval;
        }
        throw new IOException("Expected quoted word at " + this.myFileName + ":" + this.myTokenizer.lineno());
    }

    private void expectWord(String wordText) throws IOException {
        if (this.myTokenizer.ttype != -3 || !wordText.equals(this.myTokenizer.sval)) {
            throw new IOException("Expected '" + wordText + "' at " + this.myFileName + ":" + this.myTokenizer.lineno());
        }
        this.myTokenizer.nextToken();
    }

    private void expectToken(char token) throws IOException {
        if (this.myTokenizer.ttype != token) {
            throw new IOException("Expected '" + token + "' at " + this.myFileName + ":" + this.myTokenizer.lineno());
        }
        this.myTokenizer.nextToken();
    }

    private void error(String message2) throws IOException {
        throw new IOException(message2 + "' at " + this.myFileName + ":" + this.myTokenizer.lineno());
    }

    private void generatePatterns(File clangDirOrFile, boolean verifyIDsMode) throws IOException {
        this.myVerifyIDsMode = verifyIDsMode;
        this.myBuilder = new StringBuilder();
        if (clangDirOrFile.isDirectory()) {
            this.myClangDir = clangDirOrFile;
            File groupsFile = new File(clangDirOrFile, "DiagnosticGroups.td");
            if (groupsFile.exists()) {
                String messages = FileUtil.loadFile((File)groupsFile);
                this.myFileName = groupsFile.getName();
                this.parse(messages);
            }
            for (File file2 : clangDirOrFile.listFiles()) {
                if (!file2.getName().endsWith("Kinds.td")) continue;
                String messages = FileUtil.loadFile((File)file2);
                this.myFileName = file2.getName();
                this.parse(messages);
            }
        } else if (clangDirOrFile.getName().endsWith("td")) {
            this.myClangDir = clangDirOrFile.getParentFile();
            String messages = FileUtil.loadFile((File)clangDirOrFile);
            this.myFileName = clangDirOrFile.getName();
            this.parse(messages);
        }
        File outputFile = new File(this.myClangDir, "all-messages.txt");
        FileUtil.writeToFile((File)outputFile, (String)this.myBuilder.toString());
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 1) {
            File clangDir = new File(args[0]);
            if (!clangDir.exists()) {
                System.err.println(clangDir.getPath() + " does not exist");
                return;
            }
            new OCClangMessagesParser().generatePatterns(clangDir, false);
        } else {
            System.err.println("Usage: <path to .td file or directory with .td files>");
        }
    }

    private static class Parser {
        private final String myMessage;
        private final int myLength;
        private int myIndex;
        private final StringBuilder myResult = new StringBuilder();

        public Parser(String message2) {
            this.myMessage = message2;
            this.myLength = message2.length();
        }

        public String parse() {
            while (this.myIndex < this.myLength) {
                char c;
                if ((c = this.myMessage.charAt(this.myIndex++)) == '%') {
                    this.parseOperatorStart();
                    continue;
                }
                this.appendChar(c);
            }
            return this.myResult.toString();
        }

        private void parseOperatorStart() {
            char c;
            if (this.myIndex < this.myLength && this.myMessage.charAt(this.myIndex) == '%') {
                ++this.myIndex;
                this.myResult.append("%");
                return;
            }
            StringBuilder name = new StringBuilder();
            while (this.myIndex < this.myLength && (Character.isDigit(c = this.myMessage.charAt(this.myIndex)) || Character.isLetter(c))) {
                name.append(c);
                ++this.myIndex;
            }
            String operator2 = name.toString();
            if (operator2.equals("select") || operator2.equals("diff") || operator2.equals("plural")) {
                assert (this.myIndex < this.myLength);
                assert (this.myMessage.charAt(this.myIndex) == '{');
                ++this.myIndex;
                this.myResult.append("(");
                this.parseOperator(operator2.equals("plural"));
            } else {
                this.myResult.append(".*");
            }
        }

        private void parseOperator(boolean plural) {
            boolean startPart = plural;
            while (this.myIndex < this.myLength) {
                char c = this.myMessage.charAt(this.myIndex++);
                if (startPart) {
                    if (Character.isDigit(c) || c == ':') continue;
                    startPart = false;
                }
                if (c == '%') {
                    this.parseOperatorStart();
                    continue;
                }
                if (c == '}') {
                    this.parseOperatorEnd();
                    return;
                }
                if (c == '|') {
                    this.myResult.append("|");
                    startPart = plural;
                    continue;
                }
                this.appendChar(c);
            }
            assert (false);
        }

        private void parseOperatorEnd() {
            char c;
            while (this.myIndex < this.myLength && (Character.isDigit(c = this.myMessage.charAt(this.myIndex)) || c == ',')) {
                ++this.myIndex;
            }
            this.myResult.append(")");
        }

        private void appendChar(char c) {
            if (c == '$') {
                this.myResult.append(".*");
            } else if (c == '(' || c == ')' || c == '+' || c == '*' || c == '?' || c == '.' || c == '[' || c == ']' || c == '{' || c == '}' || c == '|' || c == '\\' || c == '\"') {
                this.myResult.append("\\").append(c);
            } else {
                this.myResult.append(c);
            }
        }
    }
}

