/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.intentions.OCCreateMissingSwitchCasesIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGotoStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.impl.OCAsmStatementPartImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCControlFlowBuilder
extends OCVisitor {
    private OCDataFlowAnalyzer myAnalyzer;
    protected OCControlFlowGraph myGraph;
    private TextRange mySelection;
    private boolean myHasCrossSelectionJumps;
    private boolean myHasTopLevelCaseStatements;
    private List<OCNode> myBreakNodes;
    private List<OCNode> myContinueNodes;
    private Stack<List<OCNode>> myTryThrows;
    private Stack<Ref<OCNode>> myTryFirstCalls;
    private Stack<SwitchInfo> mySwitchStack;
    private Stack<List<PsiElement>> myValuesStack;
    private Map<String, OCNode> myLabeledNodes;
    private MostlySingularMultiMap<String, OCNode> myGotoNodes;
    private int myShortCircuitDepth;
    private static final TokenSet closingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.SEMICOLON, OCTokenTypes.RBRACE}), OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, OCTokenTypes.DIRECTIVES});

    public OCControlFlowBuilder(@Nullable OCDataFlowAnalyzer analyzer, @NotNull OCControlFlowGraph graph, @Nullable TextRange selection) {
        this.myAnalyzer = analyzer;
        this.mySelection = selection;
        this.init(graph);
    }

    protected OCControlFlowBuilder() {
    }

    protected void init(@NotNull OCControlFlowGraph graph) {
        this.myGraph = graph;
        this.myGotoNodes = new MostlySingularMultiMap();
        this.myLabeledNodes = new HashMap<String, OCNode>();
        this.mySwitchStack = new Stack();
        this.myValuesStack = new Stack();
        this.myTryThrows = new Stack();
        this.myTryFirstCalls = new Stack();
        this.myContinueNodes = new ArrayList<OCNode>();
        this.myBreakNodes = new ArrayList<OCNode>();
    }

    public void visitElement(@Nullable PsiElement element) {
        if (element != null) {
            this.getKidIterator(element).acceptAll();
        }
    }

    private KidIterator getKidIterator(@NotNull PsiElement element) {
        ASTNode node = element.getNode();
        final ASTNode firstChild = node != null ? node.getFirstChildNode() : null;
        return new KidIterator(){
            private ASTNode child;
            private boolean initialized;

            @Override
            public void skipLeaves() {
                if (!this.initialized) {
                    this.initialized = true;
                    this.child = firstChild;
                }
                while (!(this.child == null || this.child.getFirstChildNode() != null && this.child.getElementType() != OCElementTypes.OBJC_KEYWORD && OCElementUtil.isElementSignificant(this.child.getPsi()))) {
                    PsiElement psiElement = this.child.getPsi();
                    if (psiElement != null && OCControlFlowBuilder.this.doEnlargeNodes()) {
                        OCNode node = OCControlFlowBuilder.this.myGraph.getLastAddedNode();
                        if (node.isEmpty() && closingTokens.contains(this.child.getElementType())) {
                            OCNode previousNode = OCControlFlowBuilder.this.myGraph.getPreviousNonEmptyNode(node);
                            while (previousNode != null && node.getEndOffset() < previousNode.getEndOffset() && previousNode.getEndOffset() <= psiElement.getTextOffset()) {
                                node = previousNode;
                                previousNode = OCControlFlowBuilder.this.myGraph.getPreviousNonEmptyNode(node);
                            }
                        }
                        node.enlarge(psiElement, psiElement.getParent());
                    }
                    this.child = this.child.getTreeNext();
                }
            }

            @Override
            public void accept(@Nullable PsiElement kid) {
                if (kid == null) {
                    return;
                }
                this.skipLeaves();
                if (this.child != null && kid == this.child.getPsi()) {
                    kid.accept((PsiElementVisitor)OCControlFlowBuilder.this);
                    this.child = this.child.getTreeNext();
                }
            }

            @Override
            public void skip(@Nullable PsiElement kid) {
                if (kid == null) {
                    return;
                }
                this.skipLeaves();
                if (this.child != null && kid == this.child.getPsi()) {
                    this.child = this.child.getTreeNext();
                }
            }

            @Override
            public void acceptAll() {
                this.skipLeaves();
                while (this.child != null) {
                    ProgressManager.checkCanceled();
                    PsiElement element = this.child.getPsi();
                    if (element != null) {
                        element.accept((PsiElementVisitor)OCControlFlowBuilder.this);
                    }
                    this.child = this.child.getTreeNext();
                    this.skipLeaves();
                }
            }

            @Override
            public void finish() {
                this.skipLeaves();
            }
        };
    }

    protected boolean doEnlargeNodes() {
        return true;
    }

    public void processFirstCodeFragment(@NotNull PsiElement codeFragment) {
        this.myTryThrows.push(new ArrayList());
        this.myValuesStack.push(new ArrayList());
        this.addStartNode(this.myGraph.addNode());
        this.processNextCodeFragment(codeFragment);
    }

    public void processNextCodeFragment(@NotNull PsiElement codeFragment) {
        if (codeFragment instanceof OCCallable) {
            this.visitElement(codeFragment);
        } else {
            codeFragment.accept((PsiElementVisitor)this);
        }
    }

    protected void addStartNode(@NotNull OCNode node) {
        this.myGraph.setStartNode(node);
    }

    @Nullable
    protected NodeState addBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues, @Nullable NodeState oldFromState) {
        if (this.myGraph.isSplitNodesAllowed()) {
            fromNode.addBranch(toNode);
        }
        return null;
    }

    @Nullable
    protected NodeState addBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues) {
        return this.addBranch(fromNode, toNode, modifiedValues, null);
    }

    @Nullable
    protected NodeState addUnstructuralBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode) {
        return this.addBranch(fromNode, toNode, null);
    }

    @Nullable
    protected NodeState addBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode) {
        return this.addBranch(fromNode, toNode, null);
    }

    protected OCNode acceptCondition(@Nullable OCElement condition2, @NotNull KidIterator itr, boolean isLoop) {
        itr.accept(condition2);
        itr.skipLeaves();
        return this.myGraph.getLastAddedNode();
    }

    @Nullable
    protected NodeState addConditionalBranch(@NotNull OCElement condition2, boolean branch, @NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues, @Nullable NodeState oldFromState) {
        if (this.myGraph.isSplitNodesAllowed()) {
            fromNode.addBranch(toNode);
        }
        return null;
    }

    @Nullable
    protected NodeState addConditionalBranch(@NotNull OCElement condition2, boolean branch, @NotNull OCNode fromNode, @NotNull OCNode toNode) {
        return this.addConditionalBranch(condition2, branch, fromNode, toNode, null, null);
    }

    @Override
    public void visitIfStatement(OCIfStatement stmt) {
        this.visitIfLike(stmt, stmt.getCondition(), stmt.getThenBranch(), stmt.getElseBranch());
    }

    @Override
    public void visitConditionalExpression(OCConditionalExpression expression2) {
        this.visitIfLike(expression2, expression2.getCondition(), expression2.getPositiveExpression(true), expression2.getNegativeExpression());
    }

    private void visitIfLike(@NotNull PsiElement element, @Nullable OCElement condition2, @Nullable PsiElement thenBranch, @Nullable PsiElement elseBranch) {
        this.myValuesStack.push(new ArrayList());
        KidIterator itr = this.getKidIterator(element);
        OCNode conditionNode = this.acceptCondition(condition2, itr, false);
        Number conditionValue = OCControlFlowBuilder.getValueOfCondition(condition2);
        boolean needThenBranch = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) != 0;
        boolean needElseBranch = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) == 0;
        OCNode thenStartNode = this.myGraph.addNode();
        if (needThenBranch && condition2 != null) {
            this.addConditionalBranch(condition2, true, conditionNode, thenStartNode);
        }
        itr.accept(thenBranch);
        OCNode thenFinishNode = this.myGraph.getLastAddedNode();
        OCNode elseStartNode = this.myGraph.addNode();
        if (needElseBranch && condition2 != null) {
            this.addConditionalBranch(condition2, false, conditionNode, elseStartNode);
        }
        itr.accept(elseBranch);
        OCNode elseFinishNode = this.myGraph.getLastAddedNode();
        List<PsiElement> writes = this.myValuesStack.pop();
        if (conditionNode != this.myGraph.getLastAddedNode()) {
            OCNode exitNode = this.myGraph.addNode();
            this.addBranch(thenFinishNode, exitNode, writes);
            this.addBranch(elseFinishNode, exitNode, writes);
        }
        itr.finish();
    }

    @Nullable
    private static Number getValueOfCondition(@Nullable OCElement condition2) {
        OCExpression conditionalExpression = null;
        if (condition2 instanceof OCExpression) {
            conditionalExpression = (OCExpression)condition2;
        } else if (condition2 instanceof OCDeclarationOrExpression) {
            OCDeclarationOrExpression declarationOrExpression = (OCDeclarationOrExpression)condition2;
            OCExpression expression2 = declarationOrExpression.getExpression();
            if (expression2 != null) {
                conditionalExpression = expression2;
            } else {
                OCDeclaration declaration2 = declarationOrExpression.getDeclaration();
                if (declaration2 != null && declaration2.getDeclarators().size() != 0) {
                    List<OCDeclarator> declarators = declaration2.getDeclarators();
                    conditionalExpression = declarators.get(0).getInitializer();
                }
            }
        }
        return OCExpressionEvaluator.evaluate(conditionalExpression);
    }

    @NotNull
    private int[] saveLoopState() {
        return new int[]{this.myBreakNodes.size(), this.myContinueNodes.size()};
    }

    private boolean isSelected(@NotNull OCNode node) {
        OCElementsRange range = node.getRange();
        return this.mySelection != null && range != null && this.mySelection.contains(range.getTextRange());
    }

    public boolean hasCrossSelectionJumps() {
        return this.myHasCrossSelectionJumps;
    }

    public boolean hasDanglingJumps() {
        return !this.myBreakNodes.isEmpty() || !this.myContinueNodes.isEmpty() || this.myHasTopLevelCaseStatements;
    }

    private void patchLoopJumps(@NotNull int[] savedState, @Nullable OCNode continueToNode, @Nullable OCNode breakToNode, @Nullable List<PsiElement> writes) {
        int i2;
        if (breakToNode != null) {
            for (i2 = this.myBreakNodes.size() - 1; i2 >= savedState[0]; --i2) {
                this.addBranch(this.myBreakNodes.get(i2), breakToNode, writes);
                this.myBreakNodes.remove(i2);
            }
        }
        if (continueToNode != null) {
            for (i2 = this.myContinueNodes.size() - 1; i2 >= savedState[1]; --i2) {
                this.addBranch(this.myContinueNodes.get(i2), continueToNode, null);
                this.myContinueNodes.remove(i2);
            }
        }
    }

    @Override
    public void visitWhileStatement(OCWhileStatement stmt) {
        this.visitForWhile(stmt, null, stmt.getCondition(), null, stmt.getBody());
    }

    @Override
    public void visitForStatement(OCForStatement stmt) {
        this.visitForWhile(stmt, stmt.getInitializer(), stmt.getCondition(), stmt.getIncrement(), stmt.getBody());
    }

    @Override
    public void visitForeachStatement(OCForeachStatement statement2) {
        OCElement condition2 = statement2.getVariableDeclaration();
        if (condition2 == null) {
            condition2 = statement2.getVariableExpression();
        }
        this.visitForWhile(statement2, condition2, statement2.getCollectionExpression(), null, statement2.getBody());
    }

    private void visitForWhile(@NotNull OCElement element, @Nullable OCElement initializer, @Nullable OCElement condition2, @Nullable OCStatement increment, @Nullable OCStatement body2) {
        OCNode conditionStartNode;
        KidIterator itr = this.getKidIterator(element);
        itr.accept(initializer);
        OCNode enterNode = this.myGraph.getLastAddedNode();
        OCNode continueNode = conditionStartNode = this.myGraph.addNode();
        NodeState condState1 = this.addBranch(enterNode, conditionStartNode);
        this.myValuesStack.push(new ArrayList());
        OCNode conditionEndNode = this.acceptCondition(condition2, itr, true);
        boolean foreach = element instanceof OCForeachStatement;
        Number conditionValue = foreach ? (Number)null : (Number)OCControlFlowBuilder.getValueOfCondition(condition2);
        boolean conditionNotFalse = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) != 0;
        boolean conditionNotTrue = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) == 0;
        OCNode bodyStartNode = this.myGraph.addNode();
        if (conditionNotFalse) {
            if (foreach || condition2 == null) {
                this.addBranch(conditionStartNode, bodyStartNode);
            } else {
                this.addConditionalBranch(condition2, true, conditionEndNode, bodyStartNode);
            }
        }
        int[] state = this.saveLoopState();
        itr.skip(increment);
        itr.accept(body2);
        OCNode bodyEndNode = this.myGraph.getLastAddedNode();
        if (increment != null) {
            OCNode incrementNode = this.myGraph.addNode();
            this.addBranch(bodyEndNode, incrementNode);
            increment.accept(this);
            bodyEndNode = this.myGraph.getLastAddedNode();
            continueNode = incrementNode;
        }
        List<PsiElement> writes = this.myValuesStack.pop();
        OCNode exitNode = this.myGraph.addNode();
        this.patchLoopJumps(state, continueNode, exitNode, writes);
        NodeState condState2 = this.addBranch(bodyEndNode, conditionStartNode, writes);
        if (conditionNotFalse) {
            if (!Comparing.equal((Object)condState1, (Object)condState2) && condition2 != null) {
                this.addConditionalBranch(condition2, true, conditionEndNode, bodyStartNode, null, condState1);
            } else {
                this.addBranch(conditionEndNode, bodyStartNode, null, condState1);
            }
        }
        if (conditionNotTrue) {
            if (foreach) {
                this.addBranch(conditionStartNode, exitNode);
            } else if (condition2 != null) {
                this.addConditionalBranch(condition2, false, conditionEndNode, exitNode);
            }
        }
        itr.finish();
    }

    @Override
    public void visitDoWhileStatement(OCDoWhileStatement stmt) {
        boolean conditionNotTrue;
        KidIterator itr = this.getKidIterator(stmt);
        OCNode lastNode = this.myGraph.getLastAddedNode();
        OCNode loopStartNode = this.myGraph.addNode();
        this.addBranch(lastNode, loopStartNode);
        int[] state = this.saveLoopState();
        this.myValuesStack.push(new ArrayList());
        itr.accept(stmt.getBody());
        OCExpression condition2 = stmt.getCondition();
        OCNode conditionNode = this.acceptCondition(condition2, itr, false);
        Number conditionValue = OCExpressionEvaluator.evaluate(condition2);
        boolean conditionNotFalse = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) != 0;
        boolean bl = conditionNotTrue = conditionValue == null || OCExpressionEvaluator.singAsInC(conditionValue) == 0;
        if (loopStartNode.isEmpty()) {
            this.myGraph.removeNode(loopStartNode, false);
            return;
        }
        List<PsiElement> writes = this.myValuesStack.pop();
        OCNode loopEndNode = this.myGraph.getLastAddedNode();
        OCNode exitNode = this.myGraph.addNode();
        if (condition2 != null) {
            if (conditionNotFalse) {
                this.addConditionalBranch(condition2, true, loopEndNode, loopStartNode, Collections.emptyList(), null);
            }
            if (conditionNotTrue) {
                this.addConditionalBranch(condition2, false, loopEndNode, exitNode);
            }
        }
        this.patchLoopJumps(state, conditionNode, exitNode, writes);
        itr.finish();
    }

    @Override
    public void visitBreakStatement(OCBreakStatement stmt) {
        this.visitElement(stmt);
        OCNode breakNode = this.myGraph.getLastAddedNode();
        this.myBreakNodes.add(breakNode);
        this.myGraph.addNode();
    }

    @Override
    public void visitContinueStatement(OCContinueStatement stmt) {
        this.visitElement(stmt);
        OCNode continueNode = this.myGraph.getLastAddedNode();
        this.myContinueNodes.add(continueNode);
        this.myGraph.addNode();
    }

    @Override
    public void visitLabeledStatement(OCLabeledStatement stmt) {
        OCNode labeledNode;
        OCNode lastNode = this.myGraph.getLastAddedNode();
        if (!lastNode.isEmpty()) {
            labeledNode = this.myGraph.addNode();
            this.addBranch(lastNode, labeledNode);
        } else {
            labeledNode = lastNode;
        }
        this.visitElement(stmt);
        this.myLabeledNodes.put(stmt.getLabel(), labeledNode);
        for (OCNode gotoNode : this.myGotoNodes.get((Object)stmt.getLabel())) {
            this.addUnstructuralBranch(gotoNode, labeledNode);
            if (!(this.isSelected(gotoNode) ^ this.isSelected(labeledNode))) continue;
            this.myHasCrossSelectionJumps = true;
        }
        OCSymbol symbol = stmt.getLocalSymbol();
        if (symbol != null) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.DECLARATOR, stmt.getLabelElement(), symbol);
        }
    }

    @Override
    public void visitGotoStatement(OCGotoStatement stmt) {
        this.visitElement(stmt);
        OCNode gotoNode = this.myGraph.getLastAddedNode();
        this.myGraph.addNode();
        OCReferenceElement label = stmt.getLabel();
        if (label == null) {
            return;
        }
        this.myGotoNodes.add((Object)label.getCanonicalText(), (Object)gotoNode);
        OCNode labeledNode = this.myLabeledNodes.get(label.getCanonicalText());
        this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, stmt.getNavigationElement(), label.resolveToSymbol());
        if (labeledNode != null) {
            this.addUnstructuralBranch(gotoNode, labeledNode);
            if (this.isSelected(gotoNode) ^ this.isSelected(labeledNode)) {
                this.myHasCrossSelectionJumps = true;
            }
        }
    }

    protected void addCaseStatement(@NotNull OCCaseStatement stmt, @NotNull OCNode caseNode, @NotNull SwitchInfo info) {
        this.addBranch(info.getNode(), caseNode);
        info.addCaseExpression(stmt.getExpression());
    }

    @Override
    public void visitCaseStatement(OCCaseStatement stmt) {
        SwitchInfo info;
        OCNode caseNode;
        OCNode lastNode = this.myGraph.getLastAddedNode();
        if (!lastNode.isEmpty()) {
            caseNode = this.myGraph.addNode();
            this.addBranch(lastNode, caseNode);
        } else {
            caseNode = lastNode;
        }
        SwitchInfo switchInfo = info = this.mySwitchStack.isEmpty() ? null : this.mySwitchStack.peek();
        if (info != null) {
            this.addCaseStatement(stmt, caseNode, info);
            if (stmt.isDefault()) {
                info.setHasDefault(true);
            }
        } else {
            this.myHasTopLevelCaseStatements = true;
        }
        this.visitElement(stmt);
    }

    @Override
    public void visitSwitchStatement(OCSwitchStatement stmt) {
        OCType type2;
        KidIterator itr = this.getKidIterator(stmt);
        OCDeclarationOrExpression expression2 = stmt.getExpression();
        itr.accept(expression2);
        itr.skipLeaves();
        this.myValuesStack.push(new ArrayList());
        OCNode switchNode = this.myGraph.getLastAddedNode();
        this.mySwitchStack.push(new SwitchInfo(expression2, switchNode));
        int[] state = this.saveLoopState();
        this.myGraph.addNode();
        OCStatement body2 = stmt.getBody();
        itr.accept(body2);
        OCNode lastNode = this.myGraph.getLastAddedNode();
        OCNode exitNode = this.myGraph.addNode();
        List<PsiElement> writes = this.myValuesStack.pop();
        this.addBranch(lastNode, exitNode, writes);
        boolean allCasesCovered = this.mySwitchStack.pop().hasDefault();
        OCType oCType = type2 = expression2 != null ? expression2.getResolvedType().getTerminalType() : null;
        if (type2 instanceof OCStructType && ((OCStructType)type2).isEnumClass()) {
            ArrayList<Pair<Integer, Integer>> ranges = new ArrayList<Pair<Integer, Integer>>();
            ArrayList<OCCaseStatement> caseStmts = new ArrayList<OCCaseStatement>();
            if (body2 != null) {
                OCCreateMissingSwitchCasesIntentionAction.findCaseStatements(body2, ranges, caseStmts);
                allCasesCovered |= OCCreateMissingSwitchCasesIntentionAction.getMissingCases(stmt, ranges, (Ref<Boolean>)new Ref()).isEmpty();
            }
        }
        if (!allCasesCovered) {
            this.addBranch(switchNode, exitNode, writes);
        }
        this.patchLoopJumps(state, null, exitNode, writes);
        itr.finish();
    }

    @Override
    public void visitReturnStatement(OCReturnStatement stmt) {
        this.visitElement(stmt);
        OCNode returnNode = this.myGraph.getLastAddedNode();
        this.myGraph.addExitNode(returnNode);
        this.myGraph.addNode();
        returnNode.setNodeAfterReturn(this.myGraph.getLastAddedNode());
    }

    @Override
    public void visitThrowExpression(OCThrowExpression expression2) {
        this.visitElement(expression2);
        this.processThrow();
    }

    private void processThrow() {
        OCNode throwNode = this.myGraph.getLastAddedNode();
        this.myGraph.addExitNode(throwNode);
        this.myGraph.addNode();
        this.myTryThrows.peek().add(throwNode);
    }

    @Override
    public void visitTryStatement(OCTryStatement stmt) {
        this.myTryFirstCalls.push((Ref<OCNode>)Ref.create());
        KidIterator itr = this.getKidIterator(stmt);
        OCNode lastNode = this.myGraph.getLastAddedNode();
        OCNode bodyStartNode = this.myGraph.addNode();
        this.addBranch(lastNode, bodyStartNode);
        this.myTryThrows.push(new ArrayList());
        itr.accept(stmt.getBody());
        bodyStartNode.enlarge(stmt, stmt);
        OCNode bodyEndNode = this.myGraph.getLastAddedNode();
        List<OCNode> throwNodes = this.myTryThrows.pop();
        ArrayList<OCNode> catchEndNodes = new ArrayList<OCNode>();
        OCNode firstCallNode = (OCNode)this.myTryFirstCalls.pop().get();
        for (PsiElement psiElement : stmt.getCatchSections()) {
            OCNode catchStartNode = this.myGraph.addNode();
            this.addBranch(bodyEndNode, catchStartNode);
            if (firstCallNode != null) {
                this.addBranch(firstCallNode, catchStartNode);
            }
            for (OCNode node : throwNodes) {
                this.addBranch(node, catchStartNode);
            }
            this.visitElement(psiElement);
            catchEndNodes.add(this.myGraph.getLastAddedNode());
        }
        OCNode exitNode = this.myGraph.addNode();
        this.addBranch(bodyEndNode, exitNode);
        for (OCNode node : catchEndNodes) {
            this.addBranch(node, exitNode);
        }
        if (stmt.getFinallySection() != null) {
            this.visitElement(stmt.getFinallySection());
        }
    }

    @Override
    public void visitBlockExpression(OCBlockExpression blockExpression) {
        this.visitBlockOrLambdaExpression(blockExpression);
    }

    @Override
    public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
        this.visitBlockOrLambdaExpression(lambdaExpression);
    }

    private void visitBlockOrLambdaExpression(@NotNull OCCallable callable) {
        this.myGraph.getLastAddedNode().enlarge(callable, callable);
        OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(callable, this.myAnalyzer, this.myAnalyzer);
        analyzer.buildControlFlowGraph();
        OCUnreachableCodeFinder finder = analyzer.getUnreachableCodeFinder();
        OCNode lastNode = this.myGraph.getLastAddedNode();
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.READ_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.READ));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.READ_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.READ_IN_BLOCK));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.WRITE_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.WRITE_IN_BLOCK, finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE_IN_BLOCK));
        this.myGraph.addInstructions(lastNode, OCInstruction.InstructionKind.REFERENCE, finder.getReachableInstructions(OCInstruction.InstructionKind.REFERENCE));
        this.processReferencesFromBlock(finder);
        finder.clearInstructions();
    }

    private void processReferencesFromBlock(OCUnreachableCodeFinder finder) {
        for (OCInstruction instruction : finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE)) {
            this.processReferenceFromBlock(instruction.getSymbol());
        }
        for (OCInstruction instruction : finder.getReachableInstructions(OCInstruction.InstructionKind.WRITE_IN_BLOCK)) {
            this.processReferenceFromBlock(instruction.getSymbol());
        }
        for (OCInstruction instruction : finder.getReachableInstructions(OCInstruction.InstructionKind.REFERENCE)) {
            this.processReferenceFromBlock(instruction.getSymbol());
        }
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        OCSymbol symbol = declarator.getLocalSymbol();
        if (symbol != null && symbol.getKind().isLocal()) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.DECLARATOR, declarator, symbol);
        }
        this.visitElement(declarator);
        if (symbol != null && symbol.getKind().isLocal()) {
            if (declarator.getInitializer() != null && symbol.getKind() != OCSymbolKind.PARAMETER) {
                this.processAssignment(symbol, declarator.getNameIdentifier(), declarator.getInitializer(), false);
            } else if (!declarator.getInitializers().isEmpty() && symbol.getKind() != OCSymbolKind.PARAMETER || !declarator.getArrayLengths().isEmpty()) {
                this.processAssignment(symbol, declarator.getNameIdentifier(), null, true);
            } else {
                PsiElement parent = declarator.getParent().getParent();
                if (parent instanceof OCForeachStatement || parent instanceof OCDeclarationStatement && parent.getParent() instanceof OCForeachStatement) {
                    this.processAssignment(symbol, declarator.getNameIdentifier(), null, true);
                } else {
                    this.processNonInitializedDeclarator(symbol, declarator.getNameIdentifier());
                }
            }
        }
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        this.visitElement(part);
        OCSymbol symbol = part.getLocalSymbol();
        if (symbol != null && symbol.getKind().isLocal()) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.DECLARATOR, part.getParameter(), symbol);
        }
        if (symbol != null) {
            this.processNonInitializedDeclarator(symbol, part.getNameIdentifier());
        }
    }

    @Override
    public void visitAssignmentExpression(OCAssignmentExpression expression2) {
        OCExpression source = expression2.getSourceExpression();
        OCExpression receiver2 = expression2.getReceiverExpression();
        if (source != null) {
            source.accept(this);
        }
        receiver2.accept(this);
    }

    protected void processNonInitializedDeclarator(@NotNull OCSymbol symbol, @Nullable PsiElement lValue) {
    }

    protected void processDereference(@NotNull OCReferenceExpression expression2) {
    }

    protected void processReference(@NotNull PsiElement element, @NotNull OCSymbol symbol) {
        this.myGraph.addInstruction(OCInstruction.InstructionKind.REFERENCE, element, symbol);
    }

    protected void processReferenceFromBlock(@NotNull OCSymbol symbol) {
    }

    protected void processAssignment(@NotNull OCSymbol symbol, @Nullable PsiElement lValue, @Nullable OCExpression rValue, boolean complexAssignment) {
        this.processAssignment(symbol, lValue, rValue, complexAssignment, false);
    }

    protected void processAssignment(@NotNull OCSymbol symbol, @Nullable PsiElement lValue, @Nullable OCExpression rValue, boolean complexAssignment, boolean shortCircuitEvaluation) {
        OCInstruction write2;
        if (!shortCircuitEvaluation) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.KILL, lValue, null, symbol);
        }
        if ((write2 = this.myGraph.addInstruction(OCInstruction.InstructionKind.WRITE, lValue, rValue, symbol)) != null) {
            this.addModifiedValue(write2.getRValue());
        }
    }

    protected void addModifiedValue(@Nullable PsiElement value2) {
        if (value2 != null) {
            for (List list : this.myValuesStack) {
                list.add(value2);
            }
        }
    }

    @Override
    public void visitBinaryExpression(OCBinaryExpression expression2) {
        OCElementType sign = expression2.getOperationSign();
        if (sign == OCTokenTypes.ANDAND || sign == OCTokenTypes.OROR) {
            KidIterator itr = this.getKidIterator(expression2);
            itr.accept(expression2.getLeft());
            Number leftValue = OCControlFlowBuilder.getValueOfCondition(expression2.getLeft());
            if (leftValue == null) {
                ++this.myShortCircuitDepth;
                itr.accept(expression2.getRight());
                --this.myShortCircuitDepth;
            } else if (OCExpressionEvaluator.singAsInC(leftValue) == 0 == (sign == OCTokenTypes.OROR)) {
                itr.accept(expression2.getRight());
            }
            itr.finish();
        } else {
            this.visitElement(expression2);
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression2) {
        if (!this.myTryFirstCalls.isEmpty() && this.myTryFirstCalls.peek().isNull()) {
            OCNode lastNode = this.myGraph.getLastAddedNode();
            OCNode callNode = this.myGraph.addNode();
            this.addBranch(lastNode, callNode);
            this.myTryFirstCalls.peek().set((Object)lastNode);
        }
        this.visitElement(expression2);
        OCExpression caller = expression2.getFunctionReferenceExpression();
        if (!(caller instanceof OCReferenceExpression)) {
            return;
        }
        OCSymbol symbol = ((OCReferenceExpression)caller).resolveToSymbol();
        if (symbol != null && OCControlFlowBuilder.isNoReturn(symbol)) {
            OCNode returnNode = this.myGraph.getLastAddedNode();
            this.myGraph.addExitNode(returnNode);
            this.myGraph.addNode();
        }
    }

    private static boolean isNoReturn(OCSymbol symbol) {
        if (symbol.hasAttribute("noreturn")) {
            return true;
        }
        String symbolName = symbol.getName();
        return symbolName.equals("__builtin_unreachable") || symbolName.equals("__builtin_trap");
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression2) {
        this.visitElement(expression2);
        OCExpression receiver2 = expression2.getReceiverExpression();
        String selector2 = expression2.getMessageSelector();
        if (selector2.startsWith("raise") && receiver2 != null && receiver2.getResolvedType().getName().equals("NSException")) {
            this.processThrow();
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expression2) {
        PsiElement parent;
        OCInstruction instruction;
        OCExpression element;
        this.visitElement(expression2);
        OCSymbol symbol = expression2.resolveToSymbol();
        if (!this.isSymbolInScope(symbol)) {
            return;
        }
        boolean wasQualifierOrIndex = false;
        if (element == null) {
            return;
        }
        if (symbol.getType().resolve(expression2.getContainingFile()) instanceof OCStructType) {
            for (element = OCParenthesesUtils.topmostParenthesized(expression2); element.getParent() instanceof OCQualifiedExpression || element.getParent() instanceof OCArraySelectionExpression && ((OCArraySelectionExpression)element.getParent()).getArrayExpression() == element; element = element.getParent()) {
                wasQualifierOrIndex = true;
            }
        }
        if (wasQualifierOrIndex && (instruction = this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, expression2, symbol)) != null && element instanceof OCExpression && !(OCParenthesesUtils.topmostParenthesized(element).getParent() instanceof OCCallExpression)) {
            instruction.setTransparentRead(true);
        }
        if ((parent = element.getContext()) == null) {
            return;
        }
        MyParentVisitor visitor = new MyParentVisitor(element, symbol, wasQualifierOrIndex);
        parent.accept((PsiElementVisitor)visitor);
        if (!wasQualifierOrIndex && !visitor.isGenerated()) {
            this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, expression2, symbol);
        }
        if (visitor.isDereference()) {
            this.processDereference(expression2);
        }
    }

    @Contract(value="null -> false")
    protected boolean isSymbolInScope(@Nullable OCSymbol symbol) {
        return symbol != null && symbol.getKind().isLocal();
    }

    @Override
    public void visitBlockStatement(OCBlockStatement stmt) {
        PsiElement parent = stmt.getParent();
        if (!(parent instanceof OCFunctionDefinition) || parent == this.myGraph.getCodeFragment()) {
            this.visitElement(stmt);
        }
    }

    private class MyParentVisitor
    extends OCVisitor {
        private PsiElement myElement;
        private OCSymbol mySymbol;
        private boolean myWasQualifierOrIndex;
        private boolean myGenerated;
        private boolean myDereference;

        private MyParentVisitor(@NotNull PsiElement element, OCSymbol symbol, boolean wasQualifierOrIndex) {
            this.myElement = element;
            this.mySymbol = symbol;
            this.myWasQualifierOrIndex = wasQualifierOrIndex;
        }

        public boolean isGenerated() {
            return this.myGenerated;
        }

        private boolean isDereference() {
            return this.myDereference;
        }

        @Override
        public void visitAssignmentExpression(OCAssignmentExpression expression2) {
            if (this.processOperator(expression2, OCOperatorReference.OperatorPlacement.INFIX)) {
                return;
            }
            boolean complexAssign = expression2.getOperationSign() != OCTokenTypes.EQ;
            OCExpression receiver2 = expression2.getReceiverExpression();
            OCExpression source = expression2.getSourceExpression();
            if (PsiTreeUtil.isAncestor((PsiElement)receiver2, (PsiElement)this.myElement, (boolean)false)) {
                this.generateAssignmentInstructions(receiver2, source, complexAssign, expression2.getContainingFile());
                this.myGenerated = true;
            }
        }

        private void generateAssignmentInstructions(@Nullable OCExpression receiver2, @Nullable OCExpression source, boolean isComplexAssign, @NotNull PsiFile containingFile) {
            if (isComplexAssign) {
                OCControlFlowBuilder.this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, this.myElement, this.mySymbol);
            }
            if (!this.myWasQualifierOrIndex) {
                OCControlFlowBuilder.this.processAssignment(this.mySymbol, receiver2, source, isComplexAssign, OCControlFlowBuilder.this.myShortCircuitDepth != 0);
            } else if (this.mySymbol.getType().resolve(containingFile) instanceof OCStructType) {
                OCControlFlowBuilder.this.myGraph.addInstruction(OCInstruction.InstructionKind.WRITE, receiver2, source, this.mySymbol);
            }
        }

        private void processFunctionCall(@Nullable OCFunctionSymbol operator2, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @Nullable OCFunctionType functionType, List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context) {
            ProgressManager.checkCanceled();
            if (arguments == null) {
                return;
            }
            if (operator2 instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol) {
                for (OCFunctionSymbol symbol : ((OCResolveOverloadsUtil.OCFunctionGroupSymbol)operator2).getOverloads()) {
                    this.processFunctionCall(symbol, operatorPlacement, functionType, arguments, context);
                }
                return;
            }
            List<Object> parameterTypes = operator2 != null ? OCResolveOverloadsUtil.getParameterTypes(operator2, operatorPlacement, context, null) : (functionType != null ? functionType.getParameterTypes() : Collections.emptyList());
            int argumentIndex = -1;
            for (int index = 0; index < arguments.size(); ++index) {
                OCTypeOwner argument = arguments.get(index);
                if (!(argument instanceof PsiElement) || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)argument), (PsiElement)this.myElement, (boolean)false)) continue;
                argumentIndex = index;
                break;
            }
            if (argumentIndex == -1 || argumentIndex >= parameterTypes.size()) {
                return;
            }
            OCType paramType = (OCType)parameterTypes.get(argumentIndex);
            if (paramType instanceof OCCppReferenceType && !((OCCppReferenceType)paramType).isReferenceToConst() || operator2 != null && argumentIndex == 0 && operator2.isCppMemberOperator(new OCResolveContext(this.myElement))) {
                OCControlFlowBuilder.this.processReference(this.myElement, this.mySymbol);
                this.myGenerated = true;
            }
        }

        private boolean processOperator(OCExpression expression2, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement) {
            boolean isOperator = false;
            PsiReference reference = expression2.getReference();
            if (reference instanceof OCOperatorReference) {
                for (OCSymbol operator2 : ((OCOperatorReference)reference).resolveToSymbols()) {
                    if (!(operator2 instanceof OCFunctionSymbol)) continue;
                    isOperator = true;
                    this.processFunctionCall((OCFunctionSymbol)operator2, operatorPlacement, null, ((OCOperatorReference)reference).getArgumentExpressions(), new OCResolveContext(expression2));
                }
            }
            return isOperator;
        }

        private void processCtorCall(@NotNull OCDeclarator declarator, @NotNull OCStructType declaratorType) {
            OCResolveContext context = new OCResolveContext(declarator);
            List<OCExpression> initializers = declarator.getInitializers();
            ArrayList<OCType> initializerTypes = new ArrayList<OCType>();
            for (OCExpression initializer : initializers) {
                initializerTypes.add(initializer.getResolvedType(context));
            }
            OCArgumentsList<OCExpression> argumentsList = new OCArgumentsList<OCExpression>(initializerTypes, initializers);
            OCSymbol symbol = declaratorType.findConstructor(argumentsList, context, true, false, null);
            if (symbol != null && symbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
                this.processFunctionCall(functionSymbol, null, null, initializers, context);
            }
        }

        @Override
        public void visitCallExpression(OCCallExpression expression2) {
            if (this.processOperator(expression2, OCOperatorReference.OperatorPlacement.POSTFIX)) {
                return;
            }
            OCType type2 = expression2.getFunctionReferenceExpression().getResolvedType().getTerminalType();
            if (type2 instanceof OCFunctionType) {
                OCFunctionType functionType = (OCFunctionType)type2;
                OCArgumentList argumentList = expression2.getArgumentList();
                this.processFunctionCall(null, null, functionType, argumentList.getArguments(), new OCResolveContext(argumentList));
            }
        }

        @Override
        public void visitArgumentList(OCArgumentList argList) {
            this.visitParent(argList);
        }

        @Override
        public void visitMessageArgument(OCMessageArgument argument) {
            OCSendMessageExpression call = (OCSendMessageExpression)argument.getParent();
            int index = call.getArguments().indexOf(argument);
            OCSendMessageExpression.ProbableResponders responders = call.getProbableResponders();
            for (OCMethodSymbol method2 : responders.getAllResponders()) {
                OCDeclaratorSymbol parameter;
                if (method2.getSelectors().size() <= index || (parameter = method2.getSelectors().get(index).getParameter()) == null || !parameter.isPassByReference() && (!(parameter.getType() instanceof OCCppReferenceType) || ((OCCppReferenceType)parameter.getType()).isReferenceToConst())) continue;
                OCExpression expression2 = argument.getArgumentExpression();
                if (expression2 != null) {
                    OCControlFlowBuilder.this.processReference(expression2, this.mySymbol);
                }
                this.myGenerated = true;
                return;
            }
        }

        @Override
        public void visitForeachStatement(OCForeachStatement statement2) {
            OCElement expression2 = statement2.getVariableExpression();
            if (expression2 instanceof OCExpressionStatement) {
                expression2 = ((OCExpressionStatement)expression2).getExpression();
            }
            if (this.myElement == expression2) {
                OCControlFlowBuilder.this.processAssignment(this.mySymbol, this.myElement, null, true);
                this.myGenerated = true;
            }
        }

        @Override
        public void visitDeclarationStatement(OCDeclarationStatement stmt) {
            if (stmt.getParent() instanceof OCForeachStatement) {
                this.visitForeachStatement((OCForeachStatement)stmt.getParent());
            } else {
                this.myGenerated = true;
            }
        }

        @Override
        public void visitDeclarator(OCDeclarator declarator) {
            OCType declaratorType = declarator.getResolvedType();
            if (declaratorType instanceof OCCppReferenceType) {
                OCCppReferenceType referenceType = (OCCppReferenceType)declaratorType;
                if (!referenceType.isReferenceToConst()) {
                    OCControlFlowBuilder.this.processReference(this.myElement, this.mySymbol);
                    this.myGenerated = true;
                }
            } else if (declaratorType instanceof OCStructType) {
                this.processCtorCall(declarator, (OCStructType)declaratorType);
            }
        }

        @Override
        public void visitExpressionStatement(OCExpressionStatement stmt) {
            if (stmt.getParent() instanceof OCForeachStatement) {
                this.visitForeachStatement((OCForeachStatement)stmt.getParent());
            } else {
                this.myGenerated = true;
            }
        }

        @Override
        public void visitPostfixExpression(OCPostfixExpression expression2) {
            if (!(this.processOperator(expression2, OCOperatorReference.OperatorPlacement.POSTFIX) || expression2.getOperationSign() != OCTokenTypes.PLUSPLUS && expression2.getOperationSign() != OCTokenTypes.MINUSMINUS)) {
                OCControlFlowBuilder.this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, this.myElement, this.mySymbol);
                OCControlFlowBuilder.this.processAssignment(this.mySymbol, expression2.getOperand(), expression2.getOperand(), true);
                this.myGenerated = true;
            }
        }

        @Override
        public void visitPrefixExpression(OCPrefixExpression expression2) {
            if (!(this.processOperator(expression2, OCOperatorReference.OperatorPlacement.PREFIX) || expression2.getOperationSign() != OCTokenTypes.PLUSPLUS && expression2.getOperationSign() != OCTokenTypes.MINUSMINUS)) {
                OCControlFlowBuilder.this.myGraph.addInstruction(OCInstruction.InstructionKind.READ, this.myElement, this.mySymbol);
                OCControlFlowBuilder.this.processAssignment(this.mySymbol, expression2.getOperand(), expression2.getOperand(), true);
                PsiElement parent = OCParenthesesUtils.topmostParenthesized(expression2).getParent();
                if (parent != null) {
                    parent.accept((PsiElementVisitor)this);
                }
            }
        }

        @Override
        public void visitBinaryExpression(OCBinaryExpression expression2) {
            this.processOperator(expression2, OCOperatorReference.OperatorPlacement.INFIX);
        }

        @Override
        public void visitUnaryExpression(OCUnaryExpression expression2) {
            if (this.processOperator(expression2, OCOperatorReference.OperatorPlacement.PREFIX)) {
                return;
            }
            OCElementType sign = expression2.getOperationSign();
            if (sign == OCTokenTypes.AND || sign == OCTokenTypes.__IMAG__KEYWORD || sign == OCTokenTypes.__REAL__KEYWORD) {
                OCControlFlowBuilder.this.processReference(expression2, this.mySymbol);
                this.myGenerated = true;
            } else if (sign == OCTokenTypes.MUL) {
                if (OCParenthesesUtils.topmostParenthesized(expression2).getParent() instanceof OCSizeofExpression) {
                    this.myGenerated = true;
                } else {
                    this.myDereference = true;
                }
            }
        }

        @Override
        public void visitQualifiedExpression(OCQualifiedExpression expression2) {
            if (!(this.processOperator(expression2, OCOperatorReference.OperatorPlacement.INFIX) || expression2.getQualifier() != this.myElement || expression2.getQualifyingTokenKind() == OCTokenTypes.DOT && expression2.getQualifier().getResolvedType().isPointerToObject())) {
                this.myDereference = true;
            }
        }

        @Override
        public void visitArraySelectionExpression(OCArraySelectionExpression expression2) {
            if (!this.processOperator(expression2, OCOperatorReference.OperatorPlacement.POSTFIX) && expression2.getArrayExpression() == this.myElement && !expression2.getArrayExpression().getResolvedType().isPointerToObject()) {
                this.myDereference = true;
            }
        }

        @Override
        public void visitConditionalExpression(OCConditionalExpression expression2) {
            if (!PsiTreeUtil.isAncestor((PsiElement)expression2.getCondition(), (PsiElement)this.myElement, (boolean)false)) {
                this.visitParent(expression2);
            }
        }

        @Override
        public void visitParenthesizedExpression(OCParenthesizedExpression expression2) {
            this.visitParent(expression2);
        }

        @Override
        public void visitCastExpression(OCCastExpression expression2) {
            OCType castType = expression2.getCastType();
            if (castType instanceof OCCppReferenceType && !((OCCppReferenceType)castType).isReferenceToConst()) {
                this.visitParent(expression2);
            }
        }

        @Override
        public void visitCompoundInitializer(OCCompoundInitializer initializer) {
            this.visitParent(initializer);
        }

        @Override
        public void visitAsmStatementPart(OCAsmStatementPartImpl statement2) {
            OCExpression expression2 = statement2.getExpression();
            if (statement2.isOutputParametersPart() && expression2 != null) {
                this.generateAssignmentInstructions(expression2, null, false, statement2.getContainingFile());
            }
        }

        private void visitParent(@NotNull PsiElement element) {
            PsiElement parent = element.getParent();
            if (parent != null) {
                parent.accept((PsiElementVisitor)this);
            }
        }
    }

    protected static class SwitchInfo {
        OCNode myNode;
        OCExpression myExpression;
        List<OCExpression> myCaseExpressions = new ArrayList<OCExpression>();
        boolean myHasDefault;

        public SwitchInfo(@Nullable OCDeclarationOrExpression expression2, @NotNull OCNode node) {
            this.myExpression = expression2 != null ? expression2.getExpression() : null;
            this.myNode = node;
        }

        @NotNull
        public OCNode getNode() {
            return this.myNode;
        }

        @Nullable
        public OCExpression getExpression() {
            return this.myExpression;
        }

        public boolean hasDefault() {
            return this.myHasDefault;
        }

        public void setHasDefault(boolean hasDefault) {
            this.myHasDefault = hasDefault;
        }

        public void addCaseExpression(@Nullable OCExpression expr) {
            if (expr != null) {
                this.myCaseExpressions.add(expr);
            }
        }

        public List<OCExpression> getCaseExpressions() {
            return this.myCaseExpressions;
        }
    }

    protected static interface NodeState {
    }

    protected static interface KidIterator {
        public void skipLeaves();

        public void accept(@Nullable PsiElement var1);

        public void skip(@Nullable PsiElement var1);

        public void acceptAll();

        public void finish();
    }
}

