/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCControlFlowGraph {
    private PsiElement myCodeFragment;
    private List<OCNode> myNodes = new ArrayList<OCNode>();
    private OCNode myStartNode;
    private Set<OCNode> myExitNodes = new HashSet<OCNode>();
    private OCControlFlowGraph myParentGraph;
    private int myForbidSplitNodesDepth;
    private int myNextNodeId;
    private Map<OCSymbol, MultiMap<OCInstruction.InstructionKind, OCInstruction>> myInstructions = new HashMap<OCSymbol, MultiMap<OCInstruction.InstructionKind, OCInstruction>>();
    private Map<PsiElement, OCInstruction> myReadInstructions = new HashMap<PsiElement, OCInstruction>();
    private Set<OCInstruction> myAllInstructions = new HashSet<OCInstruction>();
    private Map<OCSymbol, OCInstruction> myDeclarators = new HashMap<OCSymbol, OCInstruction>();
    private Map<OCSymbol, OCControlFlowGraph> myClosureVariables = new HashMap<OCSymbol, OCControlFlowGraph>();

    public OCControlFlowGraph(@NotNull PsiElement codeFragment, @Nullable OCControlFlowGraph parentGraph) {
        this.myCodeFragment = codeFragment;
        this.myParentGraph = parentGraph;
    }

    @NotNull
    public List<OCNode> getNodes() {
        return this.myNodes;
    }

    public int getNumOfNodes() {
        return this.myNodes.size();
    }

    public int getNextNodeId() {
        return this.myNextNodeId++;
    }

    @NotNull
    public OCNode addNode() {
        return this.addNode(false);
    }

    @NotNull
    public OCNode addNode(boolean isFake) {
        if (this.isSplitNodesAllowed() || isFake) {
            OCNode node = new OCNode(this, this.myNodes.size(), this.myNextNodeId++, isFake);
            this.myNodes.add(node);
            return node;
        }
        return this.getLastAddedNode();
    }

    public void forbidSplittingNodes() {
        ++this.myForbidSplitNodesDepth;
    }

    public void allowSplittingNodes() {
        --this.myForbidSplitNodesDepth;
    }

    public boolean isSplitNodesAllowed() {
        return this.myForbidSplitNodesDepth == 0;
    }

    public void removeNode(@NotNull OCNode node, boolean isFake) {
        if (this.isSplitNodesAllowed() || isFake) {
            assert (this.getLastAddedNode() == node && (node.isEmpty() || node.isFake()));
            this.myNodes.remove(this.getNumOfNodes() - 1);
        }
    }

    public void setStartNode(@NotNull OCNode startNode) {
        this.myStartNode = startNode;
    }

    @NotNull
    public OCNode getStartNode() {
        return this.myStartNode;
    }

    public void addExitNode(@NotNull OCNode node) {
        this.myExitNodes.add(node);
    }

    @NotNull
    public Set<OCNode> getExitNodes() {
        return this.myExitNodes;
    }

    @Nullable
    public OCNode getPreviousNonEmptyNode(@NotNull OCNode node) {
        for (int index = node.getIndex() - 1; index >= 0; --index) {
            if (this.myNodes.get(index).getRange() == null) continue;
            return this.myNodes.get(index);
        }
        return null;
    }

    @NotNull
    public OCNode getLastAddedNode() {
        return this.myNodes.get(this.getNumOfNodes() - 1);
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCInstruction.InstructionKind kind2, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        return this.addInstruction(this.getLastAddedNode(), kind2, null, rValue, symbol);
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCInstruction.InstructionKind kind2, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        return this.addInstruction(this.getLastAddedNode(), kind2, lValue, rValue, symbol);
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCNode node, OCInstruction.InstructionKind kind2, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        if (symbol == null) {
            return null;
        }
        OCInstruction instruction = new OCInstruction(kind2, node, lValue, rValue, symbol);
        if (kind2 == OCInstruction.InstructionKind.WRITE) {
            OCInstruction read2 = this.myReadInstructions.get(OCParenthesesUtils.diveIntoParenthesesAndCasts(rValue));
            if (read2 != null && read2.getKind() == OCInstruction.InstructionKind.READ) {
                read2.setAssociatedInstruction(instruction);
                instruction.setAssociatedInstruction(read2);
            }
        } else if (kind2 == OCInstruction.InstructionKind.READ) {
            this.myReadInstructions.put(OCParenthesesUtils.diveIntoParenthesesAndCasts(rValue), instruction);
        }
        if (kind2 == OCInstruction.InstructionKind.DECLARATOR) {
            this.myDeclarators.put(symbol, instruction);
        } else if (!this.myDeclarators.containsKey(symbol)) {
            OCControlFlowGraph parent = this.myParentGraph;
            while (parent != null && !parent.myDeclarators.containsKey(symbol)) {
                parent = parent.myParentGraph;
            }
            if (parent != null) {
                this.myClosureVariables.put(symbol, parent);
            }
        }
        MultiMap multiMap = this.myInstructions.get(symbol);
        if (multiMap == null) {
            multiMap = new MultiMap();
            this.myInstructions.put(symbol, (MultiMap<OCInstruction.InstructionKind, OCInstruction>)multiMap);
        }
        multiMap.putValue((Object)kind2, (Object)instruction);
        this.myAllInstructions.add(instruction);
        node.addInstruction(instruction);
        return instruction;
    }

    public void addInstructions(@NotNull OCNode node, @NotNull OCInstruction.InstructionKind kind2, @NotNull Collection<OCInstruction> instructions) {
        for (OCInstruction instruction : instructions) {
            OCInstruction newInstruction = this.addInstruction(node, kind2, instruction.getLValue(), instruction.getRValue(), instruction.getSymbol());
            if (newInstruction == null) continue;
            OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
            newInstruction.setAssociatedInstruction(associatedInstruction != null ? associatedInstruction : instruction);
        }
    }

    @Nullable
    public MultiMap<OCInstruction.InstructionKind, OCInstruction> getInstructions(@NotNull OCSymbol symbol) {
        return this.myInstructions.get(symbol);
    }

    public Set<OCInstruction> getAllInstructions() {
        return this.myAllInstructions;
    }

    public OCInstruction getDeclaratorInstruction(@NotNull OCSymbol symbol) {
        return this.myDeclarators.get(symbol);
    }

    public Set<OCSymbol> getLocalSymbols() {
        return this.myDeclarators.keySet();
    }

    public Set<OCSymbol> getClosureSymbols() {
        return this.myClosureVariables.keySet();
    }

    public OCControlFlowGraph getClosureVariableDeclaratorGraph(@NotNull OCSymbol symbol) {
        return this.myClosureVariables.get(symbol);
    }

    @NotNull
    public PsiElement getCodeFragment() {
        return this.myCodeFragment;
    }

    @Nullable
    public OCControlFlowGraph getParentGraph() {
        return this.myParentGraph;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("<CFG>\n");
        String fileText = this.myCodeFragment.getContainingFile().getText();
        for (OCNode node : this.myNodes) {
            String nodeName = "node";
            if (node == this.myStartNode) {
                nodeName = "start-node";
            } else if (this.myExitNodes.contains(node)) {
                nodeName = "exit-node";
            }
            result2.append("  <").append(nodeName).append(" id=\"").append(node.getIndex()).append("\">\n");
            OCElementsRange range = node.getRange();
            if (range != null) {
                TextRange textRange = range.getTextRange();
                result2.append(fileText.substring(textRange.getStartOffset(), textRange.getEndOffset()).trim()).append("\n");
            }
            if (node.getJumpTargets() != null) {
                for (OCNode target : node.getJumpTargets()) {
                    result2.append("    <target node-id=\"").append(target.getIndex()).append("\"/>\n");
                }
            }
            result2.append("  </").append(nodeName).append(">\n");
        }
        result2.append("</CFG>\n");
        return result2.toString();
    }

    public boolean hasInstructionsInParentGraph(@NotNull OCSymbol symbol, OCInstruction.InstructionKind ... kinds) {
        OCControlFlowGraph parentCfg = this.getClosureVariableDeclaratorGraph(symbol);
        if (parentCfg == null) {
            return false;
        }
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = parentCfg.getInstructions(symbol);
        if (instructions == null) {
            return false;
        }
        for (OCInstruction.InstructionKind kind2 : kinds) {
            for (OCInstruction instruction : instructions.get((Object)kind2)) {
                OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
                if (associatedInstruction != null && associatedInstruction.getNode().getGraph() == this) continue;
                return true;
            }
        }
        return false;
    }
}

