/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCEndlessLoopFinder;
import com.jetbrains.cidr.lang.dfa.OCEscapedValuesChecker;
import com.jetbrains.cidr.lang.dfa.OCInfiniteRecursionFinder;
import com.jetbrains.cidr.lang.dfa.OCInputOutputVariablesFinder;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNotInitializedVarChecker;
import com.jetbrains.cidr.lang.dfa.OCNotReleasedVariablesChecker;
import com.jetbrains.cidr.lang.dfa.OCNotUsedValueChecker;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppTypeidExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCAddElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeGCCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationButInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSendMessageToObjectIntentionAction;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCMethodReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDataFlowAnalyzer
extends OCAnnotator {
    private PsiElement[] myCodeFragments;
    private OCControlFlowGraph myGraph;
    private OCControlFlowBuilder myGraphBuilder;
    private OCUnreachableCodeFinder myUnreachableCodeFinder;
    private OCInfiniteRecursionFinder myInfiniteRecursionFinder;
    private OCEndlessLoopFinder myEndlessLoopFinder;
    private OCDataFlowAnalyzer myParentAnalyzer;
    private List<OCDataFlowAnalyzer> myChildAnalyzers = new ArrayList<OCDataFlowAnalyzer>();
    private TextRange mySelection;
    private List<OCSymbol> myInputVariables;
    private List<OCSymbol> myOutputVariables;
    private List<OCSymbol> myWrittenVariables;
    private List<OCSymbol> myEscapedDeclarators;
    private Map<OCSymbol, List<PsiReference>> myVariableUsages;
    private static final Key<CachedValue<Map<OCStructSymbol, Boolean>>> TRIVIAL_DTOR_CACHE = Key.create((String)"TRIVIAL_DTOR_CACHE_IN_FILE");

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @Nullable OCAnnotator annotator, @Nullable OCDataFlowAnalyzer parentAnalyzer) {
        this(codeFragment, parentAnalyzer != null ? parentAnalyzer.mySelection : null);
        this.myParentAnalyzer = parentAnalyzer;
        if (annotator != null) {
            this.setHolder(annotator.getHolder(), annotator.getAnnotatingElement());
        }
        if (parentAnalyzer != null) {
            parentAnalyzer.myChildAnalyzers.add(this);
        }
    }

    public OCDataFlowAnalyzer(@NotNull PsiElement[] codeFragments, @Nullable TextRange selection) {
        this.myCodeFragments = codeFragments;
        this.mySelection = selection;
        this.myInputVariables = new ArrayList<OCSymbol>();
        this.myOutputVariables = new ArrayList<OCSymbol>();
        this.myWrittenVariables = new ArrayList<OCSymbol>();
        this.myEscapedDeclarators = new ArrayList<OCSymbol>();
        this.myVariableUsages = new HashMap<OCSymbol, List<PsiReference>>();
    }

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @Nullable TextRange selection) {
        this(new PsiElement[]{codeFragment}, selection);
    }

    @NotNull
    public OCControlFlowGraph getGraph() {
        return this.myGraph;
    }

    @Nullable
    public OCControlFlowGraph findGraph(@NotNull PsiElement element) {
        if (!this.myGraph.getCodeFragment().getTextRange().contains(element.getTextOffset())) {
            return null;
        }
        for (OCDataFlowAnalyzer analyzer : this.myChildAnalyzers) {
            OCControlFlowGraph graph = analyzer.findGraph(element);
            if (graph == null) continue;
            return graph;
        }
        return this.myGraph;
    }

    @NotNull
    public OCUnreachableCodeFinder getUnreachableCodeFinder() {
        return this.myUnreachableCodeFinder;
    }

    @NotNull
    public List<OCSymbol> getInputVariables() {
        return this.myInputVariables;
    }

    @NotNull
    public List<OCSymbol> getOutputVariables() {
        return this.myOutputVariables;
    }

    @NotNull
    public List<OCSymbol> getWrittenVariables() {
        return this.myWrittenVariables;
    }

    @NotNull
    public List<OCSymbol> getEscapedDeclarators() {
        return this.myEscapedDeclarators;
    }

    public void buildControlFlowGraph() {
        this.myGraph = new OCControlFlowGraph(this.myCodeFragments[0], this.myParentAnalyzer != null ? this.myParentAnalyzer.getGraph() : null);
        this.myGraphBuilder = new OCControlFlowBuilder(this, this.myGraph, this.mySelection);
        boolean isFirst = true;
        for (PsiElement codeFragment : this.myCodeFragments) {
            if (isFirst) {
                this.myGraphBuilder.processFirstCodeFragment(codeFragment);
            } else {
                this.myGraphBuilder.processNextCodeFragment(codeFragment);
            }
            isFirst = false;
        }
        this.myUnreachableCodeFinder = new OCUnreachableCodeFinder(this.myGraph);
        this.myInfiniteRecursionFinder = new OCInfiniteRecursionFinder(this.myGraph);
        this.myEndlessLoopFinder = new OCEndlessLoopFinder(this.myGraph);
        this.myUnreachableCodeFinder.process();
        this.myInfiniteRecursionFinder.process();
        this.myEndlessLoopFinder.process();
    }

    public void analyze() {
        Annotation annotation;
        PsiElement firstCodeFragment = this.myCodeFragments[0];
        PsiElement context = firstCodeFragment.getContext();
        OCCallable callable = firstCodeFragment instanceof OCCallable ? (OCCallable)firstCodeFragment : null;
        List<PsiElement> callableIdentifiers = null;
        if (callable instanceof OCMethod) {
            callableIdentifiers = ((OCMethod)callable).getSelectors();
        } else if (callable instanceof OCFunctionDefinition) {
            callableIdentifiers = Collections.singletonList(((OCFunctionDefinition)callable).getNameIdentifier());
        }
        if (callable != null && !callable.getReturnType().resolve(callable.getContainingFile()).isVoid() && this.myUnreachableCodeFinder.isDeadEndReached()) {
            OCBlockStatement body2 = callable.getBody();
            boolean isConstructor = false;
            if (body2 == null) {
                return;
            }
            OCSymbol oCSymbol = callable.getSymbol();
            if (callable.getContainingOCFile().isCpp() && callable instanceof OCFunctionDefinition && oCSymbol != null && oCSymbol.getKind().isConstructorOrDestructor()) {
                isConstructor = true;
            }
            if (oCSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)oCSymbol).isMainFunction()) {
                return;
            }
            if (!isConstructor) {
                String message2 = "Control reaches end of non-void " + callable.getKind().toStringLowercase();
                annotation = callable instanceof OCBlockExpression ? this.addErrorAnnotation(body2.getClosingBrace(), "err_maybe_falloff_nonvoid_block", message2) : (OCCompilerHelper.doesEmptyReturnFromNonVoidProduceError(body2.getContainingOCFile()) ? this.addErrorAnnotation(body2.getClosingBrace(), OCInspections.MissingReturn.class, "warn_falloff_nonvoid_function", message2) : this.addWarningAnnotation(body2.getClosingBrace(), OCInspections.MissingReturn.class, "warn_falloff_nonvoid_function", message2));
                OCType type2 = callable.getReturnType().resolve(body2.getContainingFile());
                this.registerQuickFix(annotation, new OCAddElementIntentionAction("Add return statement", body2, OCElementFactory.statementFromText("return " + type2.getDefaultValue(callable) + ";", firstCodeFragment)));
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(callable.getSymbol(), (OCType)OCVoidType.instance(), true));
            }
        }
        for (OCElementsRange range : this.myEndlessLoopFinder.getEndlessLoops()) {
            this.addWarningAnnotation((PsiElement)firstCodeFragment.getContainingFile(), range.getTextRange(), OCInspections.EndlessLoop.class, "warn_suggest_noreturn_function", "Endless loop", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        if (callableIdentifiers != null && !this.myInfiniteRecursionFinder.isExitOrDeadEndReached()) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>(callableIdentifiers);
            elements.addAll(this.myInfiniteRecursionFinder.getRecursiveCalls());
            this.addWarningAnnotations(elements, OCInspections.InfiniteRecursion.class, "CIDR", (Object)((Object)callable.getKind()) + " '" + callable.getName() + "' recurses infinitely");
        }
        boolean arcEnabled = firstCodeFragment != null && !OCCompilerHelper.isArcDisabled(firstCodeFragment.getContainingFile());
        for (OCSymbol oCSymbol : this.myGraph.getLocalSymbols()) {
            if (oCSymbol.isUnnamed()) continue;
            this.analyzeNotUsed(oCSymbol, context);
            this.analyzeInputOutput(oCSymbol);
            this.analyzeNotInitialized(oCSymbol, arcEnabled);
            if (arcEnabled) continue;
            this.analyzeNotReleased(oCSymbol, new OCNotReleasedVariablesChecker(this.myGraph, oCSymbol), true);
        }
        for (OCSymbol oCSymbol : this.myGraph.getClosureSymbols()) {
            if (oCSymbol.isUnnamed()) continue;
            this.analyzeNotInitialized(oCSymbol, arcEnabled);
            this.analyzeInputOutput(oCSymbol);
        }
        if (!arcEnabled && firstCodeFragment != null) {
            for (Pair pair : OCNotReleasedVariablesChecker.getUnreleasedObjects(firstCodeFragment)) {
                OCCallable method2;
                OCSymbol symbol;
                annotation = this.addWarningAnnotation((PsiElement)pair.getFirst(), OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
                PsiElement object = (PsiElement)pair.getSecond();
                this.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(object, "autorelease"));
                if (!(object.getParent() instanceof OCReturnStatement) || !((symbol = (method2 = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)object, OCCallable.class)) != null ? method2.getSymbol() : null) instanceof OCMethodSymbol)) continue;
                this.registerQuickFix(annotation, new OCChangeGCCAttributeIntentionAction(symbol, "ns_returns_retained", "NS_RETURNS_RETAINED", true));
            }
        }
        this.analyzeEscapedValue();
        for (OCDataFlowAnalyzer oCDataFlowAnalyzer : this.myChildAnalyzers) {
            oCDataFlowAnalyzer.analyze();
            this.myInputVariables.addAll(oCDataFlowAnalyzer.getInputVariables());
            this.myOutputVariables.addAll(oCDataFlowAnalyzer.getOutputVariables());
            this.myEscapedDeclarators.addAll(oCDataFlowAnalyzer.getEscapedDeclarators());
            this.myWrittenVariables.addAll(oCDataFlowAnalyzer.getWrittenVariables());
            for (OCSymbol symbol : oCDataFlowAnalyzer.myVariableUsages.keySet()) {
                if (this.myVariableUsages.containsKey(symbol)) continue;
                this.myVariableUsages.put(symbol, oCDataFlowAnalyzer.myVariableUsages.get(symbol));
            }
        }
        if (this.mySelection != null) {
            Comparator comparator2 = (s1, s2) -> s1.getOffset() - s2.getOffset();
            Collections.sort(this.myInputVariables, comparator2);
            Collections.sort(this.myOutputVariables, comparator2);
            Collections.sort(this.myWrittenVariables, comparator2);
            Collections.sort(this.myEscapedDeclarators, comparator2);
        }
    }

    private void analyzeNotInitialized(@NotNull OCSymbol symbol, boolean arcEnabled) {
        if (symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
            return;
        }
        OCType resolvedType = symbol.getResolvedType();
        if (resolvedType instanceof OCStructType) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            for (OCStructSymbol struct : ((OCStructType)resolvedType).getStructs()) {
                if (!struct.processConstructors((Processor<? super OCFunctionSymbol>)finder)) break;
                if (!((OCStructType)resolvedType).isEmpty()) continue;
                return;
            }
            if (finder.isFound()) {
                return;
            }
        }
        if (arcEnabled && resolvedType.isPointerToObjectCompatible()) {
            return;
        }
        if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic()) {
            return;
        }
        OCNotInitializedVarChecker notInitializedChecker = new OCNotInitializedVarChecker(this.myGraph, symbol);
        notInitializedChecker.process();
        for (PsiElement read2 : notInitializedChecker.getNotInitializedReads()) {
            if (OCDataFlowAnalyzer.isComplicatedCppInstruction(symbol, read2) || OCDataFlowAnalyzer.isStaticallyEvaluated(read2)) continue;
            Annotation annotation = this.addWarningAnnotation(read2, symbol, OCInspections.NotInitializedVariable.class, "warn_uninit_var", symbol.getNameWithKindUppercase() + " might not have been initialized");
            OCInstruction declInstruction = this.myGraph.getDeclaratorInstruction(symbol);
            if (declInstruction == null) {
                declInstruction = this.myGraph.getClosureVariableDeclaratorGraph(symbol).getDeclaratorInstruction(symbol);
            }
            this.registerQuickFix(annotation, new OCAddInitializerIntentionAction((OCDeclarator)declInstruction.getRValue(), symbol));
        }
    }

    private static boolean isStaticallyEvaluated(@NotNull PsiElement element) {
        for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof OCSizeofExpression || parent instanceof OCCppTypeidExpression || parent instanceof OCGenericSelectionExpression) {
                return true;
            }
            if (!(parent instanceof OCTypeElement) || !Arrays.stream(parent.getNode().getChildren(null)).map(OCElementUtil::getElementType).anyMatch(elementType -> elementType == OCTokenTypes.DECLTYPE_CPP_KEYWORD)) continue;
            return true;
        }
        return false;
    }

    private static boolean isComplicatedCppInstruction(@NotNull OCSymbol symbol, @NotNull PsiElement read2) {
        OCFile file2 = symbol.getContainingOCFile();
        if (file2 != null && file2.isCpp()) {
            OCType type2 = symbol.getResolvedType();
            if (type2 instanceof OCMagicType || type2 instanceof OCStructType && ((OCStructType)type2).getSymbol().hasMemberFunctions()) {
                return true;
            }
            if (read2.getParent() instanceof OCQualifiedExpression) {
                PsiElement parent = read2.getParent();
                while (parent instanceof OCQualifiedExpression) {
                    OCQualifiedExpression expr = (OCQualifiedExpression)parent;
                    if (expr.getResolvedType() instanceof OCMagicType) {
                        return true;
                    }
                    parent = PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{OCParenthesizedExpression.class});
                }
            }
        }
        return false;
    }

    private void analyzeNotUsed(@NotNull OCSymbol symbol, @Nullable PsiElement context) {
        if (OCDataFlowAnalyzer.hasReferenceType(symbol, context) || symbol.getProject().getUserData(OCFile.DFA_UNUSED_CHECKS) == OCFile.UnusedChecksMode.DISABLED) {
            return;
        }
        OCNotUsedValueChecker notUsedChecker = new OCNotUsedValueChecker(this.myGraph, symbol);
        notUsedChecker.process();
        for (PsiElement write2 : notUsedChecker.getNotUsedWrites()) {
            String text;
            if (OCElementUtil.isPartOfMacroSubstitution(write2.getParent()) || write2.getParent() instanceof OCDeclarator && (!notUsedChecker.isSymbolUsed() || "0".equals(text = OCElementUtil.getTextWithMacros(write2 = ((OCDeclarator)write2.getParent()).getInitializer())) || OCCodeInsightUtil.isLikeNull(text)) || write2 == null) continue;
            Annotation annotation = this.addWarningAnnotation(write2, symbol, OCInspections.UnusedValue.class, "CIDR", "The value is never used", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            PsiElement element = write2.getContext();
            if (element instanceof OCDeclarator) {
                this.registerQuickFix(annotation, new OCRemoveInitializerIntentionAction((OCDeclarator)element));
                continue;
            }
            this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction("statement", element));
            this.registerQuickFix(annotation, new OCRemoveDeclarationButInitializerIntentionAction("statement", element));
        }
        if (!notUsedChecker.isSymbolUsed() && this.enableUnusedCheck(symbol, context)) {
            String clangID;
            Class inspectionClass;
            String messageSuffix = notUsedChecker.isSymbolAssigned() ? " is only assigned but never accessed" : " is never used";
            PsiElement declaratorElement = this.myGraph.getDeclaratorInstruction(symbol).getRValue();
            if (PsiTreeUtil.getParentOfType((PsiElement)declaratorElement, OCTypeElement.class) != null) {
                return;
            }
            if (declaratorElement instanceof OCDeclarator) {
                declaratorElement = ((OCDeclarator)declaratorElement).getNameIdentifier();
            }
            if (symbol.getKind() == OCSymbolKind.PARAMETER) {
                inspectionClass = OCInspections.UnusedParameter.class;
                clangID = "warn_unused_parameter";
            } else if (symbol.getKind() == OCSymbolKind.LABEL) {
                inspectionClass = OCInspections.UnusedLocalVariable.class;
                clangID = "warn_unused_label";
            } else {
                inspectionClass = OCInspections.UnusedLocalVariable.class;
                clangID = "warn_unused_variable";
            }
            Annotation annotation = this.addWarningAnnotation(declaratorElement, symbol, inspectionClass, clangID, symbol.getNameWithKindUppercase() + messageSuffix, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol));
            this.registerQuickFix(annotation, new OCRemoveDeclarationButInitializerIntentionAction(symbol));
            this.registerQuickFix(annotation, (IntentionAction)new OCChangeGCCAttributeIntentionAction.SuppressFix(symbol, "unused", "__unused", true));
        }
    }

    private static boolean hasReferenceType(@NotNull OCSymbol symbol, @Nullable PsiElement context) {
        OCType resolvedType = symbol.getType().resolve(new OCResolveContext(context));
        return resolvedType instanceof OCCppReferenceType;
    }

    private boolean enableUnusedCheck(@NotNull OCSymbol symbol, @Nullable PsiElement context) {
        OCType symbolType = symbol.getType().resolve(new OCResolveContext(context));
        if (OCDataFlowAnalyzer.specifiedByUsedOrUnusedAttribute(symbol) || OCDataFlowAnalyzer.specifiedByUsedOrUnusedAttribute(symbolType)) {
            return false;
        }
        switch (symbol.getKind()) {
            case PARAMETER: {
                return this.enableUnusedCheckForParameter(symbol);
            }
            case LOCAL_VARIABLE: {
                return OCDataFlowAnalyzer.enableUnusedCheckForLocalVariable(symbol, context);
            }
            case CATCH_EXCEPTION_VARIABLE: {
                return false;
            }
        }
        return true;
    }

    private static boolean specifiedByUsedOrUnusedAttribute(@NotNull OCSymbol symbol) {
        return symbol.hasAttribute("unused") || symbol.hasAttribute("used");
    }

    private static boolean specifiedByUsedOrUnusedAttribute(@NotNull OCType type2) {
        if (type2 instanceof OCStructType) {
            return OCDataFlowAnalyzer.specifiedByUsedOrUnusedAttribute(((OCStructType)type2).getSymbol());
        }
        return false;
    }

    private boolean enableUnusedCheckForParameter(@NotNull OCSymbol symbol) {
        OCSymbol parentSymbol;
        PsiElement firstCodeFragment = this.myCodeFragments[0];
        OCCallable callable = firstCodeFragment instanceof OCCallable ? (OCCallable)firstCodeFragment : null;
        OCSymbol oCSymbol = parentSymbol = callable != null ? callable.getSymbol() : null;
        if (parentSymbol == null || parentSymbol.getKind() == OCSymbolKind.BLOCK || parentSymbol.getKind() == OCSymbolKind.LAMBDA || parentSymbol.hasAttribute("ibaction")) {
            return false;
        }
        if (parentSymbol instanceof OCFunctionSymbol) {
            return !((OCFunctionSymbol)parentSymbol).isMainFunction();
        }
        if (parentSymbol instanceof OCMethodSymbol) {
            OCMethodSymbol method2 = (OCMethodSymbol)parentSymbol;
            if (((OCClassSymbol)method2.getParent()).getKind() != OCSymbolKind.IMPLEMENTATION) {
                return false;
            }
            OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> searchParameters = OCMemberInheritorsSearch.getParameters(method2);
            searchParameters.setAncestors(true);
            if (OCMemberInheritorsSearch.search(searchParameters).findFirst() != null) {
                return false;
            }
            OCMethodSymbol associatedSymbol = method2.getAssociatedSymbol();
            if (associatedSymbol != null) {
                method2 = associatedSymbol;
            }
            GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(symbol.getProject());
            Object methodDefinition = method2.locateDefinition();
            if (methodDefinition == null) {
                return false;
            }
            ReferencesSearch.SearchParameters parameters2 = new ReferencesSearch.SearchParameters(methodDefinition, (SearchScope)scope, false);
            return new OCMethodReferencesSearch().execute(parameters2, (Processor<PsiReference>)((Processor)psiReference -> !(psiReference.getElement() instanceof OCSelectorExpression) && !(psiReference instanceof OCExternalReference)));
        }
        return false;
    }

    private static boolean enableUnusedCheckForLocalVariable(@NotNull OCSymbol symbol, @Nullable PsiElement context) {
        if (!(symbol instanceof OCDeclaratorSymbol)) {
            return true;
        }
        OCDeclaratorSymbol declaratorSymbol = (OCDeclaratorSymbol)symbol;
        OCType declaratorType = declaratorSymbol.getType().resolve(new OCResolveContext(context));
        if (declaratorType instanceof OCStructType) {
            OCStructSymbol structSymbol = ((OCStructType)declaratorType).getSymbol();
            return OCDataFlowAnalyzer.hasTrivialDestructor(structSymbol, context);
        }
        return !(declaratorType instanceof OCMagicType);
    }

    private static boolean hasTrivialDestructor(@NotNull OCStructSymbol symbol, @Nullable PsiElement context) {
        PsiFile file2 = context != null ? context.getContainingFile() : null;
        Map<OCStructSymbol, Boolean> cache2 = OCDataFlowAnalyzer.getTrivialDtorCache(file2);
        if (cache2 != null && cache2.containsKey(symbol)) {
            return cache2.get(symbol);
        }
        Boolean hasTrivialDestructor = symbol.hasTrivialDestructor(new OCResolveContext(context));
        if (cache2 != null) {
            cache2.put(symbol, hasTrivialDestructor);
        }
        return hasTrivialDestructor;
    }

    private static Map<OCStructSymbol, Boolean> getTrivialDtorCache(@Nullable PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)file2.getProject());
        Key modificationTracker = PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT;
        CachedValueProvider provider2 = () -> new CachedValueProvider.Result(OCTypeUtils.newDeepEqualityMap(), new Object[]{modificationTracker});
        return (Map)manager.getCachedValue((UserDataHolder)file2, TRIVIAL_DTOR_CACHE, provider2, false);
    }

    public void analyzeNotReleased(@NotNull OCSymbol symbol, @NotNull OCNotReleasedVariablesChecker checker, boolean processReturns) {
        OCCallable callable;
        if (processReturns) {
            checker.setStartFromReturns(true);
        }
        if (!symbol.getResolvedType().isPointerToObjectCompatible() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic()) {
            return;
        }
        checker.process();
        HashSet<PsiElement> notReleasedElements = new HashSet<PsiElement>();
        for (PsiElement element : checker.getNotReleasedElements()) {
            notReleasedElements.add(element);
            Annotation annotation = this.addWarningAnnotation(element, symbol, OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
            this.registerQuickFix(annotation, new OCReleaseVariablesIntentionAction(symbol, element));
            this.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "autorelease"));
        }
        if (processReturns && this.myCodeFragments[0] instanceof OCCallable && !OCElementUtil.isRetainMethod(callable = (OCCallable)this.myCodeFragments[0])) {
            checker.setStartFromReturns(false);
            checker.process();
            for (PsiElement element : checker.getNotReleasedElements()) {
                if (notReleasedElements.contains(element)) continue;
                Annotation annotation = this.addWarningAnnotation(element, symbol, OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
                this.registerQuickFix(annotation, new OCReleaseVariablesIntentionAction(symbol, element));
                this.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "autorelease"));
                this.registerQuickFix(annotation, new OCChangeGCCAttributeIntentionAction(callable.getSymbol(), "ns_returns_retained", "NS_RETURNS_RETAINED", true));
            }
        }
    }

    private void analyzeEscapedValue() {
        OCEscapedValuesChecker checker = new OCEscapedValuesChecker(this.myGraph);
        checker.process();
        for (PsiElement element : checker.getEscapedVariables()) {
            this.addWarningAnnotation(element, OCInspections.LocalValueEscapesScope.class, OCClangMessageFinder.getInstance().getReturnStackAddr(), "Local value may escape the method/function");
        }
        for (PsiElement element : checker.getEscapedObjects()) {
            String message2 = (element instanceof OCBlockExpression ? "Block" : "Value") + " escapes the local scope";
            Annotation annotation = this.addWarningAnnotation(element, OCInspections.LocalValueEscapesScope.class, OCClangMessageFinder.getInstance().getReturnTempAddr(), message2);
            if (!(element instanceof OCBlockExpression)) continue;
            this.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "copy"));
        }
    }

    private void analyzeInputOutput(@NotNull OCSymbol symbol) {
        if (this.mySelection == null) {
            return;
        }
        OCInputOutputVariablesFinder finder = new OCInputOutputVariablesFinder(this.myGraph, symbol, this.mySelection);
        finder.process();
        boolean needUsages = false;
        if (finder.isInputVariable()) {
            this.myInputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isOutputVariable()) {
            this.myOutputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isWrittenVariable()) {
            this.myWrittenVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isEscapedDeclarator()) {
            this.myEscapedDeclarators.add(symbol);
            needUsages = true;
        }
        if (needUsages) {
            this.myVariableUsages.put(symbol, finder.getVariableUsages());
        }
    }

    public List<PsiReference> getVariableUsages(@NotNull OCSymbol symbol) {
        return this.myVariableUsages.get(symbol);
    }

    public boolean hasCrossSelectionJumps() {
        return this.myGraphBuilder.hasCrossSelectionJumps();
    }

    public boolean hasDanglingJumps() {
        return this.myGraphBuilder.hasDanglingJumps();
    }

    @Nullable
    private Annotation addWarningAnnotation(@Nullable PsiElement element, @NotNull OCSymbol symbol, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message2, @Nullable ProblemHighlightType highlightType) {
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        if (macroRange != null && !macroRange.mapsToArguments()) {
            OCMacroCall macroCall = macroRange.getMacroCall();
            if (symbol.getOffset() == 0 || macroCall != null && symbol.getOffset() == macroCall.getTextRange().getEndOffset()) {
                return null;
            }
        }
        return this.addWarningAnnotation(element, inspectionClass, clangID, message2, highlightType);
    }

    @Nullable
    private Annotation addWarningAnnotation(@Nullable PsiElement element, @NotNull OCSymbol symbol, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message2) {
        return this.addWarningAnnotation(element, symbol, inspectionClass, clangID, message2, null);
    }
}

