/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OCLocalDefinitionsSearcher
extends OCSingleSymbolAlgorithm {
    private MultiMap<OCInstruction.InstructionKind, OCInstruction> myInstructions = new MultiMap();
    private PsiElement myStartElement;
    private boolean myStopOnWrite;
    private boolean myProcessStartInstruction;

    public OCLocalDefinitionsSearcher(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol, @NotNull PsiElement startElement, boolean forward, boolean stopOnWrite, boolean processStartInstruction) {
        super(cfg, forward, symbol);
        this.myStartElement = startElement;
        this.myStopOnWrite = stopOnWrite;
        this.myProcessStartInstruction = processStartInstruction;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        return (OCElementUtil.isEqualWithMacros(this.myStartElement, instruction.getRValue()) || OCElementUtil.isEqualWithMacros(this.myStartElement, instruction.getLValue())) && instruction.getKind() != OCInstruction.InstructionKind.DECLARATOR && instruction.getKind() != OCInstruction.InstructionKind.KILL;
    }

    @Override
    public void process() {
        this.clearProcessedNodes();
        Collection<OCInstruction> startInstructions = this.getStartInstructions();
        if (startInstructions.isEmpty()) {
            return;
        }
        OCInstruction startInstruction = startInstructions.iterator().next();
        for (OCInstruction instruction : startInstructions) {
            if (instruction.getKind() != OCInstruction.InstructionKind.WRITE) continue;
            startInstruction = instruction;
        }
        if (this.myProcessStartInstruction && !this.processInstruction(startInstruction)) {
            return;
        }
        this.traverse(startInstruction, this.mySymbol, this.myIsForward);
    }

    public void processFromStart() {
        this.traverseFromStart(this.mySymbol);
    }

    @Override
    protected boolean processInstruction(@NotNull OCInstruction instruction) {
        OCInstruction.InstructionKind kind2 = instruction.getKind();
        this.myInstructions.putValue((Object)kind2, (Object)instruction);
        return !this.myStopOnWrite || kind2 != OCInstruction.InstructionKind.WRITE;
    }

    public Collection<OCInstruction> getInstructionsOfKind(@NotNull OCInstruction.InstructionKind kind2) {
        return this.myInstructions.get((Object)kind2);
    }
}

