/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNotReleasedVariablesChecker
extends OCSingleSymbolAlgorithm {
    private Set<Pair<OCInstanceVariableSymbol, PsiElement>> myAssignedIvars = new HashSet<Pair<OCInstanceVariableSymbol, PsiElement>>();
    private boolean myWasRetained;
    private boolean myStartFromReturns;

    public OCNotReleasedVariablesChecker(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol) {
        super(cfg, false, symbol);
    }

    public void setStartFromReturns(boolean startFromReturns) {
        this.myStartFromReturns = startFromReturns;
    }

    private boolean isAssignmentToOuterScopeVariable(@NotNull OCInstruction instruction) {
        PsiElement element = instruction.getRValue();
        if (element instanceof OCReferenceExpression && element.getParent() instanceof OCAssignmentExpression) {
            OCAssignmentExpression assignment = (OCAssignmentExpression)element.getParent();
            OCExpression receiver2 = assignment.getReceiverExpression();
            if (assignment.getSourceExpression() == element) {
                OCSymbol symbol = OCNotReleasedIvarInspection.getReceiverSymbol(receiver2, true);
                OCInstanceVariableSymbol ivar = OCNotReleasedIvarInspection.getReceiverIvar(receiver2);
                if (ivar != null) {
                    this.myAssignedIvars.add((Pair<OCInstanceVariableSymbol, PsiElement>)new Pair((Object)ivar, (Object)receiver2));
                    return true;
                }
                if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic()) {
                    return true;
                }
            }
        } else if (element instanceof OCReferenceExpression && element.getParent() instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element.getParent();
            OCSymbol symbol = declarator.getSymbol();
            if (declarator.getInitializer() == element && symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction.getKind() != OCInstruction.InstructionKind.READ && instruction.getKind() != OCInstruction.InstructionKind.READ_IN_BLOCK) {
            return false;
        }
        PsiElement element = instruction.getRValue();
        if (element instanceof OCReferenceExpression && (OCElementUtil.isReleaseCall(element.getParent()) || this.myStartFromReturns && element.getParent() instanceof OCReturnStatement)) {
            return true;
        }
        return this.isAssignmentToOuterScopeVariable(instruction);
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        PsiElement rValue = instruction.getRValue();
        if (instruction.getKind() == OCInstruction.InstructionKind.WRITE) {
            if (OCElementUtil.isRetainCall(rValue, true)) {
                this.myWasRetained = true;
                return true;
            }
            return false;
        }
        if (instruction.getKind() == OCInstruction.InstructionKind.READ) {
            PsiElement call;
            PsiElement psiElement = call = rValue != null ? rValue.getParent() : null;
            if (call instanceof OCSendMessageExpression && ((OCSendMessageExpression)call).getMessageSelector().equals("retain") && OCNotReleasedVariablesChecker.getLastUnreleasedCall((OCSendMessageExpression)call) != null) {
                this.myWasRetained = true;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    protected PsiElement getElementFromInstruction(@NotNull OCInstruction instruction) {
        if (instruction.getKind() == OCInstruction.InstructionKind.READ) {
            PsiElement rValue = instruction.getRValue();
            return rValue != null ? rValue.getParent() : null;
        }
        return super.getElementFromInstruction(instruction);
    }

    @NotNull
    public List<PsiElement> getNotReleasedElements() {
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null || !instructions.get((Object)OCInstruction.InstructionKind.READ_IN_BLOCK).isEmpty()) {
            return Collections.emptyList();
        }
        this.myWasRetained = false;
        List<PsiElement> result2 = this.getNonReachableElements();
        if (this.myWasRetained) {
            for (Pair<OCInstanceVariableSymbol, PsiElement> pair : this.myAssignedIvars) {
                this.handleAssignedIvar(pair);
            }
        }
        return result2;
    }

    protected void handleAssignedIvar(@NotNull Pair<OCInstanceVariableSymbol, PsiElement> pair) {
    }

    @NotNull
    public static List<Pair<OCSendMessageExpression, PsiElement>> getUnreleasedObjects(@NotNull PsiElement codeFragment) {
        final ArrayList<Pair<OCSendMessageExpression, PsiElement>> result2 = new ArrayList<Pair<OCSendMessageExpression, PsiElement>>();
        codeFragment.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression2) {
                OCSymbol symbol;
                super.visitSendMessageExpression(expression2);
                if (!OCElementUtil.isRetainCall(expression2, false)) {
                    return;
                }
                List<OCMethodSymbol> responders = expression2.getProbableResponders().getAllResponders();
                if (responders.isEmpty()) {
                    return;
                }
                for (OCMethodSymbol responder : responders) {
                    if (responder.getReturnType().resolve(expression2.getContainingOCFile()).isPointerToObjectCompatible()) continue;
                    return;
                }
                OCExpression receiver2 = expression2.getReceiverExpression();
                if ("retain".equals(expression2.getMessageSelector()) && (receiver2 instanceof OCReferenceExpression ? (symbol = ((OCReferenceExpression)receiver2).resolveToSymbol()) != null && symbol.getKind().isVariable() : OCNotReleasedIvarInspection.getReceiverIvar(receiver2) != null)) {
                    return;
                }
                PsiElement call = OCNotReleasedVariablesChecker.getLastUnreleasedCall(expression2);
                if (call != null) {
                    if (call.getParent() instanceof OCReturnStatement && OCElementUtil.isRetainMethod((OCCallable)PsiTreeUtil.getParentOfType((PsiElement)call, OCCallable.class))) {
                        return;
                    }
                    result2.add(Pair.create((Object)expression2, (Object)call));
                }
            }
        });
        return result2;
    }

    @Nullable
    private static PsiElement getLastUnreleasedCall(@NotNull OCSendMessageExpression expression2) {
        PsiElement parent = expression2.getParent();
        OCSendMessageExpression kid = expression2;
        OCType type2 = expression2.getResolvedType();
        while (parent != null) {
            if (parent instanceof OCParenthesizedExpression || parent instanceof OCCastExpression || parent instanceof OCConditionalExpression) {
                kid = parent;
                parent = parent.getParent();
                continue;
            }
            if (parent instanceof OCAssignmentExpression) {
                OCSymbol symbol;
                OCExpression receiver2 = ((OCAssignmentExpression)parent).getReceiverExpression();
                if (receiver2 instanceof OCQualifiedExpression && (symbol = ((OCQualifiedExpression)receiver2).resolveToSymbol()) instanceof OCPropertySymbol && ((OCPropertySymbol)symbol).isRetained()) break;
                return null;
            }
            if (parent instanceof OCDeclarator) {
                return null;
            }
            if (parent instanceof OCMessageArgument || !(parent instanceof OCSendMessageExpression)) break;
            OCSendMessageExpression parentCall = (OCSendMessageExpression)parent;
            String selector2 = parentCall.getMessageSelector();
            if (OCElementUtil.isReleaseSelector(selector2)) {
                return null;
            }
            if (OCElementUtil.isRetainCall(parentCall, false) || !parentCall.getResolvedType().isCompatible(type2, expression2)) break;
            kid = parent;
            parent = parent.getParent();
        }
        return kid;
    }
}

