/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCSingleSymbolAlgorithm
extends OCDataFlowAlgorithm {
    protected boolean myIsForward;
    protected OCSymbol mySymbol;

    protected OCSingleSymbolAlgorithm(@NotNull OCControlFlowGraph cfg, boolean forward, @NotNull OCSymbol symbol) {
        super(cfg);
        this.myIsForward = forward;
        this.mySymbol = symbol;
    }

    @Override
    public void process() {
        this.clearProcessedNodes();
        for (OCInstruction instruction : this.getStartInstructions()) {
            this.traverse(instruction, this.mySymbol, this.myIsForward);
        }
    }

    @Override
    @NotNull
    protected Collection<OCInstruction> getStartInstructions() {
        ArrayList<OCInstruction> result2 = new ArrayList<OCInstruction>();
        for (OCInstruction instruction : this.myCfg.getAllInstructions()) {
            if (instruction.getSymbolOffset() != this.mySymbol.getComplexOffset() || !this.isStartInstruction(instruction)) continue;
            result2.add(instruction);
        }
        return result2;
    }

    @NotNull
    protected List<PsiElement> getReachableElements() {
        return this.getReachableElements(this.myIsForward, this.mySymbol, false);
    }

    @NotNull
    protected List<PsiElement> getNonReachableElements() {
        return this.getReachableElements(this.myIsForward, this.mySymbol, true);
    }
}

