/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.documentation.DoxygenRender;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesProvider;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDocumentationProvider
implements DocumentationProvider {
    public static final String PSI_LINK_PREFIX_METHOD = "method,";
    @Nullable
    final ExternalProvider myExternalProvider;
    private Map<String, CodeStyleSettings> mySettings = new HashMap();

    public CidrDocumentationProvider() {
        this(null);
    }

    public CidrDocumentationProvider(@Nullable ExternalProvider provider2) {
        this.myExternalProvider = provider2;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element == null) {
            return null;
        }
        String content = this.quickDocContent(element, originalElement, false);
        return content != null ? CidrDocumentationProvider.wrapDocInHtml(content) : null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String result2;
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFile) {
            return null;
        }
        if (element instanceof OCMethodSelectorPart) {
            element = element.getParent();
        }
        if (element instanceof OCSendMessageExpression && (result2 = CidrDocumentationProvider.methodCandidates((OCSendMessageExpression)element)) != null) {
            return result2;
        }
        String doc = this.generateDocInnerHtml(element, originalElement, false);
        return doc == null ? null : CidrDocumentationProvider.wrapDocInHtml(doc);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(@Nullable PsiManager psiManager, @Nullable Object object, @Nullable PsiElement element) {
        if (object instanceof OCSymbol) {
            return ((OCSymbol)object).locateDefinition();
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(@Nullable PsiManager psiManager, @Nullable String link, @Nullable PsiElement context) {
        if (link == null || psiManager == null) {
            return null;
        }
        if (link.startsWith(PSI_LINK_PREFIX_METHOD)) {
            List parts = StringUtil.split((String)(link = link.substring(PSI_LINK_PREFIX_METHOD.length())), (String)",");
            if (parts.size() == 3) {
                PsiElement elementAt;
                PsiFile file2;
                String path = (String)parts.get(1);
                String offset = (String)parts.get(2);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file2 = psiManager.findFile(fileByPath)) != null && file2.isValid() && (elementAt = file2.findElementAt(Integer.parseInt(offset))) != null && elementAt.isValid()) {
                    return PsiTreeUtil.getParentOfType((PsiElement)elementAt, OCMethod.class, (boolean)false);
                }
            }
        } else {
            int idx = link.lastIndexOf(35);
            if (idx > -1) {
                PsiFile file3;
                String path = link.substring(0, idx);
                String offset = link.substring(idx + 1);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file3 = psiManager.findFile(fileByPath)) != null && file3.isValid()) {
                    int off = Integer.parseInt(offset);
                    PsiElement elementAt = file3.findElementAt(off);
                    return TargetElementUtil.getInstance().getNamedElement(elementAt, off);
                }
            }
        }
        return null;
    }

    @Nullable
    private static String buildLinkForMethod(@NotNull OCMethodSymbol symbol) {
        StringBuilder sb = new StringBuilder("psi_element://").append(PSI_LINK_PREFIX_METHOD);
        sb.append(symbol.getName());
        VirtualFile file2 = symbol.getContainingFile();
        if (file2 != null) {
            sb.append(',').append(file2.getPath()).append(',').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @Nullable
    private static String methodCandidates(@NotNull OCSendMessageExpression sme) {
        PsiReference reference = sme.getReference();
        if (reference != null && reference instanceof OCPolyVariantReference) {
            List list = ((OCPolyVariantReference)reference).resolveToSymbols();
            StringBuilder builder = new StringBuilder("");
            for (Object o : list) {
                if (!(o instanceof OCMethodSymbol)) continue;
                OCMethodSymbol symbol = (OCMethodSymbol)o;
                OCClassSymbol parent = (OCClassSymbol)symbol.getParent();
                String link = CidrDocumentationProvider.buildLinkForMethod(symbol);
                if (link == null) continue;
                builder.append("<a href=\"").append(link).append("\">").append(symbol.getSignature()).append(" (").append(parent.getPresentableName()).append(")</a><br>");
            }
            return CodeInsightBundle.message((String)"javadoc.candidates", (Object[])new Object[]{sme.getExpectedMethodSignature(), builder.toString()});
        }
        return null;
    }

    @Nullable
    protected String quickDocContent(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean fullDoc) {
        PsiElement resolved;
        if (originalElement != null && originalElement.getParent() instanceof OCReferenceElement) {
            originalElement = originalElement.getParent();
        }
        if ((resolved = CidrDocumentationProvider.resolveIfRequired(element)) == null) {
            return null;
        }
        element = resolved;
        if (element instanceof OCMethod) {
            return CidrDocumentationProvider.methodHintDoc((OCMethod)element);
        }
        if (element instanceof OCCppNamespace) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCSymbol symbol = ((OCCppNamespace)element).getSymbol();
            if (symbol instanceof OCNamespaceSymbol) {
                OCNamespaceSymbol namespaceSymbol = (OCNamespaceSymbol)symbol;
                if (namespaceSymbol.isInlineNamespace()) {
                    answer.append(OCTokenTypes.INLINE_KEYWORD.getName()).append(" ");
                }
                answer.append(symbol.getKindLowercase()).append(" ");
                String namespace = OCDocUtil.getNamespace(namespaceSymbol);
                if (!namespace.isEmpty()) {
                    answer.append(namespace).append("::");
                }
                return answer.append("<b>").append(symbol.getName()).append("</b>").toString();
            }
            return null;
        }
        if (element instanceof OCClassDeclaration) {
            OCFile file2;
            OCInterfaceSymbol anInterface;
            StringBuilder answer = new StringBuilder();
            OCClassDeclaration cd = (OCClassDeclaration)element;
            OCObjectType type2 = cd.getType();
            if (type2 != null && (anInterface = type2.getInterface()) != null && (file2 = anInterface.getContainingOCFile()) != null) {
                answer.append(CidrDocumentationProvider.declaredInHint(file2));
            }
            return answer.append(CidrDocumentationProvider.classHintDoc(cd)).toString();
        }
        if (element instanceof OCMethodSelectorPart) {
            StringBuilder answer = new StringBuilder();
            CidrDocumentationProvider.appendType(answer, ((OCMethodSelectorPart)element).getRawType(), ((OCMethodSelectorPart)element).getContainingOCFile(), true);
            answer.append(" <b>");
            answer.append(((OCMethodSelectorPart)element).getName());
            answer.append("</b>");
            return answer.toString();
        }
        if (element instanceof OCTypeParameterDeclaration) {
            return CidrDocumentationProvider.typeParameterHintDoc((OCTypeParameterDeclaration)element);
        }
        if (element instanceof OCCategoryName) {
            OCCategoryName category = (OCCategoryName)element;
            PsiElement parent = category.getParent();
            if (parent instanceof OCClassDeclaration) {
                OCClassDeclaration cd = (OCClassDeclaration)parent;
                return fullDoc ? this.generateDocInnerHtml(cd, originalElement, false) : this.quickDocContent(cd, originalElement, false);
            }
            return null;
        }
        if (element instanceof OCDeclarator) {
            String type3;
            OCClassDeclaration container;
            PsiElement pp;
            OCFile containingFile;
            PsiReference reference;
            OCDeclarator declarator = (OCDeclarator)element;
            StringBuilder answer = new StringBuilder();
            OCSymbol symbol = null;
            PsiReference psiReference = reference = originalElement == null ? null : originalElement.getReference();
            if (reference instanceof OCReference) {
                symbol = ((OCReference)reference).resolveToSymbol();
            }
            if (symbol == null) {
                symbol = declarator.getSymbol();
            }
            OCFile oCFile = containingFile = symbol == null ? null : symbol.getContainingOCFile();
            if (containingFile != null && symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
                answer.append(CidrDocumentationProvider.declaredInHint(containingFile));
            }
            if (symbol != null) {
                CidrDocumentationProvider.addNamespace(symbol, answer);
                CidrDocumentationProvider.addVisibility(symbol, answer);
            }
            if ((pp = element.getParent().getParent()) instanceof OCProperty) {
                OCProperty property = (OCProperty)pp;
                String iVarDoc = this.propertyIVarDoc(property);
                if (iVarDoc != null) {
                    return iVarDoc;
                }
                OCClassDeclaration container2 = property.getContainingClass();
                if (container2 != null) {
                    answer.append(CidrDocumentationProvider.classHintDoc(container2)).append("<br>");
                }
                answer.append("@property ");
                OCPropertyAttributesList attrs = property.getPropertyAttributesList();
                if (attrs != null) {
                    String attrsStr = StringUtil.join(attrs.getAttributes(), attribute -> attribute.getText(), (String)", ");
                    answer.append("(").append(attrsStr).append(") ");
                }
            } else if (pp instanceof OCInstanceVariablesList && (container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCClassDeclaration.class})) != null) {
                answer.append(CidrDocumentationProvider.classHintDoc(container)).append("<br>");
            }
            if (symbol != null) {
                if (symbol.getKind() == OCSymbolKind.INSTANCE_VARIABLE) {
                    answer.append("ivar ");
                } else if (symbol.getKind() == OCSymbolKind.TYPEDEF) {
                    answer.append("typedef ");
                }
            }
            if (symbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol definition;
                OCFunctionSymbol func = (OCFunctionSymbol)symbol;
                if (func.isFriend() && (definition = (OCFunctionSymbol)func.getDefinitionSymbol()) != null) {
                    func = definition;
                }
                answer.append(CidrDocumentationProvider.getTemplateParameters(func));
                OCDocUtil.extractModifiers(func, answer);
                if (!func.isCppConstructor() && !func.isCppDestructor()) {
                    type3 = CidrDocumentationProvider.effectiveTypeString(func);
                    answer.append(type3).append(OCDocUtil.delimiter(type3));
                }
                answer.append(CidrDocumentationProvider.getCanonicalNamePrefix(func));
                answer.append("<b>").append(CidrDocumentationProvider.escapeHTML(func.getName())).append("</b>");
                this.extractFunctionSignature(declarator, func, answer);
            } else if (symbol instanceof OCDeclaratorSymbol) {
                answer.append(CidrDocumentationProvider.getTemplateParameters(symbol));
                OCDocUtil.extractModifiers((OCDeclaratorSymbol)symbol, answer);
                boolean isEnumConst = symbol.getKind() == OCSymbolKind.ENUM_CONST;
                type3 = CidrDocumentationProvider.effectiveTypeString(symbol);
                answer.append(type3).append(OCDocUtil.delimiter(type3, isEnumConst ? "::" : " "));
                if (!isEnumConst) {
                    answer.append(CidrDocumentationProvider.getCanonicalNamePrefix(symbol));
                }
                answer.append("<b>").append(CidrDocumentationProvider.escapeHTML(symbol.getName())).append("</b>");
            } else {
                CidrDocumentationProvider.appendType(answer, declarator.getRawType(), element.getContainingFile(), false);
                answer.append(" <b>");
                answer.append(declarator.getName());
                answer.append("</b>");
            }
            this.processInitializer(declarator, answer);
            return answer.toString();
        }
        if (element instanceof OCDefineDirective) {
            PsiFile file3 = element.getContainingFile();
            StringBuilder answer = new StringBuilder();
            answer.append(CidrDocumentationProvider.declaredInHint(file3));
            OCMacroSymbol symbol = (OCMacroSymbol)((OCDefineDirective)element).getSymbol();
            if (symbol == null) {
                return "";
            }
            answer.append("#define <b>").append(CidrDocumentationProvider.escapeHTML(symbol.getName())).append("</b>");
            if (symbol.hasParameterList()) {
                answer.append('(');
                answer.append(StringUtil.join(symbol.getParameterNames(), name -> CidrDocumentationProvider.escapeHTML(name), (String)", "));
                answer.append(')');
            }
            answer.append(" ").append(CidrDocumentationProvider.escapeHTML(symbol.getSubstitution()));
            return answer.toString();
        }
        if (element instanceof OCCppUsingStatement) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCSymbol symbol = ((OCCppUsingStatement)element).getSymbol();
            if (symbol instanceof OCAliasUsingSymbol) {
                answer.append("using <b>");
                answer.append(symbol.getName());
                answer.append("</b> = ");
                answer.append(CidrDocumentationProvider.effectiveTypeString(symbol));
            }
            return answer.toString();
        }
        if (element instanceof OCCppNamespaceAlias) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCCppNamespaceAlias namespaceAliasElement = (OCCppNamespaceAlias)element;
            OCNamespaceAliasSymbol symbol = (OCNamespaceAliasSymbol)namespaceAliasElement.getSymbol();
            if (OCLog.LOG.assertTrue(symbol != null)) {
                OCSymbolKind kind2 = symbol.getKind();
                OCSymbolReference ref = symbol.getNamespaceReference();
                answer.append(kind2.getNameLowercase()).append(" ");
                answer.append("<b>").append(symbol.getName()).append("</b> = ");
                answer.append(ref.getQualifiedName().getCanonicalName(true));
            }
            return answer.toString();
        }
        if (element instanceof OCStructLike) {
            OCStructSymbol symbol = (OCStructSymbol)((OCStructLike)element).getSymbol();
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            if (symbol == null) {
                return answer.toString();
            }
            CidrDocumentationProvider.addNamespace(symbol, answer);
            CidrDocumentationProvider.addVisibility(symbol, answer);
            String canonicalNamePrefix = CidrDocumentationProvider.getCanonicalNamePrefix(symbol);
            String templateParamList = CidrDocumentationProvider.getTemplateParameters(symbol);
            if (symbol.isPredeclaration()) {
                OCDocUtil.extractModifiers(symbol, answer);
            } else {
                answer.append(templateParamList);
            }
            answer.append(symbol.getKindLowercase()).append(" ");
            if (symbol.isEnumClass()) {
                answer.append("class ");
            }
            answer.append(canonicalNamePrefix).append("<b>").append(symbol.getName()).append("</b>");
            CidrDocumentationProvider.extractTemplateSpecialization(symbol, answer);
            if (symbol.isFinal()) {
                answer.append(" ").append(OCTokenTypes.FINAL_CPP_KEYWORD.getName());
            }
            answer.append(CidrDocumentationProvider.getBaseClasses(symbol, element));
            return answer.toString().replaceAll("\\s+", " ");
        }
        OCFindUsagesProvider common = new OCFindUsagesProvider();
        if (common.canFindUsagesFor(element)) {
            return CidrDocumentationProvider.declaredInHint(element.getContainingFile()) + common.getType(element) + "  <b>" + common.getDescriptiveName(element) + "</b>";
        }
        return null;
    }

    @NotNull
    private static String getBaseClasses(@NotNull OCStructSymbol symbol, @NotNull PsiElement element) {
        OCResolveContext context = new OCResolveContext(element.getContext());
        Collection<Pair<OCType, OCVisibility>> baseClasses = symbol.getBaseCppClassesWithVisibility(context);
        if (!baseClasses.isEmpty()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, OCSymbolKind.NAMESPACE);
            OCFile containingFile = symbol.getContainingOCFile();
            String baseClassesStr = StringUtil.join(baseClasses, pair -> {
                OCVisibility visibility = (OCVisibility)((Object)((Object)pair.getSecond()));
                String visibilityStr = "";
                if (visibility != null) {
                    visibilityStr = (Object)((Object)visibility) + " ";
                }
                OCType type2 = (OCType)pair.getFirst();
                return visibilityStr + OCDocUtil.getCanonicalName(type2, contextNamespace, containingFile);
            }, (String)", ");
            return " : " + baseClassesStr;
        }
        return "";
    }

    private void processInitializer(@NotNull OCDeclarator declarator, @NotNull StringBuilder answer) {
        OCExpression initializer = (declarator = this.cleanAndReformat(declarator, OCDeclarator.class)).getInitializer();
        if (initializer != null) {
            answer.append(" =");
        } else {
            initializer = declarator.getInitializerList();
        }
        if (initializer != null) {
            answer.append(" ");
            CidrDocumentationProvider.processExpressionElement(initializer, answer);
        } else {
            OCArgumentList args = declarator.getArgumentList();
            if (args != null) {
                CidrDocumentationProvider.processExpressionElement(args, answer);
            }
        }
    }

    private static void processExpressionElement(@NotNull OCElement initializer, @NotNull StringBuilder answer) {
        String text = initializer.getTextWithMacros();
        int idx = text.indexOf(10);
        if (idx != -1) {
            String part = text.substring(0, idx).replaceAll("\\s+", " ");
            answer.append(CidrDocumentationProvider.escapeHTML(part)).append("...");
        } else {
            answer.append(CidrDocumentationProvider.escapeHTML(text));
        }
    }

    private void extractFunctionSignature(OCDeclarator declarator, OCFunctionSymbol symbol, StringBuilder answer) {
        declarator = this.cleanAndReformat(declarator, OCDeclarator.class);
        Collection<OCTypeArgument> substitutionTypes = symbol.getSubstitution().getSubstitutedTypes();
        if (substitutionTypes != null && !substitutionTypes.isEmpty()) {
            answer.append(OCDocUtil.getParametersSignature(symbol, false));
        } else {
            CidrDocumentationProvider.extractTemplateSpecialization(symbol, answer);
            answer.append(OCDocUtil.getParametersSignature(symbol, true));
        }
        OCDocUtil.extractFuncPostModifiers(symbol, answer);
        OCNoexceptSpecifier noexcept = (OCNoexceptSpecifier)PsiTreeUtil.findChildOfType((PsiElement)declarator, OCNoexceptSpecifier.class);
        if (noexcept != null) {
            CidrDocumentationProvider.processExpressionElement(noexcept, answer.append(" "));
        }
    }

    @NotNull
    private static String getTemplateParameters(@NotNull OCSymbol symbol) {
        if (symbol instanceof OCTemplateSymbol && symbol instanceof OCSymbolWithQualifiedName) {
            StringBuilder sb = new StringBuilder();
            OCTemplateSymbol templateSymbol = (OCTemplateSymbol)symbol;
            if (templateSymbol.isTemplateSymbol()) {
                List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)((Object)templateSymbol), OCSymbolKind.NAMESPACE);
                OCFile containingFile = symbol.getContainingOCFile();
                List<OCTypeParameterSymbol> templateParams = templateSymbol.getTemplateParameters();
                OCDocUtil.wrapTemplateParams(templateParams, contextNamespace, containingFile, sb);
                return sb.append("<br>").toString();
            }
        }
        return "";
    }

    @NotNull
    private <T extends PsiElement> T cleanAndReformat(@NotNull OCElement element, Class<T> clazz) {
        Language language;
        CodeFormatterFacade formatterFacade;
        PsiElement result2;
        PsiElement copy = element.copy();
        final ArrayList comments = new ArrayList();
        copy.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            public void visitComment(PsiComment comment) {
                comments.add(comment);
            }
        });
        for (PsiElement comment : comments) {
            comment.delete();
        }
        if (SourceTreeToPsiMap.hasTreeElement(copy) && (result2 = SourceTreeToPsiMap.treeElementToPsi((formatterFacade = new CodeFormatterFacade(this.getSettings(language = copy.getLanguage()), language)).processElement(SourceTreeToPsiMap.psiElementToTree(copy)))) != null) {
            return (T)result2;
        }
        return (T)copy;
    }

    private CodeStyleSettings getSettings(Language lang) {
        String langID = lang.getID();
        if (!this.mySettings.containsKey(langID)) {
            CodeStyleSettings settings = new CodeStyleSettings();
            settings.getCommonSettings((Language)lang).KEEP_LINE_BREAKS = true;
            settings.getCommonSettings((Language)lang).SPACE_WITHIN_BRACES = true;
            ((OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)).DO_NOT_ADD_BREAKS = true;
            this.mySettings.put(langID, settings);
        }
        return this.mySettings.get(langID);
    }

    private static void extractTemplateSpecialization(@NotNull OCSymbolWithQualifiedName symbol, @NotNull StringBuilder sb) {
        List<OCTypeArgument> specialization;
        if (symbol instanceof OCTemplateSymbol && (specialization = ((OCTemplateSymbol)((Object)symbol)).getTemplateSpecialization()) != null && !specialization.isEmpty()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, OCSymbolKind.NAMESPACE);
            OCFile containingFile = symbol.getContainingOCFile();
            OCDocUtil.wrapTemplateArgs(specialization, contextNamespace, containingFile, sb);
        }
    }

    private static void addNamespace(@NotNull OCSymbol symbol, @NotNull StringBuilder answer) {
        String namespace;
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER && (namespace = OCDocUtil.getNamespace((OCSymbolWithQualifiedName)symbol)).length() > 0) {
            answer.append("namespace ").append(namespace).append("<br><br>");
        }
    }

    private static void addVisibility(@NotNull OCSymbol symbol, @NotNull StringBuilder answer) {
        OCVisibility visibility;
        if (symbol instanceof OCSymbolWithQualifiedName && (visibility = ((OCSymbolWithQualifiedName)symbol).getVisibility()) != null && visibility != OCVisibility.NULL) {
            answer.append(visibility.toString()).append(":<br>");
        }
    }

    @NotNull
    private static String getCanonicalNamePrefix(@NotNull OCSymbol symbol) {
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER) {
            String prefix = OCDocUtil.getCanonicalPrefix((OCSymbolWithQualifiedName)symbol);
            return prefix.length() > 0 ? prefix + "::" : "";
        }
        return "";
    }

    @NotNull
    private static String effectiveTypeString(@NotNull OCSymbol symbol) {
        OCFile containingFile = symbol.getContainingOCFile();
        OCType effectiveType = symbol.getEffectiveType();
        OCType type2 = effectiveType.accept(new OCTypeParameterResolveVisitor(containingFile));
        if (type2 instanceof OCUnknownType || type2 instanceof OCMagicType) {
            type2 = effectiveType;
        }
        if (symbol instanceof OCSymbolWithQualifiedName) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)symbol, OCSymbolKind.NAMESPACE);
            return OCDocUtil.replaceAnonymous(OCDocUtil.getCanonicalName(type2, contextNamespace, containingFile));
        }
        return OCDocUtil.replaceAnonymous(CidrDocumentationProvider.escapeHTML(type2.getName(containingFile)));
    }

    @Nullable
    private String propertyIVarDoc(@NotNull OCProperty p) {
        PsiElement iVar = CidrDocumentationProvider.getPropertyIVar(p);
        if (iVar != null) {
            return this.generateDocInnerHtml(iVar, null, true);
        }
        return null;
    }

    @Nullable
    private static PsiElement getPropertyIVar(@NotNull OCProperty p) {
        OCPropertySymbol ps = CidrDocumentationProvider.getPropertySymbol(p);
        OCInstanceVariableSymbol iVar = null;
        if (ps != null) {
            iVar = ps.getAssociatedIvar();
        }
        return iVar == null ? null : (PsiElement)iVar.locateDefinition();
    }

    @Nullable
    private static OCPropertySymbol getPropertySymbol(@NotNull OCProperty p) {
        OCDeclaration pd = p.getDeclaration();
        if (pd == null) {
            return null;
        }
        List<OCDeclarator> ds = pd.getDeclarators();
        if (ds.size() == 0) {
            return null;
        }
        OCSymbol s = ds.get(0).getSymbol();
        return s instanceof OCPropertySymbol ? (OCPropertySymbol)s : null;
    }

    @NotNull
    private static String declaredInHint(@NotNull PsiFile file2) {
        return CidrDocumentationProvider.declaredInHint(file2.getName());
    }

    @NotNull
    public static String declaredInHint(@NotNull String fileName) {
        return "<b>Declared In:</b> " + fileName + "<br><br>";
    }

    @Nullable
    private static PsiElement resolveIfRequired(@NotNull PsiElement element) {
        if (element instanceof OCReferenceElement) {
            OCPropertySymbol property;
            OCSymbol syntheticSymbol = ((OCReferenceElement)element).resolveToSymbol();
            if (syntheticSymbol instanceof OCInstanceVariableSymbol) {
                OCPropertySymbol property2 = ((OCInstanceVariableSymbol)syntheticSymbol).getAssociatedProperty();
                if (property2 != null) {
                    return property2.locateDefinition();
                }
            } else if (syntheticSymbol instanceof OCMethodSymbol && (property = ((OCMethodSymbol)syntheticSymbol).getGeneratedFromProperty()) != null) {
                return property.locateDefinition();
            }
        }
        return element;
    }

    @Nullable
    private static String typeParameterHintDoc(@NotNull OCTypeParameterDeclaration type2) {
        return type2.getText();
    }

    @NotNull
    private static String classHintDoc(@NotNull OCClassDeclaration classDeclaration) {
        return (classDeclaration instanceof OCProtocol ? "protocol " : "class ") + classDeclaration.getName();
    }

    @NotNull
    private static String methodHintDoc(@NotNull OCMethod method2) {
        StringBuilder answer = new StringBuilder();
        OCClassDeclaration container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)method2, (Class[])new Class[]{OCClassDeclaration.class});
        if (container != null) {
            answer.append(CidrDocumentationProvider.classHintDoc(container)).append("<br>");
        }
        answer.append(method2.isInstanceMethod() ? (char)'-' : '+').append(" ");
        CidrDocumentationProvider.appendType(answer, method2.getRawReturnType(), method2.getContainingFile(), true);
        for (OCMethodSelectorPart part : method2.getParameters()) {
            String parameterName;
            answer.append("<b>");
            answer.append(part.getSelectorPart());
            answer.append("</b>");
            OCType type2 = part.getRawType();
            if (type2 != OCUnknownType.INSTANCE) {
                CidrDocumentationProvider.appendType(answer, type2, method2.getContainingFile(), true);
            }
            if ((parameterName = part.getParameterName()) != null) {
                answer.append(parameterName);
            }
            answer.append(" ");
        }
        return answer.toString();
    }

    private static void appendType(@NotNull StringBuilder answer, @NotNull OCType type2, @NotNull PsiFile context, boolean requiresParens) {
        boolean needParens;
        String typeText = type2.accept(new OCTypeParameterResolveVisitor(context)).getName();
        boolean bl = needParens = requiresParens && !typeText.startsWith("(");
        if (needParens) {
            answer.append("(");
        }
        answer.append(CidrDocumentationProvider.escapeHTML(typeText));
        if (needParens) {
            answer.append(")");
        }
    }

    @Nullable
    public String generateDocInnerHtml(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean skipQuickDoc) {
        boolean isExternalDocProvided;
        StringBuilder answer = new StringBuilder();
        if (this.myExternalProvider != null && element instanceof PsiNamedElement) {
            this.myExternalProvider.addExternalDoc(element, originalElement, answer);
        }
        boolean bl = isExternalDocProvided = answer.length() > 0;
        if (element instanceof OCDefineDirective) {
            this.addMacroDoc(originalElement, answer, (OCDefineDirective)element);
        }
        if (!skipQuickDoc && answer.length() == 0) {
            this.addQuickDoc(element, originalElement, answer);
        }
        if (!isExternalDocProvided) {
            this.addCommentDoc(element, answer);
        }
        if (element instanceof PsiNamedElement) {
            CidrDocumentationProvider.addManDoc(answer, (PsiNamedElement)element);
        }
        return answer.length() == 0 ? null : answer.toString();
    }

    private void addQuickDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement, @NotNull StringBuilder answer) {
        String quickDoc = this.quickDocContent(element, originalElement, true);
        if (quickDoc != null) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
            answer.append("<code>").append(quickDoc).append("</code>");
        }
    }

    private static void addManDoc(@NotNull StringBuilder answer, @NotNull PsiNamedElement namedElement) {
        VirtualFile vFile;
        PsiFile psiFile = namedElement.getContainingFile();
        VirtualFile virtualFile = vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        if (vFile == null || !vFile.getPath().contains("/usr/include/")) {
            return;
        }
        String name = namedElement.getName();
        if (name == null) {
            return;
        }
        String man = CidrDocumentationProvider.getManPage(name);
        if (man != null && man.length() > 0) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
            if (answer.length() > 0) {
                answer.append("<br>");
            }
            answer.append(CidrDocumentationProvider.man2html(man));
        }
    }

    private void addMacroDoc(@Nullable PsiElement originalElement, @NotNull StringBuilder answer, @NotNull OCDefineDirective define) {
        PsiFile file2;
        CidrDocumentationProvider.addBreakIfRequired(answer);
        if (answer.length() == 0 && (file2 = define.getContainingFile()) != null) {
            answer.append(CidrDocumentationProvider.declaredInHint(file2));
        }
        answer.append("<b>Definition:</b><br><br><tt><pre>");
        String defineText = this.cleanAndReformat(define, OCDefineDirective.class).getTextWithMacros().replaceAll("\\s+\\\\", "");
        answer.append(CidrDocumentationProvider.escapeHTML(defineText));
        answer.append("</pre></tt><br>");
        OCMacroCall call = (OCMacroCall)PsiTreeUtil.getContextOfType((PsiElement)originalElement, (Class[])new Class[]{OCMacroCall.class});
        if (call != null) {
            answer.append("<b>Replacement:</b><br><br> <tt><pre>");
            answer.append(CidrDocumentationProvider.escapeHTML(call.getReplacementText()));
            answer.append("</pre></tt>");
        }
    }

    @NotNull
    protected static String escapeHTML(@NotNull String text) {
        return StringUtil.escapeXml((String)text);
    }

    private static void addBreakIfRequired(@NotNull StringBuilder answer) {
        if (answer.length() > 0) {
            answer.append("<br>");
        }
    }

    @Nullable
    private static String getManPage(@NotNull String name) {
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath("man");
        cl.addParameter("3");
        cl.addParameter(name);
        cl.setCharset(CharsetToolkit.getDefaultSystemCharset());
        try {
            CapturingProcessHandler handler2 = new CapturingProcessHandler(cl);
            ProcessOutput result2 = handler2.runProcess(1000);
            if (result2.isTimeout()) {
                return null;
            }
            return result2.getStdout().trim();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @NotNull
    private static String man2html(@NotNull String man) {
        StringBuilder a = new StringBuilder();
        a.append("<pre>");
        boolean wasBold = false;
        boolean wasUnderscored = false;
        for (int i2 = 0; i2 < man.length(); ++i2) {
            boolean bold;
            char c = man.charAt(i2);
            char next = i2 + 1 < man.length() ? man.charAt(i2 + 1) : (char)'\u0000';
            boolean underscored = c == '_' && next == '\b';
            boolean bl = bold = c != '_' && next == '\b';
            if (!bold && wasBold) {
                wasBold = false;
                a.append("</b>");
            }
            if (!underscored && wasUnderscored) {
                wasUnderscored = false;
                a.append("</u>");
            }
            if (!bold && !underscored) {
                CidrDocumentationProvider.appendSymbol(a, c);
                continue;
            }
            if (bold && !wasBold) {
                a.append("<b>");
                wasBold = true;
            }
            if (underscored && !wasUnderscored) {
                a.append("<u>");
                wasUnderscored = true;
            }
            CidrDocumentationProvider.appendSymbol(a, man.charAt(i2 + 2));
            i2 += 2;
        }
        a.append("</pre>");
        return a.toString();
    }

    private static void appendSymbol(@NotNull StringBuilder a, char c) {
        switch (c) {
            case ' ': {
                a.append("&nbsp;");
                break;
            }
            case '\t': {
                a.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                break;
            }
            case '<': {
                a.append("&lt;");
                break;
            }
            case '>': {
                a.append("&gt;");
                break;
            }
            case '\"': {
                a.append("&quot;");
                break;
            }
            default: {
                a.append(c);
            }
        }
    }

    @NotNull
    public static String wrapDocInHtml(@NotNull String doc) {
        return "<html><head><style type=\"text/css\">p { margin-bottom: 5px; }</style></head><body>" + doc + "</body></html>";
    }

    private void addCommentDoc(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        boolean added = this.addCommentDocForElement(element, answer);
        if (!added) {
            List<OCSymbolWithParent> elements = OCDocUtil.getSuperSymbols(element);
            for (OCSymbolWithParent s : elements) {
                int pos = answer.length();
                Object psiElement = s.locateDefinition();
                if (psiElement == null) continue;
                if (psiElement instanceof OCDeclarator) {
                    psiElement = psiElement.getParent();
                }
                if (!this.addCommentDocForElement((PsiElement)psiElement, answer)) continue;
                answer.insert(pos, "<br><br><b>Description copied from: </b>" + OCDocUtil.getLink(s));
                break;
            }
        }
    }

    private boolean addCommentDocForElement(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        int length = answer.length();
        DoxygenRender dxRender = new DoxygenRender(element);
        if (dxRender.hasDoxygenComments()) {
            dxRender.render(answer);
        } else {
            this.addDocForElement(element, answer);
        }
        return answer.length() > length;
    }

    protected void addDocForElement(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        String data;
        ArrayList<String> content = new ArrayList<String>();
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        for (PsiComment comment : this.findCommentsFor(element)) {
            IElementType type2 = comment.getTokenType();
            comments.add(comment);
            if (type2 == OCTokenTypes.EOL_COMMENT) continue;
            content.add(this.processComments(comments));
            comments.clear();
        }
        if (!comments.isEmpty()) {
            content.add(this.processComments(comments));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(data = StringUtil.join(content, (String)"\n")))) {
            answer.append("<pre>").append(data).append("</pre>");
        }
    }

    @NotNull
    private String processComments(@NotNull List<PsiComment> comments) {
        int commonPaddingIdx = 0x3FFFFFFF;
        ArrayList content = new ArrayList();
        for (PsiComment comment : comments) {
            String text = CidrDocumentationProvider.escapeHTML(this.stripCommentBegin(comment.getText()));
            List lines = StringUtil.split((String)text, (String)"\n", (boolean)true, (boolean)false);
            assert (lines.size() > 0);
            String fistLine = (String)lines.get(0);
            if (!fistLine.isEmpty()) {
                lines.set(0, "  " + fistLine);
            }
            for (String line : lines) {
                int padding = CidrDocumentationProvider.indent(line, comment.getTokenType() != OCTokenTypes.EOL_COMMENT);
                if (padding >= commonPaddingIdx) continue;
                commonPaddingIdx = padding;
            }
            content.addAll(lines);
        }
        int padding = commonPaddingIdx;
        List result2 = content.stream().map(s -> s.substring(Math.min(s.length(), padding))).collect(Collectors.toList());
        return StringUtil.join(result2, (String)"\n");
    }

    private static int indent(@NotNull String line, boolean processAsterisk) {
        int i2;
        if (line.isEmpty()) {
            return 0x3FFFFFFF;
        }
        for (i2 = 0; i2 < line.length(); ++i2) {
            char ch = line.charAt(i2);
            if (Character.isWhitespace(ch)) continue;
            if (!processAsterisk || ch != '*') break;
            processAsterisk = false;
        }
        return i2 < line.length() ? i2 : 0x3FFFFFFF;
    }

    @NotNull
    protected String stripCommentBegin(@NotNull String text) {
        if (text.startsWith("/*") || text.startsWith("//")) {
            text = text.substring(2);
        }
        text = StringUtil.trimEnd((String)text, (String)"*/");
        text = StringUtil.trimTrailing((String)text, (char)' ');
        return text;
    }

    @NotNull
    protected List<PsiComment> findCommentsFor(@Nullable PsiElement element) {
        List<PsiComment> comments = this.findOCCommentFor(element);
        if (comments.size() == 0 && element instanceof OCSymbolDeclarator) {
            Object associatedElement;
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol();
            }
            if (symbol != null && (associatedElement = symbol.locateDefinition()) != null) {
                comments = this.findOCCommentFor((PsiElement)associatedElement);
            }
        }
        return comments;
    }

    protected boolean acceptDocComment(@NotNull PsiComment comment) {
        return !DoxygenFacade.isDoxygenSupported() || !DoxygenFacade.isDoxygenComment(comment);
    }

    @NotNull
    private List<PsiComment> findOCCommentFor(@Nullable PsiElement elt) {
        if (elt instanceof OCDeclarator) {
            elt = elt.getParent();
        }
        if (elt instanceof OCStructLike) {
            elt = PsiTreeUtil.findFirstParent((PsiElement)elt, p -> p instanceof OCDeclaration);
        }
        if (elt == null) {
            return Collections.emptyList();
        }
        if (elt.getParent() instanceof OCProperty) {
            elt = elt.getParent();
        }
        if (elt.getParent() instanceof OCDeclarationStatement) {
            elt = elt.getParent();
        }
        if (elt.getContainingFile() == null) {
            return Collections.emptyList();
        }
        LinkedList<PsiComment> comments = new LinkedList<PsiComment>();
        this.findPrevComments(elt, comments);
        this.findInnerComments(elt, comments);
        this.findPostComments(elt, comments);
        return comments;
    }

    protected void findPrevComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        for (PsiElement element = elt.getPrevSibling(); element != null; element = element.getPrevSibling()) {
            PsiComment c;
            PsiElement prevSibling;
            if (element instanceof OCMacroCall || element instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)element.getText()) <= 1) continue;
            if (!(element instanceof PsiComment) || (prevSibling = element.getPrevSibling()) != null && (!(prevSibling instanceof PsiWhiteSpace) || StringUtil.countNewLines((CharSequence)prevSibling.getText()) <= 0) || !this.acceptDocComment(c = (PsiComment)element)) break;
            comments.add(0, c);
        }
    }

    protected void findInnerComments(@NotNull PsiElement elt, List<PsiComment> comments) {
        PsiComment c;
        Iterator iterator = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)elt, PsiComment.class).iterator();
        while (iterator.hasNext() && this.acceptDocComment(c = (PsiComment)iterator.next())) {
            comments.add(c);
        }
    }

    protected void findPostComments(@NotNull PsiElement elt, List<PsiComment> comments) {
        PsiComment c;
        PsiElement next;
        for (next = elt.getNextSibling(); next != null && (next instanceof PsiWhiteSpace && !next.getText().contains("\n") || next instanceof LeafElement && ((LeafElement)next).getElementType() == OCTokenTypes.SEMICOLON); next = next.getNextSibling()) {
        }
        if (next instanceof PsiComment && this.acceptDocComment(c = (PsiComment)next)) {
            comments.add(c);
        }
    }

    public static interface ExternalProvider {
        public void addExternalDoc(@NotNull PsiElement var1, @Nullable PsiElement var2, @NotNull StringBuilder var3);
    }
}

