/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.documentation.HtmlHelper;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCommentGroup;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.documentation.doxygen.api.InfoItem;
import com.jetbrains.cidr.lang.documentation.doxygen.api.TagItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoxygenRender {
    private static Map<String, String> TAG_TABLE = new HashMap();
    private static final Map<String, String> formattingTags;
    @Nullable
    private final DoxygenCommentGroup docComment;

    private static String replaceFormattingTags(@NotNull String text) {
        Pattern p = Pattern.compile("(\\\\|@)(a|b|c|e|em|p)\\s+([^\\\\@&&[\\S]]+)");
        Matcher m = p.matcher(text);
        String result2 = text;
        while (m.find()) {
            String tag = m.group(2);
            String htmlTag = formattingTags.get(tag);
            String replacement = " <" + htmlTag + ">$3</" + htmlTag + ">";
            result2 = text.replaceFirst(p.pattern(), replacement);
        }
        return text.equals(result2) ? result2 : DoxygenRender.replaceFormattingTags(result2);
    }

    @NotNull
    private static String extractName(@NotNull String name) {
        if (TAG_TABLE.containsKey(name)) {
            return TAG_TABLE.get(name);
        }
        if (!name.isEmpty()) {
            return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    public DoxygenRender(@NotNull PsiElement element) {
        this.docComment = DoxygenFacade.getCommentGroup(element);
    }

    public boolean hasDoxygenComments() {
        return this.docComment != null && !this.docComment.isEmpty();
    }

    public void render(@NotNull StringBuilder answer) {
        InfoItem item;
        if (this.docComment == null) {
            return;
        }
        HtmlHelper.HtmlDoc html = new HtmlHelper.HtmlDoc();
        List<InfoItem> content = this.docComment.getContent();
        boolean containsHeader = false;
        StringBuilder buff = new StringBuilder();
        String options = this.docComment.getOptions();
        if (!options.isEmpty()) {
            buff.append(HtmlHelper.code(options));
        }
        if (!content.isEmpty() && !((item = content.get(0)) instanceof TagItem)) {
            containsHeader = true;
            String text = DoxygenRender.replaceFormattingTags(item.getDescription());
            if (buff.length() > 0 && !text.isEmpty()) {
                buff.append(" ");
            }
            buff.append(text);
        }
        if (buff.length() > 0) {
            html.addText(HtmlHelper.paragraph(buff.toString()));
        }
        List<InfoItem> items = DoxygenRender.squash(containsHeader ? content.subList(1, content.size()) : content);
        for (InfoItem item2 : items) {
            if (item2 instanceof CompositeInfoItem) {
                DoxygenRender.renderCompositeItem(answer, html, (CompositeInfoItem)item2);
                continue;
            }
            DoxygenRender.renderSimpleElement(item2, html);
        }
        answer.append(html.toString());
    }

    private static void renderSimpleElement(@NotNull InfoItem item, @NotNull HtmlHelper.HtmlDoc html) {
        html.addText(HtmlHelper.paragraph(DoxygenRender.replaceFormattingTags(item.getDescription())));
    }

    private static void renderCompositeItem(@NotNull StringBuilder answer, @NotNull HtmlHelper.HtmlDoc html, @NotNull CompositeInfoItem item) {
        String name = item.getName();
        if (DoxygenCmd.BRIEF.toString().equals(name)) {
            for (TagItem tag : item.getTags()) {
                answer.append(HtmlHelper.newLine(DoxygenRender.replaceFormattingTags(tag.getDescription())));
            }
        } else if (DoxygenCmd.SURROUND_TAGS.containsKey(name)) {
            for (TagItem tag : item.getTags()) {
                String description = tag.getDescription();
                html.addText(HtmlHelper.pre(HtmlHelper.code(description)));
            }
        } else {
            HtmlHelper.DL descriptionList = new HtmlHelper.DL();
            descriptionList.defineTerm(HtmlHelper.bold(DoxygenRender.extractName(name)));
            HtmlHelper.Table table = new HtmlHelper.Table();
            for (TagItem tag : item.getTags()) {
                DoxygenRender.renderTagParams(tag, table);
            }
            descriptionList.detailedDescription(table);
            html.addItem(descriptionList);
        }
    }

    private static void renderTagParams(@NotNull TagItem tag, @NotNull HtmlHelper.Table table) {
        HtmlHelper.TableRow row = HtmlHelper.TableRow.withData(HtmlHelper.code(tag.getOptions()));
        List<String> parameters2 = tag.getParameters();
        if (!parameters2.isEmpty()) {
            row.addData(HtmlHelper.bold(StringUtil.join(parameters2, (String)", ")));
        }
        StringBuilder content = new StringBuilder();
        for (InfoItem item : tag.getContent()) {
            String description = item.getDescription();
            String itemInfo = item instanceof TagItem && DoxygenCmd.SURROUND_TAGS.containsKey(((TagItem)item).getName()) ? HtmlHelper.pre(HtmlHelper.code(description)) : DoxygenRender.replaceFormattingTags(description);
            content.append(itemInfo);
        }
        row.addData(content.toString());
        table.addRow(row);
    }

    @NotNull
    private static List<InfoItem> squash(@NotNull List<InfoItem> items) {
        return DoxygenRender.squash(items, 0, null);
    }

    @NotNull
    private static List<InfoItem> squash(@NotNull List<InfoItem> items, int position, @Nullable CompositeInfoItem compositeItem) {
        ArrayList<InfoItem> blocks = new ArrayList<InfoItem>();
        if (position < items.size()) {
            InfoItem item = items.get(position);
            if (item instanceof TagItem) {
                TagItem tag = (TagItem)item;
                String name = tag.getName();
                if (!DoxygenCmd.PARAM.toString().equals(name) || !tag.getParameters().isEmpty()) {
                    if (compositeItem != null && name.equals(compositeItem.getName())) {
                        compositeItem.addItem(tag);
                    } else {
                        compositeItem = new CompositeInfoItem(tag);
                        blocks.add(compositeItem);
                    }
                }
            } else {
                compositeItem = null;
                blocks.add(item);
            }
            List<InfoItem> result2 = DoxygenRender.squash(items, ++position, compositeItem);
            blocks.addAll(result2);
        }
        return blocks;
    }

    static {
        TAG_TABLE.put(DoxygenCmd.ATTENTION.toString(), "Attention");
        TAG_TABLE.put(DoxygenCmd.AUTHOR.toString(), "Author");
        TAG_TABLE.put(DoxygenCmd.AUTHORS.toString(), "Authors");
        TAG_TABLE.put(DoxygenCmd.BUG.toString(), "Bug");
        TAG_TABLE.put(DoxygenCmd.COPYRIGHT.toString(), "Copyright");
        TAG_TABLE.put(DoxygenCmd.DATE.toString(), "Date");
        TAG_TABLE.put(DoxygenCmd.DEPRECATED.toString(), "Deprecated");
        TAG_TABLE.put(DoxygenCmd.INVARIANT.toString(), "Invariant");
        TAG_TABLE.put(DoxygenCmd.PARAM.toString(), "Parameters");
        TAG_TABLE.put(DoxygenCmd.TPARAM.toString(), "Template Parameters");
        TAG_TABLE.put(DoxygenCmd.PRE.toString(), "Precondition");
        TAG_TABLE.put(DoxygenCmd.POST.toString(), "Postcondition");
        TAG_TABLE.put(DoxygenCmd.REMARK.toString(), "Remarks");
        TAG_TABLE.put(DoxygenCmd.REMARKS.toString(), "Remarks");
        TAG_TABLE.put(DoxygenCmd.SA.toString(), "See also");
        TAG_TABLE.put(DoxygenCmd.SEE.toString(), "See also");
        TAG_TABLE.put(DoxygenCmd.SINCE.toString(), "Since");
        TAG_TABLE.put(DoxygenCmd.TODO.toString(), "Todo");
        TAG_TABLE.put(DoxygenCmd.VERSION.toString(), "Version");
        TAG_TABLE.put(DoxygenCmd.WARNING.toString(), "Warning");
        TAG_TABLE.put(DoxygenCmd.RETURN.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RETURNS.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RESULT.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RETVAL.toString(), "Return values");
        TAG_TABLE.put(DoxygenCmd.THROW.toString(), "Exceptions");
        TAG_TABLE.put(DoxygenCmd.THROWS.toString(), "Exceptions");
        TAG_TABLE.put("exception", "Exceptions");
        formattingTags = new HashMap();
        formattingTags.put("a", "em");
        formattingTags.put("b", "b");
        formattingTags.put("c", "tt");
        formattingTags.put("e", "em");
        formattingTags.put("em", "em");
        formattingTags.put("p", "tt");
    }

    private static class CompositeInfoItem
    implements InfoItem {
        private final String name;
        private final List<TagItem> tags = new ArrayList<TagItem>();

        public CompositeInfoItem(@NotNull TagItem item) {
            this.name = item.getName();
            this.tags.add(item);
        }

        public String getName() {
            return this.name;
        }

        public List<TagItem> getTags() {
            return this.tags;
        }

        public void addItem(@NotNull TagItem item) {
            assert (this.name.equals(item.getName()));
            this.tags.add(item);
        }

        @Override
        @NotNull
        public String getDescription() {
            throw new UnsupportedOperationException();
        }
    }
}

