/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;

public class DeclarationJoinLinesHandler
implements JoinRawLinesHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler");

    public int tryJoinLines(Document document, PsiFile file2, int start, int end) {
        OCExpression initializerExpression;
        PsiElement elementAtStartLineEnd = file2.findElementAt(start);
        PsiElement elementAtNextLineStart = file2.findElementAt(end);
        if (elementAtStartLineEnd == null || elementAtNextLineStart == null) {
            return -1;
        }
        if (elementAtStartLineEnd.getNode().getElementType() != OCTokenTypes.SEMICOLON) {
            return -1;
        }
        if (!(elementAtStartLineEnd.getParent() instanceof OCDeclaration)) {
            return -1;
        }
        OCDeclaration decl = (OCDeclaration)elementAtStartLineEnd.getParent();
        if (decl.getDeclarators().size() != 1) {
            return -1;
        }
        OCDeclarator var = decl.getDeclarators().get(0);
        if (elementAtNextLineStart.getNode().getElementType() != OCTokenTypes.IDENTIFIER) {
            return -1;
        }
        if (!(elementAtNextLineStart.getParent() instanceof OCReferenceElement)) {
            return -1;
        }
        OCReferenceElement ref = (OCReferenceElement)elementAtNextLineStart.getParent();
        PsiElement refResolved = ref.resolve();
        PsiManager psiManager = ref.getManager();
        if (!psiManager.areElementsEquivalent(refResolved, (PsiElement)var)) {
            return -1;
        }
        if (!(ref.getParent() instanceof OCReferenceExpression)) {
            return -1;
        }
        OCReferenceExpression refExpression = (OCReferenceExpression)ref.getParent();
        if (!(refExpression.getParent() instanceof OCAssignmentExpression)) {
            return -1;
        }
        OCAssignmentExpression assignment = (OCAssignmentExpression)refExpression.getParent();
        if (!(assignment.getParent() instanceof OCExpressionStatement)) {
            return -1;
        }
        if (ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope((PsiElement)assignment.getSourceExpression()), (boolean)false).findFirst() != null) {
            return -1;
        }
        OCElementType originalOpSign = assignment.getOperationSign();
        if (originalOpSign == OCTokenTypes.EQ) {
            initializerExpression = assignment.getSourceExpression();
        } else {
            if (var.getInitializer() == null) {
                return -1;
            }
            String opSign = null;
            if (originalOpSign == OCTokenTypes.ANDEQ) {
                opSign = "&";
            } else if (originalOpSign == OCTokenTypes.MULTEQ) {
                opSign = "*";
            } else if (originalOpSign == OCTokenTypes.DIVEQ) {
                opSign = "/";
            } else if (originalOpSign == OCTokenTypes.GTGTEQ) {
                opSign = ">>";
            } else if (originalOpSign == OCTokenTypes.LTLTEQ) {
                opSign = "<<";
            } else if (originalOpSign == OCTokenTypes.MINUSEQ) {
                opSign = "-";
            } else if (originalOpSign == OCTokenTypes.OREQ) {
                opSign = "|";
            } else if (originalOpSign == OCTokenTypes.PERCEQ) {
                opSign = "%";
            } else if (originalOpSign == OCTokenTypes.PLUSEQ) {
                opSign = "+";
            } else if (originalOpSign == OCTokenTypes.XOREQ) {
                opSign = "^";
            }
            try {
                initializerExpression = OCElementFactory.expressionFromText(var.getInitializer().getTextWithMacros() + opSign + assignment.getSourceExpression().getTextWithMacros(), (PsiElement)file2);
                initializerExpression = (OCExpression)CodeStyleManager.getInstance((PsiManager)psiManager).reformat((PsiElement)initializerExpression);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return -1;
            }
        }
        OCExpressionStatement statement2 = (OCExpressionStatement)assignment.getParent();
        int startOffset = decl.getTextRange().getStartOffset();
        try {
            OCDeclarationStatement newDecl = OCElementFactory.declarationStatement(var.getName(), var.getType(), initializerExpression, (PsiElement)file2);
            OCDeclarator variable = newDecl.getDeclaration().getDeclarators().get(0);
            int offsetBeforeEQ = variable.getNameIdentifier().getTextRange().getEndOffset();
            int offsetAfterEQ = variable.getInitializer().getRangeWithMacros().getStartOffset() + 1;
            newDecl = (OCDeclarationStatement)CodeStyleManager.getInstance((PsiManager)psiManager).reformatRange((PsiElement)newDecl, offsetBeforeEQ, offsetAfterEQ);
            decl.replace(newDecl);
            OCChangeUtil.delete(statement2);
            return startOffset + newDecl.getTextRange().getEndOffset() - newDecl.getTextRange().getStartOffset();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return -1;
        }
    }

    public int tryJoinRawLines(Document document, PsiFile file2, int start, int end) {
        PsiElement elementAtStartLineEnd = file2.findElementAt(start);
        PsiElement elementAtNextLineStart = file2.findElementAt(end);
        if (elementAtStartLineEnd == null || elementAtNextLineStart == null) {
            return -1;
        }
        if (elementAtStartLineEnd == elementAtNextLineStart && elementAtStartLineEnd.getNode().getElementType() == OCTokenTypes.RAW_STRING_LITERAL) {
            return elementAtStartLineEnd.getTextRange().getEndOffset();
        }
        return -1;
    }
}

