/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBraceMatcher
implements PairedBraceMatcher {
    public static final BracePair[] PAIRS = new BracePair[]{new BracePair((IElementType)OCTokenTypes.LPAR, (IElementType)OCTokenTypes.RPAR, false), new BracePair((IElementType)OCTokenTypes.LBRACE, (IElementType)OCTokenTypes.RBRACE, true), new BracePair((IElementType)OCTokenTypes.LBRACKET, (IElementType)OCTokenTypes.RBRACKET, false), new BracePair((IElementType)OCTokenTypes.PROTOCOL_KEYWORD, (IElementType)OCTokenTypes.END_KEYWORD, false), new BracePair((IElementType)OCTokenTypes.INTERFACE_KEYWORD, (IElementType)OCTokenTypes.END_KEYWORD, false), new BracePair((IElementType)OCTokenTypes.IMPLEMENTATION_KEYWORD, (IElementType)OCTokenTypes.END_KEYWORD, false)};

    public BracePair[] getPairs() {
        return PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (contextType instanceof OCElementType) {
            return OCBraceMatcher.isPairedBracesAllowedBeforeTypeInJava(contextType);
        }
        return true;
    }

    private static boolean isPairedBracesAllowedBeforeTypeInJava(IElementType tokenType) {
        return OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tokenType) || tokenType == OCTokenTypes.SEMICOLON || tokenType == OCTokenTypes.COMMA || tokenType == OCTokenTypes.RPAR || tokenType == OCTokenTypes.RBRACKET || tokenType == OCTokenTypes.RBRACE || tokenType == OCTokenTypes.LBRACE;
    }

    public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
        return openingBraceOffset;
    }
}

