/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.editor.OCCommenter;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCEnterInBlockCommentHandler
extends EnterHandlerDelegateAdapter {
    private static OCCommenter COMMENTER = new OCCommenter();

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        int caretOffset = (Integer)caretOffsetRef.get();
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        PsiElement psiAtOffset = OCEnterInBlockCommentHandler.findElementAt(file2, editor, caretOffset);
        if (this.shouldBeProcessed(file2, psiAtOffset, caretOffset)) {
            String commentText = psiAtOffset.getText();
            if (commentText.endsWith("*/") && !psiAtOffset.getTextRange().contains(caretOffset)) {
                return EnterHandlerDelegate.Result.Continue;
            }
            int documentStartOffset = psiAtOffset.getTextRange().getStartOffset();
            int caretInStringOffset = caretOffset - documentStartOffset;
            String commentBeforeCaret = commentText.substring(0, caretInStringOffset);
            StringBuilder indent = new StringBuilder("\n");
            indent.append(OCEnterInBlockCommentHandler.getIndentLine(psiAtOffset));
            int newCaretPosition = -1;
            int insertCommentSuffixPosition = -1;
            if (commentBeforeCaret.indexOf(10) == -1) {
                Pair<Integer, Integer> info = this.generateComment(file2, editor, caretOffset, commentText, caretInStringOffset, indent);
                insertCommentSuffixPosition = (Integer)info.first;
                newCaretPosition = (Integer)info.second;
            } else {
                caretOffset = OCEnterInBlockCommentHandler.processEnterInsideComment(commentBeforeCaret, caretInStringOffset, commentText, caretOffset, indent);
            }
            this.flushChanges(file2, editor, caretOffset, commentText, documentStartOffset, caretInStringOffset, insertCommentSuffixPosition, indent);
            if (newCaretPosition == -1) {
                newCaretPosition = caretOffset + indent.length();
            }
            editor.getCaretModel().moveToOffset(newCaretPosition);
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected boolean shouldBeProcessed(@NotNull PsiFile file2, @Nullable PsiElement psiAtOffset, int caretOffset) {
        return PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)caretOffset) instanceof OCLanguage && OCElementUtil.getElementType(psiAtOffset) == OCTokenTypes.BLOCK_COMMENT && psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset && !DoxygenFacade.isDoxygenComment((PsiComment)psiAtOffset) && OCElementUtil.getElementType(psiAtOffset.getParent()) != OCElementTypes.PRAGMA;
    }

    protected Pair<Integer, Integer> generateComment(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int caretInStringOffset, @NotNull StringBuilder indent) {
        indent.append("* ");
        int defaultCaretPosiotion = -1;
        int insertCommentSuffixPosition = -1;
        PsiElement psiAtOffset = OCEnterInBlockCommentHandler.findElementAt(file2, editor, caretOffset);
        if (OCEnterInBlockCommentHandler.needCommentSuffixGeneration(editor, (PsiComment)psiAtOffset, commentText, ch -> Character.isJavaIdentifierPart(ch.charValue()) || "{}".indexOf(ch.charValue()) >= 0)) {
            int lineEnd = commentText.indexOf(10) != -1 ? commentText.indexOf(10) : commentText.length();
            insertCommentSuffixPosition = caretOffset + indent.length() + (lineEnd - caretInStringOffset);
        }
        return Pair.create((Object)insertCommentSuffixPosition, (Object)defaultCaretPosiotion);
    }

    protected void flushChanges(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int documentStartOffset, int caretInStringOffset, int insertCommentSuffixPosition, @NotNull StringBuilder indent) {
        Document document = editor.getDocument();
        PsiElement psiAtOffset = OCEnterInBlockCommentHandler.findElementAt(file2, editor, caretOffset);
        if (CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            int deleteTo = caretInStringOffset;
            while (deleteTo < commentText.length() && "\t ".indexOf(commentText.charAt(deleteTo)) >= 0) {
                ++deleteTo;
                --insertCommentSuffixPosition;
            }
            document.deleteString(caretOffset, documentStartOffset + deleteTo);
        }
        document.insertString(caretOffset, (CharSequence)indent);
        if (insertCommentSuffixPosition >= 0) {
            StringBuilder insert = new StringBuilder("\n").append(OCEnterInBlockCommentHandler.getIndentLine(psiAtOffset)).append("*/");
            document.insertString(insertCommentSuffixPosition, (CharSequence)insert);
        }
    }

    public static boolean needCommentSuffixGeneration(@NotNull Editor editor, @Nullable PsiComment comment, @NotNull String commentText, @NotNull Predicate<Character> isNotAcceptedSymbol) {
        char ch;
        if (comment == null) {
            return false;
        }
        if (EnterHandler.isCommentComplete(comment, COMMENTER, editor)) {
            return false;
        }
        for (int offset = 0; offset < commentText.length() && (ch = commentText.charAt(offset)) != '\n'; ++offset) {
            if (!isNotAcceptedSymbol.test(Character.valueOf(ch))) continue;
            return false;
        }
        return true;
    }

    private static int processEnterInsideComment(String commentBeforeCaret, int caretInStringOffset, String commentText, int caretOffset, StringBuilder indent) {
        int offsetInCommentString;
        char ch = ' ';
        StringBuilder prevIndent = new StringBuilder("\n");
        for (offsetInCommentString = commentBeforeCaret.lastIndexOf(10) + 1; offsetInCommentString < caretInStringOffset; ++offsetInCommentString) {
            char c = commentText.charAt(offsetInCommentString);
            ch = c;
            if ("\t ".indexOf(c) < 0) break;
            prevIndent.append(ch);
        }
        if (indent.length() < prevIndent.length()) {
            indent.setLength(0);
            indent.append((CharSequence)prevIndent);
        }
        if (ch == '*') {
            int size;
            indent.append('*');
            if (++offsetInCommentString == caretInStringOffset && offsetInCommentString < commentText.length()) {
                ch = commentText.charAt(offsetInCommentString);
                if ("\t ".indexOf(ch) >= 0) {
                    ++caretOffset;
                    indent.append(ch);
                }
            } else {
                while (offsetInCommentString < caretInStringOffset && "\t ".indexOf(ch = commentText.charAt(offsetInCommentString)) >= 0) {
                    ++offsetInCommentString;
                    indent.append(ch);
                }
            }
            if ((size = indent.length()) != 0 && indent.charAt(size - 1) == '*') {
                indent.append(' ');
            }
        }
        return caretOffset;
    }

    @Nullable
    public static PsiElement findElementAt(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset) {
        return file2.findElementAt(caretOffset == editor.getDocument().getTextLength() && caretOffset > 0 ? caretOffset - 1 : caretOffset);
    }

    @NotNull
    public static String getFirstCommentLineIndentFromContext(@Nullable PsiElement element) {
        String indentSpace = "";
        if (element == null) {
            return "";
        }
        PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
        if (prev instanceof PsiWhiteSpace) {
            String whiteSpaces = prev.getText();
            int lineStart = whiteSpaces.lastIndexOf(10);
            if (lineStart >= 0) {
                indentSpace = whiteSpaces.substring(lineStart + 1);
            } else if (prev.getTextOffset() == 0) {
                indentSpace = whiteSpaces;
            }
        }
        return indentSpace;
    }

    @NotNull
    public static String customSettingsIndent(@Nullable PsiElement element) {
        if (element == null) {
            return "";
        }
        if (((OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)element.getProject()).getCustomSettings(OCCodeStyleSettings.class)).INDENT_BLOCK_COMMENT) {
            return " ";
        }
        return "";
    }

    @NotNull
    public static String getIndentLine(@Nullable PsiElement element) {
        return OCEnterInBlockCommentHandler.getFirstCommentLineIndentFromContext(element) + OCEnterInBlockCommentHandler.customSettingsIndent(element);
    }
}

