/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCArgumentListCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCCompoundInitializerCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionParameterInfo;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCParameterListCallPlace;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionParameterInfoHandler
implements ParameterInfoHandler<PsiElement, FunctionInfoWrapper> {
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.editor.OCFunctionParameterInfoHandler");
    private static final Condition<String> IS_UNNAMED = s -> "<unnamed>".equals(s);

    public boolean couldShowInLookup() {
        return true;
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public PsiElement findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        int startOffset;
        int offset;
        PsiFile file2 = context.getFile();
        OCFunctionCallPlace callPlace = OCFunctionParameterInfoHandler.findCallPlace(file2, offset = context.getOffset(), startOffset = context.getParameterListStart());
        if (callPlace != null) {
            ArrayList<OCFunctionCallOption> callOptions = new ArrayList<OCFunctionCallOption>();
            callPlace.collectCallOptions(callOptions);
            Collections.sort(callOptions, (o1, o2) -> Comparing.compare((int)o1.getOffset(), (int)o2.getOffset()));
            ArrayList<FunctionInfoWrapper> overloads = new ArrayList<FunctionInfoWrapper>();
            OCResolveContext resolveContext = new OCResolveContext((PsiElement)file2);
            block0: for (OCFunctionCallOption option : callOptions) {
                OCFunctionParameterInfo info = option.getParameterInfo();
                OCFunctionType funcType = info.getType();
                for (int i2 = 0; i2 < overloads.size(); ++i2) {
                    FunctionInfoWrapper other = (FunctionInfoWrapper)overloads.get(i2);
                    OCFunctionType otherType = other.getInfo().getType();
                    if (!otherType.equalsAfterResolving((OCType)funcType, (PsiElement)file2)) continue;
                    if (!OCFunctionParameterInfoHandler.hasUnnamedParam(otherType) || OCFunctionParameterInfoHandler.hasUnnamedParam(funcType)) continue block0;
                    overloads.set(i2, new FunctionInfoWrapper(info, resolveContext));
                    continue block0;
                }
                overloads.add(new FunctionInfoWrapper(info, resolveContext));
            }
            context.setItemsToShow(overloads.toArray());
        }
        return callPlace == null ? null : (PsiElement)callPlace.getElement();
    }

    private static boolean hasUnnamedParam(@NotNull OCFunctionType funcType) {
        List<String> names = funcType.getParameterNames();
        if (names == null) {
            return funcType.getParameterTypes().size() > 0;
        }
        return ContainerUtil.find(names, IS_UNNAMED) != null;
    }

    @Nullable
    private static OCFunctionCallPlace findCallPlace(PsiFile file2, int offset, int startOffset) {
        if (file2 == null) {
            return null;
        }
        if (startOffset == -1) {
            startOffset = offset;
        }
        PsiElement e1 = file2.findElementAt(offset);
        PsiElement e2 = file2.findElementAt(startOffset);
        if (e1 == null || e2 == null) {
            return null;
        }
        PsiElement element = PsiTreeUtil.findCommonContext((PsiElement)e1, (PsiElement)e2);
        if (element == null) {
            return null;
        }
        while (element != null) {
            OCFunctionCallPlace<? extends PsiElement> place = OCFunctionParameterInfoHandler.callPlace(element);
            if (place != null) {
                return place;
            }
            if (element instanceof OCBlockExpression || element instanceof OCLambdaExpression) {
                return null;
            }
            element = element.getContext();
        }
        return null;
    }

    @Nullable
    private static OCFunctionCallPlace<? extends PsiElement> callPlace(@NotNull PsiElement element) {
        if (element instanceof OCArgumentList) {
            return new OCArgumentListCallPlace((OCArgumentList)element);
        }
        if (!(element instanceof OCElement)) {
            return null;
        }
        if (!((OCElement)element).getContainingOCFile().isCpp()) {
            return null;
        }
        if (element instanceof OCParameterList) {
            return new OCParameterListCallPlace((OCParameterList)element);
        }
        if (element instanceof OCCompoundInitializer) {
            return new OCCompoundInitializerCallPlace((OCCompoundInitializer)element);
        }
        return null;
    }

    public void showParameterInfo(@NotNull PsiElement element, @NotNull CreateParameterInfoContext context) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.parameterInfo");
        context.showHint(element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        Object[] objectArray;
        Object object = item.getObject();
        if (object instanceof OCFunctionType) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public Object[] getParametersForDocumentation(FunctionInfoWrapper wrapper, ParameterInfoContext context) {
        return wrapper.getInfo().getType().getParameterTypes().toArray();
    }

    public PsiElement findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        OCFunctionCallPlace place = OCFunctionParameterInfoHandler.findCallPlace(context.getFile(), context.getOffset(), context.getParameterListStart());
        return place == null ? null : (PsiElement)place.getElement();
    }

    public void updateParameterInfo(@NotNull PsiElement parameterOwner, @NotNull UpdateParameterInfoContext context) {
        OCFunctionCallPlace<? extends PsiElement> callPlace = OCFunctionParameterInfoHandler.callPlace(parameterOwner);
        OCLog.LOG.assertTrue(callPlace != null);
        int offset = context.getOffset();
        if (!parameterOwner.getTextRange().contains(offset)) {
            context.removeHint();
            return;
        }
        int index = 0;
        for (ASTNode child = parameterOwner.getNode().getFirstChildNode(); child != null && child.getStartOffset() < offset; child = child.getTreeNext()) {
            if (child.getElementType() != OCTokenTypes.COMMA) continue;
            ++index;
        }
        context.setCurrentParameter(index);
        Object[] methods = context.getObjectsToView();
        List<OCExpression> argExpressions = callPlace.getArgumentExpressions();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            OCFunctionType funcType = ((FunctionInfoWrapper)methods[i2]).getInfo().getType();
            context.setUIComponentEnabled(i2, OCFunctionParameterInfoHandler.isApplicableBeforeIndex(funcType, argExpressions, index));
        }
    }

    public static boolean isApplicableBeforeIndex(@NotNull OCFunctionType funcType, @NotNull List<OCExpression> argExpressions, int index) {
        List<OCType> paramTypes = funcType.getParameterTypes();
        return (index == 0 || paramTypes.size() > index || funcType.isVararg()) && OCFunctionParameterInfoHandler.isAssignableParametersBeforeGivenIndex(paramTypes, argExpressions, index + 1);
    }

    private static boolean isAssignableParametersBeforeGivenIndex(@NotNull List<? extends OCType> params, @NotNull List<OCExpression> args, int length) {
        int min = Math.min(length, Math.min(args.size(), params.size()));
        for (int j = 0; j < min; ++j) {
            OCExpression arg;
            OCType argType;
            OCType paramType = params.get(j);
            if (!paramType.checkCompatible(argType = (arg = args.get(j)).getResolvedType(), arg, arg).getState().isError(arg)) continue;
            return false;
        }
        return true;
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public void updateUI(@NotNull FunctionInfoWrapper wrapper, @NotNull ParameterInfoUIContext context) {
        OCFunctionParameterInfoHandler.updateFunctionUI(wrapper.getInfo(), context);
    }

    public static String updateFunctionUI(@NotNull OCFunctionParameterInfo info, ParameterInfoUIContext context) {
        StringBuilder buffer = new StringBuilder();
        int currentParameter = context.getCurrentParameterIndex();
        OCFunctionType type2 = info.getType();
        List<String> defParamValues = info.getDefaultParameterValues();
        List<OCType> paramTypes = type2.getParameterTypes();
        List<String> paramNames = type2.getParameterNames();
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (paramTypes.isEmpty()) {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        } else {
            int numParams = paramTypes.size();
            for (int i2 = 0; i2 < numParams; ++i2) {
                int startOffset = buffer.length();
                String typeText = paramTypes.get(i2).getName();
                String paramName = paramNames == null ? "<unnamed>" : paramNames.get(i2);
                String defValue = defParamValues == null ? null : defParamValues.get(i2);
                buffer.append(OCDocUtil.parameterSignature(typeText, paramName, defValue));
                int endOffset = buffer.length();
                if (i2 < numParams - 1) {
                    buffer.append(", ");
                }
                if (!context.isUIComponentEnabled() || i2 != currentParameter && (i2 != numParams - 1 || !type2.isVararg() || currentParameter < numParams)) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        }
        return context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
    }

    public static class FunctionInfoWrapper {
        @NotNull
        private final OCFunctionParameterInfo myInfo;
        @NotNull
        private final OCResolveContext myContext;

        public FunctionInfoWrapper(@NotNull OCFunctionParameterInfo info, @NotNull OCResolveContext context) {
            this.myInfo = info;
            this.myContext = context;
        }

        @NotNull
        public OCFunctionParameterInfo getInfo() {
            return this.myInfo;
        }

        public int hashCode() {
            return this.myInfo.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof FunctionInfoWrapper && this.myInfo.getType().equals((Object)((FunctionInfoWrapper)obj).getInfo().getType(), this.myContext);
        }
    }
}

