/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodParameterInfoHandler
implements ParameterInfoHandler<OCSendMessageExpression, OCMethodSymbol> {
    public boolean couldShowInLookup() {
        return true;
    }

    public boolean tracksParameterIndex() {
        return false;
    }

    public void showParameterInfo(@NotNull OCSendMessageExpression element, @NotNull CreateParameterInfoContext context) {
        List<OCMessageArgument> arguments = element.getArguments();
        if (!arguments.isEmpty()) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.parameterInfo");
            context.showHint((PsiElement)element, arguments.get(0).getTextRange().getStartOffset(), (ParameterInfoHandler)this);
        }
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        Object object = item.getObject();
        if (object instanceof OCMethodSymbol) {
            return new Object[]{object};
        }
        return null;
    }

    public OCSendMessageExpression findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        OCSendMessageExpression callExpression = OCMethodParameterInfoHandler.findArgList(context.getFile(), context.getOffset(), context.getParameterListStart());
        if (callExpression != null) {
            List<OCMethodSymbol> responders = callExpression.getProbableResponders().getFilteredByStaticnessResponders();
            context.setItemsToShow(responders.toArray());
            return callExpression;
        }
        return null;
    }

    @Nullable
    private static OCSendMessageExpression findArgList(PsiFile file2, int offset, int startOffset) {
        if (startOffset == -1) {
            startOffset = offset;
        }
        PsiElement e1 = file2.findElementAt(offset);
        PsiElement e2 = file2.findElementAt(startOffset);
        if (e1 == null || e2 == null) {
            return null;
        }
        PsiElement element = PsiTreeUtil.findCommonContext((PsiElement)e1, (PsiElement)e2);
        if (element == null) {
            return null;
        }
        while (element != null) {
            if (element instanceof OCSendMessageExpression && element.getTextRange().getStartOffset() < offset) {
                return (OCSendMessageExpression)element;
            }
            if (element instanceof OCBlockExpression || element instanceof OCLambdaExpression) {
                return null;
            }
            element = element.getContext();
        }
        return null;
    }

    public Object[] getParametersForDocumentation(OCMethodSymbol p, ParameterInfoContext context) {
        return p.getSelectors().toArray();
    }

    public OCSendMessageExpression findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        return OCMethodParameterInfoHandler.findArgList(context.getFile(), context.getOffset(), context.getParameterListStart());
    }

    public void updateParameterInfo(@NotNull OCSendMessageExpression parameterOwner, @NotNull UpdateParameterInfoContext context) {
        int offset = context.getEditor().getCaretModel().getOffset();
        if (!parameterOwner.getRangeWithMacros().contains(offset)) {
            context.removeHint();
            return;
        }
        int index = -1;
        for (ASTNode child = parameterOwner.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCElementTypes.MESSAGE_ARGUMENT) {
                ++index;
                if (child.getTextRange().contains(offset)) break;
            }
            if (child.getStartOffset() >= offset) break;
        }
        context.setCurrentParameter(index);
        Object[] methods = context.getObjectsToView();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            OCMethodSymbol method2 = (OCMethodSymbol)methods[i2];
            context.setUIComponentEnabled(i2, method2.getSelectors().size() >= index);
        }
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public void updateUI(OCMethodSymbol p, @NotNull ParameterInfoUIContext context) {
        StringBuilder buffer = new StringBuilder();
        int currentParameter = context.getCurrentParameterIndex();
        List<OCMethodSymbol.SelectorPartSymbol> parms = p.getSelectors();
        int numParams = parms.size();
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (numParams == 0 || numParams == 1 && parms.get(0).getParameter() == null) {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        } else {
            for (int j = 0; j < numParams; ++j) {
                OCMethodSymbol.SelectorPartSymbol parm = parms.get(j);
                int startOffset = buffer.length();
                buffer.append(parm.getSelectorName());
                OCDeclaratorSymbol param = parm.getParameter();
                if (param != null) {
                    buffer.append('(').append(param.getType().getName()).append(")");
                }
                int endOffset = buffer.length();
                if (j < numParams - 1) {
                    buffer.append(" ");
                }
                if (!context.isUIComponentEnabled()) continue;
                if (j != currentParameter) {
                    if (j != numParams - 1) continue;
                    continue;
                }
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        }
        context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
    }
}

