/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Override
    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
        if (file2.getLanguage() != OCLanguage.getInstance()) {
            return null;
        }
        boolean isLiteral = true;
        for (int i2 = 0; i2 < startOffsets.length && isLiteral; ++i2) {
            if (OCStringLiteralCopyPasteProcessor.findLiteralTokenType(file2, startOffsets[i2], endOffsets[i2]) != null) continue;
            isLiteral = false;
        }
        return isLiteral ? StringUtil.unescapeStringCharacters((String)text) : null;
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project2, PsiFile file2, Editor editor, String text, RawText rawText) {
        if (file2.getLanguage() != OCLanguage.getInstance()) {
            return text;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        IElementType tokenType = OCStringLiteralCopyPasteProcessor.findLiteralTokenType(file2, selectionStart, selectionEnd);
        if (tokenType == OCTokenTypes.STRING_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                return rawText.rawText;
            }
            StringBuilder buffer = new StringBuilder(text.length());
            String breaker = "\\n\"\n \"";
            String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
            for (int i2 = 0; i2 < lines.length; ++i2) {
                String line = lines[i2];
                buffer.append(StringUtil.escapeStringCharacters((String)line));
                if (i2 == lines.length - 1) continue;
                buffer.append(breaker);
            }
            text = buffer.toString();
        } else if (tokenType == OCTokenTypes.CHARACTER_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                return rawText.rawText;
            }
            return OCStringLiteralCopyPasteProcessor.escapeCharCharacters(text);
        }
        return text;
    }

    @Nullable
    private static IElementType findLiteralTokenType(PsiFile file2, int selectionStart, int selectionEnd) {
        PsiElement elementAtSelection = file2.findElementAt(selectionStart);
        if (elementAtSelection == null) {
            return null;
        }
        if (elementAtSelection.getNode() == null) {
            OCLog.LOG.error("node is null for " + elementAtSelection + "\n\tin " + file2);
            return null;
        }
        IElementType tokenType = elementAtSelection.getNode().getElementType();
        if (tokenType != OCTokenTypes.STRING_LITERAL && tokenType != OCTokenTypes.CHARACTER_LITERAL) {
            return null;
        }
        TextRange textRange = elementAtSelection.getTextRange();
        if (selectionStart <= textRange.getStartOffset() || selectionEnd >= textRange.getEndOffset()) {
            return null;
        }
        return tokenType;
    }

    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)buffer);
        return buffer.toString();
    }
}

