/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.completion.FunctionDeclarationInsertHandler;
import com.jetbrains.cidr.lang.editor.completion.FunctionInsertHandler;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallableInsertUtils {
    public static void moveCaretToCallableBody(InsertionContext context) {
        Document document = context.getDocument();
        Editor editor = context.getEditor();
        CodeFoldingManager foldManager = CodeFoldingManager.getInstance(context.getProject());
        foldManager.updateFoldRegions(editor);
        String documentText = document.getText();
        int bodyStart = documentText.indexOf("{", context.getStartOffset());
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)context.getProject());
        pdm.commitDocument(document);
        PsiFile file2 = pdm.getPsiFile(document);
        if (file2 != null) {
            PsiElement leaf = file2.findElementAt(bodyStart);
            OCBlockStatement body2 = (OCBlockStatement)PsiTreeUtil.getContextOfType((PsiElement)leaf, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
            OCCodeInsightUtil.selectBody(editor, body2);
        }
    }

    @NotNull
    public static InsertHandler<LookupElement> createHandler(@NotNull OCFunctionSymbol symbol, @Nullable PsiElement contextExpression) {
        if (contextExpression instanceof OCDeclarator) {
            return new FunctionDeclarationInsertHandler(symbol);
        }
        return new FunctionInsertHandler(symbol, contextExpression);
    }

    public static boolean isReplaceCompletionBeforeParen(@NotNull InsertionContext context) {
        boolean tabBeforePar = false;
        if (CallableInsertUtils.isReplaceCompletion(context)) {
            CharSequence chars = context.getDocument().getCharsSequence();
            tabBeforePar = chars.length() > context.getTailOffset() && chars.charAt(context.getTailOffset()) == '(';
        }
        return tabBeforePar;
    }

    public static boolean isReplaceCompletion(@NotNull InsertionContext context) {
        return context.getCompletionChar() == '\t';
    }

    public static void addParensIfRequired(InsertionContext context, LookupElement item, boolean hasParams) {
        CommonCodeStyleSettings styleSettings = context.getCodeStyleSettings();
        ParenthesesInsertHandler.getInstance((boolean)hasParams, (boolean)styleSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES, (styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES && hasParams ? 1 : 0) != 0, (boolean)true, (boolean)styleSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE).handleInsert(context, item);
    }

    public static boolean shouldInsertPlaceholders(@NotNull InsertionContext context) {
        boolean isAppcode;
        PsiFile file2 = context.getFile();
        OCLanguageKind languageKind = file2 instanceof OCFile ? ((OCFile)file2).getKind() : null;
        boolean bl = isAppcode = PlatformUtils.isAppCode() && !ApplicationManager.getApplication().isUnitTestMode();
        if (!isAppcode && languageKind != OCLanguageKind.OBJ_C && languageKind != OCLanguageKind.OBJ_CPP) {
            return false;
        }
        Document document = context.getDocument();
        int offset = context.getEditor().getCaretModel().getOffset();
        return offset < document.getTextLength() && document.getCharsSequence().charAt(offset) == ')';
    }

    public static void selectFirstPlaceholderIfPresent(@NotNull InsertionContext context) {
        Editor editor = context.getEditor();
        Project project2 = context.getProject();
        String documentText = context.getDocument().getText();
        int firstParamStart = documentText.indexOf("<#", context.getStartOffset());
        int firstParamEnd = documentText.indexOf("#>", firstParamStart);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (firstParamStart >= 0 && firstParamEnd >= 0 && firstParamStart < context.getTailOffset()) {
            selectionModel.setSelection(firstParamStart, firstParamEnd + 2);
        }
        context.commitDocument();
        OCChangeUtil.reformatTextIfNotInjected(context.getFile(), context.getStartOffset(), context.getTailOffset());
        CodeFoldingManager.getInstance(project2).updateFoldRegions(editor);
    }
}

