/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FunctionDeclarationInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final OCFunctionSymbol mySymbol;

    FunctionDeclarationInsertHandler(@NotNull OCFunctionSymbol symbol) {
        this.mySymbol = symbol;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        Document document = context.getDocument();
        String insertion = this.getInsertion(context, item);
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)insertion);
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)context.getProject());
        pdm.commitDocument(document);
        CaretModel caretModel = context.getEditor().getCaretModel();
        String defaultInsertion = item.getLookupString();
        int caretOffset = caretModel.getOffset() - defaultInsertion.length();
        OCDeclaration method2 = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(caretOffset), OCDeclaration.class, (boolean)false);
        boolean hasType = false;
        if (method2 != null) {
            OCTypeElement typeElement = method2.getTypeElement();
            if (typeElement != null && !OCElementUtil.isElementEmpty(typeElement) && method2.getDeclarators().size() == 1) {
                OCDeclarator declarator = method2.getDeclarators().get(0);
                hasType = this.mySymbol.getName().equals(declarator.getName());
            }
            if (!hasType && !this.mySymbol.getKind().isConstructorOrDestructor()) {
                OCElement before = typeElement != null ? typeElement : method2;
                String returnType = this.mySymbol.getEffectiveType().getBestNameInContext(method2, OCElementUtil.getReturnTypeTextWithModifiers(this.mySymbol));
                document.insertString(before.getTextRange().getStartOffset(), (CharSequence)(returnType + " "));
            }
        }
        CallableInsertUtils.moveCaretToCallableBody(context);
        if (context.getCompletionChar() == '{') {
            context.setAddCompletionChar(false);
        }
        OCChangeUtil.reformatTextIfNotInjected(context.getFile(), context.getStartOffset(), context.getStartOffset() + insertion.length());
    }

    private String getInsertion(InsertionContext context, LookupElement item) {
        StringBuilder insertion = new StringBuilder();
        insertion.append(this.mySymbol.getName());
        boolean addEmptyBody = true;
        if (CallableInsertUtils.isReplaceCompletion(context)) {
            CaretModel caretModel = context.getEditor().getCaretModel();
            String defaultInsertion = item.getLookupString();
            int caretOffset = caretModel.getOffset() - defaultInsertion.length();
            OCDeclaration func = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(caretOffset), OCDeclaration.class, (boolean)false);
            if (func instanceof OCFunctionDefinition) {
                context.setTailOffset(((OCFunctionDefinition)func).getBody().getTextRange().getStartOffset());
                addEmptyBody = false;
            }
            if (CallableInsertUtils.isReplaceCompletionBeforeParen(context)) {
                return insertion.toString();
            }
        }
        insertion.append('(');
        if (!this.mySymbol.getType().hasNoParameters()) {
            List<OCDeclaratorSymbol> params = this.mySymbol.getParameterSymbols();
            for (int i2 = 0; i2 < params.size(); ++i2) {
                OCDeclaratorSymbol param = params.get(i2);
                OCType type2 = param.getType();
                if (i2 > 0) {
                    insertion.append(", ");
                }
                String name = !param.isUnnamed() ? param.getName() : "";
                insertion.append(type2.getBestNameInContext((PsiElement)param.locateDefinition(), OCElementUtil.getTypeTextWithModifiers(param))).append(" ").append(name);
            }
        }
        insertion.append(')');
        if (this.mySymbol.getType().isConst()) {
            insertion.append(" const ");
        }
        if (this.mySymbol.getType().isVolatile()) {
            insertion.append(" volatile ");
        }
        if (addEmptyBody) {
            insertion.append("{ }");
        }
        return insertion.toString();
    }
}

